/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.json;

import ai.grakn.migration.base.MigrationCLI;
import ai.grakn.migration.base.MigrationOptions;
import ai.grakn.migration.json.JsonMigrationOptions;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mjson.Json;

public class JsonMigrator
implements AutoCloseable {
    private final Set<Reader> readers;

    public static void main(String[] args) {
        MigrationCLI.init((String[])args, JsonMigrationOptions::new).stream().filter(Optional::isPresent).map(Optional::get).forEach(JsonMigrator::runJson);
    }

    public static void runJson(JsonMigrationOptions options) {
        File jsonDataFile = new File(options.getInput());
        File jsonTemplateFile = new File(options.getTemplate());
        if (!jsonDataFile.exists()) {
            MigrationCLI.die((String)("Cannot find file: " + options.getInput()));
        }
        if (!jsonTemplateFile.exists() || jsonTemplateFile.isDirectory()) {
            MigrationCLI.die((String)("Cannot find file: " + options.getTemplate()));
        }
        MigrationCLI.printInitMessage((MigrationOptions)options, (String)jsonDataFile.getPath());
        try (JsonMigrator jsonMigrator = new JsonMigrator(jsonDataFile);){
            MigrationCLI.loadOrPrint((File)jsonTemplateFile, jsonMigrator.convert(), (MigrationOptions)options);
        }
        catch (Throwable throwable) {
            MigrationCLI.die((Throwable)throwable);
        }
    }

    public JsonMigrator(File jsonFileOrDir) {
        File[] files = new File[]{jsonFileOrDir};
        if (jsonFileOrDir.isDirectory()) {
            FilenameFilter jsonFiles = (dir, name) -> name.toLowerCase().endsWith(".json");
            files = jsonFileOrDir.listFiles(jsonFiles);
        }
        this.readers = Stream.of(files).map(this::asReader).collect(Collectors.toSet());
    }

    public JsonMigrator(Reader reader) {
        this.readers = Sets.newHashSet((Object[])new Reader[]{reader});
    }

    public Stream<Map<String, Object>> convert() {
        return this.readers.stream().map(this::asString).map(this::toJsonMap);
    }

    @Override
    public void close() {
        this.readers.forEach(reader -> {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Map<String, Object> toJsonMap(String data) {
        return Json.read((String)data).asMap();
    }

    private String asString(Reader reader) {
        try {
            return CharStreams.toString((Readable)reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading input");
        }
    }

    private InputStreamReader asReader(File file) {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading input");
        }
    }
}

