/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.xml;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlSchema {
    private Map<String, TypeInfo> types = new HashMap<String, TypeInfo>();

    public TypeInfo typeOf(String elementName) {
        TypeInfo ti = this.types.get(elementName);
        return ti == null ? new TypeInfo("xs:complexType", 1L) : ti;
    }

    public XmlSchema read(File schemaFile) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(schemaFile);
            NodeList list = doc.getElementsByTagName("xs:element");
            for (int i = 0; i < list.getLength(); ++i) {
                Element el = (Element)list.item(i);
                long cardinality = 1L;
                if (el.hasAttribute("maxOccurs")) {
                    long l = cardinality = "unbounded".equals(el.getAttribute("maxOccurs")) ? Long.MAX_VALUE : Long.parseLong(el.getAttribute("maxOccurs"));
                }
                if (el.hasAttribute("type")) {
                    this.types.put(el.getAttribute("name"), new TypeInfo(el.getAttribute("type"), cardinality));
                    continue;
                }
                this.types.put(el.getAttribute("name"), new TypeInfo("xs:complexType", cardinality));
            }
            return this;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TypeInfo {
        private String name;
        private long cardinality;

        public TypeInfo(String name, long cardinality) {
            this.name = name;
            this.cardinality = cardinality;
        }

        public String name() {
            return this.name;
        }

        public long cardinality() {
            return this.cardinality;
        }
    }
}

