/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.xml;

import ai.grakn.migration.base.MigrationCLI;
import ai.grakn.migration.base.MigrationOptions;
import ai.grakn.migration.xml.XmlMigrationOptions;
import ai.grakn.migration.xml.XmlSchema;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlMigrator
implements AutoCloseable {
    private XmlSchema schema;
    private final Set<Reader> readers;
    private String element;
    private final FilenameFilter xmlFiles = (dir, name) -> name.toLowerCase().endsWith(".xml");

    public static void main(String[] args) {
        try {
            MigrationCLI.init((String[])args, XmlMigrationOptions::new).stream().filter(Optional::isPresent).map(Optional::get).forEach(XmlMigrator::runXml);
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
        }
    }

    public static void runXml(XmlMigrationOptions options) {
        File xmlDataFile = new File(options.getInput());
        File xmlTemplateFile = new File(options.getTemplate());
        if (!xmlDataFile.exists()) {
            throw new IllegalArgumentException("Cannot find file: " + options.getInput());
        }
        if (!xmlTemplateFile.exists() || xmlTemplateFile.isDirectory()) {
            throw new IllegalArgumentException("Cannot find file: " + options.getTemplate());
        }
        try (XmlMigrator xmlMigrator = new XmlMigrator(xmlDataFile);){
            if (options.getElement() == null) {
                throw new IllegalArgumentException("Please specify XML element for the top-level data item.");
            }
            xmlMigrator.element(options.getElement());
            if (options.getSchemaFile() != null) {
                xmlMigrator.schema(new XmlSchema().read(new File(options.getSchemaFile())));
            }
            MigrationCLI.loadOrPrint((File)xmlTemplateFile, xmlMigrator.convert(), (MigrationOptions)options);
        }
    }

    public XmlMigrator(File xmlFileOrDir) {
        File[] files = new File[]{xmlFileOrDir};
        if (xmlFileOrDir.isDirectory()) {
            files = xmlFileOrDir.listFiles(this.xmlFiles);
        }
        this.readers = Stream.of(files).map(this::asReader).collect(Collectors.toSet());
        this.schema = new XmlSchema();
    }

    public XmlMigrator(Reader reader) {
        this.readers = Sets.newHashSet((Object[])new Reader[]{reader});
    }

    public XmlMigrator element(String element) {
        this.element = element;
        return this;
    }

    public XmlMigrator schema(XmlSchema schema) {
        this.schema = schema;
        return this;
    }

    public Stream<Map<String, Object>> convert() {
        return this.readers.stream().flatMap(this::toXmlNodes).map(this::digest).map(data -> data);
    }

    @Override
    public void close() {
        this.readers.forEach(reader -> {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    Map<String, Object> digest(Element node) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder textContent = new StringBuilder();
        NodeList children = node.getChildNodes();
        block3: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    Element el = (Element)child;
                    Object value = null;
                    XmlSchema.TypeInfo type = this.schema.typeOf(el.getNodeName());
                    value = "xs:complexType".equals(type.name()) ? this.digest(el) : ("xs:boolean".equals(type.name()) ? Boolean.valueOf("true".equals(el.getTextContent().trim())) : ("xs:int".equals(type.name()) ? Integer.valueOf(Integer.parseInt(el.getTextContent().trim())) : ("xs:double".equals(type.name()) ? Double.valueOf(Double.parseDouble(el.getTextContent().trim())) : el.getTextContent())));
                    if (type.cardinality() > 1L) {
                        ArrayList<Object> allValues = (ArrayList<Object>)result.get(el.getTagName());
                        if (allValues == null) {
                            allValues = new ArrayList<Object>();
                            result.put(el.getTagName(), allValues);
                        }
                        allValues.add(value);
                        continue block3;
                    }
                    result.put(el.getTagName(), value);
                    continue block3;
                }
                default: {
                    textContent.append(child.getTextContent().trim());
                }
            }
        }
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            result.put("~" + attr.getName(), attr.getValue());
        }
        if (textContent.length() > 0) {
            result.put("textContent", textContent.toString());
        }
        return result;
    }

    Stream<Element> toXmlNodes(Reader reader) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(reader));
            NodeList list = doc.getElementsByTagName(this.element);
            Iterable iterable = () -> new ElementIterator(list);
            return StreamSupport.stream(iterable.spliterator(), false);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStreamReader asReader(File file) {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading input");
        }
    }

    private static class ElementIterator
    implements Iterator<Element> {
        private final NodeList list;
        int current;

        ElementIterator(NodeList list) {
            this.list = list;
            this.current = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.list.getLength();
        }

        @Override
        public Element next() {
            Element elem;
            if ((elem = (Element)this.list.item(this.current++)) == null) {
                throw new NoSuchElementException();
            }
            return elem;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

