/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn;

import ai.grakn.GraknDbConnectionState;
import ai.grakn.GraknSession;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.SNB;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Entity;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Match;
import ai.grakn.graql.Order;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.answer.ConceptList;
import ai.grakn.graql.answer.ConceptMap;
import ai.grakn.util.GraqlSyntax;
import com.ldbc.driver.DbException;
import com.ldbc.driver.Operation;
import com.ldbc.driver.OperationHandler;
import com.ldbc.driver.ResultReporter;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcQuery1;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcQuery13;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcQuery13Result;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcQuery1Result;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcQuery2;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcQuery2Result;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcQuery8;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcQuery8Result;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GraknQueryHandlers {
    private GraknQueryHandlers() {
    }

    public static class LdbcQuery13Handler
    implements OperationHandler<LdbcQuery13, GraknDbConnectionState> {
        public void executeOperation(LdbcQuery13 ldbcQuery13, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graknTx = session.transaction(GraknTxType.READ);){
                int l;
                Match match = Graql.match((Pattern[])new Pattern[]{SNB.$person.has("person-id", (Object)ldbcQuery13.person1Id())});
                Concept person1 = ((ConceptMap)match.withTx(graknTx).get().execute().iterator().next()).get(SNB.$person);
                match = Graql.match((Pattern[])new Pattern[]{SNB.$person.has("person-id", (Object)ldbcQuery13.person2Id())});
                Concept person2 = ((ConceptMap)match.withTx(graknTx).get().execute().iterator().next()).get(SNB.$person);
                List paths = Graql.compute((GraqlSyntax.Compute.Method)GraqlSyntax.Compute.Method.PATH).from(person1.id()).to(person2.id()).in("knows", new String[]{"person"}).withTx(graknTx).execute();
                List path = Collections.emptyList();
                if (!paths.isEmpty()) {
                    path = ((ConceptList)paths.get(0)).list();
                }
                LdbcQuery13Result result = (l = path.size() - 1) < 1 ? new LdbcQuery13Result(l) : new LdbcQuery13Result(l / 2);
                resultReporter.report(0, (Object)result, (Operation)ldbcQuery13);
            }
        }
    }

    public static class LdbcQuery1Handler
    implements OperationHandler<LdbcQuery1, GraknDbConnectionState> {
        public void executeOperation(LdbcQuery1 ldbcQuery1, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graknTx = session.transaction(GraknTxType.READ);){
                Var anyone = Graql.var((String)"anyone");
                Var anyoneElse = Graql.var((String)"anyoneElse");
                ConceptId graknPersonId = ((ConceptMap)Graql.match((Pattern[])new Pattern[]{SNB.$person.has("person-id", (Object)ldbcQuery1.personId())}).withTx(graknTx).get().execute().iterator().next()).get(SNB.$person).id();
                Comparator<ConceptMap> byLastNameAndId = Comparator.comparing(SNB.by(SNB.$lastName)).thenComparing(SNB.by(SNB.$friendId));
                Match match = Graql.match((Pattern[])new Pattern[]{SNB.$person.id(graknPersonId), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$friend).isa(SNB.KNOWS), SNB.$friend.has("first-name", (Object)ldbcQuery1.firstName()).has("last-name", (VarPattern)SNB.$lastName).has("person-id", (VarPattern)SNB.$friendId), SNB.$person.neq((VarPattern)SNB.$friend)});
                List distance1Result = match.withTx(graknTx).get().execute();
                List<LdbcQuery1Result> distance1LdbcResult = LdbcQuery1Handler.populateResults(distance1Result.stream().sorted(byLastNameAndId), ldbcQuery1, graknTx, 1);
                if (distance1Result.size() < ldbcQuery1.limit()) {
                    match = Graql.match((Pattern[])new Pattern[]{SNB.$person.id(graknPersonId), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)anyone).isa(SNB.KNOWS), Graql.var().rel((VarPattern)anyone).rel((VarPattern)SNB.$friend).isa(SNB.KNOWS), SNB.$friend.has("first-name", (Object)ldbcQuery1.firstName()).has("last-name", (VarPattern)SNB.$lastName).has("person-id", (VarPattern)SNB.$friendId), SNB.$person.neq((VarPattern)SNB.$friend)});
                    List distance2Result = match.withTx(graknTx).get().execute();
                    distance1LdbcResult.addAll(LdbcQuery1Handler.populateResults(distance2Result.stream().sorted(byLastNameAndId), ldbcQuery1, graknTx, 2));
                    if (distance1Result.size() + distance2Result.size() < ldbcQuery1.limit()) {
                        match = Graql.match((Pattern[])new Pattern[]{SNB.$person.id(graknPersonId), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)anyone).isa(SNB.KNOWS), Graql.var().rel((VarPattern)anyone).rel((VarPattern)anyoneElse).isa(SNB.KNOWS), Graql.var().rel((VarPattern)anyoneElse).rel((VarPattern)SNB.$friend).isa(SNB.KNOWS), SNB.$friend.has("first-name", (Object)ldbcQuery1.firstName()).has("last-name", (VarPattern)SNB.$lastName).has("person-id", (VarPattern)SNB.$friendId), SNB.$person.neq((VarPattern)SNB.$friend), SNB.$friend.neq((VarPattern)anyone)});
                        List distance3Result = match.withTx(graknTx).get().execute();
                        distance1LdbcResult.addAll(LdbcQuery1Handler.populateResults(distance3Result.stream().sorted(byLastNameAndId), ldbcQuery1, graknTx, 3));
                    }
                }
                resultReporter.report(0, distance1LdbcResult, (Operation)ldbcQuery1);
            }
        }

        private static List<LdbcQuery1Result> populateResults(Stream<ConceptMap> graqlResults, LdbcQuery1 ldbcQuery1, GraknTx graknTx, int distance) {
            return graqlResults.limit(ldbcQuery1.limit()).map(map -> {
                Var location = Graql.var((String)"aLocation");
                Match locationQuery = Graql.match((Pattern[])new Pattern[]{SNB.$friend.id(map.get(SNB.$friend).id()), Graql.var().rel((VarPattern)SNB.$friend).rel((VarPattern)location).isa(SNB.IS_LOCATED_IN)});
                ConceptMap locationResult = (ConceptMap)locationQuery.withTx(graknTx).get().execute().iterator().next();
                Var year = Graql.var((String)"aYear");
                Var oganisation = Graql.var((String)"aOrganisation");
                Match universityQuery = Graql.match((Pattern[])new Pattern[]{SNB.$friend.id(map.get(SNB.$friend).id()), Graql.var().rel((VarPattern)SNB.$friend).rel((VarPattern)oganisation).isa(SNB.STUDY_AT).has("class-year", (VarPattern)year), Graql.var().rel((VarPattern)oganisation).rel((VarPattern)location).isa(SNB.IS_LOCATED_IN)});
                List universityResults = universityQuery.withTx(graknTx).get().execute();
                List universityProcessedResults = universityResults.stream().map(answer -> {
                    ArrayList result = new ArrayList();
                    result.add(LdbcQuery1Handler.getSingleResource(answer.get(oganisation).asEntity(), "name", graknTx));
                    result.add(SNB.resource(answer, year));
                    result.add(LdbcQuery1Handler.getSingleResource(answer.get(location).asEntity(), "name", graknTx));
                    return result;
                }).collect(Collectors.toList());
                Match workQuery = Graql.match((Pattern[])new Pattern[]{SNB.$friend.id(map.get(SNB.$friend).id()), Graql.var().rel((VarPattern)SNB.$friend).rel((VarPattern)oganisation).isa(SNB.WORK_AT).has("work-from", (VarPattern)year), Graql.var().rel((VarPattern)oganisation).rel((VarPattern)location).isa(SNB.IS_LOCATED_IN)});
                List workResults = workQuery.withTx(graknTx).get().execute();
                List workProcessedResults = workResults.stream().map(answer -> {
                    ArrayList result = new ArrayList();
                    result.add(LdbcQuery1Handler.getSingleResource(answer.get(oganisation).asEntity(), "name", graknTx));
                    result.add(SNB.resource(answer, year));
                    result.add(LdbcQuery1Handler.getSingleResource(answer.get(location).asEntity(), "name", graknTx));
                    return result;
                }).collect(Collectors.toList());
                return new LdbcQuery1Result(((Long)SNB.resource(map, SNB.$friendId)).longValue(), (String)SNB.resource(map, SNB.$lastName), distance, SNB.toEpoch((LocalDateTime)LdbcQuery1Handler.getSingleResource(map.get(SNB.$friend).asEntity(), "birth-day", graknTx)), SNB.toEpoch((LocalDateTime)LdbcQuery1Handler.getSingleResource(map.get(SNB.$friend).asEntity(), "creation-date", graknTx)), (String)LdbcQuery1Handler.getSingleResource(map.get(SNB.$friend).asEntity(), "gender", graknTx), (String)LdbcQuery1Handler.getSingleResource(map.get(SNB.$friend).asEntity(), "browser-used", graknTx), (String)LdbcQuery1Handler.getSingleResource(map.get(SNB.$friend).asEntity(), "location-ip", graknTx), LdbcQuery1Handler.getListResources(map.get(SNB.$friend).asEntity(), "email", graknTx), LdbcQuery1Handler.getListResources(map.get(SNB.$friend).asEntity(), "speaks", graknTx), (String)LdbcQuery1Handler.getSingleResource(locationResult.get(location).asEntity(), "name", graknTx), universityProcessedResults, workProcessedResults);
            }).collect(Collectors.toList());
        }

        private static <T> T getSingleResource(Entity entity, String resourceType, GraknTx graknTx) {
            return (T)((Attribute)entity.attributes(new AttributeType[]{graknTx.getAttributeType(resourceType)}).iterator().next()).value();
        }

        private static <T> List<T> getListResources(Entity entity, String resourceType, GraknTx graknTx) {
            Stream rawResources = entity.attributes(new AttributeType[]{graknTx.getAttributeType(resourceType)});
            return rawResources.map(resource -> resource.value()).collect(Collectors.toList());
        }
    }

    public static class LdbcQuery8Handler
    implements OperationHandler<LdbcQuery8, GraknDbConnectionState> {
        public void executeOperation(LdbcQuery8 ldbcQuery8, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graknTx = session.transaction(GraknTxType.READ);){
                Var reply = Graql.var((String)"aReply");
                Var responder = Graql.var((String)"responder");
                Var responderId = Graql.var((String)"responderId");
                Match orderQuery = Graql.match((Pattern[])new Pattern[]{SNB.$person.has("person-id", (Object)ldbcQuery8.personId()), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$message).isa(SNB.HAS_CREATOR), Graql.var().rel((VarPattern)SNB.$message).rel(SNB.REPLY, (VarPattern)reply).isa(SNB.REPLY_OF), reply.has("creation-date", (VarPattern)SNB.$date).has("message-id", (VarPattern)SNB.$messageId)});
                List rawResult = orderQuery.withTx(graknTx).orderBy(SNB.$date, Order.desc).limit((long)ldbcQuery8.limit()).get().execute();
                List result = rawResult.stream().sorted(Comparator.comparing(SNB.by(SNB.$date)).reversed().thenComparing(SNB.by(SNB.$messageId))).map(map -> {
                    Match queryExtendedInfo = Graql.match((Pattern[])new Pattern[]{reply.has("message-id", SNB.resource(map, SNB.$messageId)), Graql.or((Pattern[])new Pattern[]{reply.has("content", (VarPattern)SNB.$content), reply.has("image-file", (VarPattern)SNB.$content)}), Graql.var().rel((VarPattern)reply).rel((VarPattern)responder).isa(SNB.HAS_CREATOR), responder.has("person-id", (VarPattern)responderId).has("first-name", (VarPattern)SNB.$firstName).has("last-name", (VarPattern)SNB.$lastName)});
                    ConceptMap extendedInfo = (ConceptMap)queryExtendedInfo.withTx(graknTx).get().execute().iterator().next();
                    return new LdbcQuery8Result(((Long)SNB.resource(extendedInfo, responderId)).longValue(), (String)SNB.resource(extendedInfo, SNB.$firstName), (String)SNB.resource(extendedInfo, SNB.$lastName), SNB.toEpoch((LocalDateTime)SNB.resource(map, SNB.$date)), ((Long)SNB.resource(map, SNB.$messageId)).longValue(), (String)SNB.resource(extendedInfo, SNB.$content));
                }).collect(Collectors.toList());
                resultReporter.report(0, result, (Operation)ldbcQuery8);
            }
        }
    }

    public static class LdbcQuery2Handler
    implements OperationHandler<LdbcQuery2, GraknDbConnectionState> {
        public void executeOperation(LdbcQuery2 ldbcQuery2, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graknTx = session.transaction(GraknTxType.READ);){
                LocalDateTime maxDate = SNB.fromDate(ldbcQuery2.maxDate());
                Match graknLdbcQuery2 = Graql.match((Pattern[])new Pattern[]{Graql.var().rel(SNB.$person.has("person-id", (Object)ldbcQuery2.personId())).rel((VarPattern)SNB.$friend).isa(SNB.KNOWS), Graql.var().rel((VarPattern)SNB.$friend).rel((VarPattern)SNB.$message).isa(SNB.HAS_CREATOR), SNB.$message.has("creation-date", (VarPattern)SNB.$date).has("message-id", (VarPattern)SNB.$messageId), SNB.$date.val(Graql.lte((Comparable)maxDate))});
                List rawResult = graknLdbcQuery2.orderBy(SNB.$date, Order.desc).limit((long)ldbcQuery2.limit()).withTx(graknTx).get().execute();
                List result = rawResult.stream().sorted(Comparator.comparing(SNB.by(SNB.$date)).reversed().thenComparing(SNB.by(SNB.$messageId))).map(map -> {
                    Match queryExtendedInfo = Graql.match((Pattern[])new Pattern[]{SNB.$friend.has("first-name", (VarPattern)SNB.$firstName).has("last-name", (VarPattern)SNB.$lastName).has("person-id", (VarPattern)SNB.$friendId), Graql.var().rel((VarPattern)SNB.$friend).rel((VarPattern)SNB.$message).isa(SNB.HAS_CREATOR), SNB.$message.has("creation-date", (VarPattern)SNB.$date).has("message-id", SNB.resource(map, SNB.$messageId)), Graql.or((Pattern[])new Pattern[]{SNB.$message.has("content", (VarPattern)SNB.$content), SNB.$message.has("image-file", (VarPattern)SNB.$content)})});
                    ConceptMap extendedInfo = (ConceptMap)queryExtendedInfo.withTx(graknTx).get().execute().iterator().next();
                    return new LdbcQuery2Result(((Long)SNB.resource(extendedInfo, SNB.$friendId)).longValue(), (String)SNB.resource(extendedInfo, SNB.$firstName), (String)SNB.resource(extendedInfo, SNB.$lastName), ((Long)SNB.resource(map, SNB.$messageId)).longValue(), (String)SNB.resource(extendedInfo, SNB.$content), SNB.toEpoch((LocalDateTime)SNB.resource(map, SNB.$date)));
                }).collect(Collectors.toList());
                resultReporter.report(0, result, (Operation)ldbcQuery2);
            }
        }
    }
}

