/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn;

import ai.grakn.GraknDbConnectionState;
import ai.grakn.GraknSession;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.SNB;
import ai.grakn.concept.ConceptId;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Order;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.answer.ConceptMap;
import com.ldbc.driver.DbException;
import com.ldbc.driver.Operation;
import com.ldbc.driver.OperationHandler;
import com.ldbc.driver.ResultReporter;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery1PersonProfile;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery1PersonProfileResult;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery2PersonPosts;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery2PersonPostsResult;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery3PersonFriends;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery3PersonFriendsResult;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery4MessageContent;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery4MessageContentResult;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery5MessageCreator;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery5MessageCreatorResult;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery6MessageForum;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery6MessageForumResult;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery7MessageReplies;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcShortQuery7MessageRepliesResult;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class GraknShortQueryHandlers {
    private GraknShortQueryHandlers() {
    }

    public static class LdbcShortQuery7MessageRepliesHandler
    implements OperationHandler<LdbcShortQuery7MessageReplies, GraknDbConnectionState> {
        public void executeOperation(LdbcShortQuery7MessageReplies operation, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.READ);){
                List results = graph.graql().match(new Pattern[]{SNB.$message.isa(SNB.MESSAGE).has("message-id", (Object)operation.messageId()), Graql.var().rel(SNB.PRODUCT, (VarPattern)SNB.$message).rel(SNB.CREATOR, (VarPattern)SNB.$author1).isa(SNB.HAS_CREATOR), Graql.var().rel(SNB.ORIGINAL, (VarPattern)SNB.$message).rel(SNB.REPLY, (VarPattern)SNB.$comment).isa(SNB.REPLY_OF), Graql.var().rel((VarPattern)SNB.$comment).rel((VarPattern)SNB.$commentId).isa(SNB.key("message-id")), Graql.var().rel((VarPattern)SNB.$comment).rel((VarPattern)SNB.$content).isa(SNB.has("content")), Graql.var().rel((VarPattern)SNB.$comment).rel((VarPattern)SNB.$date).isa(SNB.has("creation-date")), Graql.var().rel(SNB.PRODUCT, (VarPattern)SNB.$comment).rel(SNB.CREATOR, (VarPattern)SNB.$author2).isa(SNB.HAS_CREATOR), Graql.var().rel((VarPattern)SNB.$author2).rel((VarPattern)SNB.$personId).isa(SNB.key("person-id")), Graql.var().rel((VarPattern)SNB.$author2).rel((VarPattern)SNB.$firstName).isa(SNB.has("first-name")), Graql.var().rel((VarPattern)SNB.$author2).rel((VarPattern)SNB.$lastName).isa(SNB.has("last-name"))}).get().execute();
                List result = results.stream().sorted(Comparator.comparing(SNB.by(SNB.$date)).reversed().thenComparing(SNB.by(SNB.$personId))).map(map -> new LdbcShortQuery7MessageRepliesResult(((Long)SNB.resource(map, SNB.$commentId)).longValue(), (String)SNB.resource(map, SNB.$content), SNB.toEpoch((LocalDateTime)SNB.resource(map, SNB.$date)), ((Long)SNB.resource(map, SNB.$personId)).longValue(), (String)SNB.resource(map, SNB.$firstName), (String)SNB.resource(map, SNB.$lastName), this.checkIfFriends(this.conceptId((ConceptMap)map, SNB.$author1), this.conceptId((ConceptMap)map, SNB.$author2), graph))).collect(Collectors.toList());
                resultReporter.report(0, result, (Operation)operation);
            }
        }

        private boolean checkIfFriends(ConceptId author1, ConceptId author2, GraknTx graph) {
            return graph.graql().match(new Pattern[]{Graql.var().rel(SNB.FRIEND, Graql.var().id(author1)).rel(SNB.FRIEND, Graql.var().id(author2)).isa(SNB.KNOWS)}).stream().findAny().isPresent();
        }

        private ConceptId conceptId(ConceptMap result, Var var) {
            return result.get(var).id();
        }
    }

    public static class LdbcShortQuery6MessageForumHandler
    implements OperationHandler<LdbcShortQuery6MessageForum, GraknDbConnectionState> {
        public void executeOperation(LdbcShortQuery6MessageForum operation, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.READ);){
                List results = graph.graql().infer(true).match(new Pattern[]{SNB.$message.has("message-id", (Object)operation.messageId()), Graql.var().rel(SNB.MEMBER_MESSAGE, (VarPattern)SNB.$message).rel(SNB.GROUP_FORUM, (VarPattern)SNB.$forum).isa(SNB.FORUM_MEMBER), SNB.$forum.has("forum-id", (VarPattern)SNB.$forumId).has("title", (VarPattern)SNB.$title), Graql.var().rel(SNB.MODERATED, (VarPattern)SNB.$forum).rel(SNB.MODERATOR, (VarPattern)SNB.$mod).isa(SNB.HAS_MODERATOR), SNB.$mod.isa(SNB.PERSON).has("person-id", (VarPattern)SNB.$modId).has("first-name", (VarPattern)SNB.$firstName).has("last-name", (VarPattern)SNB.$lastName)}).get().execute();
                if (!results.isEmpty()) {
                    ConceptMap fres = (ConceptMap)results.get(0);
                    LdbcShortQuery6MessageForumResult result = new LdbcShortQuery6MessageForumResult(((Long)SNB.resource(fres, SNB.$forumId)).longValue(), (String)SNB.resource(fres, SNB.$title), ((Long)SNB.resource(fres, SNB.$modId)).longValue(), (String)SNB.resource(fres, SNB.$firstName), (String)SNB.resource(fres, SNB.$lastName));
                    resultReporter.report(0, (Object)result, (Operation)operation);
                } else {
                    resultReporter.report(0, null, (Operation)operation);
                }
            }
        }
    }

    public static class LdbcShortQuery5MessageCreatorHandler
    implements OperationHandler<LdbcShortQuery5MessageCreator, GraknDbConnectionState> {
        public void executeOperation(LdbcShortQuery5MessageCreator operation, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.READ);){
                List results = graph.graql().match(new Pattern[]{SNB.$message.has("message-id", (Object)operation.messageId()), Graql.var().rel(SNB.PRODUCT, (VarPattern)SNB.$message).rel(SNB.CREATOR, (VarPattern)SNB.$person).isa(SNB.HAS_CREATOR), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$firstName).isa(SNB.has("first-name")), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$lastName).isa(SNB.has("last-name")), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$personId).isa(SNB.key("person-id"))}).get().execute();
                if (!results.isEmpty()) {
                    ConceptMap fres = (ConceptMap)results.get(0);
                    LdbcShortQuery5MessageCreatorResult result = new LdbcShortQuery5MessageCreatorResult(((Long)SNB.resource(fres, SNB.$personId)).longValue(), (String)SNB.resource(fres, SNB.$firstName), (String)SNB.resource(fres, SNB.$lastName));
                    resultReporter.report(0, (Object)result, (Operation)operation);
                } else {
                    resultReporter.report(0, null, (Operation)operation);
                }
            }
        }
    }

    public static class LdbcShortQuery4MessageContentHandler
    implements OperationHandler<LdbcShortQuery4MessageContent, GraknDbConnectionState> {
        public void executeOperation(LdbcShortQuery4MessageContent operation, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.READ);){
                List results = graph.graql().match(new Pattern[]{SNB.$message.has("message-id", (Object)operation.messageId()), Graql.var().rel((VarPattern)SNB.$message).rel((VarPattern)SNB.$date).isa(SNB.has("creation-date")), Graql.var().rel((VarPattern)SNB.$message).rel((VarPattern)SNB.$content).isa(SNB.has("content")).or((Pattern)Graql.var().rel((VarPattern)SNB.$message).rel((VarPattern)SNB.$content).isa(SNB.has("image-file")))}).get().execute();
                if (!results.isEmpty()) {
                    ConceptMap fres = (ConceptMap)results.get(0);
                    LdbcShortQuery4MessageContentResult result = new LdbcShortQuery4MessageContentResult((String)SNB.resource(fres, SNB.$content), SNB.toEpoch((LocalDateTime)SNB.resource(fres, SNB.$date)));
                    resultReporter.report(0, (Object)result, (Operation)operation);
                } else {
                    resultReporter.report(0, null, (Operation)operation);
                }
            }
        }
    }

    public static class LdbcShortQuery3PersonFriendsHandler
    implements OperationHandler<LdbcShortQuery3PersonFriends, GraknDbConnectionState> {
        public void executeOperation(LdbcShortQuery3PersonFriends operation, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.READ);){
                List results = graph.graql().match(new Pattern[]{SNB.$person.has("person-id", (Object)operation.personId()), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$friend).isa(SNB.KNOWS).has("creation-date", (VarPattern)SNB.$date), SNB.$friend.has("person-id", (VarPattern)SNB.$friendId).has("first-name", (VarPattern)SNB.$firstName).has("last-name", (VarPattern)SNB.$lastName)}).get().execute();
                List result = results.stream().sorted(Comparator.comparing(SNB.by(SNB.$date)).reversed().thenComparing(SNB.by(SNB.$friendId))).map(map -> new LdbcShortQuery3PersonFriendsResult(((Long)SNB.resource(map, SNB.$friendId)).longValue(), (String)SNB.resource(map, SNB.$firstName), (String)SNB.resource(map, SNB.$lastName), SNB.toEpoch((LocalDateTime)SNB.resource(map, SNB.$date)))).collect(Collectors.toList());
                resultReporter.report(0, result, (Operation)operation);
            }
        }
    }

    public static class LdbcShortQuery2PersonPostsHandler
    implements OperationHandler<LdbcShortQuery2PersonPosts, GraknDbConnectionState> {
        public void executeOperation(LdbcShortQuery2PersonPosts operation, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.READ);){
                List messageResults = graph.graql().match(new Pattern[]{SNB.$person.isa(SNB.PERSON).has("person-id", (Object)operation.personId()), Graql.var().rel(SNB.CREATOR, (VarPattern)SNB.$person).rel(SNB.PRODUCT, (VarPattern)SNB.$message).isa(SNB.HAS_CREATOR), Graql.var().rel((VarPattern)SNB.$message).rel((VarPattern)SNB.$date).isa(SNB.has("creation-date")), Graql.var().rel((VarPattern)SNB.$message).rel((VarPattern)SNB.$messageId).isa(SNB.key("message-id"))}).orderBy(SNB.$date, Order.desc).limit((long)operation.limit()).get().execute();
                ArrayList allResults = new ArrayList();
                messageResults.forEach(a -> {
                    List results = graph.graql().infer(true).match(new Pattern[]{SNB.$message.id(a.get(SNB.$message).id()), Graql.var().rel((VarPattern)SNB.$message).rel((VarPattern)SNB.$date).isa(SNB.has("creation-date")), Graql.var().rel((VarPattern)SNB.$message).rel((VarPattern)SNB.$messageId).isa(SNB.key("message-id")), Graql.var().rel((VarPattern)SNB.$message).rel((VarPattern)SNB.$content).isa(SNB.has("content")).or((Pattern)Graql.var().rel((VarPattern)SNB.$message).rel((VarPattern)SNB.$content).isa(SNB.has("image-file"))), SNB.$originalPost.isa(SNB.POST), Graql.var().rel(SNB.CHILD_MESSAGE, (VarPattern)SNB.$message).rel(SNB.PARENT_MESSAGE, (VarPattern)SNB.$originalPost).isa(SNB.ORIGINAL_POST), Graql.var().rel((VarPattern)SNB.$originalPost).rel((VarPattern)SNB.$opId).isa(SNB.key("message-id")), SNB.$author.isa(SNB.PERSON), Graql.var().rel(SNB.PRODUCT, (VarPattern)SNB.$originalPost).rel(SNB.CREATOR, (VarPattern)SNB.$author).isa(SNB.HAS_CREATOR), Graql.var().rel((VarPattern)SNB.$author).rel((VarPattern)SNB.$authorId).isa(SNB.key("person-id")), Graql.var().rel((VarPattern)SNB.$author).rel((VarPattern)SNB.$firstName).isa(SNB.has("first-name")), Graql.var().rel((VarPattern)SNB.$author).rel((VarPattern)SNB.$lastName).isa(SNB.has("last-name"))}).get().execute();
                    allResults.addAll(results);
                });
                List result = allResults.stream().sorted(Comparator.comparing(SNB.by(SNB.$date)).thenComparing(SNB.by(SNB.$messageId)).reversed()).map(map -> new LdbcShortQuery2PersonPostsResult(((Long)SNB.resource(map, SNB.$messageId)).longValue(), (String)SNB.resource(map, SNB.$content), SNB.toEpoch((LocalDateTime)SNB.resource(map, SNB.$date)), ((Long)SNB.resource(map, SNB.$opId)).longValue(), ((Long)SNB.resource(map, SNB.$authorId)).longValue(), (String)SNB.resource(map, SNB.$firstName), (String)SNB.resource(map, SNB.$lastName))).collect(Collectors.toList());
                resultReporter.report(0, result, (Operation)operation);
            }
        }
    }

    public static class LdbcShortQuery1PersonProfileHandler
    implements OperationHandler<LdbcShortQuery1PersonProfile, GraknDbConnectionState> {
        public void executeOperation(LdbcShortQuery1PersonProfile operation, GraknDbConnectionState dbConnectionState, ResultReporter resultReporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.READ);){
                Optional answer = graph.graql().match(new Pattern[]{SNB.$person.has("person-id", (Object)operation.personId()), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$firstName).isa(SNB.has("first-name")), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$lastName).isa(SNB.has("last-name")), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$birthday).isa(SNB.has("birth-day")), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$locationIp).isa(SNB.has("location-ip")), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$browserUsed).isa(SNB.has("browser-used")), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$gender).isa(SNB.has("gender")), Graql.var().rel((VarPattern)SNB.$person).rel((VarPattern)SNB.$creationDate).isa(SNB.has("creation-date")), Graql.var().rel(SNB.LOCATED, (VarPattern)SNB.$person).rel(SNB.REGION, (VarPattern)SNB.$place).isa(SNB.IS_LOCATED_IN), Graql.var().rel((VarPattern)SNB.$place).rel((VarPattern)SNB.$placeId).isa(SNB.key("place-id"))}).get().stream().findAny();
                if (answer.isPresent()) {
                    ConceptMap fres = (ConceptMap)answer.get();
                    LdbcShortQuery1PersonProfileResult result = new LdbcShortQuery1PersonProfileResult((String)fres.get(SNB.$firstName).asAttribute().value(), (String)fres.get(SNB.$lastName).asAttribute().value(), SNB.toEpoch((LocalDateTime)fres.get(SNB.$birthday).asAttribute().value()), (String)fres.get(SNB.$locationIp).asAttribute().value(), (String)fres.get(SNB.$browserUsed).asAttribute().value(), ((Long)fres.get(SNB.$placeId).asAttribute().value()).longValue(), (String)fres.get(SNB.$gender).asAttribute().value(), SNB.toEpoch((LocalDateTime)fres.get(SNB.$creationDate).asAttribute().value()));
                    resultReporter.report(0, (Object)result, (Operation)operation);
                } else {
                    resultReporter.report(0, null, (Operation)operation);
                }
            }
        }
    }
}

