/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn;

import ai.grakn.GraknDbConnectionState;
import ai.grakn.GraknSession;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.SNB;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import com.google.common.collect.ImmutableSet;
import com.ldbc.driver.DbException;
import com.ldbc.driver.Operation;
import com.ldbc.driver.OperationHandler;
import com.ldbc.driver.ResultReporter;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcNoResult;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcUpdate1AddPerson;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcUpdate2AddPostLike;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcUpdate3AddCommentLike;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcUpdate4AddForum;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcUpdate5AddForumMembership;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcUpdate6AddPost;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcUpdate7AddComment;
import com.ldbc.driver.workloads.ldbc.snb.interactive.LdbcUpdate8AddFriendship;
import java.util.Collection;
import java.util.Iterator;

public class GraknUpdateQueryHandlers {
    private GraknUpdateQueryHandlers() {
    }

    public static class LdbcUpdate8AddFriendshipHandler
    implements OperationHandler<LdbcUpdate8AddFriendship, GraknDbConnectionState> {
        public void executeOperation(LdbcUpdate8AddFriendship operation, GraknDbConnectionState dbConnectionState, ResultReporter reporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.WRITE);){
                Var person1 = Graql.var((String)"person1");
                Var person2 = Graql.var((String)"person2");
                graph.graql().match(new Pattern[]{person1.has("person-id", (Object)operation.person1Id()), person2.has("person-id", (Object)operation.person2Id())}).insert(new VarPattern[]{Graql.var().rel(SNB.FRIEND, (VarPattern)person1).rel(SNB.FRIEND, (VarPattern)person2).isa(SNB.KNOWS).has("creation-date", (Object)SNB.fromDate(operation.creationDate()))}).execute();
                graph.commit();
                reporter.report(0, (Object)LdbcNoResult.INSTANCE, (Operation)operation);
            }
        }
    }

    public static class LdbcUpdate7AddCommentHandler
    implements OperationHandler<LdbcUpdate7AddComment, GraknDbConnectionState> {
        public void executeOperation(LdbcUpdate7AddComment operation, GraknDbConnectionState dbConnectionState, ResultReporter reporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.WRITE);){
                ImmutableSet.Builder match = ImmutableSet.builder();
                ImmutableSet.Builder insert = ImmutableSet.builder();
                match.add((Object)SNB.$author.has("person-id", (Object)operation.authorPersonId()));
                if (operation.replyToPostId() != -1L) {
                    match.add((Object)SNB.$original.has("message-id", (Object)operation.replyToPostId()));
                } else {
                    match.add((Object)SNB.$original.has("message-id", (Object)operation.replyToCommentId()));
                }
                match.add((Object)SNB.$country.has("place-id", (Object)operation.countryId()));
                Iterator iterator = operation.tagIds().iterator();
                while (iterator.hasNext()) {
                    long tagId = (Long)iterator.next();
                    Var tag = Graql.var((String)Long.toString(tagId));
                    match.add((Object)tag.has("tag-id", (Object)tagId));
                    insert.add((Object)Graql.var().rel(SNB.TAGGED, (VarPattern)SNB.$comment).rel(SNB.TOPIC, (VarPattern)tag).isa(SNB.HAS_TAG));
                }
                insert.add((Object[])new VarPattern[]{SNB.$comment.isa(SNB.COMMENT).has("message-id", (Object)operation.commentId()).has("content", (Object)operation.content()).has("location-ip", (Object)operation.locationIp()).has("browser-used", (Object)operation.browserUsed()).has("creation-date", (Object)SNB.fromDate(operation.creationDate())).has("length", (Object)operation.length()), Graql.var().rel(SNB.PRODUCT, (VarPattern)SNB.$comment).rel(SNB.CREATOR, (VarPattern)SNB.$author).isa(SNB.HAS_CREATOR), Graql.var().rel(SNB.LOCATED, (VarPattern)SNB.$comment).rel(SNB.REGION, (VarPattern)SNB.$country).isa(SNB.IS_LOCATED_IN), Graql.var().rel(SNB.REPLY, (VarPattern)SNB.$comment).rel(SNB.ORIGINAL, (VarPattern)SNB.$original).isa(SNB.REPLY_OF)});
                graph.graql().match((Collection)match.build()).insert((Collection)insert.build()).execute();
                graph.commit();
                reporter.report(0, (Object)LdbcNoResult.INSTANCE, (Operation)operation);
            }
        }
    }

    public static class LdbcUpdate6AddPostHandler
    implements OperationHandler<LdbcUpdate6AddPost, GraknDbConnectionState> {
        public void executeOperation(LdbcUpdate6AddPost operation, GraknDbConnectionState dbConnectionState, ResultReporter reporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.WRITE);){
                ImmutableSet.Builder match = ImmutableSet.builder();
                ImmutableSet.Builder insert = ImmutableSet.builder();
                match.add((Object[])new VarPattern[]{SNB.$author.has("person-id", (Object)operation.authorPersonId()), SNB.$forum.has("forum-id", (Object)operation.forumId()), SNB.$country.has("place-id", (Object)operation.countryId())});
                Iterator iterator = operation.tagIds().iterator();
                while (iterator.hasNext()) {
                    long tagId = (Long)iterator.next();
                    Var tag = Graql.var((String)Long.toString(tagId));
                    match.add((Object)tag.has("tag-id", (Object)tagId));
                    insert.add((Object)Graql.var().rel(SNB.TAGGED, (VarPattern)SNB.$post).rel(SNB.TOPIC, (VarPattern)tag).isa(SNB.HAS_TAG));
                }
                insert.add((Object)SNB.$post.isa(SNB.POST).has("message-id", (Object)operation.postId()).has("location-ip", (Object)operation.locationIp()).has("browser-used", (Object)operation.browserUsed()).has("length", (Object)operation.length()).has("creation-date", (Object)SNB.fromDate(operation.creationDate())));
                if (operation.language().length() > 0) {
                    insert.add((Object)SNB.$post.has("language", (Object)operation.language()));
                }
                if (operation.imageFile().length() > 0) {
                    insert.add((Object)SNB.$post.has("image-file", (Object)operation.imageFile()));
                } else {
                    insert.add((Object)SNB.$post.has("content", (Object)operation.content()));
                }
                insert.add((Object[])new VarPattern[]{Graql.var().rel(SNB.PRODUCT, (VarPattern)SNB.$post).rel(SNB.CREATOR, (VarPattern)SNB.$author).isa(SNB.HAS_CREATOR), Graql.var().rel(SNB.LOCATED, (VarPattern)SNB.$post).rel(SNB.REGION, (VarPattern)SNB.$country).isa(SNB.IS_LOCATED_IN), Graql.var().rel(SNB.CONTAINED, (VarPattern)SNB.$post).rel(SNB.CONTAINER, (VarPattern)SNB.$forum).isa(SNB.CONTAINER_OF)});
                graph.graql().match((Collection)match.build()).insert((Collection)insert.build()).execute();
                graph.commit();
                reporter.report(0, (Object)LdbcNoResult.INSTANCE, (Operation)operation);
            }
        }
    }

    public static class LdbcUpdate5AddForumMembershipHandler
    implements OperationHandler<LdbcUpdate5AddForumMembership, GraknDbConnectionState> {
        public void executeOperation(LdbcUpdate5AddForumMembership operation, GraknDbConnectionState dbConnectionState, ResultReporter reporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.WRITE);){
                graph.graql().match(new Pattern[]{SNB.$forum.has("forum-id", (Object)operation.forumId()), SNB.$person.has("person-id", (Object)operation.personId())}).insert(new VarPattern[]{Graql.var().rel(SNB.MEMBER, (VarPattern)SNB.$person).rel(SNB.GROUP, (VarPattern)SNB.$forum).isa(SNB.HAS_MEMBER).has("join-date", (Object)SNB.fromDate(operation.joinDate()))}).execute();
                graph.commit();
                reporter.report(0, (Object)LdbcNoResult.INSTANCE, (Operation)operation);
            }
        }
    }

    public static class LdbcUpdate4AddForumHandler
    implements OperationHandler<LdbcUpdate4AddForum, GraknDbConnectionState> {
        public void executeOperation(LdbcUpdate4AddForum operation, GraknDbConnectionState dbConnectionState, ResultReporter reporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.WRITE);){
                ImmutableSet.Builder match = ImmutableSet.builder();
                ImmutableSet.Builder insert = ImmutableSet.builder();
                match.add((Object)SNB.$mod.has("person-id", (Object)operation.moderatorPersonId()));
                Iterator iterator = operation.tagIds().iterator();
                while (iterator.hasNext()) {
                    long tagId = (Long)iterator.next();
                    Var tag = Graql.var((String)Long.toString(tagId));
                    match.add((Object)tag.has("tag-id", (Object)tagId));
                    insert.add((Object)Graql.var().rel(SNB.TAGGED, (VarPattern)SNB.$forum).rel(SNB.TOPIC, (VarPattern)tag).isa(SNB.HAS_TAG));
                }
                insert.add((Object)SNB.$forum.isa(SNB.FORUM).has("forum-id", (Object)operation.forumId()).has("title", (Object)operation.forumTitle()).has("creation-date", (Object)SNB.fromDate(operation.creationDate())));
                insert.add((Object)Graql.var().rel(SNB.MODERATOR, (VarPattern)SNB.$mod).rel(SNB.MODERATED, (VarPattern)SNB.$forum).isa(SNB.HAS_MODERATOR));
                graph.graql().match((Collection)match.build()).insert((Collection)insert.build()).execute();
                graph.commit();
                reporter.report(0, (Object)LdbcNoResult.INSTANCE, (Operation)operation);
            }
        }
    }

    public static class LdbcUpdate3AddCommentLikeHandler
    implements OperationHandler<LdbcUpdate3AddCommentLike, GraknDbConnectionState> {
        public void executeOperation(LdbcUpdate3AddCommentLike operation, GraknDbConnectionState dbConnectionState, ResultReporter reporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.WRITE);){
                graph.graql().match(new Pattern[]{SNB.$person.has("person-id", (Object)operation.personId()), SNB.$message.has("message-id", (Object)operation.commentId())}).insert(new VarPattern[]{Graql.var().rel(SNB.ADMIRER, (VarPattern)SNB.$person).rel(SNB.LIKE, (VarPattern)SNB.$message).isa(SNB.LIKES).has("creation-date", (Object)SNB.fromDate(operation.creationDate()))}).execute();
                graph.commit();
                reporter.report(0, (Object)LdbcNoResult.INSTANCE, (Operation)operation);
            }
        }
    }

    public static class LdbcUpdate2AddPostLikeHandler
    implements OperationHandler<LdbcUpdate2AddPostLike, GraknDbConnectionState> {
        public void executeOperation(LdbcUpdate2AddPostLike operation, GraknDbConnectionState dbConnectionState, ResultReporter reporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.WRITE);){
                graph.graql().match(new Pattern[]{SNB.$person.has("person-id", (Object)operation.personId()), SNB.$message.has("message-id", (Object)operation.postId())}).insert(new VarPattern[]{Graql.var().rel(SNB.ADMIRER, (VarPattern)SNB.$person).rel(SNB.LIKE, (VarPattern)SNB.$message).isa(SNB.LIKES).has("creation-date", (Object)SNB.fromDate(operation.creationDate()))}).execute();
                graph.commit();
                reporter.report(0, (Object)LdbcNoResult.INSTANCE, (Operation)operation);
            }
        }
    }

    public static class LdbcUpdate1AddPersonHandler
    implements OperationHandler<LdbcUpdate1AddPerson, GraknDbConnectionState> {
        public void executeOperation(LdbcUpdate1AddPerson operation, GraknDbConnectionState dbConnectionState, ResultReporter reporter) throws DbException {
            GraknSession session = dbConnectionState.session();
            try (GraknTx graph = session.transaction(GraknTxType.WRITE);){
                Var organisation;
                ImmutableSet.Builder match = ImmutableSet.builder();
                ImmutableSet.Builder insert = ImmutableSet.builder();
                match.add((Object)SNB.$city.has("place-id", (Object)operation.cityId()));
                for (Long theTag : operation.tagIds()) {
                    Var tag = Graql.var((String)theTag.toString());
                    match.add((Object)tag.isa(SNB.TAG).has("tag-id", (Object)theTag));
                    insert.add((Object)Graql.var().rel(SNB.INTERESTED, (VarPattern)SNB.$person).rel(SNB.INTEREST, (VarPattern)tag).isa(SNB.HAS_INTEREST));
                }
                for (LdbcUpdate1AddPerson.Organization org : operation.studyAt()) {
                    organisation = Graql.var((String)Long.toString(org.organizationId()));
                    match.add((Object)organisation.isa(SNB.UNIVERSITY).has("organisation-id", (Object)org.organizationId()));
                    insert.add((Object)Graql.var().rel(SNB.STUDENT, (VarPattern)SNB.$person).rel(SNB.SCHOOL, (VarPattern)organisation).isa(SNB.STUDY_AT).has("class-year", (Object)org.year()));
                }
                for (LdbcUpdate1AddPerson.Organization org : operation.workAt()) {
                    organisation = Graql.var((String)Long.toString(org.organizationId()));
                    match.add((Object)organisation.isa(SNB.COMPANY).has("organisation-id", (Object)org.organizationId()));
                    insert.add((Object)Graql.var().rel(SNB.EMPLOYEE, (VarPattern)SNB.$person).rel(SNB.EMPLOYER, (VarPattern)organisation).isa(SNB.WORK_AT).has("work-from", (Object)org.year()));
                }
                insert.add((Object)SNB.$person.isa(SNB.PERSON).has("person-id", (Object)operation.personId()).has("first-name", (Object)operation.personFirstName()).has("last-name", (Object)operation.personLastName()).has("birth-day", (Object)SNB.fromDate(operation.birthday())).has("creation-date", (Object)SNB.fromDate(operation.creationDate())).has("location-ip", (Object)operation.locationIp()).has("browser-used", (Object)operation.browserUsed()).has("gender", (Object)operation.gender()));
                for (String language : operation.languages()) {
                    insert.add((Object)SNB.$person.has("speaks", (Object)language));
                }
                for (String theEmail : operation.emails()) {
                    insert.add((Object)SNB.$person.has("email", (Object)theEmail));
                }
                insert.add((Object)Graql.var().rel(SNB.LOCATED, (VarPattern)SNB.$person).rel(SNB.REGION, (VarPattern)SNB.$city).isa(SNB.IS_LOCATED_IN));
                graph.graql().match((Collection)match.build()).insert((Collection)insert.build()).execute();
                graph.commit();
                reporter.report(0, (Object)LdbcNoResult.INSTANCE, (Operation)operation);
            }
        }
    }
}

