/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.featurestore.abfs;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.security.AccessControlException;

public class FeatureStoreSASTokenProvider
implements SASTokenProvider {
    private Configuration configuration;

    public void initialize(Configuration configuration, String accountName) throws IOException {
        this.configuration = configuration;
    }

    public String getSASToken(String account, String fileSystem, String path, String operation) throws IOException, AccessControlException {
        String token;
        String rootToken = this.configuration.get(String.format("spark.hadoop.ai.h2o.featurestore.storage.%s.%s.rootSasToken", account, fileSystem));
        String correctedPath = this.getCorrectedPath(path);
        if (correctedPath.isEmpty()) {
            token = rootToken;
        } else {
            Path tokenPath = FileSystems.getDefault().getPath(correctedPath, new String[0]);
            token = this.findPathToken(account, fileSystem, tokenPath);
        }
        if (token != null && !token.isEmpty()) {
            return token;
        }
        return this.configuration.get("spark.hadoop.ai.h2o.featurestore.storage.staticToken");
    }

    private String getCorrectedPath(String path) {
        String correctedPath = path.replaceAll("/+", "/");
        if (correctedPath.startsWith("/")) {
            return correctedPath.substring(1);
        }
        return correctedPath;
    }

    private String findPathToken(String account, String fileSystem, Path path) {
        if (path == null) {
            return this.configuration.get(String.format("spark.hadoop.ai.h2o.featurestore.storage.%s.%s.pathSasToken", account, fileSystem));
        }
        String token = this.configuration.get(String.format("spark.hadoop.ai.h2o.featurestore.storage.%s.%s.%s.pathSasToken", account, fileSystem, path));
        if (token != null) {
            return token;
        }
        return this.findPathToken(account, fileSystem, path.getParent());
    }
}

