package ai.h2o.featurestore.abfs;

import ai.h2o.featurestore.Token;
import ai.h2o.featurestore.TokenProvider;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.security.AccessControlException;

/**
 * A class that provides SAS tokens for Feature Store operations on Azure Blob Storage.
 */
public class FeatureStoreSASTokenProvider implements SASTokenProvider {

  private Configuration configuration;

  @Override
  public void initialize(Configuration configuration, String accountName) {
    this.configuration = configuration;
  }

  @Override
  public String getSASToken(String account, String fileSystem, String path, String operation) {
    TokenProvider tokenProvider = new TokenProvider(configuration,
        String.format("spark.hadoop.ai.h2o.featurestore.storage.%s.%s", account, fileSystem));
    Token token =  tokenProvider.getToken(path);
    if(token != null) {
      return token.getToken();
    } else {
      return null;
    }
  }
}
