package ai.h2o.featurestore.gs;

import ai.h2o.featurestore.Token;
import ai.h2o.featurestore.TokenProvider;
import com.google.cloud.hadoop.util.AccessBoundary;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class FeatureStoreTokenProvider implements AccessTokenProvider {

  private Configuration configuration;

  @Override
  public AccessToken getAccessToken() {
    return null;
  }

  @Override
  public AccessToken getAccessToken(List<AccessBoundary> accessBoundaries) {
    AccessBoundary accessBoundary = accessBoundaries.get(0);

    TokenProvider tokenProvider = new TokenProvider(configuration,
        String.format("spark.hadoop.ai.h2o.featurestore.storage.%s", accessBoundary.bucketName()));
    Token token = tokenProvider.getToken(accessBoundary.objectName());
    if (token != null) {
      return new AccessToken(token.getToken(), Duration.between(Instant.now(), token.getExpirationTime()).toMillis());
    } else {
      return null;
    }
  }

  @Override
  public AccessTokenType getAccessTokenType() {
    return AccessTokenType.DOWNSCOPED;
  }

  @Override
  public void refresh() {

  }

  @Override
  public void setConf(Configuration conf) {
    this.configuration = conf;
  }

  @Override
  public Configuration getConf() {
    return configuration;
  }
}
