/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.featurestore;

import java.time.Instant;

public class Token {
    private final String token;
    private final Instant expirationTime;

    public Token(String token, Instant expirationTime) {
        this.token = token;
        this.expirationTime = expirationTime;
    }

    public static Token createToken(String token, String expirationTime) {
        if (token == null || token.isEmpty()) {
            return null;
        }
        if (expirationTime != null && !expirationTime.isEmpty()) {
            return new Token(token, Instant.parse(expirationTime));
        }
        return new Token(token, null);
    }

    public String getToken() {
        return this.token;
    }

    public Instant getExpirationTime() {
        return this.expirationTime;
    }
}

