/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.featurestore;

import ai.h2o.featurestore.Token;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenProvider {
    private static final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    private final Configuration configuration;
    private final String prefix;

    public TokenProvider(Configuration configuration, String prefix) {
        this.configuration = configuration;
        this.prefix = prefix;
    }

    public Token getToken(String path) {
        String rootToken = this.configuration.get(String.format("%s.rootSasToken", this.prefix));
        String correctedPath = this.getCorrectedPath(path);
        if (correctedPath.isEmpty()) {
            return Token.createToken(rootToken, null);
        }
        Path tokenPath = FileSystems.getDefault().getPath(correctedPath, new String[0]);
        Token token = this.findPathToken(tokenPath);
        if (token != null) {
            return token;
        }
        return Token.createToken(this.configuration.get("spark.hadoop.ai.h2o.featurestore.storage.staticToken"), null);
    }

    private String getCorrectedPath(String path) {
        String correctedPath = path.replaceAll("/+", "/");
        if (correctedPath.startsWith("/")) {
            return correctedPath.substring(1);
        }
        return correctedPath;
    }

    private Token findPathToken(Path path) {
        log.info("Retrieving token for: {}", (Object)path);
        if (path == null) {
            String sasToken = this.configuration.get(this.prefix + ".pathSasToken");
            String expirationTime = this.configuration.get(this.prefix + ".expirationTime");
            return Token.createToken(sasToken, expirationTime);
        }
        return this.getFilePath(path).or(() -> this.getDirectoryPath(path)).orElseGet(() -> this.findPathToken(path.getParent()));
    }

    private Optional<Token> getFilePath(Path path) {
        return this.getFilePath(path.toString());
    }

    private Optional<Token> getFilePath(String path) {
        String sasToken = this.configuration.get(String.format("%s.%s.pathSasToken", this.prefix, path));
        String expirationTime = this.configuration.get(String.format("%s.%s.expirationTime", this.prefix, path));
        return Optional.ofNullable(Token.createToken(sasToken, expirationTime));
    }

    private Optional<Token> getDirectoryPath(Path path) {
        return this.getFilePath(path.toString() + "/");
    }
}

