/*
 * Decompiled with CFR 0.152.
 */
package hex.Infogram;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hex.Infogram.Infogram;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLMModel;
import hex.schemas.InfogramV3;
import hex.util.DistributionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import water.AutoBuffer;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.udf.CFuncRef;

public class InfogramModel
extends Model<InfogramModel, InfogramParameters, InfogramModelOutput> {
    public InfogramModel(Key<InfogramModel> selfKey, InfogramParameters parms, InfogramModelOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        assert (domain == null);
        switch (((InfogramModelOutput)this._output).getModelCategory()) {
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((InfogramModelOutput)this._output).nclasses(), domain, ((InfogramParameters)this._parms)._auc_type);
            }
        }
        throw H2O.unimpl((String)("Invalid ModelCategory " + ((InfogramModelOutput)this._output).getModelCategory()));
    }

    protected double[] score0(double[] data, double[] preds) {
        throw new UnsupportedOperationException("Infogram does not support scoring on data.  It only provides information on predictors and choose admissible features for users.  Users can take the admissible features, buildtheir own model and score with that model.");
    }

    public Frame score(Frame fr, String destinationKey, Job j, boolean computeMetrics, CFuncRef customMetricFunc) {
        this.score0(null, null);
        return null;
    }

    public boolean haveMojo() {
        return false;
    }

    public boolean havePojo() {
        return false;
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        super.remove_impl(fs, cascade);
        Keyed.remove(((InfogramModelOutput)this._output)._admissible_score_key, (Futures)fs, (boolean)true);
        Keyed.remove(((InfogramModelOutput)this._output)._admissible_score_key_valid, (Futures)fs, (boolean)true);
        Keyed.remove(((InfogramModelOutput)this._output)._admissible_score_key_xval, (Futures)fs, (boolean)true);
        return fs;
    }

    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        if (((InfogramModelOutput)this._output)._admissible_score_key != null) {
            ab.putKey(((InfogramModelOutput)this._output)._admissible_score_key);
        }
        if (((InfogramModelOutput)this._output)._admissible_score_key_valid != null) {
            ab.putKey(((InfogramModelOutput)this._output)._admissible_score_key_valid);
        }
        if (((InfogramModelOutput)this._output)._admissible_score_key_xval != null) {
            ab.putKey(((InfogramModelOutput)this._output)._admissible_score_key_xval);
        }
        return super.writeAll_impl(ab);
    }

    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        if (((InfogramModelOutput)this._output)._admissible_score_key != null) {
            ab.getKey(((InfogramModelOutput)this._output)._admissible_score_key, fs);
        }
        if (((InfogramModelOutput)this._output)._admissible_score_key_valid != null) {
            ab.getKey(((InfogramModelOutput)this._output)._admissible_score_key_valid, fs);
        }
        if (((InfogramModelOutput)this._output)._admissible_score_key_xval != null) {
            ab.getKey(((InfogramModelOutput)this._output)._admissible_score_key_xval, fs);
        }
        return super.readAll_impl(ab, fs);
    }

    public static class InfogramModelOutput
    extends Model.Output {
        public static final int _COLUMN_INDEX = 0;
        public static final int _ADMISSIBLE_PREDICTOR_INDEX = 1;
        public static final int _RELEVANCE_INDEX = 3;
        public static final int _CMI_INDEX = 4;
        public static final int _CMI_RAW_INDEX = 5;
        public double[] _admissible_cmi;
        public double[] _admissible_cmi_raw;
        public double[] _admissible_relevance;
        public String[] _admissible_features;
        public String[] _admissible_features_valid;
        public String[] _admissible_features_xval;
        public double[] _admissible_index;
        public double[] _admissible_index_valid;
        public double[] _admissible;
        public double[] _admissible_valid;
        public DistributionFamily _distribution;
        public double[] _cmi_raw;
        public double[] _cmi_raw_valid;
        public double[] _cmi;
        public double[] _cmi_valid;
        public String[] _all_predictor_names;
        public String[] _all_predictor_names_valid;
        public double[] _relevance;
        public double[] _relevance_valid;
        public Key<Frame> _admissible_score_key;
        public Key<Frame> _admissible_score_key_valid;
        public Key<Frame> _admissible_score_key_xval;
        public String[] _topKFeatures;
        public long _validNonZeroNumRows;

        public ModelCategory getModelCategory() {
            if (DistributionFamily.bernoulli.equals((Object)this._distribution)) {
                return ModelCategory.Binomial;
            }
            if (DistributionFamily.multinomial.equals((Object)this._distribution)) {
                return ModelCategory.Multinomial;
            }
            if (DistributionFamily.ordinal.equals((Object)this._distribution)) {
                return ModelCategory.Ordinal;
            }
            throw new IllegalArgumentException("Infogram currently only support binomial and multinomial classification");
        }

        public void setDistribution(DistributionFamily distribution) {
            this._distribution = distribution;
        }

        public InfogramModelOutput(Infogram b) {
            super((ModelBuilder)b);
            if (InfogramParameters.Algorithm.glm.equals((Object)((InfogramParameters)b._parms)._algorithm)) {
                this._distribution = DistributionUtils.familyToDistribution((GLMModel.GLMParameters.Family)((GLMModel.GLMParameters)((InfogramParameters)b._parms)._infogram_algorithm_parameters)._family);
            }
        }

        public void extractAdmissibleFeatures(Frame relCMIFrame, boolean validFrame, boolean cvFrame) {
            long numRow = relCMIFrame.numRows();
            ArrayList<Double> varimps = new ArrayList<Double>();
            ArrayList<Double> predictorCMI = new ArrayList<Double>();
            ArrayList<Double> predictorCMIRaw = new ArrayList<Double>();
            ArrayList<String> admissiblePred = new ArrayList<String>();
            for (long rowIndex = 0L; rowIndex < numRow; ++rowIndex) {
                if (!(relCMIFrame.vec(1).at(rowIndex) > 0.0)) continue;
                varimps.add(relCMIFrame.vec(3).at(rowIndex));
                predictorCMI.add(relCMIFrame.vec(4).at(rowIndex));
                predictorCMIRaw.add(relCMIFrame.vec(5).at(rowIndex));
                admissiblePred.add(relCMIFrame.vec(0).stringAt(rowIndex));
            }
            if (validFrame) {
                this._admissible_features_valid = admissiblePred.toArray(new String[admissiblePred.size()]);
            } else if (cvFrame) {
                this._admissible_features_xval = admissiblePred.toArray(new String[admissiblePred.size()]);
            } else {
                this._admissible_features = admissiblePred.toArray(new String[admissiblePred.size()]);
                this._admissible_cmi = predictorCMI.stream().mapToDouble(i -> i).toArray();
                this._admissible_cmi_raw = predictorCMIRaw.stream().mapToDouble(i -> i).toArray();
                this._admissible_relevance = varimps.stream().mapToDouble(i -> i).toArray();
            }
        }

        public static void sortCMIRel(int[] indices, double[] relevance, double[] cmiRawA, double[] cmi, String[] allPredictorNames, double[] admissibleIndex, double[] admissibleA) {
            int indexLength = indices.length;
            double[] rel = new double[indexLength];
            double[] cmiRaw = new double[indexLength];
            double[] cmiNorm = new double[indexLength];
            double[] distanceCorner = new double[indexLength];
            String[] predNames = new String[indexLength];
            double[] admissible = new double[indexLength];
            double[] admissibleI = new double[indexLength];
            for (int index = 0; index < indexLength; ++index) {
                rel[index] = relevance[indices[index]];
                cmiRaw[index] = cmiRawA[indices[index]];
                cmiNorm[index] = cmi[indices[index]];
                predNames[index] = allPredictorNames[indices[index]];
                distanceCorner[index] = admissibleIndex[indices[index]];
                admissible[index] = admissibleA[indices[index]];
                admissibleI[index] = admissibleIndex[indices[index]];
            }
            System.arraycopy(rel, 0, relevance, 0, indexLength);
            System.arraycopy(cmiNorm, 0, cmi, 0, indexLength);
            System.arraycopy(cmiRaw, 0, cmiRawA, 0, indexLength);
            System.arraycopy(predNames, 0, allPredictorNames, 0, indexLength);
            System.arraycopy(distanceCorner, 0, admissibleIndex, 0, indexLength);
            System.arraycopy(admissible, 0, admissibleA, 0, indexLength);
            System.arraycopy(admissibleI, 0, admissibleIndex, 0, indexLength);
        }
    }

    public static class InfogramParameters
    extends Model.Parameters {
        public Algorithm _algorithm = Algorithm.AUTO;
        public String _algorithm_params = new String();
        public String[] _protected_columns = null;
        public double _cmi_threshold = 0.1;
        public double _relevance_threshold = 0.1;
        public double _total_information_threshold = -1.0;
        public double _net_information_threshold = -1.0;
        public double _safety_index_threshold = -1.0;
        public double _relevance_index_threshold = -1.0;
        public double _data_fraction = 1.0;
        public Model.Parameters _infogram_algorithm_parameters;
        public int _top_n_features = 50;
        public boolean _compute_p_values = false;
        public int _nparallelism = 0;

        public String algoName() {
            return "Infogram";
        }

        public String fullName() {
            return "Information Diagram";
        }

        public String javaName() {
            return InfogramModel.class.getName();
        }

        public long progressUnits() {
            return this.train() != null ? (long)this.train().numCols() : 1L;
        }

        public void extraModelSpecificParams() {
            boolean fillParams;
            Properties p = new Properties();
            ArrayList<String> excludeList = new ArrayList<String>();
            boolean bl = fillParams = this._algorithm_params != null && !this._algorithm_params.isEmpty();
            if (fillParams) {
                HashMap map = (HashMap)new Gson().fromJson(this._algorithm_params, new TypeToken<HashMap<String, String[]>>(){}.getType());
                for (Map.Entry param : map.entrySet()) {
                    Object[] paramVal = (String[])param.getValue();
                    String paramName = (String)param.getKey();
                    excludeList.add("_" + paramName);
                    if (paramVal.length == 1) {
                        p.setProperty(paramName, (String)paramVal[0]);
                        continue;
                    }
                    p.setProperty(paramName, Arrays.toString(paramVal));
                }
            }
            InfogramV3.InfogramParametersV3.generateModelParams(this, p, excludeList);
            this.copyInfoGramParams(excludeList);
        }

        public void copyInfoGramParams(List<String> excludeList) {
            Field[] algoParams;
            for (Field oneField : algoParams = Model.Parameters.class.getDeclaredFields()) {
                try {
                    String fieldName = oneField.getName();
                    Field algoField = ((Object)((Object)this)).getClass().getField(fieldName);
                    if (excludeList.size() != 0 && excludeList.contains(fieldName)) continue;
                    algoField.set(this._infogram_algorithm_parameters, oneField.get((Object)this));
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }

        public static enum Algorithm {
            AUTO,
            deeplearning,
            drf,
            gbm,
            glm,
            xgboost;

        }
    }
}

