/*
 * Decompiled with CFR 0.152.
 */
package hex.Infogram;

import hex.Infogram.EstimateCMI;
import hex.Infogram.InfogramModel;
import hex.Infogram.InfogramUtils;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelBuilderHelper;
import hex.ModelCategory;
import hex.gam.MatrixFrameUtils.GamUtils;
import hex.genmodel.utils.DistributionFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.TwoDimTable;

public class Infogram
extends ModelBuilder<InfogramModel, InfogramModel.InfogramParameters, InfogramModel.InfogramModelOutput> {
    static final double NORMALIZE_ADMISSIBLE_INDEX = 1.0 / Math.sqrt(2.0);
    boolean _buildCore;
    String[] _topKPredictors;
    Frame _baseOrSensitiveFrame = null;
    String[] _modelDescription;
    int _numModels;
    double[] _cmi;
    double[] _cmiValid;
    double[] _cmiCV;
    double[] _cmiRaw;
    double[] _cmiRawValid;
    double[] _cmiRawCV;
    String[] _columnsCV;
    TwoDimTable _varImp;
    int _numPredictors;
    Key<Frame> _cmiRelKey;
    Key<Frame> _cmiRelKeyValid;
    Key<Frame> _cmiRelKeyCV;
    Key<Frame>[] _generatedFrameKeys;
    boolean _cvDone = false;
    private transient InfogramModel _model;
    long _validNonZeroNumRows;
    int _nFoldOrig = 0;
    Model.Parameters.FoldAssignmentScheme _foldAssignmentOrig = null;
    String _foldColumnOrig = null;

    public Infogram(boolean startup_once) {
        super((Model.Parameters)new InfogramModel.InfogramParameters(), startup_once);
    }

    public Infogram(InfogramModel.InfogramParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public Infogram(InfogramModel.InfogramParameters parms, Key<InfogramModel> key) {
        super((Model.Parameters)parms, key);
        this.init(false);
    }

    protected ModelBuilder.Driver trainModelImpl() {
        return new InfogramDriver();
    }

    protected int nModelsInParallel(int folds) {
        return this.nModelsInParallel(folds, 2);
    }

    public void computeCrossValidation() {
        this.info("cross-validation", "cross-validation infogram information is stored in frame with key labeled as admissible_score_key_cv and the admissible features in admissible_features_cv.");
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
        }
        super.computeCrossValidation();
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder[] cvModelBuilders) {
        Object g;
        int i;
        int nBuilders = cvModelBuilders.length;
        double[][] cmiRaw = new double[nBuilders][];
        ArrayList<List<String>> columns = new ArrayList<List<String>>();
        long[] nObs = new long[nBuilders];
        for (i = 0; i < cvModelBuilders.length; ++i) {
            g = (InfogramModel)cvModelBuilders[i].dest().get();
            Scope.track_generic((Keyed)g);
            InfogramUtils.extractInfogramInfo(g, cmiRaw, columns, i);
            nObs[i] = ((InfogramModel.InfogramModelOutput)g._output)._validNonZeroNumRows;
        }
        this.calculateMeanInfogramInfo(cmiRaw, columns, nObs);
        for (i = 0; i < cvModelBuilders.length; ++i) {
            g = (Infogram)cvModelBuilders[i];
            InfogramModel gm = ((Infogram)((Object)g))._model;
            gm.write_lock(this._job);
            gm.update(this._job);
            gm.unlock(this._job);
        }
        this._cvDone = true;
    }

    public void calculateMeanInfogramInfo(double[][] cmiRaw, List<List<String>> columns, long[] nObs) {
        int pIndex;
        int nFolds = cmiRaw.length;
        HashSet<String> allNames = new HashSet<String>();
        for (List<String> oneFold : columns) {
            allNames.addAll(oneFold);
        }
        ArrayList allNamesList = new ArrayList(allNames);
        int nPreds = allNames.size();
        this._cmiCV = new double[nPreds];
        this._cmiRawCV = new double[nPreds];
        double oneOverNObsSum = 1.0 / (double)ArrayUtils.sum((long[])nObs);
        int foldPredSize = cmiRaw[0].length;
        for (int fIndex = 0; fIndex < nFolds; ++fIndex) {
            List<String> oneFoldC = columns.get(fIndex);
            double scale = (double)nObs[fIndex] * oneOverNObsSum;
            for (pIndex = 0; pIndex < foldPredSize; ++pIndex) {
                int allNameIndex;
                String colName = oneFoldC.get(pIndex);
                int n = allNameIndex = allNamesList.indexOf(colName);
                this._cmiRawCV[n] = this._cmiRawCV[n] + cmiRaw[fIndex][pIndex] * scale;
            }
        }
        double maxCMI = ArrayUtils.maxValue((double[])this._cmiRawCV);
        double oneOverMaxCMI = maxCMI == 0.0 ? 0.0 : 1.0 / maxCMI;
        for (pIndex = 0; pIndex < nPreds; ++pIndex) {
            this._cmiCV[pIndex] = this._cmiRawCV[pIndex] * oneOverMaxCMI;
        }
        this._columnsCV = (String[])allNamesList.stream().toArray(String[]::new);
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Binomial, ModelCategory.Multinomial};
    }

    public boolean isSupervised() {
        return true;
    }

    public boolean havePojo() {
        return false;
    }

    public boolean haveMojo() {
        return false;
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (expensive) {
            this.validateInfoGramParameters();
        }
    }

    private void validateInfoGramParameters() {
        Frame dataset = ((InfogramModel.InfogramParameters)this._parms).train();
        if (!((InfogramModel.InfogramParameters)this._parms).train().vec(((InfogramModel.InfogramParameters)this._parms)._response_column).isCategorical()) {
            this.error("response_column", "Regression is not supported for Infogram. If you meant to do classification, convert your response column to categorical/factor type before calling Infogram.");
        }
        if (((InfogramModel.InfogramParameters)this._parms)._protected_columns != null) {
            HashSet<String> colNames = new HashSet<String>(Arrays.asList(dataset.names()));
            for (String senAttribute : ((InfogramModel.InfogramParameters)this._parms)._protected_columns) {
                if (colNames.contains(senAttribute)) continue;
                this.error("protected_columns", "protected_columns: " + senAttribute + " is not a valid column in the training dataset.");
            }
        }
        boolean bl = this._buildCore = ((InfogramModel.InfogramParameters)this._parms)._protected_columns == null;
        if (this._buildCore) {
            if (((InfogramModel.InfogramParameters)this._parms)._net_information_threshold == -1.0) {
                ((InfogramModel.InfogramParameters)this._parms)._cmi_threshold = 0.1;
                ((InfogramModel.InfogramParameters)this._parms)._net_information_threshold = 0.1;
            } else if (((InfogramModel.InfogramParameters)this._parms)._net_information_threshold > 1.0 || ((InfogramModel.InfogramParameters)this._parms)._net_information_threshold < 0.0) {
                this.error("net_information_threshold", " should be set to be between 0 and 1.");
            } else {
                ((InfogramModel.InfogramParameters)this._parms)._cmi_threshold = ((InfogramModel.InfogramParameters)this._parms)._net_information_threshold;
            }
            if (((InfogramModel.InfogramParameters)this._parms)._total_information_threshold == -1.0) {
                ((InfogramModel.InfogramParameters)this._parms)._relevance_threshold = 0.1;
                ((InfogramModel.InfogramParameters)this._parms)._total_information_threshold = 0.1;
            } else if (((InfogramModel.InfogramParameters)this._parms)._total_information_threshold < 0.0 || ((InfogramModel.InfogramParameters)this._parms)._total_information_threshold > 1.0) {
                this.error("total_information_threshold", " should be set to be between 0 and 1.");
            } else {
                ((InfogramModel.InfogramParameters)this._parms)._relevance_threshold = ((InfogramModel.InfogramParameters)this._parms)._total_information_threshold;
            }
            if (((InfogramModel.InfogramParameters)this._parms)._safety_index_threshold != -1.0) {
                this.warn("safety_index_threshold", "Should not set safety_index_threshold for core infogram runs.  Set net_information_threshold instead.  Using default of 0.1 if not set");
            }
            if (((InfogramModel.InfogramParameters)this._parms)._relevance_index_threshold != -1.0) {
                this.warn("relevance_index_threshold", "Should not set relevance_index_threshold for core infogram runs.  Set total_information_threshold instead.  Using default of 0.1 if not set");
            }
        } else {
            if (((InfogramModel.InfogramParameters)this._parms)._safety_index_threshold == -1.0) {
                ((InfogramModel.InfogramParameters)this._parms)._cmi_threshold = 0.1;
                ((InfogramModel.InfogramParameters)this._parms)._safety_index_threshold = 0.1;
            } else if (((InfogramModel.InfogramParameters)this._parms)._safety_index_threshold < 0.0 || ((InfogramModel.InfogramParameters)this._parms)._safety_index_threshold > 1.0) {
                this.error("safety_index_threshold", " should be set to be between 0 and 1.");
            } else {
                ((InfogramModel.InfogramParameters)this._parms)._cmi_threshold = ((InfogramModel.InfogramParameters)this._parms)._safety_index_threshold;
            }
            if (((InfogramModel.InfogramParameters)this._parms)._relevance_index_threshold == -1.0) {
                ((InfogramModel.InfogramParameters)this._parms)._relevance_threshold = 0.1;
                ((InfogramModel.InfogramParameters)this._parms)._relevance_index_threshold = 0.1;
            } else if (((InfogramModel.InfogramParameters)this._parms)._relevance_index_threshold < 0.0 || ((InfogramModel.InfogramParameters)this._parms)._relevance_index_threshold > 1.0) {
                this.error("relevance_index_threshold", " should be set to be between 0 and 1.");
            } else {
                ((InfogramModel.InfogramParameters)this._parms)._relevance_threshold = ((InfogramModel.InfogramParameters)this._parms)._relevance_index_threshold;
            }
            if (((InfogramModel.InfogramParameters)this._parms)._net_information_threshold != -1.0) {
                this.warn("net_information_threshold", "Should not set net_information_threshold for fair infogram runs, set safety_index_threshold instead.  Using default of 0.1 if not set");
            }
            if (((InfogramModel.InfogramParameters)this._parms)._total_information_threshold != -1.0) {
                this.warn("total_information_threshold", "Should not set total_information_threshold for fair infogram runs, set relevance_index_threshold instead.  Using default of 0.1 if not set");
            }
            if (InfogramModel.InfogramParameters.Algorithm.AUTO.equals((Object)((InfogramModel.InfogramParameters)this._parms)._algorithm)) {
                ((InfogramModel.InfogramParameters)this._parms)._algorithm = InfogramModel.InfogramParameters.Algorithm.gbm;
            }
        }
        if (((InfogramModel.InfogramParameters)this._parms)._top_n_features < 0) {
            this.error("_topk", "topk must be between 0 and the number of predictor columns in your training dataset.");
        }
        this._numPredictors = ((InfogramModel.InfogramParameters)this._parms).train().numCols() - 1;
        if (((InfogramModel.InfogramParameters)this._parms)._weights_column != null) {
            --this._numPredictors;
        }
        if (((InfogramModel.InfogramParameters)this._parms)._offset_column != null) {
            --this._numPredictors;
        }
        if (((InfogramModel.InfogramParameters)this._parms)._top_n_features > this._numPredictors) {
            this.warn("top_n_features", "The top_n_features exceed the actual number of predictor columns in your training dataset.  It will be set to the number of predictors in your training dataset.");
            ((InfogramModel.InfogramParameters)this._parms)._top_n_features = this._numPredictors;
        }
        if (((InfogramModel.InfogramParameters)this._parms)._nparallelism < 0) {
            this.error("nparallelism", "must be >= 0.  If 0, it is adaptive");
        }
        if (((InfogramModel.InfogramParameters)this._parms)._nparallelism == 0) {
            ((InfogramModel.InfogramParameters)this._parms)._nparallelism = H2O.NUMCPUS;
        }
        if (((InfogramModel.InfogramParameters)this._parms)._compute_p_values) {
            this.error("compute_p_values", " compute_p_values calculation is not yet implemented.");
        }
        if (this.nclasses() < 2) {
            this.error("distribution", " infogram currently only supports classification models");
        }
        if (DistributionFamily.AUTO.equals((Object)((InfogramModel.InfogramParameters)this._parms)._distribution)) {
            DistributionFamily distributionFamily = ((InfogramModel.InfogramParameters)this._parms)._distribution = this.nclasses() == 2 ? DistributionFamily.bernoulli : DistributionFamily.multinomial;
        }
        if (this._cvDone) {
            this._nFoldOrig = ((InfogramModel.InfogramParameters)this._parms)._nfolds;
            this._foldColumnOrig = ((InfogramModel.InfogramParameters)this._parms)._fold_column;
            this._foldAssignmentOrig = ((InfogramModel.InfogramParameters)this._parms)._fold_assignment;
            ((InfogramModel.InfogramParameters)this._parms)._fold_column = null;
            ((InfogramModel.InfogramParameters)this._parms)._nfolds = 0;
            ((InfogramModel.InfogramParameters)this._parms)._fold_assignment = null;
        }
    }

    private class InfogramDriver
    extends ModelBuilder.Driver {
        private InfogramDriver() {
            super((ModelBuilder)Infogram.this);
        }

        void prepareModelTrainingFrame() {
            Infogram.this._generatedFrameKeys = new Key[(((InfogramModel.InfogramParameters)Infogram.this._parms)._top_n_features + 1) * 3 + 2];
            String[] eligiblePredictors = InfogramUtils.extractPredictors((InfogramModel.InfogramParameters)Infogram.this._parms, Infogram.this._train, Infogram.this._foldColumnOrig);
            Infogram.this._baseOrSensitiveFrame = InfogramUtils.extractTrainingFrame((InfogramModel.InfogramParameters)Infogram.this._parms, ((InfogramModel.InfogramParameters)Infogram.this._parms)._protected_columns, 1.0, (Frame)((InfogramModel.InfogramParameters)Infogram.this._parms).train().clone());
            ((InfogramModel.InfogramParameters)Infogram.this._parms).extraModelSpecificParams();
            Infogram.this._topKPredictors = InfogramUtils.extractTopKPredictors((InfogramModel.InfogramParameters)Infogram.this._parms, ((InfogramModel.InfogramParameters)Infogram.this._parms).train(), eligiblePredictors, Infogram.this._generatedFrameKeys);
            Infogram.this._numModels = 1 + Infogram.this._topKPredictors.length;
            Infogram.this._modelDescription = InfogramUtils.generateModelDescription(Infogram.this._topKPredictors, ((InfogramModel.InfogramParameters)Infogram.this._parms)._protected_columns);
        }

        public void computeImpl() {
            Infogram.this.init(true);
            if (Infogram.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)Infogram.this);
            }
            Infogram.this._job.update(0L, "Initializing model training");
            this.buildModel();
        }

        public final void buildModel() {
            try {
                boolean validPresent = ((InfogramModel.InfogramParameters)Infogram.this._parms).valid() != null;
                this.prepareModelTrainingFrame();
                InfogramModel model = new InfogramModel((Key<InfogramModel>)Infogram.this.dest(), (InfogramModel.InfogramParameters)Infogram.this._parms, new InfogramModel.InfogramModelOutput(Infogram.this));
                Infogram.this._model = (InfogramModel)model.delete_and_lock(Infogram.this._job);
                ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._start_time = System.currentTimeMillis();
                Infogram.this._cmiRaw = new double[Infogram.this._numModels];
                if (((InfogramModel.InfogramParameters)Infogram.this._parms).valid() != null) {
                    Infogram.this._cmiRawValid = new double[Infogram.this._numModels];
                }
                this.buildInfoGramsNRelevance(validPresent);
                Infogram.this._job.update(1L, "finished building models for Infogram ...");
                ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output).setDistribution(((InfogramModel.InfogramParameters)Infogram.this._parms)._distribution);
                this.copyCMIRelevance((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output);
                Infogram.this._cmi = ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._cmi;
                if (validPresent) {
                    this.copyCMIRelevanceValid((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output);
                }
                Infogram.this._cmiRelKey = this.setCMIRelFrame(validPresent);
                ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output).extractAdmissibleFeatures((Frame)DKV.getGet(Infogram.this._cmiRelKey), false, false);
                if (validPresent) {
                    Infogram.this._cmiRelKeyValid = ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._admissible_score_key_valid;
                    ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output).extractAdmissibleFeatures((Frame)DKV.getGet(Infogram.this._cmiRelKeyValid), true, false);
                    ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._validNonZeroNumRows = Infogram.this._validNonZeroNumRows;
                }
                if (Infogram.this._cvDone) {
                    Infogram.this._cmiRelKeyCV = this.setCMIRelFrameCV();
                    ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._admissible_score_key_xval = Infogram.this._cmiRelKeyCV;
                    ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output).extractAdmissibleFeatures((Frame)DKV.getGet(Infogram.this._cmiRelKeyCV), false, true);
                    ((InfogramModel.InfogramParameters)Infogram.this._parms)._nfolds = Infogram.this._nFoldOrig;
                    ((InfogramModel.InfogramParameters)Infogram.this._parms)._fold_assignment = Infogram.this._foldAssignmentOrig;
                    ((InfogramModel.InfogramParameters)Infogram.this._parms)._fold_column = Infogram.this._foldColumnOrig;
                }
                Infogram.this._job.update(1L, "Infogram building completed...");
                Infogram.this._model.update(Infogram.this._job._key);
            }
            catch (Throwable throwable) {
                DKV.remove((Key)Infogram.this._baseOrSensitiveFrame._key);
                InfogramUtils.removeFromDKV(Infogram.this._generatedFrameKeys);
                ArrayList keep = new ArrayList();
                if (Infogram.this._model != null) {
                    GamUtils.keepFrameKeys(keep, (Key[])new Key[]{Infogram.this._cmiRelKey});
                    if (Infogram.this._cmiRelKeyValid != null) {
                        GamUtils.keepFrameKeys(keep, (Key[])new Key[]{Infogram.this._cmiRelKeyValid});
                    }
                    if (Infogram.this._cmiRelKeyCV != null) {
                        GamUtils.keepFrameKeys(keep, (Key[])new Key[]{Infogram.this._cmiRelKeyCV});
                    }
                    Infogram.this._model.update(Infogram.this._job._key);
                    Infogram.this._model.unlock(Infogram.this._job);
                }
                Scope.exit((Key[])keep.toArray(new Key[keep.size()]));
                throw throwable;
            }
            DKV.remove((Key)Infogram.this._baseOrSensitiveFrame._key);
            InfogramUtils.removeFromDKV(Infogram.this._generatedFrameKeys);
            ArrayList keep = new ArrayList();
            if (Infogram.this._model != null) {
                GamUtils.keepFrameKeys(keep, (Key[])new Key[]{Infogram.this._cmiRelKey});
                if (Infogram.this._cmiRelKeyValid != null) {
                    GamUtils.keepFrameKeys(keep, (Key[])new Key[]{Infogram.this._cmiRelKeyValid});
                }
                if (Infogram.this._cmiRelKeyCV != null) {
                    GamUtils.keepFrameKeys(keep, (Key[])new Key[]{Infogram.this._cmiRelKeyCV});
                }
                Infogram.this._model.update(Infogram.this._job._key);
                Infogram.this._model.unlock(Infogram.this._job);
            }
            Scope.exit((Key[])keep.toArray(new Key[keep.size()]));
        }

        private void copyCMIRelevance(InfogramModel.InfogramModelOutput modelOutput) {
            modelOutput._cmi_raw = new double[Infogram.this._cmi.length];
            System.arraycopy(Infogram.this._cmiRaw, 0, modelOutput._cmi_raw, 0, modelOutput._cmi_raw.length);
            modelOutput._admissible_index = new double[Infogram.this._cmi.length];
            modelOutput._admissible = new double[Infogram.this._cmi.length];
            modelOutput._cmi = (double[])Infogram.this._cmi.clone();
            modelOutput._topKFeatures = (String[])Infogram.this._topKPredictors.clone();
            modelOutput._all_predictor_names = (String[])Infogram.this._topKPredictors.clone();
            int numRows = Infogram.this._varImp.getRowDim();
            String[] varRowHeaders = Infogram.this._varImp.getRowHeaders();
            ArrayList<String> relNames = new ArrayList<String>(Arrays.asList(varRowHeaders));
            modelOutput._relevance = new double[numRows];
            this.copyGenerateAdmissibleIndex(numRows, relNames, modelOutput._cmi, modelOutput._cmi_raw, modelOutput._relevance, modelOutput._admissible_index, modelOutput._admissible, modelOutput._all_predictor_names);
        }

        public void copyCMIRelevanceValid(InfogramModel.InfogramModelOutput modelOutput) {
            modelOutput._cmi_raw_valid = new double[Infogram.this._cmiValid.length];
            System.arraycopy(Infogram.this._cmiRawValid, 0, modelOutput._cmi_raw_valid, 0, modelOutput._cmi_raw_valid.length);
            modelOutput._admissible_index_valid = new double[Infogram.this._cmiValid.length];
            modelOutput._admissible_valid = new double[Infogram.this._cmiValid.length];
            modelOutput._cmi_valid = (double[])Infogram.this._cmiValid.clone();
            int numRows = Infogram.this._varImp.getRowDim();
            String[] varRowHeaders = Infogram.this._varImp.getRowHeaders();
            ArrayList<String> relNames = new ArrayList<String>(Arrays.asList(varRowHeaders));
            modelOutput._all_predictor_names_valid = (String[])modelOutput._topKFeatures.clone();
            modelOutput._relevance_valid = new double[numRows];
            this.copyGenerateAdmissibleIndex(numRows, relNames, modelOutput._cmi_valid, modelOutput._cmi_raw_valid, modelOutput._relevance_valid, modelOutput._admissible_index_valid, modelOutput._admissible_valid, modelOutput._all_predictor_names_valid);
        }

        public void copyGenerateAdmissibleIndex(int numRows, List<String> relNames, double[] cmi, double[] cmi_raw, double[] relevance, double[] admissible_index, double[] admissible, String[] all_predictor_names) {
            for (int index = 0; index < numRows; ++index) {
                int newIndex = relNames.indexOf(all_predictor_names[index]);
                relevance[index] = (Double)Infogram.this._varImp.get(newIndex, 1);
                double temp1 = relevance[index];
                double temp2 = cmi[index];
                admissible_index[index] = NORMALIZE_ADMISSIBLE_INDEX * Math.sqrt(temp1 * temp1 + temp2 * temp2);
                admissible[index] = relevance[index] >= ((InfogramModel.InfogramParameters)Infogram.this._parms)._relevance_threshold && cmi[index] >= ((InfogramModel.InfogramParameters)Infogram.this._parms)._cmi_threshold ? 1.0 : 0.0;
            }
            int[] indices = IntStream.range(0, cmi.length).toArray();
            ArrayUtils.sort((int[])indices, (double[])admissible_index, (int)-1, (int)-1);
            InfogramModel.InfogramModelOutput.sortCMIRel(indices, relevance, cmi_raw, cmi, all_predictor_names, admissible_index, admissible);
        }

        private Key<Frame> setCMIRelFrame(boolean validPresent) {
            Frame cmiRelFrame = InfogramUtils.generateCMIRelevance(((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._all_predictor_names, ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._admissible, ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._admissible_index, ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._relevance, ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._cmi, ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._cmi_raw, Infogram.this._buildCore);
            ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._admissible_score_key = cmiRelFrame._key;
            if (validPresent) {
                Frame cmiRelFrameValid = InfogramUtils.generateCMIRelevance(((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._all_predictor_names_valid, ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._admissible_valid, ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._admissible_index_valid, ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._relevance_valid, ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._cmi_valid, ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._cmi_raw_valid, Infogram.this._buildCore);
                ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._admissible_score_key_valid = cmiRelFrameValid._key;
            }
            return cmiRelFrame._key;
        }

        private void cleanUpCV() {
            String[] mainModelPredNames = ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._all_predictor_names;
            ArrayList<String> cvNames = new ArrayList<String>(Arrays.asList(Infogram.this._columnsCV));
            int nPred = mainModelPredNames.length;
            String[] newCVNames = new String[nPred];
            double[] cmiCV = new double[nPred];
            double[] cmiRawCV = new double[nPred];
            for (int index = 0; index < nPred; ++index) {
                String mainPredNames = mainModelPredNames[index];
                int cvIndex = cvNames.indexOf(mainPredNames);
                if (cvIndex < 0) continue;
                newCVNames[index] = mainPredNames;
                cmiCV[index] = Infogram.this._cmiCV[cvIndex];
                cmiRawCV[index] = Infogram.this._cmiRawCV[cvIndex];
            }
            Infogram.this._columnsCV = (String[])newCVNames.clone();
            Infogram.this._cmiCV = (double[])cmiCV.clone();
            Infogram.this._cmiRawCV = (double[])cmiRawCV.clone();
        }

        private Key<Frame> setCMIRelFrameCV() {
            String[] mainModelPredNames = ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._all_predictor_names;
            double[] mainModelRelevance = ((InfogramModel.InfogramModelOutput)((Infogram)Infogram.this)._model._output)._relevance;
            double[] relevanceCV = new double[mainModelRelevance.length];
            int nPred = mainModelPredNames.length;
            double[] admissibleIndex = new double[nPred];
            double[] admissible = new double[nPred];
            this.cleanUpCV();
            for (int index = 0; index < nPred; ++index) {
                relevanceCV[index] = mainModelRelevance[index];
                double temp1 = 1.0 - relevanceCV[index];
                double temp2 = 1.0 - Infogram.this._cmiCV[index];
                admissibleIndex[index] = Math.sqrt(temp1 * temp1 + temp2 * temp2) * NORMALIZE_ADMISSIBLE_INDEX;
                admissible[index] = Infogram.this._cmiCV[index] >= ((InfogramModel.InfogramParameters)Infogram.this._parms)._cmi_threshold && relevanceCV[index] >= ((InfogramModel.InfogramParameters)Infogram.this._parms)._relevance_threshold ? 1.0 : 0.0;
            }
            int[] indices = IntStream.range(0, relevanceCV.length).toArray();
            Infogram.this._columnsCV = (String[])mainModelPredNames.clone();
            ArrayUtils.sort((int[])indices, (double[])admissibleIndex, (int)-1, (int)-1);
            InfogramModel.InfogramModelOutput.sortCMIRel(indices, relevanceCV, Infogram.this._cmiRawCV, Infogram.this._cmiCV, Infogram.this._columnsCV, admissibleIndex, admissible);
            Frame cmiRelFrame = InfogramUtils.generateCMIRelevance(Infogram.this._columnsCV, admissible, admissibleIndex, relevanceCV, Infogram.this._cmiCV, Infogram.this._cmiRawCV, Infogram.this._buildCore);
            return cmiRelFrame._key;
        }

        private void buildInfoGramsNRelevance(boolean validPresent) {
            int leftOver;
            int outerLoop = (int)Math.floor(Infogram.this._numModels / ((InfogramModel.InfogramParameters)Infogram.this._parms)._nparallelism);
            int modelCount = 0;
            int lastModelInd = Infogram.this._numModels - 1;
            if (outerLoop > 0) {
                for (int outerInd = 0; outerInd < outerLoop; ++outerInd) {
                    this.buildModelCMINRelevance(modelCount, ((InfogramModel.InfogramParameters)Infogram.this._parms)._nparallelism, lastModelInd);
                    modelCount += ((InfogramModel.InfogramParameters)Infogram.this._parms)._nparallelism;
                    Infogram.this._job.update((long)((InfogramModel.InfogramParameters)Infogram.this._parms)._nparallelism, "in the middle of building infogram models.");
                }
            }
            if ((leftOver = Infogram.this._numModels - modelCount) > 0) {
                this.buildModelCMINRelevance(modelCount, leftOver, lastModelInd);
                Infogram.this._job.update((long)leftOver, " building the final set of infogram models.");
            }
            Infogram.this._cmi = InfogramUtils.calculateFinalCMI(Infogram.this._cmiRaw, Infogram.this._buildCore);
            if (validPresent) {
                Infogram.this._cmiValid = InfogramUtils.calculateFinalCMI(Infogram.this._cmiRawValid, Infogram.this._buildCore);
            }
        }

        private void buildModelCMINRelevance(int modelCount, int numModel, int lastModelInd) {
            boolean lastModelIndcluded = modelCount + numModel >= lastModelInd;
            Frame[] trainingFrames = this.buildTrainingFrames(modelCount, numModel, lastModelInd);
            Model.Parameters[] modelParams = InfogramUtils.buildModelParameters(trainingFrames, ((InfogramModel.InfogramParameters)Infogram.this._parms)._infogram_algorithm_parameters, numModel, ((InfogramModel.InfogramParameters)Infogram.this._parms)._algorithm);
            ModelBuilder[] builders = ModelBuilderHelper.trainModelsParallel((ModelBuilder[])InfogramUtils.buildModelBuilders(modelParams), (int)numModel);
            if (lastModelIndcluded) {
                this.extractRelevance(builders[numModel - 1].get(), modelParams[numModel - 1]);
            }
            Infogram.this._validNonZeroNumRows = this.generateInfoGrams(builders, trainingFrames, modelCount, numModel);
        }

        private Frame[] buildTrainingFrames(int startInd, int numFrames, int lastModelInd) {
            Frame[] trainingFrames = new Frame[numFrames];
            Frame trainingFrame = ((InfogramModel.InfogramParameters)Infogram.this._parms).train();
            int finalFrameInd = startInd + numFrames;
            int frameCount = 0;
            int keyIndex = InfogramUtils.findstart(Infogram.this._generatedFrameKeys);
            int keyLength = Infogram.this._generatedFrameKeys.length;
            for (int frameInd = startInd; frameInd < finalFrameInd; ++frameInd) {
                trainingFrames[frameCount] = new Frame(Infogram.this._baseOrSensitiveFrame);
                if (Infogram.this._buildCore) {
                    for (int vecInd = 0; vecInd < Infogram.this._topKPredictors.length; ++vecInd) {
                        if (frameInd < lastModelInd && vecInd != frameInd) {
                            trainingFrames[frameCount].add(Infogram.this._topKPredictors[vecInd], trainingFrame.vec(Infogram.this._topKPredictors[vecInd]));
                            continue;
                        }
                        if (frameInd != lastModelInd) continue;
                        trainingFrames[frameCount].add(Infogram.this._topKPredictors[vecInd], trainingFrame.vec(Infogram.this._topKPredictors[vecInd]));
                    }
                } else if (frameInd < lastModelInd) {
                    trainingFrames[frameCount].prepend(Infogram.this._topKPredictors[frameInd], trainingFrame.vec(Infogram.this._topKPredictors[frameInd]));
                }
                Infogram.this._generatedFrameKeys[keyIndex++] = trainingFrames[frameCount]._key;
                DKV.put((Keyed)trainingFrames[frameCount++]);
            }
            return trainingFrames;
        }

        private long generateInfoGrams(ModelBuilder[] builders, Frame[] trainingFrames, int startIndex, int numModels) {
            long nonZeroRows = Long.MAX_VALUE;
            int keyIndex = InfogramUtils.findstart(Infogram.this._generatedFrameKeys);
            for (int index = 0; index < numModels; ++index) {
                Model oneModel = builders[index].get();
                int nclasses = oneModel._output.nclasses();
                Frame prediction = oneModel.score(trainingFrames[index]);
                prediction.add(((InfogramModel.InfogramParameters)Infogram.this._parms)._response_column, trainingFrames[index].vec(((InfogramModel.InfogramParameters)Infogram.this._parms)._response_column));
                Scope.track_generic((Keyed)oneModel);
                if (oneModel._parms._weights_column != null && Arrays.asList(trainingFrames[index].names()).contains(oneModel._parms._weights_column)) {
                    prediction.add(oneModel._parms._weights_column, trainingFrames[index].vec(oneModel._parms._weights_column));
                }
                Infogram.this._generatedFrameKeys[keyIndex++] = prediction._key;
                Infogram.this._cmiRaw[index + startIndex] = ((EstimateCMI)new EstimateCMI((Frame)prediction, (int)nclasses).doAll((Frame)prediction))._meanCMI;
                if (((InfogramModel.InfogramParameters)Infogram.this._parms).valid() == null) continue;
                Frame validFrame = ((InfogramModel.InfogramParameters)Infogram.this._parms).valid();
                Frame predictionValid = oneModel.score(validFrame);
                predictionValid.add(((InfogramModel.InfogramParameters)Infogram.this._parms)._response_column, validFrame.vec(((InfogramModel.InfogramParameters)Infogram.this._parms)._response_column));
                if (oneModel._parms._weights_column != null) {
                    if (Arrays.asList(validFrame.names()).contains("__internal_cv_weights__")) {
                        predictionValid.add(oneModel._parms._weights_column, validFrame.vec("__internal_cv_weights__"));
                    } else {
                        predictionValid.add(oneModel._parms._weights_column, validFrame.vec(oneModel._parms._weights_column));
                    }
                }
                Infogram.this._generatedFrameKeys[keyIndex++] = predictionValid._key;
                EstimateCMI calCMI = (EstimateCMI)new EstimateCMI(predictionValid, nclasses).doAll(predictionValid);
                Infogram.this._cmiRawValid[index + startIndex] = calCMI._meanCMI;
                nonZeroRows = Math.min(nonZeroRows, (long)calCMI._nonZeroRows);
            }
            return nonZeroRows;
        }

        private void extractRelevance(Model model, Model.Parameters parms) {
            if (Infogram.this._buildCore) {
                Infogram.this._varImp = model._output.getVariableImportances();
            } else {
                Frame fullFrame = InfogramUtils.subtractAdd2Frame(Infogram.this._baseOrSensitiveFrame, ((InfogramModel.InfogramParameters)Infogram.this._parms).train(), ((InfogramModel.InfogramParameters)Infogram.this._parms)._protected_columns, Infogram.this._topKPredictors);
                parms._train = fullFrame._key;
                int keyIndex = InfogramUtils.findstart(Infogram.this._generatedFrameKeys);
                Infogram.this._generatedFrameKeys[keyIndex++] = fullFrame._key;
                ModelBuilder builder = ModelBuilder.make((Model.Parameters)parms);
                Model fairModel = (Model)builder.trainModel().get();
                Infogram.this._varImp = fairModel._output.getVariableImportances();
                Scope.track_generic((Keyed)fairModel);
            }
        }
    }
}

