/*
 * Decompiled with CFR 0.152.
 */
package hex.Infogram;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;

public class EstimateCMI
extends MRTask<EstimateCMI> {
    public int _nonZeroRows;
    public double _accumulatedCMI;
    public double _meanCMI = 0.0;
    public static final double _scale = 1.0 / Math.log(2.0);
    public final int _responseColumn;
    public final int _nclass;

    public EstimateCMI(Frame fr, int nclasses, String response) {
        this._responseColumn = fr.find(response);
        this._nclass = nclasses;
    }

    public void map(Chunk[] ck) {
        this._nonZeroRows = 0;
        this._accumulatedCMI = 0.0;
        int nchunks = ck.length - 1;
        boolean weightIncluded = nchunks - this._nclass == 2;
        int numRow = ck[0].len();
        for (int rowIndex = 0; rowIndex < numRow; ++rowIndex) {
            int prediction;
            double predictionProb;
            if (weightIncluded && (!weightIncluded || !(ck[nchunks].atd(rowIndex) > 0.0)) || Double.isNaN(predictionProb = ck[(prediction = (int)ck[this._responseColumn].atd(rowIndex)) + 1].atd(rowIndex)) || !(predictionProb > 0.0)) continue;
            ++this._nonZeroRows;
            this._accumulatedCMI += Math.log(predictionProb);
        }
    }

    public void reduce(EstimateCMI other) {
        this._nonZeroRows += other._nonZeroRows;
        this._accumulatedCMI += other._accumulatedCMI;
    }

    public void postGlobal() {
        this._meanCMI = _scale * this._accumulatedCMI / (double)this._nonZeroRows;
    }
}

