/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.AUC;
import hex.AUCData;
import hex.ConfusionMatrix;
import hex.ConfusionMatrix2;
import hex.FrameTask;
import hex.HitRatio;
import hex.SupervisedModel;
import hex.SupervisedModelBuilder;
import hex.VarImp;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.Neurons;
import hex.schemas.DeepLearningModelV2;
import java.util.Arrays;
import java.util.Random;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.MRTask;
import water.api.ModelSchema;
import water.api.ValidationAdapter;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;
import water.util.ModelUtils;
import water.util.PrettyPrint;
import water.util.RandomUtils;

public class DeepLearningModel
extends SupervisedModel<DeepLearningModel, DeepLearningParameters, DeepLearningOutput> {
    private volatile DeepLearningModelInfo model_info;
    private long run_time;
    private long start_time;
    public long actual_train_samples_per_iteration;
    public double time_for_communication_us;
    public double epoch_counter;
    public long training_rows;
    public long validation_rows;
    private Errors[] errors;
    private float _bestError = Float.MAX_VALUE;
    public Key actual_best_model_key;
    public long _timeLastScoreEnter;
    private transient long _timeLastScoreStart;
    private transient long _timeLastScoreEnd;
    private transient long _timeLastPrintStart;
    private final transient String unstable_msg = "Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing.";

    public ModelSchema schema() {
        return new DeepLearningModelV2();
    }

    void set_model_info(DeepLearningModelInfo mi) {
        this.model_info = mi;
    }

    public final DeepLearningModelInfo model_info() {
        return this.model_info;
    }

    public Errors[] scoring_history() {
        return this.errors;
    }

    Errors last_scored() {
        return this.errors == null ? null : this.errors[this.errors.length - 1];
    }

    public final DeepLearningParameters get_params() {
        return (DeepLearningParameters)this._parms;
    }

    protected double missingColumnsType() {
        return this.get_params()._sparse ? 0.0 : Double.NaN;
    }

    public float error() {
        return (float)(((DeepLearningOutput)this._output).isClassifier() ? this.cm().err() : this.mse());
    }

    public int compareTo(DeepLearningModel o) {
        if (((DeepLearningOutput)o._output).isClassifier() != ((DeepLearningOutput)this._output).isClassifier()) {
            throw new UnsupportedOperationException("Cannot compare classifier against regressor.");
        }
        if (((DeepLearningOutput)o._output).nclasses() != ((DeepLearningOutput)this._output).nclasses()) {
            throw new UnsupportedOperationException("Cannot compare models with different number of classes.");
        }
        return this.error() < o.error() ? -1 : (this.error() > o.error() ? 1 : 0);
    }

    public ConfusionMatrix2 cm() {
        ConfusionMatrix cm;
        Errors lasterror = this.last_scored();
        if (lasterror == null) {
            return null;
        }
        ConfusionMatrix confusionMatrix = cm = lasterror.validation || lasterror.num_folds > 0 ? lasterror.valid_confusion_matrix : lasterror.train_confusion_matrix;
        if (cm == null || cm.cm == null) {
            if (lasterror.validation || lasterror.num_folds > 0) {
                return new ConfMat(lasterror.valid_err, lasterror.validAUC != null ? lasterror.validAUC.F1() : 0.0);
            }
            return new ConfMat(lasterror.train_err, lasterror.trainAUC != null ? lasterror.trainAUC.F1() : 0.0);
        }
        return new ConfusionMatrix2(cm.cm, cm.cm.length - 1);
    }

    public double mse() {
        if (this.errors == null) {
            return Double.NaN;
        }
        return this.last_scored().validation || this.last_scored().num_folds > 0 ? this.last_scored().valid_mse : this.last_scored().train_mse;
    }

    public VarImp varimp() {
        if (this.errors == null) {
            return null;
        }
        return this.last_scored().variable_importances;
    }

    public DeepLearningModel(Key destKey, DeepLearningModel cp, boolean store_best_model, Frame train, FrameTask.DataInfo dataInfo) {
        super(destKey, (SupervisedModel.SupervisedParameters)((DeepLearningParameters)((DeepLearningParameters)cp._parms).clone()), (SupervisedModel.SupervisedOutput)((DeepLearningOutput)((DeepLearningOutput)cp._output).clone()));
        if (store_best_model) {
            this.model_info = cp.model_info.deep_clone();
            this.model_info.data_info = dataInfo.deep_clone();
        } else {
            this.model_info = (DeepLearningModelInfo)cp.model_info.clone();
            this.model_info.data_info = dataInfo;
            ((DeepLearningParameters)this._parms)._checkpoint = cp._key;
        }
        this.actual_best_model_key = cp.actual_best_model_key;
        this.start_time = cp.start_time;
        this.run_time = cp.run_time;
        this.training_rows = cp.training_rows;
        this.validation_rows = cp.validation_rows;
        this._bestError = cp._bestError;
        this.errors = (Errors[])cp.errors.clone();
        for (int i = 0; i < this.errors.length; ++i) {
            this.errors[i] = cp.errors[i].deep_clone();
        }
        this._timeLastScoreEnter = System.currentTimeMillis();
        this._timeLastScoreStart = 0L;
        this._timeLastScoreEnd = 0L;
        this._timeLastPrintStart = 0L;
        assert (Arrays.equals(this._key._kb, destKey._kb));
    }

    public DeepLearningModel(Key destKey, DeepLearningParameters parms, DeepLearningOutput output, Frame train, Frame valid) {
        super(destKey, (SupervisedModel.SupervisedParameters)parms, (SupervisedModel.SupervisedOutput)output);
        this.run_time = 0L;
        this._timeLastScoreEnter = this.start_time = System.currentTimeMillis();
        boolean classification = train.lastVec().isEnum();
        FrameTask.DataInfo dinfo = new FrameTask.DataInfo(Key.make(), train, valid, parms._autoencoder ? 0 : 1, parms._autoencoder || parms._use_all_factor_levels, parms._autoencoder ? FrameTask.DataInfo.TransformType.NORMALIZE : FrameTask.DataInfo.TransformType.STANDARDIZE, classification ? FrameTask.DataInfo.TransformType.NONE : FrameTask.DataInfo.TransformType.STANDARDIZE);
        output._names = train._names;
        output._domains = train.domains();
        DKV.put((Key)dinfo._key, (Iced)dinfo);
        this.model_info = new DeepLearningModelInfo(parms, dinfo, classification, train, valid);
        this.actual_best_model_key = Key.makeUserHidden((Key)Key.make());
        if (parms._n_folds != 0) {
            this.actual_best_model_key = null;
        }
        if (!parms._autoencoder) {
            this.errors = new Errors[1];
            this.errors[0] = new Errors();
            this.errors[0].validation = parms._valid != null;
            this.errors[0].num_folds = parms._n_folds;
        }
        assert (this._key.equals((Object)destKey));
    }

    boolean doScoring(Frame train, Frame ftrain, Frame ftest, Key job_key, ValidationAdapter.Response2CMAdaptor vadaptor) {
        boolean keep_running = true;
        try {
            long now = System.currentTimeMillis();
            this.epoch_counter = (float)this.model_info().get_processed_total() / (float)this.training_rows;
            double time_last_iter_millis = Math.max(5L, now - this._timeLastScoreEnter);
            if (H2O.CLOUD.size() > 1 && this.get_params()._train_samples_per_iteration == -2L && this.time_for_communication_us > 10000.0) {
                double comm_to_work_ratio = this.time_for_communication_us * 0.001 / time_last_iter_millis;
                double correction = this.get_params()._target_ratio_comm_to_comp / comm_to_work_ratio;
                this.actual_train_samples_per_iteration = (long)((double)this.actual_train_samples_per_iteration / correction);
                this.actual_train_samples_per_iteration = Math.max(1L, this.actual_train_samples_per_iteration);
            }
            this.run_time = (long)((double)this.run_time + time_last_iter_millis);
            this._timeLastScoreEnter = now;
            keep_running = this.epoch_counter < this.get_params()._epochs;
            long sinceLastScore = now - this._timeLastScoreStart;
            long sinceLastPrint = now - this._timeLastPrintStart;
            long samples = this.model_info().get_processed_total();
            if (!keep_running || (double)sinceLastPrint > this.get_params()._score_interval * 1000.0) {
                this._timeLastPrintStart = now;
                Log.info((Object[])new Object[]{"Training time: " + PrettyPrint.msecs((long)this.run_time, (boolean)true) + ". Processed " + String.format("%,d", samples) + " samples" + " (" + String.format("%.3f", this.epoch_counter) + " epochs)." + " Speed: " + String.format("%.3f", 1000.0 * (double)samples / (double)this.run_time) + " samples/sec."});
            }
            if (!keep_running || (double)sinceLastScore > this.get_params()._score_interval * 1000.0 && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < this.get_params()._score_duty_cycle) {
                boolean printme = !this.get_params()._quiet_mode;
                boolean adaptCM = ((DeepLearningOutput)this._output).isClassifier() && vadaptor.needsAdaptation2CM();
                this._timeLastScoreStart = now;
                if (this.get_params()._diagnostics) {
                    this.model_info().computeStats();
                }
                Errors err = new Errors();
                err.training_time_ms = this.run_time;
                err.epoch_counter = this.epoch_counter;
                err.training_samples = this.model_info().get_processed_total();
                err.validation = ftest != null;
                err.score_training_samples = ftrain.numRows();
                if (this.get_params()._autoencoder) {
                    if (printme) {
                        Log.info((Object[])new Object[]{"Scoring the auto-encoder."});
                    }
                    Frame mse_frame = this.scoreAutoEncoder(ftrain);
                    Vec l2 = mse_frame.anyVec();
                    Log.info((Object[])new Object[]{"Mean reconstruction error on training data: " + l2.mean() + "\n"});
                    err.train_mse = l2.mean();
                    mse_frame.delete();
                } else {
                    String m;
                    if (printme) {
                        Log.info((Object[])new Object[]{"Scoring the model."});
                    }
                    err.classification = ((DeepLearningOutput)this._output).isClassifier();
                    err.num_folds = this.get_params()._n_folds;
                    err.train_confusion_matrix = new ConfusionMatrix();
                    int hit_k = Math.min(((DeepLearningOutput)this._output).nclasses(), this.get_params()._max_hit_ratio_k);
                    if (err.classification && ((DeepLearningOutput)this._output).nclasses() > 2 && hit_k > 0) {
                        err.train_hitratio = new HitRatio();
                        err.train_hitratio.set_max_k(hit_k);
                    }
                    if ((m = this.model_info().toString()).length() > 0) {
                        Log.info((Object[])new Object[]{m});
                    }
                    Frame trainPredict = this.score(ftrain, false);
                    AUC trainAUC = null;
                    if (err.classification && ((DeepLearningOutput)this._output).nclasses() == 2) {
                        trainAUC = new AUC();
                    }
                    double trainErr = this.calcError(ftrain, ftrain.lastVec(), trainPredict, trainPredict, "training", printme, this.get_params()._max_confusion_matrix_size, err.train_confusion_matrix, trainAUC, err.train_hitratio);
                    if (((DeepLearningOutput)this._output).isClassifier()) {
                        err.train_err = trainErr;
                    }
                    if (trainAUC != null) {
                        err.trainAUC = trainAUC.data();
                    } else {
                        err.train_mse = trainErr;
                    }
                    trainPredict.delete();
                    if (err.validation) {
                        assert (ftest != null);
                        err.score_validation_samples = ftest.numRows();
                        err.valid_confusion_matrix = new ConfusionMatrix();
                        if (err.classification && ((DeepLearningOutput)this._output).nclasses() > 2 && hit_k > 0) {
                            err.valid_hitratio = new HitRatio();
                            err.valid_hitratio.set_max_k(hit_k);
                        }
                        String adaptRespName = vadaptor.adaptedValidationResponse(((DeepLearningOutput)this._output).responseName());
                        Vec adaptCMresp = null;
                        if (adaptCM) {
                            Vec[] v = ftest.vecs();
                            assert (ftest.find(adaptRespName) == v.length - 1);
                            adaptCMresp = ftest.remove(v.length - 1);
                        }
                        Frame validPredict = this.score(ftest, adaptCM);
                        Frame hitratio_validPredict = new Frame(validPredict);
                        Vec orig_label = validPredict.vecs()[0];
                        if (adaptCM) {
                            assert (adaptCMresp != null);
                            assert (ftest.find(adaptRespName) == -1);
                            ftest.add(adaptRespName, adaptCMresp);
                            Vec CMadapted = vadaptor.adaptModelResponse2CM(validPredict.vecs()[0]);
                            validPredict.replace(0, CMadapted);
                            validPredict.add("to_be_deleted", CMadapted);
                        }
                        AUC validAUC = null;
                        if (err.classification && ((DeepLearningOutput)this._output).nclasses() == 2) {
                            validAUC = new AUC();
                        }
                        double validErr = this.calcError(ftest, ftest.lastVec(), validPredict, hitratio_validPredict, "validation", printme, this.get_params()._max_confusion_matrix_size, err.valid_confusion_matrix, validAUC, err.valid_hitratio);
                        if (((DeepLearningOutput)this._output).isClassifier()) {
                            err.valid_err = validErr;
                        }
                        if (trainAUC != null) {
                            err.validAUC = validAUC.data();
                        } else {
                            err.valid_mse = validErr;
                        }
                        validPredict.delete();
                        if (adaptCM) {
                            orig_label.remove(new Futures()).blockForPending();
                        }
                    }
                    if (this.get_params()._variable_importances) {
                        if (!this.get_params()._quiet_mode) {
                            Log.info((Object[])new Object[]{"Computing variable importances."});
                        }
                        float[] vi = this.model_info().computeVariableImportances();
                        err.variable_importances = new VarImp(vi, Arrays.copyOfRange(this.model_info().data_info().coefNames(), 0, vi.length));
                    }
                    if (err.train_confusion_matrix.cm != null && err.train_confusion_matrix.cm.length - 1 >= this.get_params()._max_confusion_matrix_size) {
                        err.train_confusion_matrix = null;
                        err.valid_confusion_matrix = null;
                    }
                }
                this._timeLastScoreEnd = System.currentTimeMillis();
                err.scoring_time = System.currentTimeMillis() - now;
                if (this.errors == null) {
                    this.errors = new Errors[]{err};
                } else {
                    Errors[] err2 = new Errors[this.errors.length + 1];
                    System.arraycopy(this.errors, 0, err2, 0, this.errors.length);
                    err2[err2.length - 1] = err;
                    this.errors = err2;
                }
                if (!this.get_params()._autoencoder) {
                    if (this.actual_best_model_key != null && (DKV.get((Key)this.actual_best_model_key) != null && (this.error() < ((DeepLearningModel)DKV.get((Key)this.actual_best_model_key).get()).error() || !Arrays.equals(this.model_info().units, ((DeepLearningModel)DKV.get((Key)this.actual_best_model_key).get()).model_info().units)) || DKV.get((Key)this.actual_best_model_key) == null && this.error() < this._bestError)) {
                        if (!this.get_params()._quiet_mode) {
                            Log.info((Object[])new Object[]{"Error reduced from " + this._bestError + " to " + this.error() + ". Storing best model so far under key " + this.actual_best_model_key.toString() + "."});
                        }
                        this._bestError = this.error();
                        this.putMeAsBestModel(this.actual_best_model_key, train);
                    }
                    for (String s : this.toString().split("\n")) {
                        Log.info((Object[])new Object[]{s});
                    }
                    if (printme) {
                        Log.info((Object[])new Object[]{"Time taken for scoring and diagnostics: " + PrettyPrint.msecs((long)err.scoring_time, (boolean)true)});
                    }
                }
            }
            if (this.model_info().unstable()) {
                Log.warn((Object[])new Object[]{"Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing."});
                keep_running = false;
            } else if (((DeepLearningOutput)this._output).isClassifier() && this.last_scored().train_err <= this.get_params()._classification_stop || !((DeepLearningOutput)this._output).isClassifier() && this.last_scored().train_mse <= this.get_params()._regression_stop) {
                Log.info((Object[])new Object[]{"Achieved requested predictive accuracy on the training data. Model building completed."});
                keep_running = false;
            }
            this.update(job_key);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            keep_running = false;
            throw new RuntimeException(ex);
        }
        return keep_running;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.model_info.toString());
        sb.append(this.last_scored().toString());
        return sb.toString();
    }

    public String toStringAll() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.model_info.toStringAll());
        sb.append(this.last_scored().toString());
        return sb.toString();
    }

    public Frame score(Frame frame) {
        if (!this.get_params()._autoencoder) {
            return super.score(frame);
        }
        Frame[] adaptFrms = this.adapt(frame, false, false);
        Frame adaptFrm = adaptFrms[0];
        Frame onlyAdaptFrm = adaptFrms[1];
        final int len = this.model_info().data_info().fullN();
        String prefix = "reconstr_";
        assert (this.model_info().data_info()._responses == 0);
        String[] coefnames = this.model_info().data_info().coefNames();
        assert (len == coefnames.length);
        for (int c = 0; c < len; ++c) {
            adaptFrm.add(prefix + coefnames[c], adaptFrm.anyVec().makeZero());
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[((DeepLearningOutput)DeepLearningModel.this._output)._names.length];
                float[] preds = new float[len];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    float[] p = DeepLearningModel.this.score_autoencoder(chks, row, tmp, preds, neurons);
                    for (int c = 0; c < preds.length; ++c) {
                        chks[((DeepLearningOutput)DeepLearningModel.this._output)._names.length + c].set0(row, p[c]);
                    }
                }
            }
        }.doAll(adaptFrm);
        int x = ((DeepLearningOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame f = adaptFrm.extractFrame(x, y);
        onlyAdaptFrm.delete();
        return f;
    }

    public float[] score0(double[] data, float[] preds) {
        if (this.model_info().unstable()) {
            Log.warn((Object[])new Object[]{"Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing."});
            throw new UnsupportedOperationException("Trying to predict with an unstable model.");
        }
        Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this.model_info);
        ((Neurons.Input)neurons[0]).setInput(-1L, data);
        DeepLearningTask.step(-1L, neurons, this.model_info, false, null);
        float[] out = neurons[neurons.length - 1]._a.raw();
        if (((DeepLearningOutput)this._output).isClassifier()) {
            assert (preds.length == out.length + 1);
            for (int i = 0; i < preds.length - 1; ++i) {
                preds[i + 1] = out[i];
                if (!Float.isNaN(preds[i + 1])) continue;
                throw new RuntimeException("Predicted class probability NaN!");
            }
            preds[0] = ModelUtils.getPrediction((float[])preds, (double[])data);
        } else {
            assert (preds.length == 1 && out.length == 1);
            preds[0] = this.model_info().data_info()._normRespMul != null ? (float)((double)out[0] / this.model_info().data_info()._normRespMul[0] + this.model_info().data_info()._normRespSub[0]) : out[0];
            if (Float.isNaN(preds[0])) {
                throw new RuntimeException("Predicted regression target NaN!");
            }
        }
        return preds;
    }

    public Frame scoreAutoEncoder(Frame frame) {
        final int len = ((DeepLearningOutput)this._output)._names.length;
        Frame[] adaptFrms = this.adapt(frame, false, false);
        Frame adaptFrm = adaptFrms[0];
        Frame onlyAdaptFrm = adaptFrms[1];
        adaptFrm.add("Reconstruction.MSE", adaptFrm.anyVec().makeZero());
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[len];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    for (int i = 0; i < ((DeepLearningOutput)DeepLearningModel.this._output)._names.length; ++i) {
                        tmp[i] = chks[i].at0(row);
                    }
                    chks[len].set0(row, DeepLearningModel.this.score_autoencoder(tmp, null, neurons));
                }
            }
        }.doAll(adaptFrm);
        int x = ((DeepLearningOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame l2 = adaptFrm.extractFrame(x, y);
        onlyAdaptFrm.delete();
        return l2;
    }

    private float[] score_autoencoder(Chunk[] chks, int row_in_chunk, double[] tmp, float[] preds, Neurons[] neurons) {
        assert (this.get_params()._autoencoder);
        assert (tmp.length == ((DeepLearningOutput)this._output)._names.length);
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = chks[i].at0(row_in_chunk);
        }
        this.score_autoencoder(tmp, preds, neurons);
        return preds;
    }

    private double score_autoencoder(double[] data, float[] preds, Neurons[] neurons) {
        assert (this.model_info().get_params()._autoencoder);
        if (this.model_info().unstable()) {
            Log.warn((Object[])new Object[]{"Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing."});
            throw new UnsupportedOperationException("Trying to predict with an unstable model.");
        }
        ((Neurons.Input)neurons[0]).setInput(-1L, data);
        DeepLearningTask.step(-1L, neurons, this.model_info, false, null);
        float[] in = neurons[0]._a.raw();
        float[] out = neurons[neurons.length - 1]._a.raw();
        assert (in.length == out.length);
        double l2 = 0.0;
        for (int i = 0; i < in.length; ++i) {
            l2 += Math.pow(out[i] - in[i], 2.0);
        }
        l2 /= (double)in.length;
        if (preds != null) {
            this.model_info().data_info().unScaleNumericals(out, out);
            System.arraycopy(out, 0, preds, 0, out.length);
        }
        return l2;
    }

    private void putMeAsBestModel(Key bestModelKey, Frame train) {
        DeepLearningModel bestModel = new DeepLearningModel(bestModelKey, this, true, train, this.model_info().data_info());
        Key job = null;
        bestModel.delete_and_lock(job);
        bestModel.unlock(job);
        assert (DKV.get((Key)bestModelKey) != null);
        assert (bestModel.compareTo(this) <= 0);
        assert (((DeepLearningModel)DKV.get((Key)bestModelKey).get()).error() == this._bestError);
    }

    public void delete_best_model() {
        if (this.actual_best_model_key != null && this.actual_best_model_key != this._key) {
            DKV.remove((Key)this.actual_best_model_key);
        }
    }

    public void delete_xval_models() {
    }

    public static class DeepLearningModelInfo
    extends Iced {
        private FrameTask.DataInfo data_info;
        private Neurons.DenseRowMatrix[] dense_row_weights;
        private Neurons.DenseColMatrix[] dense_col_weights;
        private Neurons.DenseVector[] biases;
        private Neurons.DenseVector[] avg_activations;
        private Neurons.DenseRowMatrix[] dense_row_weights_momenta;
        private Neurons.DenseColMatrix[] dense_col_weights_momenta;
        private Neurons.DenseVector[] biases_momenta;
        private Neurons.DenseRowMatrix[] dense_row_ada_dx_g;
        private Neurons.DenseColMatrix[] dense_col_ada_dx_g;
        private Neurons.DenseVector[] biases_ada_dx_g;
        private DeepLearningParameters parameters;
        private float[] mean_rate;
        private float[] rms_rate;
        private float[] mean_bias;
        private float[] rms_bias;
        private float[] mean_weight;
        public float[] rms_weight;
        public float[] mean_a;
        private volatile boolean unstable = false;
        private long processed_global;
        private long processed_local;
        int[] units;
        final boolean _classification;
        final Frame _train;
        final Frame _valid;

        public FrameTask.DataInfo data_info() {
            return this.data_info;
        }

        public long size() {
            long siz = 0L;
            for (Neurons.DenseRowMatrix denseRowMatrix : this.dense_row_weights) {
                if (denseRowMatrix == null) continue;
                siz += denseRowMatrix.size();
            }
            for (Iced iced : this.dense_col_weights) {
                if (iced == null) continue;
                siz += iced.size();
            }
            for (Iced iced : this.biases) {
                siz += (long)iced.size();
            }
            return siz;
        }

        boolean has_momenta() {
            return this.get_params()._momentum_start != 0.0 || this.get_params()._momentum_stable != 0.0;
        }

        boolean adaDelta() {
            return this.get_params()._adaptive_rate;
        }

        public final Neurons.Matrix get_weights(int i) {
            return (Neurons.Matrix)(this.dense_row_weights[i] == null ? this.dense_col_weights[i] : this.dense_row_weights[i]);
        }

        public final Neurons.DenseVector get_biases(int i) {
            return this.biases[i];
        }

        public final Neurons.Matrix get_weights_momenta(int i) {
            return (Neurons.Matrix)(this.dense_row_weights_momenta[i] == null ? this.dense_col_weights_momenta[i] : this.dense_row_weights_momenta[i]);
        }

        public final Neurons.DenseVector get_biases_momenta(int i) {
            return this.biases_momenta[i];
        }

        public final Neurons.Matrix get_ada_dx_g(int i) {
            return (Neurons.Matrix)(this.dense_row_ada_dx_g[i] == null ? this.dense_col_ada_dx_g[i] : this.dense_row_ada_dx_g[i]);
        }

        public final Neurons.DenseVector get_biases_ada_dx_g(int i) {
            return this.biases_ada_dx_g[i];
        }

        public final Neurons.DenseVector get_avg_activations(int i) {
            return this.avg_activations[i];
        }

        public final DeepLearningParameters get_params() {
            return this.parameters;
        }

        public boolean unstable() {
            return this.unstable;
        }

        public void set_unstable() {
            if (!this.unstable) {
                this.computeStats();
            }
            this.unstable = true;
        }

        public synchronized long get_processed_global() {
            return this.processed_global;
        }

        public synchronized void set_processed_global(long p) {
            this.processed_global = p;
        }

        public synchronized void add_processed_global(long p) {
            this.processed_global += p;
        }

        public synchronized long get_processed_local() {
            return this.processed_local;
        }

        public synchronized void set_processed_local(long p) {
            this.processed_local = p;
        }

        public synchronized void add_processed_local(long p) {
            this.processed_local += p;
        }

        public synchronized long get_processed_total() {
            return this.processed_global + this.processed_local;
        }

        public DeepLearningModelInfo() {
            this._classification = false;
            this._valid = null;
            this._train = null;
        }

        public DeepLearningModelInfo(DeepLearningParameters params, FrameTask.DataInfo dinfo, boolean classification, Frame train, Frame valid) {
            int i;
            int num_output;
            this._classification = classification;
            this._train = train;
            this._valid = valid;
            this.data_info = dinfo;
            this.parameters = params;
            int num_input = dinfo.fullN();
            int n = this.get_params()._autoencoder ? num_input : (num_output = this._classification ? train.lastVec().cardinality() : 1);
            assert (num_input > 0);
            assert (num_output > 0);
            if (this.has_momenta() && this.adaDelta()) {
                throw new IllegalArgumentException("Cannot have non-zero momentum and adaptive rate at the same time.");
            }
            int layers = this.get_params()._hidden.length;
            this.units = new int[layers + 2];
            this.units[0] = this.get_params()._max_categorical_features <= Integer.MAX_VALUE - dinfo._nums ? Math.min(dinfo._nums + this.get_params()._max_categorical_features, num_input) : num_input;
            System.arraycopy(this.get_params()._hidden, 0, this.units, 1, layers);
            this.units[layers + 1] = num_output;
            this.dense_row_weights = new Neurons.DenseRowMatrix[layers + 1];
            this.dense_col_weights = new Neurons.DenseColMatrix[layers + 1];
            if (this.get_params()._col_major) {
                this.dense_col_weights[0] = new Neurons.DenseColMatrix(this.units[1], this.units[0]);
            } else {
                this.dense_row_weights[0] = new Neurons.DenseRowMatrix(this.units[1], this.units[0]);
            }
            for (i = 1; i <= layers; ++i) {
                this.dense_row_weights[i] = new Neurons.DenseRowMatrix(this.units[i + 1], this.units[i]);
            }
            this.biases = new Neurons.DenseVector[layers + 1];
            for (i = 0; i <= layers; ++i) {
                this.biases[i] = new Neurons.DenseVector(this.units[i + 1]);
            }
            if (this.get_params()._autoencoder && this.get_params()._sparsity_beta > 0.0) {
                this.avg_activations = new Neurons.DenseVector[layers];
                this.mean_a = new float[layers];
                for (i = 0; i < layers; ++i) {
                    this.avg_activations[i] = new Neurons.DenseVector(this.units[i + 1]);
                }
            }
            this.fillHelpers();
            this.mean_rate = new float[this.units.length];
            this.rms_rate = new float[this.units.length];
            this.mean_bias = new float[this.units.length];
            this.rms_bias = new float[this.units.length];
            this.mean_weight = new float[this.units.length];
            this.rms_weight = new float[this.units.length];
        }

        DeepLearningModelInfo deep_clone() {
            AutoBuffer ab = new AutoBuffer();
            this.write(ab);
            ab.flipForReading();
            return (DeepLearningModelInfo)new DeepLearningModelInfo().read(ab);
        }

        void fillHelpers() {
            block9: {
                int i;
                block8: {
                    int i2;
                    if (!this.has_momenta()) break block8;
                    this.dense_row_weights_momenta = new Neurons.DenseRowMatrix[this.dense_row_weights.length];
                    this.dense_col_weights_momenta = new Neurons.DenseColMatrix[this.dense_col_weights.length];
                    if (this.dense_row_weights[0] != null) {
                        this.dense_row_weights_momenta[0] = new Neurons.DenseRowMatrix(this.units[1], this.units[0]);
                    } else {
                        this.dense_col_weights_momenta[0] = new Neurons.DenseColMatrix(this.units[1], this.units[0]);
                    }
                    for (i2 = 1; i2 < this.dense_row_weights_momenta.length; ++i2) {
                        this.dense_row_weights_momenta[i2] = new Neurons.DenseRowMatrix(this.units[i2 + 1], this.units[i2]);
                    }
                    this.biases_momenta = new Neurons.DenseVector[this.biases.length];
                    for (i2 = 0; i2 < this.biases_momenta.length; ++i2) {
                        this.biases_momenta[i2] = new Neurons.DenseVector(this.units[i2 + 1]);
                    }
                    break block9;
                }
                if (!this.adaDelta()) break block9;
                this.dense_row_ada_dx_g = new Neurons.DenseRowMatrix[this.dense_row_weights.length];
                this.dense_col_ada_dx_g = new Neurons.DenseColMatrix[this.dense_col_weights.length];
                if (this.dense_row_weights[0] != null) {
                    this.dense_row_ada_dx_g[0] = new Neurons.DenseRowMatrix(this.units[1], 2 * this.units[0]);
                } else {
                    this.dense_col_ada_dx_g[0] = new Neurons.DenseColMatrix(2 * this.units[1], this.units[0]);
                }
                for (i = 1; i < this.dense_row_ada_dx_g.length; ++i) {
                    this.dense_row_ada_dx_g[i] = new Neurons.DenseRowMatrix(this.units[i + 1], 2 * this.units[i]);
                }
                this.biases_ada_dx_g = new Neurons.DenseVector[this.biases.length];
                for (i = 0; i < this.biases_ada_dx_g.length; ++i) {
                    this.biases_ada_dx_g[i] = new Neurons.DenseVector(2 * this.units[i + 1]);
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.get_params()._diagnostics && !this.get_params()._quiet_mode) {
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this);
                sb.append("Number of hidden layers is " + this.get_params()._hidden.length + " \n");
                if (this.get_params()._sparsity_beta > 0.0) {
                    for (int k = 0; k < this.get_params()._hidden.length; ++k) {
                        sb.append("Average activation in hidden layer " + k + " is  " + this.mean_a[k] + " \n");
                    }
                }
                sb.append("Status of Neuron Layers:\n");
                sb.append("#  Units         Type      Dropout    L1       L2    " + (this.get_params()._adaptive_rate ? "  Rate (Mean,RMS)   " : "  Rate      Momentum") + "   Weight (Mean, RMS)      Bias (Mean,RMS)\n");
                String format = "%7g";
                for (int i = 0; i < neurons.length; ++i) {
                    sb.append(i + 1 + " " + String.format("%6d", neurons[i].units) + " " + String.format("%16s", neurons[i].getClass().getSimpleName()));
                    if (i == 0) {
                        sb.append("  " + PrettyPrint.formatPct((double)neurons[i].params._input_dropout_ratio) + " \n");
                        continue;
                    }
                    if (i < neurons.length - 1) {
                        if (neurons[i].params._hidden_dropout_ratios == null) {
                            sb.append("  " + PrettyPrint.formatPct((double)0.0) + " ");
                        } else {
                            sb.append("  " + PrettyPrint.formatPct((double)neurons[i].params._hidden_dropout_ratios[i - 1]) + " ");
                        }
                    } else {
                        sb.append("          ");
                    }
                    sb.append(" " + String.format("%5f", neurons[i].params._l1) + " " + String.format("%5f", neurons[i].params._l2) + " " + (this.get_params()._adaptive_rate ? " (" + String.format("%7g", Float.valueOf(this.mean_rate[i])) + ", " + String.format("%7g", Float.valueOf(this.rms_rate[i])) + ")" : String.format("%10g", Float.valueOf(neurons[i].rate(this.get_processed_total()))) + " " + String.format("%5f", Float.valueOf(neurons[i].momentum(this.get_processed_total())))) + " (" + String.format("%7g", Float.valueOf(this.mean_weight[i])) + ", " + String.format("%7g", Float.valueOf(this.rms_weight[i])) + ")" + " (" + String.format("%7g", Float.valueOf(this.mean_bias[i])) + ", " + String.format("%7g", Float.valueOf(this.rms_bias[i])) + ")\n");
                    if (!(this.get_params()._sparsity_beta > 0.0)) continue;
                }
            }
            return sb.toString();
        }

        public String toStringAll() {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString());
            for (i = 0; i < this.units.length - 1; ++i) {
                sb.append("\nweights[" + i + "][]=" + Arrays.toString(this.get_weights(i).raw()));
            }
            for (i = 0; i < this.units.length - 1; ++i) {
                sb.append("\nbiases[" + i + "][]=" + Arrays.toString(this.get_biases(i).raw()));
            }
            if (this.has_momenta()) {
                for (i = 0; i < this.units.length - 1; ++i) {
                    sb.append("\nweights_momenta[" + i + "][]=" + Arrays.toString(this.get_weights_momenta(i).raw()));
                }
            }
            if (this.biases_momenta != null) {
                for (i = 0; i < this.units.length - 1; ++i) {
                    sb.append("\nbiases_momenta[" + i + "][]=" + Arrays.toString(this.biases_momenta[i].raw()));
                }
            }
            sb.append("\nunits[]=" + Arrays.toString(this.units));
            sb.append("\nprocessed global: " + this.get_processed_global());
            sb.append("\nprocessed local:  " + this.get_processed_local());
            sb.append("\nprocessed total:  " + this.get_processed_total());
            sb.append("\n");
            return sb.toString();
        }

        void initializeMembers() {
            this.randomizeWeights();
            for (int i = 0; i < this.get_params()._hidden.length; ++i) {
                if (this.get_params()._activation == DeepLearningParameters.Activation.Rectifier || this.get_params()._activation == DeepLearningParameters.Activation.RectifierWithDropout || this.get_params()._activation == DeepLearningParameters.Activation.Maxout || this.get_params()._activation == DeepLearningParameters.Activation.MaxoutWithDropout) {
                    Arrays.fill(this.biases[i].raw(), i == 0 ? 0.5f : 1.0f);
                    continue;
                }
                if (this.get_params()._activation != DeepLearningParameters.Activation.Tanh && this.get_params()._activation != DeepLearningParameters.Activation.TanhWithDropout) continue;
                Arrays.fill(this.biases[i].raw(), 0.0f);
            }
            Arrays.fill(this.biases[this.biases.length - 1].raw(), 0.0f);
        }

        public void add(DeepLearningModelInfo other) {
            int i;
            for (i = 0; i < this.dense_row_weights.length; ++i) {
                ArrayUtils.add((float[])this.get_weights(i).raw(), (float[])other.get_weights(i).raw());
            }
            for (i = 0; i < this.biases.length; ++i) {
                ArrayUtils.add((float[])this.biases[i].raw(), (float[])other.biases[i].raw());
            }
            if (this.avg_activations != null) {
                for (i = 0; i < this.avg_activations.length; ++i) {
                    ArrayUtils.add((float[])this.avg_activations[i].raw(), (float[])other.biases[i].raw());
                }
            }
            if (this.has_momenta()) {
                assert (other.has_momenta());
                for (i = 0; i < this.dense_row_weights_momenta.length; ++i) {
                    ArrayUtils.add((float[])this.get_weights_momenta(i).raw(), (float[])other.get_weights_momenta(i).raw());
                }
                for (i = 0; i < this.biases_momenta.length; ++i) {
                    ArrayUtils.add((float[])this.biases_momenta[i].raw(), (float[])other.biases_momenta[i].raw());
                }
            }
            if (this.adaDelta()) {
                assert (other.adaDelta());
                for (i = 0; i < this.dense_row_ada_dx_g.length; ++i) {
                    ArrayUtils.add((float[])this.get_ada_dx_g(i).raw(), (float[])other.get_ada_dx_g(i).raw());
                }
            }
            this.add_processed_local(other.get_processed_local());
        }

        protected void div(float N) {
            for (int i = 0; i < this.dense_row_weights.length; ++i) {
                ArrayUtils.div((float[])this.get_weights(i).raw(), (float)N);
            }
            for (Neurons.DenseVector bias : this.biases) {
                ArrayUtils.div((float[])bias.raw(), (float)N);
            }
            if (this.avg_activations != null) {
                for (Neurons.DenseVector avgac : this.avg_activations) {
                    ArrayUtils.div((float[])avgac.raw(), (float)N);
                }
            }
            if (this.has_momenta()) {
                for (int i = 0; i < this.dense_row_weights_momenta.length; ++i) {
                    ArrayUtils.div((float[])this.get_weights_momenta(i).raw(), (float)N);
                }
                for (Neurons.DenseVector bias_momenta : this.biases_momenta) {
                    ArrayUtils.div((float[])bias_momenta.raw(), (float)N);
                }
            }
            if (this.adaDelta()) {
                for (int i = 0; i < this.dense_row_ada_dx_g.length; ++i) {
                    ArrayUtils.div((float[])this.get_ada_dx_g(i).raw(), (float)N);
                }
            }
        }

        double uniformDist(Random rand, double min, double max) {
            return min + (double)rand.nextFloat() * (max - min);
        }

        void randomizeWeights() {
            for (int w = 0; w < this.dense_row_weights.length; ++w) {
                Random rng = RandomUtils.getDeterRNG((long)(this.get_params()._seed + 195911405L + (long)w + 1L));
                double range = Math.sqrt(6.0 / (double)(this.units[w] + this.units[w + 1]));
                for (int i = 0; i < this.get_weights(w).rows(); ++i) {
                    for (int j = 0; j < this.get_weights(w).cols(); ++j) {
                        if (this.get_params()._initial_weight_distribution == DeepLearningParameters.InitialWeightDistribution.UniformAdaptive) {
                            if (w == this.dense_row_weights.length - 1 && this._classification) {
                                this.get_weights(w).set(i, j, (float)(4.0 * this.uniformDist(rng, -range, range)));
                                continue;
                            }
                            this.get_weights(w).set(i, j, (float)this.uniformDist(rng, -range, range));
                            continue;
                        }
                        if (this.get_params()._initial_weight_distribution == DeepLearningParameters.InitialWeightDistribution.Uniform) {
                            this.get_weights(w).set(i, j, (float)this.uniformDist(rng, -this.get_params()._initial_weight_scale, this.get_params()._initial_weight_scale));
                            continue;
                        }
                        if (this.get_params()._initial_weight_distribution != DeepLearningParameters.InitialWeightDistribution.Normal) continue;
                        this.get_weights(w).set(i, j, (float)(rng.nextGaussian() * this.get_params()._initial_weight_scale));
                    }
                }
            }
        }

        public float[] computeVariableImportances() {
            int i;
            int k;
            float[] vi = new float[this.units[0]];
            Arrays.fill(vi, 0.0f);
            float[][] Qik = new float[this.units[0]][this.units[2]];
            float[] sum_wj = new float[this.units[1]];
            float[] sum_wk = new float[this.units[2]];
            for (float[] Qi : Qik) {
                Arrays.fill(Qi, 0.0f);
            }
            Arrays.fill(sum_wj, 0.0f);
            Arrays.fill(sum_wk, 0.0f);
            for (int j = 0; j < this.units[1]; ++j) {
                for (int i2 = 0; i2 < this.units[0]; ++i2) {
                    float wij = this.get_weights(0).get(j, i2);
                    int n = j;
                    sum_wj[n] = sum_wj[n] + Math.abs(wij);
                }
            }
            for (k = 0; k < this.units[2]; ++k) {
                for (int j = 0; j < this.units[1]; ++j) {
                    float wjk = this.get_weights(1).get(k, j);
                    int n = k;
                    sum_wk[n] = sum_wk[n] + Math.abs(wjk);
                }
            }
            for (i = 0; i < this.units[0]; ++i) {
                for (int k2 = 0; k2 < this.units[2]; ++k2) {
                    for (int j = 0; j < this.units[1]; ++j) {
                        float wij = this.get_weights(0).get(j, i);
                        float wjk = this.get_weights(1).get(k2, j);
                        float[] fArray = Qik[i];
                        int n = k2;
                        fArray[n] = fArray[n] + Math.abs(wij) / sum_wj[j] * Math.abs(wjk) / sum_wk[k2];
                    }
                }
            }
            for (k = 0; k < this.units[2]; ++k) {
                int i3;
                float sumQk = 0.0f;
                for (i3 = 0; i3 < this.units[0]; ++i3) {
                    sumQk += Qik[i3][k];
                }
                for (i3 = 0; i3 < this.units[0]; ++i3) {
                    float[] fArray = Qik[i3];
                    int n = k;
                    fArray[n] = fArray[n] / sumQk;
                }
            }
            for (i = 0; i < this.units[0]; ++i) {
                vi[i] = ArrayUtils.sum((float[])Qik[i]);
            }
            ArrayUtils.div((float[])vi, (float)ArrayUtils.maxValue((float[])vi));
            return vi;
        }

        public void computeStats() {
            float[][] rate = this.get_params()._adaptive_rate ? (Object)new float[this.units.length - 1][] : (float[][])null;
            Object object = rate;
            if (this.get_params()._autoencoder && this.get_params()._sparsity_beta > 0.0) {
                for (int k = 0; k < this.get_params()._hidden.length; ++k) {
                    this.mean_a[k] = 0.0f;
                    for (int j = 0; j < this.avg_activations[k].size(); ++j) {
                        int n = k;
                        this.mean_a[n] = this.mean_a[n] + this.avg_activations[k].get(j);
                    }
                    int n = k;
                    this.mean_a[n] = this.mean_a[n] / (float)this.avg_activations[k].size();
                }
            }
            for (int y = 1; y < this.units.length; ++y) {
                int u;
                this.rms_rate[y] = 0.0f;
                this.mean_rate[y] = 0.0f;
                this.rms_bias[y] = 0.0f;
                this.mean_bias[y] = 0.0f;
                this.rms_weight[y] = 0.0f;
                this.mean_weight[y] = 0.0f;
                for (u = 0; u < this.biases[y - 1].size(); ++u) {
                    int n = y;
                    this.mean_bias[n] = this.mean_bias[n] + this.biases[y - 1].get(u);
                }
                if (rate != null) {
                    rate[y - 1] = new float[this.get_weights(y - 1).raw().length];
                }
                for (u = 0; u < this.get_weights(y - 1).raw().length; ++u) {
                    int n = y;
                    this.mean_weight[n] = this.mean_weight[n] + this.get_weights(y - 1).raw()[u];
                    if (rate == null) continue;
                    float RMS_dx = MathUtils.approxSqrt((float)(this.get_ada_dx_g(y - 1).raw()[2 * u] + (float)this.get_params()._epsilon));
                    float invRMS_g = MathUtils.approxInvSqrt((float)(this.get_ada_dx_g(y - 1).raw()[2 * u + 1] + (float)this.get_params()._epsilon));
                    rate[y - 1][u] = RMS_dx * invRMS_g;
                    int n2 = y;
                    this.mean_rate[n2] = this.mean_rate[n2] + rate[y - 1][u];
                }
                int n = y;
                this.mean_bias[n] = this.mean_bias[n] / (float)this.biases[y - 1].size();
                int n3 = y;
                this.mean_weight[n3] = this.mean_weight[n3] / (float)this.get_weights(y - 1).size();
                if (rate != null) {
                    int n4 = y;
                    this.mean_rate[n4] = this.mean_rate[n4] / (float)rate[y - 1].length;
                }
                for (u = 0; u < this.biases[y - 1].size(); ++u) {
                    double db = this.biases[y - 1].get(u) - this.mean_bias[y];
                    int n5 = y;
                    this.rms_bias[n5] = (float)((double)this.rms_bias[n5] + db * db);
                }
                u = 0;
                while ((long)u < this.get_weights(y - 1).size()) {
                    double dw = this.get_weights(y - 1).raw()[u] - this.mean_weight[y];
                    int n6 = y;
                    this.rms_weight[n6] = (float)((double)this.rms_weight[n6] + dw * dw);
                    if (rate != null) {
                        double drate = rate[y - 1][u] - this.mean_rate[y];
                        int n7 = y;
                        this.rms_rate[n7] = (float)((double)this.rms_rate[n7] + drate * drate);
                    }
                    ++u;
                }
                this.rms_bias[y] = MathUtils.approxSqrt((float)(this.rms_bias[y] / (float)this.biases[y - 1].size()));
                this.rms_weight[y] = MathUtils.approxSqrt((float)(this.rms_weight[y] / (float)this.get_weights(y - 1).size()));
                if (rate != null) {
                    this.rms_rate[y] = MathUtils.approxSqrt((float)(this.rms_rate[y] / (float)rate[y - 1].length));
                }
                double thresh = 1.0E10;
                this.unstable |= (double)this.mean_bias[y] > 1.0E10 || Double.isNaN(this.mean_bias[y]) || (double)this.rms_bias[y] > 1.0E10 || Double.isNaN(this.rms_bias[y]) || (double)this.mean_weight[y] > 1.0E10 || Double.isNaN(this.mean_weight[y]) || (double)this.rms_weight[y] > 1.0E10 || Double.isNaN(this.rms_weight[y]);
            }
        }
    }

    private static final class ConfMat
    extends ConfusionMatrix2 {
        private final double _err;
        private final double _f1;

        public ConfMat(double err, double f1) {
            super((long[][])null);
            this._err = err;
            this._f1 = f1;
        }

        public double err() {
            return this._err;
        }

        public double F1() {
            return this._f1;
        }

        public double[] classErr() {
            return null;
        }
    }

    public static class Errors
    extends Iced {
        public double epoch_counter;
        public long training_samples;
        public long training_time_ms;
        boolean validation;
        int num_folds;
        public long score_training_samples;
        public long score_validation_samples;
        public boolean classification;
        VarImp variable_importances;
        public ConfusionMatrix train_confusion_matrix;
        public ConfusionMatrix valid_confusion_matrix;
        public double train_err = 1.0;
        public double valid_err = 1.0;
        public AUCData trainAUC;
        public AUCData validAUC;
        public HitRatio train_hitratio;
        public HitRatio valid_hitratio;
        public double train_mse = Double.POSITIVE_INFINITY;
        public double valid_mse = Double.POSITIVE_INFINITY;
        public long scoring_time;

        Errors deep_clone() {
            AutoBuffer ab = new AutoBuffer();
            this.write(ab);
            ab.flipForReading();
            return (Errors)new Errors().read(ab);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.classification) {
                sb.append("Error on training data (misclassification)" + (this.trainAUC != null ? " [using threshold for " + this.trainAUC.threshold_criterion.toString().replace("_", " ") + "]: " : ": ") + String.format("%.2f", 100.0 * this.train_err) + "%");
                if (this.trainAUC != null) {
                    sb.append(", AUC on training data: " + String.format("%.4f", 100.0 * this.trainAUC.AUC) + "%");
                }
                if (this.validation || this.num_folds > 0) {
                    sb.append("\nError on " + (this.num_folds > 0 ? this.num_folds + "-fold cross-" : "") + "validation data (misclassification)" + (this.validAUC != null ? " [using threshold for " + this.validAUC.threshold_criterion.toString().replace("_", " ") + "]: " : ": ") + String.format("%.2f", 100.0 * this.valid_err) + "%");
                }
                if (this.validAUC != null) {
                    sb.append(", AUC on validation data: " + String.format("%.4f", 100.0 * this.validAUC.AUC) + "%");
                }
            } else if (!Double.isInfinite(this.train_mse)) {
                sb.append("Error on training data (MSE): " + this.train_mse);
                if (this.validation || this.num_folds > 0) {
                    sb.append("\nError on " + (this.num_folds > 0 ? this.num_folds + "-fold cross-" : "") + "validation data (MSE): " + this.valid_mse);
                }
            }
            return sb.toString();
        }
    }

    public static class DeepLearningOutput
    extends SupervisedModel.SupervisedOutput {
        public DeepLearningOutput() {
        }

        public DeepLearningOutput(DeepLearning b) {
            super((SupervisedModelBuilder)b);
        }
    }

    public static class DeepLearningParameters
    extends SupervisedModel.SupervisedParameters {
        public int _n_folds;
        public boolean _keep_cross_validation_splits;
        public Key _checkpoint;
        public boolean _override_with_best_model = true;
        public boolean _expert_mode = false;
        public boolean _autoencoder = false;
        public boolean _use_all_factor_levels = true;
        public Activation _activation = Activation.Rectifier;
        public int[] _hidden = new int[]{200, 200};
        public double _epochs = 10.0;
        public long _train_samples_per_iteration = -2L;
        public double _target_ratio_comm_to_comp = 0.02;
        public long _seed = new Random().nextLong();
        public boolean _adaptive_rate = true;
        public double _rho = 0.99;
        public double _epsilon = 1.0E-8;
        public double _rate = 0.005;
        public double _rate_annealing = 1.0E-6;
        public double _rate_decay = 1.0;
        public double _momentum_start = 0.0;
        public double _momentum_ramp = 1000000.0;
        public double _momentum_stable = 0.0;
        public boolean _nesterov_accelerated_gradient = true;
        public double _input_dropout_ratio = 0.0;
        public double[] _hidden_dropout_ratios;
        public double _l1 = 0.0;
        public double _l2 = 0.0;
        public float _max_w2 = Float.POSITIVE_INFINITY;
        public InitialWeightDistribution _initial_weight_distribution = InitialWeightDistribution.UniformAdaptive;
        public double _initial_weight_scale = 1.0;
        public Loss _loss = Loss.Automatic;
        public double _score_interval = 5.0;
        public long _score_training_samples = 10000L;
        public long _score_validation_samples = 0L;
        public double _score_duty_cycle = 0.1;
        public double _classification_stop = 0.0;
        public double _regression_stop = 1.0E-6;
        public boolean _quiet_mode = false;
        public int _max_confusion_matrix_size = 20;
        public int _max_hit_ratio_k = 10;
        public boolean _balance_classes = false;
        public float[] _class_sampling_factors;
        public float _max_after_balance_size = 5.0f;
        public ClassSamplingMethod _score_validation_sampling = ClassSamplingMethod.Uniform;
        public boolean _diagnostics = true;
        public boolean _variable_importances = false;
        public boolean _fast_mode = true;
        public boolean _ignore_const_cols = true;
        public boolean _force_load_balance = true;
        public boolean _replicate_training_data = true;
        public boolean _single_node_mode = false;
        public boolean _shuffle_training_data = false;
        public MissingValuesHandling _missing_values_handling = MissingValuesHandling.MeanImputation;
        public boolean _sparse = false;
        public boolean _col_major = false;
        public double _average_activation = 0.0;
        public double _sparsity_beta = 0.0;
        public int _max_categorical_features = Integer.MAX_VALUE;
        public boolean _reproducible = false;

        void validate(DeepLearning dl) {
            boolean classification = dl.isClassifier();
            if (this._hidden == null || this._hidden.length == 0) {
                dl.error("_hidden", "There must be at least one hidden layer.");
            }
            for (int i = 0; i < this._hidden.length; ++i) {
                if (this._hidden[i] != 0) continue;
                dl.error("_hidden", "Hidden layer size must be >0.");
            }
            if (this._valid == null) {
                dl.hide("_score_validation_samples", "score_validation_samples requires a validation frame.");
            }
            if (classification) {
                dl.hide("_regression_stop", "regression_stop is used only with regression.");
            } else {
                dl.hide("_classification_stop", "classification_stop is used only with classification.");
                dl.hide("_max_confusion_matrix_size", "max_confusion_matrix_size is used only with classification.");
                dl.hide("_max_hit_ratio_k", "max_hit_ratio_k is used only with classification.");
                dl.hide("_balance_classes", "balance_classes is used only with classification.");
            }
            if (!classification || !this._balance_classes) {
                dl.hide("_class_sampling_factors", "class_sampling_factors requires both classification and balance_classes.");
            }
            if (classification && !this._balance_classes || !classification) {
                dl.hide("_max_after_balance_size", "max_after_balance_size required regression OR classification with balance_classes.");
            }
            if (!classification && this._valid != null || this._valid == null) {
                dl.hide("_score_validation_sampling", "score_validation_sampling requires regression and a validation frame OR no validation frame.");
            }
            if (this._activation != Activation.TanhWithDropout && this._activation != Activation.MaxoutWithDropout && this._activation != Activation.RectifierWithDropout) {
                dl.hide("_hidden_dropout_ratios", "hidden_dropout_ratios requires a dropout activation function.");
            }
            if (this._hidden_dropout_ratios == null) {
                if (this._activation == Activation.TanhWithDropout || this._activation == Activation.MaxoutWithDropout || this._activation == Activation.RectifierWithDropout) {
                    this._hidden_dropout_ratios = new double[this._hidden.length];
                    if (!this._quiet_mode) {
                        dl.info("_hidden_dropout_ratios", "Automatically setting all hidden dropout ratios to 0.5.");
                    }
                    Arrays.fill(this._hidden_dropout_ratios, 0.5);
                }
            } else if (this._hidden_dropout_ratios.length != this._hidden.length) {
                dl.error("_hidden_dropout_ratios", "Must have " + this._hidden.length + " hidden layer dropout ratios.");
            } else if (this._activation != Activation.TanhWithDropout && this._activation != Activation.MaxoutWithDropout && this._activation != Activation.RectifierWithDropout && !this._quiet_mode) {
                dl.warn("_hidden_dropout_ratios", "Ignoring hidden_dropout_ratios because a non-dropout activation function was specified.");
            }
            if (this._input_dropout_ratio < 0.0 || this._input_dropout_ratio >= 1.0) {
                dl.error("_input_dropout_ratio", "Input dropout must be in [0,1).");
            }
            if (H2O.CLOUD.size() == 1 && this._replicate_training_data) {
                dl.hide("_replicate_training_data", "replicate_training_data is only valid with cloud size greater than 1.");
                dl.info("_replicate_training_data", "Disabling replicate_training_data on 1 node.");
                this._replicate_training_data = false;
            }
            if (this._single_node_mode && (H2O.CLOUD.size() == 1 || !this._replicate_training_data)) {
                dl.hide("_single_node_mode", "single_node_mode is only used with multi-node operation with replicated training data.");
                dl.info("_single_node_mode", "Disabling single_node_mode (only for multi-node operation with replicated training data).");
                this._single_node_mode = false;
            }
            if (this._autoencoder) {
                dl.hide("_use_all_factor_levels", "use_all_factor_levels is unsupported in combination with autoencoder.");
            }
            if (!this._use_all_factor_levels && this._autoencoder) {
                dl.warn("_use_all_factor_levels", "Enabling all_factor_levels for auto-encoders.");
                this._use_all_factor_levels = true;
            }
            if (this._n_folds != 0) {
                dl.hide("_override_with_best_model", "override_with_best_model is unsupported in combination with n-fold cross-validation.");
            }
            if (this._override_with_best_model && this._n_folds != 0) {
                dl.warn("_override_with_best_model", "Disabling override_with_best_model in combination with n-fold cross-validation.");
                this._override_with_best_model = false;
            }
            if (this._adaptive_rate) {
                dl.hide("_rate", "rate is not used with adaptive_rate.");
                dl.hide("_rate_annealing", "rate_annealing is not used with adaptive_rate.");
                dl.hide("_rate_decay", "rate_decay is not used with adaptive_rate.");
                dl.hide("_momentum_start", "momentum_start is not used with adaptive_rate.");
                dl.hide("_momentum_ramp", "momentum_ramp is not used with adaptive_rate.");
                dl.hide("_momentum_stable", "momentum_stable is not used with adaptive_rate.");
                dl.hide("_nesterov_accelerated_gradient", "nesterov_accelerated_gradient is not used with adaptive_rate.");
            } else {
                dl.hide("_rho", "rho is only used with adaptive_rate.");
                dl.hide("_epsilon", "epsilon is only used with adaptive_rate.");
            }
            if (!this._quiet_mode) {
                if (this._adaptive_rate) {
                    dl.info("_adaptive_rate", "Using automatic learning rate.  Ignoring the following input parameters: rate, rate_decay, rate_annealing, momentum_start, momentum_ramp, momentum_stable, nesterov_accelerated_gradient.");
                    this._momentum_start = 0.0;
                    this._momentum_stable = 0.0;
                } else {
                    dl.info("_adaptive_rate", "Using manual learning rate.  Ignoring the following input parameters: rho, epsilon.");
                    this._rho = 0.0;
                    this._epsilon = 0.0;
                }
                if (this._initial_weight_distribution == InitialWeightDistribution.UniformAdaptive) {
                    dl.hide("_initial_weight_scale", "initial_weight_scale is not used if initial_weight_distribution == UniformAdaptive.");
                    dl.info("_initial_weight_scale", "Ignoring initial_weight_scale for UniformAdaptive weight distribution.");
                }
                if (this._n_folds != 0 && this._override_with_best_model) {
                    dl.warn("_override_with_best_model", "Automatically disabling override_with_best_model, since the final model is the only scored model with n-fold cross-validation.");
                    this._override_with_best_model = false;
                }
            }
            if (this._loss == Loss.Automatic) {
                if (!classification) {
                    if (!this._quiet_mode) {
                        dl.info("_loss", "Automatically setting loss to MeanSquare for regression.");
                    }
                    this._loss = Loss.MeanSquare;
                } else if (this._autoencoder) {
                    if (!this._quiet_mode) {
                        dl.info("_loss", "Automatically setting loss to MeanSquare for auto-encoder.");
                    }
                    this._loss = Loss.MeanSquare;
                } else {
                    if (!this._quiet_mode) {
                        dl.info("_loss", "Automatically setting loss to Cross-Entropy for classification.");
                    }
                    this._loss = Loss.CrossEntropy;
                }
            }
            if (this._autoencoder && this._sparsity_beta > 0.0) {
                if (this._activation == Activation.Tanh || this._activation == Activation.TanhWithDropout) {
                    if (this._average_activation >= 1.0 || this._average_activation <= -1.0) {
                        dl.error("_average_activation", "Tanh average activation must be in (-1,1).");
                    }
                } else if ((this._activation == Activation.Rectifier || this._activation == Activation.RectifierWithDropout) && this._average_activation <= 0.0) {
                    dl.error("_average_activation", "Rectifier average activation must be positive.");
                }
            }
            if (!classification && this._loss == Loss.CrossEntropy) {
                dl.error("_loss", "Cannot use CrossEntropy loss function for regression.");
            }
            if (this._autoencoder && this._loss != Loss.MeanSquare) {
                dl.error("_loss", "Must use MeanSquare loss function for auto-encoder.");
            }
            if (this._autoencoder && classification) {
                dl.error("_classification", "Can only use regression mode for auto-encoder.");
            }
            if (!this._autoencoder && this._sparsity_beta != 0.0) {
                dl.info("_sparsity_beta", "Sparsity beta can only be used for autoencoder.");
            }
            if (this._autoencoder && this._valid != null) {
                dl.error("_validation_frame", "Cannot specify a validation dataset for auto-encoder.");
            }
            if (this._autoencoder && this._activation == Activation.Maxout) {
                dl.error("_activation", "Maxout activation is not supported for auto-encoder.");
            }
            if (this._max_categorical_features < 1) {
                dl.error("_max_categorical_features", "max_categorical_features must be at least 1.");
            }
            if (!this._sparse && this._col_major && !this._quiet_mode) {
                dl.error("_col_major", "Cannot use column major storage for non-sparse data handling.");
            }
            if (!classification && this._balance_classes) {
                dl.error("_balance_classes", "balance_classes requires classification to be enabled.");
            }
            if (this._class_sampling_factors != null && !this._balance_classes) {
                dl.error("_class_sampling_factors", "class_sampling_factors requires balance_classes to be enabled.");
            }
            if (this._reproducible) {
                if (!this._quiet_mode) {
                    Log.info((Object[])new Object[]{"Automatically enabling force_load_balancing, disabling single_node_mode and replicate_training_data\nand setting train_samples_per_iteration to -1 to enforce reproducibility."});
                }
                this._force_load_balance = true;
                this._single_node_mode = false;
                this._train_samples_per_iteration = -1L;
                this._replicate_training_data = false;
            }
        }

        public static enum Loss {
            Automatic,
            MeanSquare,
            CrossEntropy;

        }

        public static enum Activation {
            Tanh,
            TanhWithDropout,
            Rectifier,
            RectifierWithDropout,
            Maxout,
            MaxoutWithDropout;

        }

        public static enum InitialWeightDistribution {
            UniformAdaptive,
            Uniform,
            Normal;

        }

        public static enum ClassSamplingMethod {
            Uniform,
            Stratified;

        }

        public static enum MissingValuesHandling {
            Skip,
            MeanImputation;

        }
    }
}

