/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import hex.schemas.ModelBuilderSchema;
import water.api.API;
import water.api.ModelParametersSchema;
import water.fvec.Frame;
import water.util.PojoUtils;

public class KMeansV2
extends ModelBuilderSchema<KMeans, KMeansV2, KMeansParametersV2> {
    protected String acceptsFrame(Frame fr) {
        return "/v2/KMeans?training_frame=" + fr._key;
    }

    public static final class KMeansParametersV2
    extends ModelParametersSchema<KMeansModel.KMeansParameters, KMeansParametersV2> {
        public static String[] own_fields = new String[]{"K", "max_iters", "normalize", "seed", "init"};
        @API(help="Number of clusters", required=true)
        public int K;
        @API(help="Maximum training iterations.")
        public int max_iters;
        @API(help="Normalize columns", level=API.Level.secondary)
        public boolean normalize = true;
        @API(help="RNG Seed", level=API.Level.expert)
        public long seed;
        @API(help="Initialization mode", values={"None", "PlusPlus", "Furthest"})
        public KMeans.Initialization init;

        public KMeansParametersV2 fillFromImpl(KMeansModel.KMeansParameters parms) {
            super.fillFromImpl((Model.Parameters)parms);
            this.init = KMeans.Initialization.Furthest;
            return this;
        }

        public KMeansModel.KMeansParameters fillImpl(KMeansModel.KMeansParameters impl) {
            PojoUtils.copyProperties((Object)((Object)impl), (Object)((Object)this), (PojoUtils.FieldNaming)PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES);
            impl._init = KMeans.Initialization.Furthest;
            impl._train = this.training_frame == null ? null : this.training_frame._key;
            impl._valid = this.validation_frame == null ? null : this.validation_frame._key;
            return impl;
        }
    }
}

