/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.CompressedTree;
import hex.tree.DHistogram;
import hex.tree.SharedTreeModel;
import hex.tree.TreeVisitor;
import java.util.Arrays;
import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.fvec.Chunk;
import water.util.IcedBitSet;
import water.util.Log;
import water.util.MathUtils;
import water.util.SB;

public class DTree
extends Iced {
    final String[] _names;
    final int _ncols;
    final char _nbins;
    final char _nclass;
    final int _min_rows;
    final long _seed;
    private Node[] _ns;
    public int _len;
    public int _leaves;
    public int _depth;
    private static final SB TO_JAVA_BENCH_FUNC = new SB().nl().p("  /**").nl().p("   * Run a predict() benchmark with the generated model and some synthetic test data.").nl().p("   *").nl().p("   * @param iters number of iterations to run; each iteration predicts on every sample (i.e. row) in the test data").nl().p("   * @param data test data to predict on").nl().p("   * @param preds output predictions").nl().p("   * @param ntrees number of trees").nl().p("   */").nl().p("  public void bench(int iters, double[][] data, float[] preds, int ntrees) {").nl().p("    System.out.println(\"Iterations: \" + iters);").nl().p("    System.out.println(\"Data rows : \" + data.length);").nl().p("    System.out.println(\"Trees     : \" + ntrees + \"x\" + (preds.length-1));").nl().nl().p("    long startMillis;").nl().p("    long endMillis;").nl().p("    long deltaMillis;").nl().p("    double deltaSeconds;").nl().p("    double samplesPredicted;").nl().p("    double samplesPredictedPerSecond;").nl().p("    System.out.println(\"Starting timing phase of \"+iters+\" iterations...\");").nl().nl().p("    startMillis = System.currentTimeMillis();").nl().p("    for (int i=0; i<iters; i++) {").nl().p("      // Uncomment the nanoTime logic for per-iteration prediction times.").nl().p("      // long startTime = System.nanoTime();").nl().nl().p("      for (double[] row : data) {").nl().p("        predict(row, preds);").nl().p("        // System.out.println(java.util.Arrays.toString(preds) + \" : \" + (DOMAINS[DOMAINS.length-1]!=null?(DOMAINS[DOMAINS.length-1][(int)preds[0]]+\"~\"+DOMAINS[DOMAINS.length-1][(int)row[row.length-1]]):(preds[0] + \" ~ \" + row[row.length-1])) );").nl().p("      }").nl().nl().p("      // long ttime = System.nanoTime()-startTime;").nl().p("      // System.out.println(i+\". iteration took \" + (ttime) + \"ns: scoring time per row: \" + ttime/data.length +\"ns, scoring time per row and tree: \" + ttime/data.length/ntrees + \"ns\");").nl().nl().p("      if ((i % 1000) == 0) {").nl().p("        System.out.println(\"finished \"+i+\" iterations (of \"+iters+\")...\");").nl().p("      }").nl().p("    }").nl().p("    endMillis = System.currentTimeMillis();").nl().nl().p("    deltaMillis = endMillis - startMillis;").nl().p("    deltaSeconds = (double)deltaMillis / 1000.0;").nl().p("    samplesPredicted = data.length * iters;").nl().p("    samplesPredictedPerSecond = samplesPredicted / deltaSeconds;").nl().p("    System.out.println(\"finished in \"+deltaSeconds+\" seconds.\");").nl().p("    System.out.println(\"samplesPredicted: \" + samplesPredicted);").nl().p("    System.out.println(\"samplesPredictedPerSecond: \" + samplesPredictedPerSecond);").nl().p("  }").nl().nl();

    public DTree(String[] names, int ncols, char nbins, char nclass, int min_rows) {
        this(names, ncols, nbins, nclass, min_rows, -1L);
    }

    public DTree(String[] names, int ncols, char nbins, char nclass, int min_rows, long seed) {
        this._names = names;
        this._ncols = ncols;
        this._nbins = nbins;
        this._nclass = nclass;
        this._min_rows = min_rows;
        this._ns = new Node[1];
        this._seed = seed;
    }

    public final Node root() {
        return this._ns[0];
    }

    void init_tree() {
        for (int j = 0; j < this._len; ++j) {
            this._ns[j]._tree = this;
        }
    }

    public final Node node(int i) {
        if (i >= this._len) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this._ns[i];
    }

    public final UndecidedNode undecided(int i) {
        return (UndecidedNode)this.node(i);
    }

    public final DecidedNode decided(int i) {
        return (DecidedNode)this.node(i);
    }

    private synchronized int newIdx(Node n) {
        if (this._len == this._ns.length) {
            this._ns = Arrays.copyOf(this._ns, this._len << 1);
        }
        this._ns[this._len] = n;
        return this._len++;
    }

    public final int len() {
        return this._len;
    }

    public static boolean isRootNode(Node n) {
        return n._pid == -1;
    }

    public CompressedTree compress(int tid, int cls) {
        int sz = this.root().size();
        if (this.root() instanceof LeafNode) {
            sz += 3;
        }
        AutoBuffer ab = new AutoBuffer(sz);
        if (this.root() instanceof LeafNode) {
            ab.put1(0).put2('\uffff');
        }
        this.root().compress(ab);
        assert (ab.position() == sz);
        return new CompressedTree(ab.buf(), this._nclass, this._seed, tid, cls);
    }

    static class TreeJCodeGen
    extends TreeVisitor<RuntimeException> {
        public static final int MAX_NODES = 1024;
        final byte[] _bits = new byte[100];
        final float[] _fs = new float[100];
        final SB[] _sbs = new SB[100];
        final int[] _nodesCnt = new int[100];
        SB _sb;
        SB _csb;
        SB _grpsplit;
        int _subtrees = 0;
        int _grpcnt = 0;

        public TreeJCodeGen(SharedTreeModel tm, CompressedTree ct, SB sb) {
            super(tm, ct);
            this._sb = sb;
            this._csb = new SB();
            this._grpsplit = new SB();
        }

        protected void preamble(SB sb, int subtree) throws RuntimeException {
            String subt = subtree > 0 ? String.valueOf(subtree) : "";
            sb.i().p("static final ").p("float").p(" predict").p(subt).p("(double[] data) {").nl().ii(1);
            sb.i().p("float").p(" pred = ");
        }

        protected void closure(SB sb) throws RuntimeException {
            sb.p(";").nl();
            sb.i(1).p("return pred;").nl().di(1);
            sb.i().p("}").nl();
        }

        @Override
        protected void pre(int col, float fcmp, IcedBitSet gcmp, int equal) {
            if (equal == 2 || equal == 3 && gcmp != null) {
                this._grpsplit.i(1).p("// ").p(gcmp.toString()).nl();
                this._grpsplit.i(1).p("public static final byte[] GRPSPLIT").p(this._grpcnt).p(" = new byte[] ").p(gcmp.toStrArray()).p(";").nl();
            }
            if (this._depth > 0) {
                byte b = this._bits[this._depth - 1];
                assert (b > 0) : Arrays.toString(this._bits) + "\n" + this._sb.toString();
                if (b == 1) {
                    this._bits[this._depth - 1] = 3;
                }
                if (b == 1 || b == 2) {
                    this._sb.p('\n').i(this._depth).p("?");
                }
                if (b == 2) {
                    this._sb.p(' ').pj(this._fs[this._depth - 1]);
                }
                if (b == 2 || b == 3) {
                    this._sb.p('\n').i(this._depth).p(":");
                }
            }
            if (this._nodes > 1024) {
                this._sb.p("predict").p(this._subtrees).p("(data)");
                this._nodesCnt[this._depth] = this._nodes;
                this._sbs[this._depth] = this._sb;
                this._sb = new SB();
                this._nodes = 0;
                this.preamble(this._sb, this._subtrees);
                ++this._subtrees;
            }
            this._sb.p(" (Double.isNaN(data[").p(col).p("]) || ");
            if (equal != 0 && equal != 1) {
                ++this._grpcnt;
                throw H2O.unimpl();
            }
            String scmp = this._tm.isFromSpeeDRF() ? "<= " : "< ";
            this._sb.p("(float) data[").p(col).p(" /* ").p(this._tm._output._names[col]).p(" */").p("] ").p(equal == 1 ? "!= " : scmp).pj(fcmp);
            assert (this._bits[this._depth] == 0);
            this._bits[this._depth] = 1;
        }

        @Override
        protected void leaf(float pred) {
            assert (this._depth == 0 || this._bits[this._depth - 1] > 0) : Arrays.toString(this._bits);
            if (this._depth == 0) {
                this._sb.pj(pred);
            } else if (this._bits[this._depth - 1] == 1) {
                this._bits[this._depth - 1] = 2;
                this._fs[this._depth - 1] = pred;
            } else {
                if (this._bits[this._depth - 1] == 2) {
                    this._sb.p(" ? ").pj(this._fs[this._depth - 1]).p(" ");
                } else {
                    this._sb.p('\n').i(this._depth);
                }
                this._sb.p(": ").pj(pred);
            }
        }

        @Override
        protected void post(int col, float fcmp, int equal) {
            this._sb.p(')');
            this._bits[this._depth] = 0;
            if (this._sbs[this._depth] != null) {
                this.closure(this._sb);
                this._csb.p(this._sb);
                this._sb = this._sbs[this._depth];
                this._nodes = this._nodesCnt[this._depth];
                this._sbs[this._depth] = null;
            }
        }

        public void generate() {
            this.preamble(this._sb, this._subtrees++);
            this.visit();
            this.closure(this._sb);
            this._sb.p(this._grpsplit).di(1);
            this._sb.p(this._csb);
        }
    }

    public static abstract class LeafNode
    extends Node {
        public double _pred;

        public LeafNode(DTree tree, int pid) {
            super(tree, pid);
        }

        public LeafNode(DTree tree, int pid, int nid) {
            super(tree, pid, nid);
        }

        public String toString() {
            return "Leaf#" + this._nid + " = " + this._pred;
        }

        @Override
        public final StringBuilder toString2(StringBuilder sb, int depth) {
            for (int d = 0; d < depth; ++d) {
                sb.append("  ");
            }
            sb.append(this._nid).append(" ");
            return sb.append("pred=").append(this._pred).append("\n");
        }
    }

    public static abstract class DecidedNode
    extends Node {
        public final Split _split;
        public final float _splat;
        public final int[] _nids = new int[2];
        transient byte _nodeType;
        transient int _size = 0;

        public abstract UndecidedNode makeUndecidedNode(DHistogram[] var1);

        public abstract Split bestCol(UndecidedNode var1, DHistogram[] var2);

        public DecidedNode(UndecidedNode n, DHistogram[] hs) {
            super(n._tree, n._pid, n._nid);
            this._split = this.bestCol(n, hs);
            if (this._split._col == -1) {
                this._splat = Float.NaN;
                Arrays.fill(this._nids, -1);
                return;
            }
            this._splat = this._split._equal == 0 || this._split._equal == 1 ? this._split.splat(hs) : -1.0f;
            char nbins = this._tree._nbins;
            int min_rows = this._tree._min_rows;
            for (int b = 0; b < 2; ++b) {
                DHistogram[] nhists = this._split.split(b, nbins, min_rows, hs, this._splat);
                assert (nhists == null || nhists.length == this._tree._ncols);
                this._nids[b] = nhists == null ? -1 : this.makeUndecidedNode((DHistogram[])nhists)._nid;
            }
        }

        public int bin(Chunk[] chks, int row) {
            float d = (float)chks[this._split._col].at0(row);
            if (Float.isNaN(d)) {
                return 0;
            }
            if (this._split._equal == 0) {
                return d < this._splat ? 0 : 1;
            }
            if (this._split._equal == 1) {
                return d != this._splat ? 0 : 1;
            }
            return this._split._bs.contains((int)d) ? 1 : 0;
        }

        public int ns(Chunk[] chks, int row) {
            return this._nids[this.bin(chks, row)];
        }

        public String toString() {
            if (this._split._col == -1) {
                return "Decided has col = -1";
            }
            int col = this._split._col;
            if (this._split._equal == 1) {
                return this._tree._names[col] + " != " + this._splat + "\n" + this._tree._names[col] + " == " + this._splat + "\n";
            }
            if (this._split._equal == 2 || this._split._equal == 3) {
                return this._tree._names[col] + " != " + this._split._bs.toString() + "\n" + this._tree._names[col] + " == " + this._split._bs.toString() + "\n";
            }
            return this._tree._names[col] + " < " + this._splat + "\n" + this._splat + " <=" + this._tree._names[col] + "\n";
        }

        StringBuilder printChild(StringBuilder sb, int nid) {
            int i;
            int n = i = this._nids[0] == nid ? 0 : 1;
            assert (this._nids[i] == nid) : "No child nid " + nid + "? " + Arrays.toString(this._nids);
            sb.append("[").append(this._tree._names[this._split._col]);
            sb.append(this._split._equal != 0 ? (i == 0 ? " != " : " == ") : (i == 0 ? " <  " : " >= "));
            sb.append(this._split._equal == 2 || this._split._equal == 3 ? this._split._bs.toString() : Float.valueOf(this._splat)).append("]");
            return sb;
        }

        @Override
        public StringBuilder toString2(StringBuilder sb, int depth) {
            for (int i = 0; i < this._nids.length; ++i) {
                for (int d = 0; d < depth; ++d) {
                    sb.append("  ");
                }
                sb.append(this._nid).append(" ");
                if (this._split._col < 0) {
                    sb.append("init");
                } else {
                    sb.append(this._tree._names[this._split._col]);
                    sb.append(this._split._equal != 0 ? (i == 0 ? " != " : " == ") : (i == 0 ? " <  " : " >= "));
                    sb.append(this._split._equal == 2 || this._split._equal == 3 ? this._split._bs.toString() : Float.valueOf(this._splat)).append("\n");
                }
                if (this._nids[i] < 0 || this._nids[i] >= this._tree._len) continue;
                this._tree.node(this._nids[i]).toString2(sb, depth + 1);
            }
            return sb;
        }

        @Override
        public final int size() {
            if (this._size != 0) {
                return this._size;
            }
            assert (this._nodeType == 0) : "unexpected node type: " + this._nodeType;
            if (this._split._equal != 0) {
                this._nodeType = (byte)(this._nodeType | (this._split._equal == 1 ? 4 : (this._split._equal == 2 ? 8 : 12)));
            }
            int res = this._split._equal == 3 ? 7 + this._split._bs.numBytes() : 7;
            Node left = this._tree.node(this._nids[0]);
            int lsz = left.size();
            res += lsz;
            if (left instanceof LeafNode) {
                this._nodeType = (byte)(this._nodeType | 0x30);
            } else {
                int slen = lsz < 256 ? 0 : (lsz < 65535 ? 1 : (lsz < 0x1000000 ? 2 : 3));
                this._nodeType = (byte)(this._nodeType | slen);
                res += slen + 1;
            }
            Node rite = this._tree.node(this._nids[1]);
            if (rite instanceof LeafNode) {
                this._nodeType = (byte)(this._nodeType | 0xFFFFFFC0);
            }
            res += rite.size();
            assert ((this._nodeType & 0x33) != 51);
            assert (res != 0);
            this._size = res;
            return this._size;
        }

        @Override
        public AutoBuffer compress(AutoBuffer ab) {
            int pos = ab.position();
            if (this._nodeType == 0) {
                this.size();
            }
            ab.put1((int)this._nodeType);
            assert (this._split._col != -1);
            ab.put2((short)this._split._col);
            if (this._split._equal != 0 && this._split._equal != 1) {
                if (this._split._equal == 2) {
                    throw H2O.unimpl();
                }
                assert (this._split._equal == 3);
                throw H2O.unimpl();
            }
            ab.put4f(this._splat);
            Node left = this._tree.node(this._nids[0]);
            if ((this._nodeType & 0x30) == 0) {
                int sz = left.size();
                if (sz < 256) {
                    ab.put1(sz);
                } else if (sz < 65535) {
                    ab.put2((short)sz);
                } else if (sz < 0x1000000) {
                    ab.put3(sz);
                } else {
                    ab.put4(sz);
                }
            }
            left.compress(ab);
            Node rite = this._tree.node(this._nids[1]);
            rite.compress(ab);
            assert (this._size == ab.position() - pos) : "reported size = " + this._size + " , real size = " + (ab.position() - pos);
            return ab;
        }
    }

    public static abstract class UndecidedNode
    extends Node {
        public transient DHistogram[] _hs;
        public final int[] _scoreCols;

        public UndecidedNode(DTree tree, int pid, DHistogram[] hs) {
            super(tree, pid);
            assert (hs.length == tree._ncols);
            this._hs = hs;
            this._scoreCols = this.scoreCols(hs);
        }

        public abstract int[] scoreCols(DHistogram[] var1);

        public void do_not_split() {
            if (this._pid == -1) {
                return;
            }
            DecidedNode dn = this._tree.decided(this._pid);
            for (int i = 0; i < dn._nids.length; ++i) {
                if (dn._nids[i] != this._nid) continue;
                dn._nids[i] = -1;
                return;
            }
            throw H2O.fail();
        }

        public String toString() {
            String colPad = "  ";
            int cntW = 4;
            int mmmW = 4;
            int menW = 5;
            int varW = 5;
            int colW = 26;
            StringBuilder sb = new StringBuilder();
            sb.append("Nid# ").append(this._nid).append(", ");
            this.printLine(sb).append("\n");
            if (this._hs == null) {
                return sb.append("_hs==null").toString();
            }
            int ncols = this._hs.length;
            for (DHistogram hs : this._hs) {
                if (hs == null) continue;
                UndecidedNode.p(sb, hs._name + String.format(", %4.1f-%4.1f", Float.valueOf(hs._min), Float.valueOf(hs._maxEx)), 26).append("  ");
            }
            sb.append('\n');
            for (DHistogram hs : this._hs) {
                if (hs == null) continue;
                UndecidedNode.p(sb, "cnt", 4).append('/');
                UndecidedNode.p(sb, "min", 4).append('/');
                UndecidedNode.p(sb, "max", 4).append('/');
                UndecidedNode.p(sb, "mean", 5).append('/');
                UndecidedNode.p(sb, "var", 5).append("  ");
            }
            sb.append('\n');
            int nbins = 0;
            for (int j = 0; j < ncols; ++j) {
                if (this._hs[j] == null || this._hs[j].nbins() <= nbins) continue;
                nbins = this._hs[j].nbins();
            }
            for (int i = 0; i < nbins; ++i) {
                for (int j = 0; j < ncols; ++j) {
                    DHistogram h = this._hs[j];
                    if (h == null) continue;
                    if (i < h.nbins() && h._bins != null) {
                        UndecidedNode.p(sb, h.bins(i), 4).append('/');
                        UndecidedNode.p(sb, h.binAt(i), 4).append('/');
                        UndecidedNode.p(sb, h.binAt(i + 1), 4).append('/');
                        UndecidedNode.p(sb, h.mean(i), 5).append('/');
                        UndecidedNode.p(sb, h.var(i), 5).append("  ");
                        continue;
                    }
                    UndecidedNode.p(sb, "", 26).append("  ");
                }
                sb.append('\n');
            }
            sb.append("Nid# ").append(this._nid);
            return sb.toString();
        }

        private static StringBuilder p(StringBuilder sb, String s, int w) {
            return sb.append(Log.fixedLength((String)s, (int)w));
        }

        private static StringBuilder p(StringBuilder sb, long l, int w) {
            return UndecidedNode.p(sb, Long.toString(l), w);
        }

        private static StringBuilder p(StringBuilder sb, double d, int w) {
            String s;
            String string = Double.isNaN(d) ? "NaN" : (d == 3.4028234663852886E38 || d == -3.4028234663852886E38 || d == Double.MAX_VALUE || d == -1.7976931348623157E308 ? " -" : (s = d == 0.0 ? " 0" : Double.toString(d)));
            if (s.length() <= w) {
                return UndecidedNode.p(sb, s, w);
            }
            s = String.format("% 4.2f", d);
            if (s.length() > w) {
                s = String.format("%4.1f", d);
            }
            if (s.length() > w) {
                s = String.format("%4.0f", d);
            }
            return UndecidedNode.p(sb, s, w);
        }

        @Override
        public StringBuilder toString2(StringBuilder sb, int depth) {
            for (int d = 0; d < depth; ++d) {
                sb.append("  ");
            }
            return sb.append("Undecided\n");
        }

        @Override
        protected AutoBuffer compress(AutoBuffer ab) {
            throw H2O.fail();
        }

        @Override
        protected int size() {
            throw H2O.fail();
        }
    }

    public static class Split
    extends Iced {
        public final int _col;
        public final int _bin;
        final IcedBitSet _bs;
        final byte _equal;
        final double _se0;
        final double _se1;
        final long _n0;
        final long _n1;
        final double _p0;
        final double _p1;

        public Split(int col, int bin, IcedBitSet bs, byte equal, double se0, double se1, long n0, long n1, double p0, double p1) {
            this._col = col;
            this._bin = bin;
            this._bs = bs;
            this._equal = equal;
            this._n0 = n0;
            this._n1 = n1;
            this._se0 = se0;
            this._se1 = se1;
            this._p0 = p0;
            this._p1 = p1;
        }

        public final double se() {
            return this._se0 + this._se1;
        }

        public final int col() {
            return this._col;
        }

        public final int bin() {
            return this._bin;
        }

        float splat(DHistogram[] hs) {
            int n;
            int x;
            DHistogram h = hs[this._col];
            assert (this._bin > 0 && this._bin < h.nbins());
            if (this._equal == 1) {
                assert (h.bins(this._bin) != 0);
                return h.binAt(this._bin);
            }
            for (x = this._bin - 1; x >= 0 && h.bins(x) == 0; --x) {
            }
            for (n = this._bin; n < h.nbins() && h.bins(n) == 0; ++n) {
            }
            float lo = h.binAt(x + 1);
            float hi = h.binAt(n);
            if (h._isInt > 0) {
                float f = lo = h._step == 1.0f ? lo - 1.0f : (float)Math.floor(lo);
            }
            if (h._isInt > 0) {
                hi = h._step == 1.0f ? hi : (float)Math.ceil(hi);
            }
            return (lo + hi) / 2.0f;
        }

        public DHistogram[] split(int way, char nbins, int min_rows, DHistogram[] hs, float splat) {
            double se;
            long n;
            long l = n = way == 0 ? this._n0 : this._n1;
            if (n < (long)min_rows || n <= 1L) {
                return null;
            }
            double d = se = way == 0 ? this._se0 : this._se1;
            if (se <= 1.0E-30) {
                return null;
            }
            int cnt = 0;
            DHistogram[] nhists = new DHistogram[hs.length];
            for (int j = 0; j < hs.length; ++j) {
                float maxEx;
                float min;
                DHistogram h = hs[j];
                if (h == null) continue;
                int adj_nbins = Math.max(h.nbins() >> 1, nbins);
                if (h._bins == null) {
                    min = h._min;
                    maxEx = h._maxEx;
                } else {
                    min = h.find_min();
                    if (h.find_maxIn() == min) continue;
                    maxEx = h.find_maxEx();
                }
                if (this._col == j) {
                    if (this._equal != 0) {
                        if (way == 1) {
                            continue;
                        }
                    } else {
                        if (h._bins[this._bin] == 0) {
                            throw H2O.unimpl();
                        }
                        float split = splat;
                        if (h._isInt > 0) {
                            split = (float)Math.ceil(split);
                        }
                        if (way == 0) {
                            maxEx = split;
                        } else {
                            min = split;
                        }
                    }
                }
                if (MathUtils.equalsWithinOneSmallUlp((float)min, (float)maxEx) || h._isInt > 0 && !(min + 1.0f < maxEx) || min > maxEx) continue;
                assert (min < maxEx && n > 1L) : "" + min + "<" + maxEx + " n=" + n;
                nhists[j] = DHistogram.make(h._name, adj_nbins, h._isInt, min, maxEx, n, h._doGrpSplit, h.isBinom());
                ++cnt;
            }
            return cnt == 0 ? null : nhists;
        }

        public static StringBuilder ary2str(StringBuilder sb, int w, long[] xs) {
            sb.append('[');
            for (long x : xs) {
                UndecidedNode.p(sb, x, w).append(",");
            }
            return sb.append(']');
        }

        public static StringBuilder ary2str(StringBuilder sb, int w, float[] xs) {
            sb.append('[');
            for (float x : xs) {
                UndecidedNode.p(sb, x, w).append(",");
            }
            return sb.append(']');
        }

        public static StringBuilder ary2str(StringBuilder sb, int w, double[] xs) {
            sb.append('[');
            for (double x : xs) {
                UndecidedNode.p(sb, (float)x, w).append(",");
            }
            return sb.append(']');
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append(this._col).append("/");
            UndecidedNode.p(sb, this._bin, 2);
            sb.append(", se0=").append(this._se0);
            sb.append(", se1=").append(this._se1);
            sb.append(", n0=").append(this._n0);
            sb.append(", n1=").append(this._n1);
            return sb.append("}").toString();
        }
    }

    public static abstract class Node
    extends Iced {
        protected transient DTree _tree;
        public final int _pid;
        protected final int _nid;

        Node(DTree tree, int pid, int nid) {
            this._tree = tree;
            this._pid = pid;
            this._nid = nid;
            ((DTree)tree)._ns[this._nid] = this;
        }

        Node(DTree tree, int pid) {
            this._tree = tree;
            this._pid = pid;
            this._nid = tree.newIdx(this);
        }

        StringBuilder printLine(StringBuilder sb) {
            if (this._pid == -1) {
                return sb.append("[root]");
            }
            DecidedNode parent = this._tree.decided(this._pid);
            parent.printLine(sb).append(" to ");
            return parent.printChild(sb, this._nid);
        }

        public abstract StringBuilder toString2(StringBuilder var1, int var2);

        protected abstract AutoBuffer compress(AutoBuffer var1);

        protected abstract int size();

        public final int nid() {
            return this._nid;
        }
    }
}

