/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.SupervisedModelBuilder;
import hex.VarImp;
import hex.tree.DHistogram;
import hex.tree.DTree;
import hex.tree.Score;
import hex.tree.ScoreBuildHistogram;
import hex.tree.SharedTreeModel;
import java.util.Arrays;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.Scope;
import water.Value;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MRUtils;
import water.util.ModelUtils;
import water.util.Timer;

public abstract class SharedTree<M extends SharedTreeModel<M, P, O>, P extends SharedTreeModel.SharedTreeParameters, O extends SharedTreeModel.SharedTreeOutput>
extends SupervisedModelBuilder<M, P, O> {
    protected int _ntrees;
    protected M _model;
    protected int _ncols;
    protected double _initialPrediction;
    transient long _timeLastScoreStart;
    transient long _timeLastScoreEnd;
    transient long _firstScore;

    public SharedTree(String name, P parms) {
        super(name, parms);
    }

    public void init(boolean expensive) {
        Value cv;
        super.init(expensive);
        if (this._nclass > 1000) {
            throw new IllegalArgumentException("Too many levels in response column!");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees < 0 || ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees > 100000) {
            this.error("_ntrees", "Requested ntrees must be between 1 and 100000");
        }
        this._ntrees = ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees;
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._checkpoint && (cv = DKV.get((Key)((SharedTreeModel.SharedTreeParameters)this._parms)._destination_key)) != null) {
            SharedTreeModel checkpointModel = (SharedTreeModel)cv.get();
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees < ((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._ntrees + 1) {
                this.error("_ntrees", "Requested ntrees must be between " + ((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._ntrees + 1 + " and 100000");
            }
            this._ntrees = ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees - ((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._ntrees;
        }
        if (this._train != null) {
            this._ncols = this._train.numCols() - 1;
        }
        if (this._response == null) {
            return;
        }
        double mean = this._response.mean();
        this._initialPrediction = this._nclass == 1 ? mean : (this._nclass == 2 ? -0.5 * Math.log(mean / (1.0 - mean)) : 0.0);
    }

    protected DHistogram[][][] buildLayer(Frame fr, int nbins, DTree[] ktrees, int[] leafs, DHistogram[][][] hcs, boolean subset, boolean build_tree_one_node) {
        H2O.H2OCountedCompleter[] sb1ts = new H2O.H2OCountedCompleter[this._nclass];
        Vec[] vecs = fr.vecs();
        for (int k = 0; k < this._nclass; ++k) {
            DTree tree = ktrees[k];
            if (tree == null) continue;
            Frame fr2 = new Frame(Arrays.copyOf(fr._names, this._ncols + 1), Arrays.copyOf(vecs, this._ncols + 1));
            fr2.add(fr._names[this._ncols + 1 + k], vecs[this._ncols + 1 + k]);
            fr2.add(fr._names[this._ncols + 1 + this._nclass + k], vecs[this._ncols + 1 + this._nclass + k]);
            fr2.add(fr._names[this._ncols + 1 + this._nclass + this._nclass + k], vecs[this._ncols + 1 + this._nclass + this._nclass + k]);
            sb1ts[k] = new ScoreBuildOneTree(k, nbins, tree, leafs, hcs, fr2, subset, build_tree_one_node);
            H2O.submitTask((H2O.H2OCountedCompleter)sb1ts[k]);
        }
        boolean did_split = false;
        for (int k = 0; k < this._nclass; ++k) {
            DTree tree = ktrees[k];
            if (tree == null) continue;
            sb1ts[k].join();
            if (!((ScoreBuildOneTree)sb1ts[k])._did_split) continue;
            did_split = true;
        }
        return did_split ? hcs : (DHistogram[][][])null;
    }

    protected Chunk chk_resp(Chunk[] chks) {
        return chks[this._ncols];
    }

    protected Chunk chk_tree(Chunk[] chks, int c) {
        return chks[this._ncols + 1 + c];
    }

    protected Chunk chk_work(Chunk[] chks, int c) {
        return chks[this._ncols + 1 + this._nclass + c];
    }

    protected Chunk chk_nids(Chunk[] chks, int t) {
        return chks[this._ncols + 1 + this._nclass + this._nclass + t];
    }

    protected Chunk chk_oobt(Chunk[] chks) {
        return chks[this._ncols + 1 + this._nclass + this._nclass + this._nclass];
    }

    protected final Vec vec_nids(Frame fr, int t) {
        return fr.vecs()[this._ncols + 1 + this._nclass + this._nclass + t];
    }

    protected final Vec vec_resp(Frame fr, int t) {
        return fr.vecs()[this._ncols];
    }

    protected final Vec vec_tree(Frame fr, int c) {
        return fr.vecs()[this._ncols + 1 + c];
    }

    protected double[] data_row(Chunk[] chks, int row, double[] data) {
        assert (data.length == this._ncols);
        for (int f = 0; f < this._ncols; ++f) {
            data[f] = chks[f].at0(row);
        }
        return data;
    }

    protected abstract DTree.DecidedNode makeDecided(DTree.UndecidedNode var1, DHistogram[] var2);

    protected abstract boolean outOfBagRow(Chunk[] var1, int var2);

    protected abstract float score1(Chunk[] var1, float[] var2, int var3);

    protected abstract VarImp doVarImpCalc(boolean var1);

    float score2(Chunk[] chks, float[] fs, int row) {
        float sum = this.score1(chks, fs, row);
        if (this.isClassifier() && ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._priorClassDist != null && ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._modelClassDist != null && !Float.isInfinite(sum) && sum > 0.0f) {
            ArrayUtils.div((float[])fs, (float)sum);
            ModelUtils.correctProbabilities((float[])fs, (float[])((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._priorClassDist, (float[])((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._modelClassDist);
            sum = 1.0f;
        }
        return sum;
    }

    protected void doScoringAndSaveModel(boolean finalScoring, boolean oob, boolean build_tree_one_node) {
        long now = System.currentTimeMillis();
        if (this._firstScore == 0L) {
            this._firstScore = now;
        }
        long sinceLastScore = now - this._timeLastScoreStart;
        boolean updated = false;
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._score_each_iteration || finalScoring || now - this._firstScore < 4000L || sinceLastScore > 4000L && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < 0.1) {
            this._model.update(this._key);
            updated = true;
            this._timeLastScoreStart = now;
            Score sc = new Score(this, oob).doIt(build_tree_one_node).report(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees, null);
            ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._r2 = sc.r2();
            ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._cm = sc.cm();
            ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._auc = sc.auc();
            this._timeLastScoreEnd = System.currentTimeMillis();
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._importance && ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees > 0) {
            if (!updated) {
                this._model.update(this._key);
            }
            updated = true;
            Timer vi_timer = new Timer();
            ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._varimp = this.doVarImpCalc(false);
            Log.info((Object[])new Object[]{"Computation of variable importance took: " + vi_timer.toString()});
        }
        if (updated) {
            this._model.update(this._key);
        }
    }

    protected static void printGenerateTrees(DTree[] trees) {
        for (int k = 0; k < trees.length; ++k) {
            if (trees[k] == null) continue;
            System.out.println(trees[k].root().toString2(new StringBuilder(), 0));
        }
    }

    class ExcludeNAResponse
    extends MRTask<ExcludeNAResponse> {
        ExcludeNAResponse() {
        }

        public void map(Chunk[] chks) {
            Chunk ys = SharedTree.this.chk_resp(chks);
            for (int row = 0; row < ys._len; ++row) {
                if (!ys.isNA0(row)) continue;
                for (int t = 0; t < SharedTree.this._nclass; ++t) {
                    SharedTree.this.chk_nids(chks, t).set0(row, -1L);
                }
            }
        }
    }

    private class ScoreBuildOneTree
    extends H2O.H2OCountedCompleter {
        final int _k;
        final int _nbins;
        final DTree _tree;
        final int[] _leafs;
        final DHistogram[][][] _hcs;
        final Frame _fr2;
        final boolean _build_tree_one_node;
        final boolean _subset;
        boolean _did_split;

        ScoreBuildOneTree(int k, int nbins, DTree tree, int[] leafs, DHistogram[][][] hcs, Frame fr2, boolean subset, boolean build_tree_one_node) {
            this._k = k;
            this._nbins = nbins;
            this._tree = tree;
            this._leafs = leafs;
            this._hcs = hcs;
            this._fr2 = fr2;
            this._subset = subset;
            this._build_tree_one_node = build_tree_one_node;
        }

        public void compute2() {
            new ScoreBuildHistogram(this, this._k, SharedTree.this._ncols, this._nbins, this._tree, this._leafs[this._k], this._hcs[this._k], this._subset).dfork(0, this._fr2, this._build_tree_one_node);
        }

        public void onCompletion(CountedCompleter caller) {
            ScoreBuildHistogram sbh = (ScoreBuildHistogram)caller;
            int leafk = this._leafs[this._k];
            int tmax = this._tree.len();
            for (int leaf = leafk; leaf < tmax; ++leaf) {
                DTree.UndecidedNode udn = this._tree.undecided(leaf);
                DTree.DecidedNode dn = SharedTree.this.makeDecided(udn, sbh._hcs[leaf - leafk]);
                if (dn._split.col() == -1) {
                    udn.do_not_split();
                    continue;
                }
                this._did_split = true;
            }
            this._leafs[this._k] = tmax;
            int new_leafs = this._tree.len() - tmax;
            this._hcs[this._k] = new DHistogram[new_leafs][];
            for (int nl = tmax; nl < this._tree.len(); ++nl) {
                this._hcs[this._k][nl - tmax] = this._tree.undecided((int)nl)._hs;
            }
            if (new_leafs > 0) {
                ++this._tree._depth;
            }
        }
    }

    protected abstract class Driver
    extends H2O.H2OCountedCompleter<Driver> {
        protected Driver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void compute2() {
            block16: {
                Timer _bm_timer = new Timer();
                SharedTree.this._model = null;
                try {
                    int i;
                    Scope.enter();
                    SharedTree.this.init(true);
                    ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).lock_frames((Job)SharedTree.this);
                    if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._checkpoint && DKV.get((Key)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._destination_key) != null) {
                        SharedTree.this._model = (SharedTreeModel)DKV.get((Key)SharedTree.this._dest).get();
                        SharedTree.this._model.write_lock(SharedTree.this._key);
                    } else {
                        SharedTree.this._model = this.makeModel(SharedTree.this._dest, (Object)((Object)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)));
                        SharedTree.this._model.delete_and_lock(SharedTree.this._key);
                        ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._initialPrediction = SharedTree.this._initialPrediction;
                    }
                    String[] domain = SharedTree.this._response.domain();
                    assert (SharedTree.this._nclass > 1 && domain != null || SharedTree.this._nclass == 1 && domain == null);
                    if (SharedTree.this._nclass == 1) {
                        domain = new String[]{"r"};
                    }
                    Frame fr = SharedTree.this._train;
                    if (SharedTree.this._nclass > 1) {
                        if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._balance_classes) {
                            float[] trainSamplingFactors = new float[domain.length];
                            Frame stratified = MRUtils.sampleFrameStratified((Frame)fr, (Vec)fr.lastVec(), (float[])trainSamplingFactors, (long)((long)(((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._max_after_balance_size * (float)fr.numRows())), (long)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._seed, (boolean)true, (boolean)false);
                            if (stratified != fr) {
                                throw H2O.unimpl();
                            }
                        }
                        Log.info((Object[])new Object[]{"Prior class distribution: " + Arrays.toString(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._priorClassDist)});
                        Log.info((Object[])new Object[]{"Model class distribution: " + Arrays.toString(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._modelClassDist)});
                    }
                    for (i = 0; i < SharedTree.this._nclass; ++i) {
                        fr.add("Tree_" + domain[i], SharedTree.this._response.makeZero());
                    }
                    for (i = 0; i < SharedTree.this._nclass; ++i) {
                        fr.add("Work_" + domain[i], SharedTree.this._response.makeZero());
                    }
                    for (i = 0; i < SharedTree.this._nclass; ++i) {
                        fr.add("NIDs_" + domain[i], SharedTree.this._response.makeCon(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution == null ? 0.0 : (double)(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution[i] == 0L ? -1 : 0)));
                    }
                    new ExcludeNAResponse().doAll(fr);
                    final double init = SharedTree.this._initialPrediction;
                    if (init != 0.0) {
                        new MRTask(){

                            public void map(Chunk tree) {
                                for (int i = 0; i < tree._len; ++i) {
                                    tree.set0(i, init);
                                }
                            }
                        }.doAll(new Vec[]{SharedTree.this.vec_tree(SharedTree.this._train, 0)});
                    }
                    this.buildModel();
                    if (SharedTree.this._model == null) break block16;
                }
                catch (Throwable t) {
                    try {
                        SharedTree.this.cancel2(t);
                        throw t;
                    }
                    catch (Throwable throwable) {
                        if (SharedTree.this._model != null) {
                            SharedTree.this._model.unlock(SharedTree.this._key);
                        }
                        ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).unlock_frames((Job)SharedTree.this);
                        SharedTree.this.done();
                        Scope.exit((Key[])new Key[]{((SharedTreeModel)((Object)SharedTree.this._model))._key});
                        throw throwable;
                    }
                }
                SharedTree.this._model.unlock(SharedTree.this._key);
            }
            ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).unlock_frames((Job)SharedTree.this);
            SharedTree.this.done();
            Scope.exit((Key[])new Key[]{((SharedTreeModel)((Object)SharedTree.this._model))._key});
            this.tryComplete();
        }

        protected abstract M makeModel(Key var1, P var2);

        protected abstract void buildModel();
    }
}

