/*
 * Decompiled with CFR 0.152.
 */
package hex.example;

import hex.Model;
import hex.SupervisedModel;
import hex.SupervisedModelBuilder;
import hex.example.ExampleModel;
import hex.schemas.ExampleV2;
import hex.schemas.ModelBuilderSchema;
import java.util.Arrays;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.Log;

public class Example
extends SupervisedModelBuilder<ExampleModel, ExampleModel.ExampleParameters, ExampleModel.ExampleOutput> {
    public Model.ModelCategory[] can_build() {
        return new Model.ModelCategory[]{Model.ModelCategory.Unknown};
    }

    public Example(ExampleModel.ExampleParameters parms) {
        super("Example", (SupervisedModel.SupervisedParameters)parms);
        this.init(false);
    }

    public ModelBuilderSchema schema() {
        return new ExampleV2();
    }

    public Example trainModel() {
        return (Example)this.start(new ExampleDriver(), ((ExampleModel.ExampleParameters)this._parms)._max_iters);
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((ExampleModel.ExampleParameters)this._parms)._max_iters < 1 || ((ExampleModel.ExampleParameters)this._parms)._max_iters > 9999999) {
            this.error("max_iters", "must be between 1 and 10 million");
        }
    }

    private static class Max
    extends MRTask<Max> {
        double[] _maxs;

        private Max() {
        }

        public void map(Chunk[] cs) {
            this._maxs = new double[cs.length];
            Arrays.fill(this._maxs, -1.7976931348623157E308);
            for (int col = 0; col < cs.length; ++col) {
                for (int row = 0; row < cs[col]._len; ++row) {
                    this._maxs[col] = Math.max(this._maxs[col], cs[col].at0(row));
                }
            }
        }

        public void reduce(Max that) {
            for (int col = 0; col < this._maxs.length; ++col) {
                this._maxs[col] = Math.max(this._maxs[col], that._maxs[col]);
            }
        }
    }

    private class ExampleDriver
    extends H2O.H2OCountedCompleter<ExampleDriver> {
        private ExampleDriver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void compute2() {
            ExampleModel model;
            block6: {
                model = null;
                try {
                    Scope.enter();
                    ((ExampleModel.ExampleParameters)Example.this._parms).lock_frames((Job)Example.this);
                    Example.this.init(true);
                    model = new ExampleModel(Example.this.dest(), (ExampleModel.ExampleParameters)Example.this._parms, new ExampleModel.ExampleOutput(Example.this));
                    model.delete_and_lock(Example.this._key);
                    while (((ExampleModel.ExampleOutput)model._output)._iters < ((ExampleModel.ExampleParameters)Example.this._parms)._max_iters && Example.this.isRunning()) {
                        double[] maxs = ((Max)new Max().doAll((Frame)((ExampleModel.ExampleParameters)Example.this._parms).train()))._maxs;
                        ((ExampleModel.ExampleOutput)model._output)._maxs = maxs;
                        model.update(Example.this._key);
                        Example.this.update(1L);
                        StringBuilder sb = new StringBuilder();
                        sb.append("Example: iter: ").append(((ExampleModel.ExampleOutput)model._output)._iters);
                        Log.info((Object[])new Object[]{sb});
                        ++((ExampleModel.ExampleOutput)model._output)._iters;
                    }
                    if (model == null) break block6;
                }
                catch (Throwable t) {
                    try {
                        t.printStackTrace();
                        Example.this.cancel2(t);
                        throw t;
                    }
                    catch (Throwable throwable) {
                        if (model != null) {
                            model.unlock(Example.this._key);
                        }
                        ((ExampleModel.ExampleParameters)Example.this._parms).unlock_frames((Job)Example.this);
                        Scope.exit((Key[])new Key[]{model._key});
                        Example.this.done();
                        throw throwable;
                    }
                }
                model.unlock(Example.this._key);
            }
            ((ExampleModel.ExampleParameters)Example.this._parms).unlock_frames((Job)Example.this);
            Scope.exit((Key[])new Key[]{model._key});
            Example.this.done();
            this.tryComplete();
        }
    }
}

