/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.Model;
import hex.ModelBuilder;
import hex.kmeans.KMeans;
import hex.schemas.KMeansModelV2;
import water.Key;
import water.api.ModelSchema;

public class KMeansModel
extends Model<KMeansModel, KMeansParameters, KMeansOutput> {
    public KMeansModel(Key selfKey, KMeansParameters parms, KMeansOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelSchema schema() {
        return new KMeansModelV2();
    }

    protected float[] score0(double[] data, float[] preds) {
        preds[0] = KMeans.closest(((KMeansOutput)this._output)._clusters, data, ((KMeansOutput)this._output)._ncats);
        return preds;
    }

    public static class KMeansOutput
    extends Model.Output {
        public int _ncats;
        public int _iters;
        public double[][] _clusters;
        public long[] _rows;
        public double[] _mses;
        public double _mse;

        public KMeansOutput(KMeans b) {
            super((ModelBuilder)b);
        }

        public Model.ModelCategory getModelCategory() {
            return Model.ModelCategory.Clustering;
        }
    }

    public static class KMeansParameters
    extends Model.Parameters {
        public int _k = 2;
        public int _max_iters = 1000;
        public boolean _standardize = true;
        public long _seed = System.nanoTime();
        public KMeans.Initialization _init = KMeans.Initialization.Furthest;
    }
}

