/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.schemas.SupervisedModelBuilderSchema;
import java.util.Random;
import water.api.API;
import water.api.KeyV1;
import water.api.SupervisedModelParametersSchema;
import water.fvec.Frame;

public class DeepLearningV2
extends SupervisedModelBuilderSchema<DeepLearning, DeepLearningV2, DeepLearningParametersV2> {
    protected String acceptsFrame(Frame fr) {
        return "/v2/DeepLearning?training_frame=" + fr._key;
    }

    public static final class DeepLearningParametersV2
    extends SupervisedModelParametersSchema<DeepLearningModel.DeepLearningParameters, DeepLearningParametersV2> {
        public static String[] own_fields = new String[]{"n_folds", "keep_cross_validation_splits", "checkpoint", "override_with_best_model", "expert_mode", "autoencoder", "use_all_factor_levels", "activation", "hidden", "epochs", "train_samples_per_iteration", "target_ratio_comm_to_comp", "seed", "adaptive_rate", "rho", "epsilon", "rate", "rate_annealing", "rate_decay", "momentum_start", "momentum_ramp", "momentum_stable", "nesterov_accelerated_gradient", "input_dropout_ratio", "hidden_dropout_ratios", "l1", "l2", "max_w2", "initial_weight_distribution", "initial_weight_scale", "loss", "score_interval", "score_training_samples", "score_validation_samples", "score_duty_cycle", "classification_stop", "regression_stop", "quiet_mode", "max_confusion_matrix_size", "max_hit_ratio_k", "balance_classes", "class_sampling_factors", "max_after_balance_size", "score_validation_sampling", "diagnostics", "variable_importances", "fast_mode", "ignore_const_cols", "force_load_balance", "replicate_training_data", "single_node_mode", "shuffle_training_data", "missing_values_handling", "sparse", "col_major", "average_activation", "sparsity_beta"};
        @API(help="Number of folds for n-fold cross-validation (0 to n)", direction=API.Direction.INOUT)
        public int n_folds;
        @API(help="Keep cross-validation Frames", direction=API.Direction.INOUT)
        public boolean keep_cross_validation_splits = false;
        @API(help="Model checkpoint to resume training with", direction=API.Direction.INOUT)
        public KeyV1.ModelKeyV1 checkpoint;
        @API(help="If enabled, override the final model with the best model found during training", direction=API.Direction.INOUT)
        public boolean override_with_best_model = true;
        @API(help="Enable expert mode (to access all options from GUI)", direction=API.Direction.INOUT)
        public boolean expert_mode = false;
        @API(help="Auto-Encoder (Experimental)", direction=API.Direction.INOUT)
        public boolean autoencoder = false;
        @API(help="Use all factor levels of categorical variables. Otherwise, the first factor level is omitted (without loss of accuracy). Useful for variable importances and auto-enabled for autoencoder.", level=API.Level.secondary, direction=API.Direction.INOUT)
        public boolean use_all_factor_levels = true;
        @API(help="Activation function", values={"Tanh", "TanhWithDropout", "Rectifier", "RectifierWithDropout", "Maxout", "MaxoutWithDropout"}, level=API.Level.critical, direction=API.Direction.INOUT)
        public DeepLearningModel.DeepLearningParameters.Activation activation = DeepLearningModel.DeepLearningParameters.Activation.Rectifier;
        @API(help="Hidden layer sizes (e.g. 100,100). Grid search: (10,10), (20,20,20)", level=API.Level.critical, direction=API.Direction.INOUT)
        public int[] hidden = new int[]{200, 200};
        @API(help="How many times the dataset should be iterated (streamed), can be fractional", level=API.Level.critical, direction=API.Direction.INOUT)
        public double epochs = 10.0;
        @API(help="Number of training samples (globally) per MapReduce iteration. Special values are 0: one epoch, -1: all available data (e.g., replicated training data), -2: automatic", level=API.Level.secondary, direction=API.Direction.INOUT)
        public long train_samples_per_iteration = -2L;
        @API(help="Target ratio of communication overhead to computation. Only for multi-node operation and train_samples_per_iteration=-2 (auto-tuning)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double target_ratio_comm_to_comp = 0.02;
        @API(help="Seed for random numbers (affects sampling) - Note: only reproducible when running single threaded", direction=API.Direction.INOUT)
        public long seed = new Random().nextLong();
        @API(help="Adaptive learning rate (ADADELTA)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public boolean adaptive_rate = true;
        @API(help="Adaptive learning rate time decay factor (similarity to prior updates)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double rho = 0.99;
        @API(help="Adaptive learning rate smoothing factor (to avoid divisions by zero and allow progress)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double epsilon = 1.0E-8;
        @API(help="Learning rate (higher => less stable, lower => slower convergence)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double rate = 0.005;
        @API(help="Learning rate annealing: rate / (1 + rate_annealing * samples)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double rate_annealing = 1.0E-6;
        @API(help="Learning rate decay factor between layers (N-th layer: rate*alpha^(N-1))", level=API.Level.expert, direction=API.Direction.INOUT)
        public double rate_decay = 1.0;
        @API(help="Initial momentum at the beginning of training (try 0.5)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double momentum_start = 0.0;
        @API(help="Number of training samples for which momentum increases", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double momentum_ramp = 1000000.0;
        @API(help="Final momentum after the ramp is over (try 0.99)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double momentum_stable = 0.0;
        @API(help="Use Nesterov accelerated gradient (recommended)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public boolean nesterov_accelerated_gradient = true;
        @API(help="Input layer dropout ratio (can improve generalization, try 0.1 or 0.2)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double input_dropout_ratio = 0.0;
        @API(help="Hidden layer dropout ratios (can improve generalization), specify one value per hidden layer, defaults to 0.5", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double[] hidden_dropout_ratios;
        @API(help="L1 regularization (can add stability and improve generalization, causes many weights to become 0)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double l1 = 0.0;
        @API(help="L2 regularization (can add stability and improve generalization, causes many weights to be small", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double l2 = 0.0;
        @API(help="Constraint for squared sum of incoming weights per unit (e.g. for Rectifier)", level=API.Level.expert, direction=API.Direction.INOUT)
        public float max_w2 = Float.POSITIVE_INFINITY;
        @API(help="Initial Weight Distribution", values={"UniformAdaptive", "Uniform", "Normal"}, level=API.Level.expert, direction=API.Direction.INOUT)
        public DeepLearningModel.DeepLearningParameters.InitialWeightDistribution initial_weight_distribution = DeepLearningModel.DeepLearningParameters.InitialWeightDistribution.UniformAdaptive;
        @API(help="Uniform: -value...value, Normal: stddev)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double initial_weight_scale = 1.0;
        @API(help="Loss function", values={"Automatic", "MeanSquare", "CrossEntropy"}, level=API.Level.expert, direction=API.Direction.INOUT)
        public DeepLearningModel.DeepLearningParameters.Loss loss = DeepLearningModel.DeepLearningParameters.Loss.Automatic;
        @API(help="Shortest time interval (in secs) between model scoring", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double score_interval = 5.0;
        @API(help="Number of training set samples for scoring (0 for all)", level=API.Level.expert, direction=API.Direction.INOUT)
        public long score_training_samples = 10000L;
        @API(help="Number of validation set samples for scoring (0 for all)", level=API.Level.expert, direction=API.Direction.INOUT)
        public long score_validation_samples = 0L;
        @API(help="Maximum duty cycle fraction for scoring (lower: more training, higher: more scoring).", level=API.Level.expert, direction=API.Direction.INOUT)
        public double score_duty_cycle = 0.1;
        @API(help="Stopping criterion for classification error fraction on training data (-1 to disable)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double classification_stop = 0.0;
        @API(help="Stopping criterion for regression error (MSE) on training data (-1 to disable)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double regression_stop = 1.0E-6;
        @API(help="Enable quiet mode for less output to standard output", direction=API.Direction.INOUT)
        public boolean quiet_mode = false;
        @API(help="Max. size (number of classes) for confusion matrices to be shown", direction=API.Direction.INOUT)
        public int max_confusion_matrix_size = 20;
        @API(help="Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable)", level=API.Level.expert, direction=API.Direction.INOUT)
        public int max_hit_ratio_k = 10;
        @API(help="Balance training data class counts via over/under-sampling (for imbalanced data)", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean balance_classes = false;
        @API(help="Desired over/under-sampling ratios per class (in lexicographic order).  If not specified, they will be automatically computed to obtain class balance during training.", direction=API.Direction.INOUT)
        public float[] class_sampling_factors;
        @API(help="Maximum relative size of the training data after balancing class counts (can be less than 1.0)", level=API.Level.expert, direction=API.Direction.INOUT)
        public float max_after_balance_size = 5.0f;
        @API(help="Method used to sample validation dataset for scoring", values={"Uniform", "Stratified"}, level=API.Level.expert, direction=API.Direction.INOUT)
        public DeepLearningModel.DeepLearningParameters.ClassSamplingMethod score_validation_sampling = DeepLearningModel.DeepLearningParameters.ClassSamplingMethod.Uniform;
        @API(help="Enable diagnostics for hidden layers", direction=API.Direction.INOUT)
        public boolean diagnostics = true;
        @API(help="Compute variable importances for input features (Gedeon method) - can be slow for large networks", direction=API.Direction.INOUT)
        public boolean variable_importances = false;
        @API(help="Enable fast mode (minor approximation in back-propagation)", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean fast_mode = true;
        @API(help="Ignore constant training columns (no information can be gained anyway)", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean ignore_const_cols = true;
        @API(help="Force extra load balancing to increase training speed for small datasets (to keep all cores busy)", direction=API.Direction.INOUT)
        public boolean force_load_balance = true;
        @API(help="Replicate the entire training dataset onto every node for faster training on small datasets", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean replicate_training_data = true;
        @API(help="Run on a single node for fine-tuning of model parameters", direction=API.Direction.INOUT)
        public boolean single_node_mode = false;
        @API(help="Enable shuffling of training data (recommended if training data is replicated and train_samples_per_iteration is close to #nodes x #rows)", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean shuffle_training_data = false;
        @API(help="Handling of missing values. Either Skip or MeanImputation.", values={"Skip", "MeanImputation"}, direction=API.Direction.INOUT)
        public DeepLearningModel.DeepLearningParameters.MissingValuesHandling missing_values_handling = DeepLearningModel.DeepLearningParameters.MissingValuesHandling.MeanImputation;
        @API(help="Sparse data handling (Experimental).", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean sparse = false;
        @API(help="Use a column major weight matrix for input layer. Can speed up forward propagation, but might slow down backpropagation (Experimental).", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean col_major = false;
        @API(help="Average activation for sparse auto-encoder (Experimental)", direction=API.Direction.INOUT)
        public double average_activation = 0.0;
        @API(help="Sparsity regularization (Experimental)", direction=API.Direction.INOUT)
        public double sparsity_beta = 0.0;
        @API(help="Max. number of categorical features, enforced via hashing (Experimental)", level=API.Level.expert, direction=API.Direction.INOUT)
        public int max_categorical_features = Integer.MAX_VALUE;
        @API(help="Force reproducibility on small data (will be slow - only uses 1 thread)", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean reproducible = false;
    }
}

