/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.schemas.SupervisedModelBuilderSchema;
import water.api.API;
import water.api.SupervisedModelParametersSchema;
import water.fvec.Frame;

public class GLMV2
extends SupervisedModelBuilderSchema<GLM, GLMV2, GLMParametersV2> {
    protected String acceptsFrame(Frame fr) {
        return "/v2/GLM?training_frame=" + fr._key;
    }

    public static final class GLMParametersV2
    extends SupervisedModelParametersSchema<GLMModel.GLMParameters, GLMParametersV2> {
        public static String[] own_fields = new String[]{"standardize", "family", "link", "tweedie_variance_power", "tweedie_link_power", "alpha", "lambda", "prior1", "lambda_search", "nlambdas", "lambda_min_ratio", "higher_accuracy", "use_all_factor_levels", "n_folds"};
        @API(help="Standardize numeric columns to have zero mean and unit variance.")
        public boolean standardize;
        @API(help="Family.", values={"gaussian", "binomial", "poisson", "gamma", "tweedie"})
        public GLMModel.GLMParameters.Family family;
        @API(help="", level=API.Level.secondary, values={"family_default", "identity", "logit", "log", "inverse", "tweedie"})
        public GLMModel.GLMParameters.Link link;
        @API(help="Tweedie variance power", level=API.Level.secondary)
        public double tweedie_variance_power;
        @API(help="Tweedie link power", level=API.Level.secondary)
        public double tweedie_link_power;
        @API(help="distribution of regularization between L1 and L2.", level=API.Level.secondary)
        public double[] alpha;
        @API(help="regularization strength", level=API.Level.secondary)
        public double[] lambda;
        @API(help="prior probability for y==1. To be used only for logistic regression iff the data has been sampled and the mean of response does not reflect reality.", level=API.Level.expert)
        public double prior1;
        @API(help="use lambda search starting at lambda max, given lambda is then interpreted as lambda min", level=API.Level.secondary)
        public boolean lambda_search;
        @API(help="number of lambdas to be used in a search", level=API.Level.expert)
        public int nlambdas;
        @API(help="min lambda used in lambda search, specified as a ratio of lambda_max", level=API.Level.expert)
        public double lambda_min_ratio;
        @API(help="use line search (slower speed, to be used if glm does not converge otherwise)", level=API.Level.secondary)
        public boolean higher_accuracy;
        @API(help="By default, first factor level is skipped from the possible set of predictors. Set this flag if you want use all of the levels. Needs sufficient regularization to solve!", level=API.Level.secondary)
        public boolean use_all_factor_levels;
        @API(help="validation folds")
        public int n_folds;
    }
}

