/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import hex.schemas.ModelBuilderSchema;
import water.api.API;
import water.api.ModelParametersSchema;
import water.fvec.Frame;

public class KMeansV2
extends ModelBuilderSchema<KMeans, KMeansV2, KMeansParametersV2> {
    protected String acceptsFrame(Frame fr) {
        return "/v2/KMeans?training_frame=" + fr._key;
    }

    public static final class KMeansParametersV2
    extends ModelParametersSchema<KMeansModel.KMeansParameters, KMeansParametersV2> {
        public static String[] own_fields = new String[]{"k", "max_iters", "standardize", "seed", "init"};
        @API(help="Number of clusters", required=true)
        public int k;
        @API(help="Maximum training iterations.")
        public int max_iters;
        @API(help="Standardize columns", level=API.Level.secondary)
        public boolean standardize = true;
        @API(help="RNG Seed", level=API.Level.expert)
        public long seed;
        @API(help="Initialization mode", values={"None", "PlusPlus", "Furthest"})
        public KMeans.Initialization init;

        public KMeansParametersV2 fillFromImpl(KMeansModel.KMeansParameters parms) {
            super.fillFromImpl((Model.Parameters)parms);
            this.init = KMeans.Initialization.Furthest;
            return this;
        }

        public KMeansModel.KMeansParameters fillImpl(KMeansModel.KMeansParameters impl) {
            super.fillImpl((Model.Parameters)impl);
            impl._init = KMeans.Initialization.Furthest;
            return impl;
        }
    }
}

