/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.SharedTreeModel;
import hex.tree.TreeVisitor;
import java.util.Arrays;
import water.AutoBuffer;
import water.H2O;
import water.Key;
import water.Keyed;
import water.util.IcedBitSet;
import water.util.SB;

class CompressedTree
extends Keyed {
    final byte[] _bits;
    final int _nclass;
    final long _seed;

    public CompressedTree(byte[] bits, int nclass, long seed, int tid, int cls) {
        super(Key.makeSystem((String)("tree_" + tid + "_" + cls + "_" + Key.rand())));
        this._bits = bits;
        this._nclass = nclass;
        this._seed = seed;
    }

    public float score(double[] row) {
        int lmask;
        AutoBuffer ab = new AutoBuffer(this._bits);
        IcedBitSet ibs = null;
        do {
            int nodeType = ab.get1U();
            char colId = ab.get2();
            if (colId == '\uffff') {
                return this.scoreLeaf(ab);
            }
            int equal = (nodeType & 0xC) >> 2;
            assert (equal >= 0 && equal <= 3) : "illegal equal value " + equal + " at " + ab + " in bitpile " + Arrays.toString(this._bits);
            float splitVal = -1.0f;
            boolean grpContains = false;
            if (equal == 0 || equal == 1) {
                splitVal = ab.get4f();
            } else {
                int sz;
                char off = equal == 3 ? ab.get2() : (char)'\u0000';
                int n = sz = equal == 3 ? (int)ab.get2() : 4;
                if (ibs == null) {
                    ibs = new IcedBitSet(0);
                }
                ibs.fill(this._bits, ab.position(), sz, (int)off);
                ab.skip(sz);
            }
            lmask = nodeType & 0x33;
            int rmask = (nodeType & 0xC0) >> 2;
            int skip = 0;
            switch (lmask) {
                case 0: {
                    skip = ab.get1U();
                    break;
                }
                case 1: {
                    skip = ab.get2();
                    break;
                }
                case 2: {
                    skip = ab.get3();
                    break;
                }
                case 3: {
                    skip = ab.get4();
                    break;
                }
                case 16: {
                    skip = this._nclass < 256 ? 1 : 2;
                    break;
                }
                case 48: {
                    skip = 4;
                    break;
                }
                default: {
                    assert (false) : "illegal lmask value " + lmask + " at " + ab + " in bitpile " + Arrays.toString(this._bits);
                    break;
                }
            }
            double d = row[colId];
            if (Double.isNaN(d) || !(equal == 0 && (float)d >= splitVal || equal == 1 && (float)d == splitVal) && (equal != 2 && equal != 3 || !ibs.contains((int)d))) continue;
            ab.skip(skip);
            lmask = rmask;
        } while ((lmask & 0x10) != 16);
        return this.scoreLeaf(ab);
    }

    private float scoreLeaf(AutoBuffer ab) {
        return ab.get4f();
    }

    public long checksum() {
        throw H2O.fail();
    }

    public String toString(SharedTreeModel.SharedTreeOutput tm) {
        final String[] names = tm._names;
        final SB sb = new SB();
        new TreeVisitor<RuntimeException>(this){
            int _d;

            @Override
            protected void pre(int col, float fcmp, IcedBitSet gcmp, int equal) {
                sb.i().p(names[col]).p(' ');
                if (equal == 0) {
                    sb.p("< ").p(fcmp);
                } else if (equal == 1) {
                    sb.p("!=").p(fcmp);
                } else {
                    sb.p("in ").p(gcmp);
                }
                sb.ii(1).nl();
            }

            @Override
            protected void post(int col, float fcmp, int equal) {
                sb.di(1);
            }

            @Override
            protected void leaf(float pred) {
                sb.i().p("return ").p(pred).nl();
            }
        }.visit();
        return sb.toString();
    }
}

