/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Model;
import hex.ModelMetrics;
import hex.tree.SharedTree;
import hex.tree.SharedTreeModel;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.ModelUtils;

public class Score
extends MRTask<Score> {
    final SharedTree _bldr;
    final boolean _oob;
    ModelMetrics.MetricBuilder _mb;

    public Score(SharedTree bldr, boolean oob) {
        this._bldr = bldr;
        this._oob = oob;
    }

    public void map(Chunk[] chks) {
        float[] fArray;
        Chunk ys = this._bldr.chk_resp(chks);
        int nclass = this._bldr._nclass;
        String[] domain = this._bldr.vresponse().domain();
        int oobColIdx = this._bldr.idx_oobt();
        if (nclass == 2) {
            fArray = ModelUtils.DEFAULT_THRESHOLDS;
        } else {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = 0.5f;
        }
        this._mb = new ModelMetrics.MetricBuilder(domain, fArray);
        float[] cdists = this._mb._work;
        double[] tmp = this._bldr._parms._valid != null ? new double[this._bldr._ncols] : null;
        for (int row = 0; row < ys._len; ++row) {
            if (ys.isNA0(row) || this._oob && chks[oobColIdx].at80(row) != 0L) continue;
            if (this._bldr._parms._valid != null) {
                this._bldr._model.score0(chks, row, tmp, cdists);
            } else {
                this._bldr.score2(chks, cdists, row);
            }
            if (nclass > 1) {
                cdists[0] = ModelUtils.getPrediction((float[])cdists, (int)row);
            }
            this._mb.perRow(cdists, (float)ys.at0(row));
        }
    }

    public void reduce(Score t) {
        this._mb.reduce(t._mb);
    }

    ModelMetrics makeModelMetrics(SharedTreeModel model, Frame fr, String resp) {
        return this._mb.makeModelMetrics((Model)model, fr, fr.vec(resp).sigma());
    }
}

