/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DTree;
import water.Iced;

public class TreeStats
extends Iced {
    public int _minDepth = Integer.MAX_VALUE;
    public int _maxDepth = Integer.MIN_VALUE;
    public float _meanDepth;
    public int _minLeaves = Integer.MAX_VALUE;
    public int _maxLeaves = Integer.MIN_VALUE;
    public float _meanLeaves;
    transient long _sumDepth = 0L;
    transient long _sumLeaves = 0L;
    transient int _numTrees = 0;

    public boolean isValid() {
        return this._minDepth <= this._maxDepth;
    }

    public void updateBy(DTree[] ktrees) {
        if (ktrees == null) {
            return;
        }
        for (int i = 0; i < ktrees.length; ++i) {
            DTree tree = ktrees[i];
            if (tree == null) continue;
            if (this._minDepth > tree._depth) {
                this._minDepth = tree._depth;
            }
            if (this._maxDepth < tree._depth) {
                this._maxDepth = tree._depth;
            }
            if (this._minLeaves > tree._leaves) {
                this._minLeaves = tree._leaves;
            }
            if (this._maxLeaves < tree._leaves) {
                this._maxLeaves = tree._leaves;
            }
            this._sumDepth += (long)tree._depth;
            this._sumLeaves += (long)tree._leaves;
            ++this._numTrees;
            this._meanDepth = (float)this._sumDepth / (float)this._numTrees;
            this._meanLeaves = (float)this._sumLeaves / (float)this._numTrees;
        }
    }

    public void setNumTrees(int i) {
        this._numTrees = i;
    }
}

