/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.SupervisedModel;
import hex.schemas.SupervisedModelBuilderSchema;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import water.api.API;
import water.api.SupervisedModelParametersSchema;
import water.fvec.Frame;

public class GBMV2
extends SupervisedModelBuilderSchema<GBM, GBMV2, GBMParametersV2> {
    protected String acceptsFrame(Frame fr) {
        return "/v2/GBM?training_frame=" + fr._key;
    }

    public static final class GBMParametersV2
    extends SupervisedModelParametersSchema<GBMModel.GBMParameters, GBMParametersV2> {
        public static String[] own_fields = new String[]{"ntrees", "max_depth", "min_rows", "nbins", "learn_rate", "loss", "variable_importance", "seed", "group_split"};
        @API(help="Number of trees.  Grid Search, comma sep values:50,100,150,200")
        public int ntrees;
        @API(help="Maximum tree depth.  Grid Search, comma sep values:5,7")
        public int max_depth;
        @API(help="Fewest allowed observations in a leaf (in R called 'nodesize'). Grid Search, comma sep values")
        public int min_rows;
        @API(help="Build a histogram of this many bins, then split at the best point")
        public int nbins;
        @API(help="Learning rate from 0.0 to 1.0")
        public float learn_rate;
        @API(help="Loss function", values={"AUTO", "bernoulli"})
        public GBMModel.GBMParameters.Family loss;
        @API(help="RNG Seed for balancing classes", level=API.Level.expert)
        public long seed;
        @API(help="Compute variable importance", level=API.Level.critical)
        public boolean variable_importance;
        @API(help="Perform Group Splitting Categoricals")
        public boolean group_split;

        public GBMParametersV2 fillFromImpl(GBMModel.GBMParameters parms) {
            super.fillFromImpl((SupervisedModel.SupervisedParameters)parms);
            this.loss = GBMModel.GBMParameters.Family.AUTO;
            this.variable_importance = parms._variable_importance;
            return this;
        }

        public GBMModel.GBMParameters fillImpl(GBMModel.GBMParameters impl) {
            super.fillImpl((SupervisedModel.SupervisedParameters)impl);
            impl._variable_importance = this.variable_importance;
            return impl;
        }
    }
}

