/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DHistogram;
import hex.tree.DTree;
import water.MemoryManager;
import water.util.ArrayUtils;
import water.util.AtomicUtils;

public class DRealHistogram
extends DHistogram<DRealHistogram> {
    private float[] _sums;
    private float[] _ssqs;

    public DRealHistogram(String name, int nbins, byte isInt, float min, float maxEx, long nelems, boolean doGrpSplit) {
        super(name, nbins, isInt, min, maxEx, nelems, doGrpSplit);
    }

    @Override
    boolean isBinom() {
        return false;
    }

    @Override
    public double mean(int b) {
        int n = this._bins[b];
        return n > 0 ? (double)(this._sums[b] / (float)n) : 0.0;
    }

    @Override
    public double var(int b) {
        int n = this._bins[b];
        if (n <= 1) {
            return 0.0;
        }
        return (this._ssqs[b] - this._sums[b] * this._sums[b] / (float)n) / (float)(n - 1);
    }

    @Override
    void init0() {
        this._sums = MemoryManager.malloc4f((int)this._nbin);
        this._ssqs = MemoryManager.malloc4f((int)this._nbin);
    }

    @Override
    void incr0(int b, float y) {
        AtomicUtils.FloatArray.add((float[])this._sums, (int)b, (float)y);
        AtomicUtils.FloatArray.add((float[])this._ssqs, (int)b, (float)(y * y));
    }

    void incr1(int b, float y, float yy) {
        AtomicUtils.FloatArray.add((float[])this._sums, (int)b, (float)y);
        AtomicUtils.FloatArray.add((float[])this._ssqs, (int)b, (float)yy);
    }

    @Override
    void add0(DRealHistogram dsh) {
        ArrayUtils.add((float[])this._sums, (float[])dsh._sums);
        ArrayUtils.add((float[])this._ssqs, (float[])dsh._ssqs);
    }

    @Override
    public DTree.Split scoreMSE(int col) {
        int b;
        int nbins = this.nbins();
        assert (nbins > 1);
        double[] sums0 = MemoryManager.malloc8d((int)(nbins + 1));
        double[] ssqs0 = MemoryManager.malloc8d((int)(nbins + 1));
        long[] ns0 = MemoryManager.malloc8((int)(nbins + 1));
        for (int b2 = 1; b2 <= nbins; ++b2) {
            double m0 = sums0[b2 - 1];
            double m1 = this._sums[b2 - 1];
            double s0 = ssqs0[b2 - 1];
            double s1 = this._ssqs[b2 - 1];
            long k0 = ns0[b2 - 1];
            long k1 = this._bins[b2 - 1];
            if (k0 == 0L && k1 == 0L) continue;
            sums0[b2] = m0 + m1;
            ssqs0[b2] = s0 + s1;
            ns0[b2] = k0 + k1;
        }
        long tot = ns0[nbins];
        if (ssqs0[nbins] * (double)tot - sums0[nbins] * sums0[nbins] == 0.0) {
            assert (this.isConstantResponse());
            return null;
        }
        double[] sums1 = MemoryManager.malloc8d((int)(nbins + 1));
        double[] ssqs1 = MemoryManager.malloc8d((int)(nbins + 1));
        long[] ns1 = MemoryManager.malloc8((int)(nbins + 1));
        for (int b3 = nbins - 1; b3 >= 0; --b3) {
            double m0 = sums1[b3 + 1];
            double m1 = this._sums[b3];
            double s0 = ssqs1[b3 + 1];
            double s1 = this._ssqs[b3];
            long k0 = ns1[b3 + 1];
            long k1 = this._bins[b3];
            if (k0 == 0L && k1 == 0L) continue;
            sums1[b3] = m0 + m1;
            ssqs1[b3] = s0 + s1;
            ns1[b3] = k0 + k1;
            assert (ns0[b3] + ns1[b3] == tot);
        }
        int best = 0;
        double best_se0 = Double.MAX_VALUE;
        double best_se1 = Double.MAX_VALUE;
        byte equal = 0;
        for (b = 1; b <= nbins - 1; ++b) {
            double se1;
            double se0;
            if (this._bins[b] == 0 || !((se0 = ssqs0[b] - sums0[b] * sums0[b] / (double)ns0[b]) + (se1 = ssqs1[b] - sums1[b] * sums1[b] / (double)ns1[b]) < best_se0 + best_se1) && (se0 + se1 != best_se0 + best_se1 || Math.abs(b - (nbins >> 1)) >= Math.abs(best - (nbins >> 1)))) continue;
            best_se0 = se0;
            best_se1 = se1;
            best = b;
        }
        if (this._isInt > 0 && this._step == 1.0f && this._maxEx - this._min > 2.0f) {
            for (b = 1; b <= nbins - 1; ++b) {
                double sx;
                double si;
                if (this._bins[b] == 0) continue;
                long N = ns0[b + 0] + ns1[b + 1];
                double sums = sums0[b + 0] + sums1[b + 1];
                double ssqs = ssqs0[b + 0] + ssqs1[b + 1];
                if (N == 0L || !((si = ssqs - sums * sums / (double)N) + (sx = (double)(this._ssqs[b] - this._sums[b] * this._sums[b] / (float)this._bins[b])) < best_se0 + best_se1)) continue;
                best_se0 = si;
                best_se1 = sx;
                best = b;
                equal = 1;
            }
        }
        if (best == 0) {
            return null;
        }
        assert (best > 0) : "Must actually pick a split " + best;
        long n0 = equal == 0 ? ns0[best] : ns0[best] + ns1[best + 1];
        long n1 = equal == 0 ? ns1[best] : (long)this._bins[best];
        double p0 = equal == 0 ? sums0[best] : sums0[best] + sums1[best + 1];
        double p1 = equal == 0 ? sums1[best] : (double)this._sums[best];
        return new DTree.Split(col, best, null, equal, best_se0, best_se1, n0, n1, p0 / (double)n0, p1 / (double)n1);
    }

    @Override
    public long byteSize0() {
        return 40 + this._sums.length << 27 + this._ssqs.length << 3;
    }
}

