/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DHistogram;
import hex.tree.DRealHistogram;
import hex.tree.DTree;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.util.AtomicUtils;

public class ScoreBuildHistogram
extends MRTask<ScoreBuildHistogram> {
    final int _k;
    final int _ncols;
    final int _nbins;
    final DTree _tree;
    final int _leaf;
    final DHistogram[][] _hcs;
    final boolean _subset;
    public static final int DECIDED_ROW = -1;
    public static final int OUT_OF_BAG = -2;

    public ScoreBuildHistogram(H2O.H2OCountedCompleter cc, int k, int ncols, int nbins, DTree tree, int leaf, DHistogram[][] hcs, boolean subset) {
        super(cc);
        this._k = k;
        this._ncols = ncols;
        this._nbins = nbins;
        this._tree = tree;
        this._leaf = leaf;
        this._hcs = hcs;
        this._subset = subset;
    }

    public static boolean isOOBRow(int nid) {
        return nid <= -2;
    }

    public static boolean isDecidedRow(int nid) {
        return nid == -1;
    }

    public static int oob2Nid(int oobNid) {
        return -oobNid + -2;
    }

    public static int nid2Oob(int nid) {
        return -nid + -2;
    }

    public void setupLocal() {
        this._tree.init_tree();
        for (int l = this._leaf; l < this._tree._len; ++l) {
            DTree.UndecidedNode udn = this._tree.undecided(l);
            DHistogram[] hs = this._hcs[l - this._leaf];
            int[] sCols = udn._scoreCols;
            if (sCols != null) {
                for (int col : sCols) {
                    hs[col].init();
                }
                continue;
            }
            for (int j = 0; j < this._ncols; ++j) {
                if (hs[j] == null) continue;
                hs[j].init();
            }
        }
    }

    public void map(Chunk[] chks) {
        assert (chks.length == this._ncols + 4);
        Chunk wrks = chks[this._ncols + 2];
        Chunk nids = chks[this._ncols + 3];
        int[] nnids = new int[nids._len];
        if (this._leaf > 0) {
            this.score_decide(chks, nids, nnids);
        } else {
            for (int row = 0; row < nids._len; ++row) {
                if (!ScoreBuildHistogram.isDecidedRow((int)nids.atd(row))) continue;
                nnids[row] = -1;
            }
        }
        if (this._subset) {
            this.accum_subset(chks, wrks, nnids);
        } else {
            this.accum_all(chks, wrks, nnids);
        }
    }

    public void reduce(ScoreBuildHistogram sbh) {
        if (sbh._hcs == this._hcs) {
            return;
        }
        for (int i = 0; i < this._hcs.length; ++i) {
            DHistogram[] hs1 = this._hcs[i];
            DHistogram[] hs2 = sbh._hcs[i];
            if (hs1 == null) {
                this._hcs[i] = hs2;
                continue;
            }
            if (hs2 == null) continue;
            for (int j = 0; j < hs1.length; ++j) {
                if (hs1[j] == null) {
                    hs1[j] = hs2[j];
                    continue;
                }
                if (hs2[j] == null) continue;
                hs1[j].add(hs2[j]);
            }
        }
    }

    private void score_decide(Chunk[] chks, Chunk nids, int[] nnids) {
        for (int row = 0; row < nids._len; ++row) {
            int xnid;
            int nid = (int)nids.at8(row);
            if (ScoreBuildHistogram.isDecidedRow(nid)) {
                nnids[row] = nid - this._leaf;
                continue;
            }
            boolean oob = ScoreBuildHistogram.isOOBRow(nid);
            if (oob) {
                nid = ScoreBuildHistogram.oob2Nid(nid);
            }
            DTree.DecidedNode dn = this._tree.decided(nid);
            if (dn._split._col == -1 && DTree.isRootNode(dn)) {
                nnids[row] = nid - this._leaf;
                continue;
            }
            if (dn._split._col == -1) {
                nid = dn._pid;
                xnid = oob ? ScoreBuildHistogram.nid2Oob(nid) : nid;
                nids.set(row, (long)xnid);
                nnids[row] = xnid - this._leaf;
                dn = this._tree.decided(nid);
            }
            assert (!ScoreBuildHistogram.isDecidedRow(nid));
            nid = dn.ns(chks, row);
            if (!ScoreBuildHistogram.isDecidedRow(nid)) {
                xnid = oob ? ScoreBuildHistogram.nid2Oob(nid) : nid;
                nids.set(row, (long)xnid);
                nnids[row] = xnid - this._leaf;
                continue;
            }
            nnids[row] = nid - this._leaf;
        }
    }

    private void accum_subset(Chunk[] chks, Chunk wrks, int[] nnids) {
        for (int row = 0; row < nnids.length; ++row) {
            int[] sCols;
            int nid = nnids[row];
            if (nid < 0) continue;
            assert (!Double.isNaN(wrks.atd(row)));
            DHistogram[] nhs = this._hcs[nid];
            for (int col : sCols = this._tree.undecided((int)(nid + this._leaf))._scoreCols) {
                nhs[col].incr((float)chks[col].atd(row), (float)wrks.atd(row));
            }
        }
    }

    private void accum_all(Chunk[] chks, Chunk wrks, int[] nnids) {
        DHistogram[][] hcs = this._hcs;
        int[] nh = new int[hcs.length + 1];
        for (int i : nnids) {
            if (i < 0) continue;
            int n = i + 1;
            nh[n] = nh[n] + 1;
        }
        for (int i = 0; i < hcs.length; ++i) {
            int n = i + 1;
            nh[n] = nh[n] + nh[i];
        }
        int[] rows = new int[nnids.length];
        for (int row = 0; row < nnids.length; ++row) {
            if (nnids[row] < 0) continue;
            int n = nnids[row];
            int n2 = nh[n];
            nh[n] = n2 + 1;
            rows[n2] = row;
        }
        this.accum_all2(chks, wrks, nh, rows);
    }

    private void accum_all2(Chunk[] chks, Chunk wrks, int[] nh, int[] rows) {
        DHistogram[][] hcs = this._hcs;
        int[] bins = new int[this._nbins];
        double[] sums = new double[this._nbins];
        double[] ssqs = new double[this._nbins];
        for (int c = 0; c < this._ncols; ++c) {
            Chunk chk = chks[c];
            for (int n = 0; n < hcs.length; ++n) {
                DRealHistogram rh = (DRealHistogram)hcs[n][c];
                if (rh == null) continue;
                int lo = n == 0 ? 0 : nh[n - 1];
                int hi = nh[n];
                float min = rh._min2;
                float max = rh._maxIn;
                if (rh._bins.length >= bins.length) {
                    bins = new int[rh._bins.length];
                    sums = new double[rh._bins.length];
                    ssqs = new double[rh._bins.length];
                }
                for (int xrow = lo; xrow < hi; ++xrow) {
                    int b;
                    int row = rows[xrow];
                    float col_data = (float)chk.atd(row);
                    if (col_data < min) {
                        min = col_data;
                    }
                    if (col_data > max) {
                        max = col_data;
                    }
                    int n2 = b = rh.bin(col_data);
                    bins[n2] = bins[n2] + 1;
                    double resp = wrks.atd(row);
                    int n3 = b;
                    sums[n3] = sums[n3] + resp;
                    int n4 = b;
                    ssqs[n4] = ssqs[n4] + resp * resp;
                }
                rh.setMin(min);
                rh.setMax(max);
                for (int b = 0; b < rh._bins.length; ++b) {
                    if (bins[b] != 0) {
                        AtomicUtils.IntArray.add((int[])rh._bins, (int)b, (int)bins[b]);
                        bins[b] = 0;
                    }
                    if (ssqs[b] == 0.0) continue;
                    rh.incr1(b, (float)sums[b], (float)ssqs[b]);
                    ssqs[b] = 0.0;
                    sums[b] = 0.0;
                }
            }
        }
    }
}

