/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.CompressedTree;
import water.AutoBuffer;
import water.H2O;
import water.util.IcedBitSet;

public abstract class TreeVisitor<T extends Exception> {
    protected final CompressedTree _ct;
    private final AutoBuffer _ts;
    private final IcedBitSet _gcmp;
    protected int _depth;
    protected int _nodes;

    protected void pre(int col, float fcmp, IcedBitSet gcmp, int equal) throws T {
    }

    protected void mid(int col, float fcmp, int equal) throws T {
    }

    protected void post(int col, float fcmp, int equal) throws T {
    }

    protected void leaf(float pred) throws T {
    }

    long result() {
        return 0L;
    }

    public TreeVisitor(CompressedTree ct) {
        this._ct = ct;
        this._ts = new AutoBuffer(this._ct._bits);
        this._gcmp = new IcedBitSet(0);
    }

    private final void leaf2(int mask) throws T {
        assert (mask == 0 || (mask & 0x10) == 16 && (mask & 0x20) == 32) : "Unknown mask: " + mask;
        this.leaf(this._ts.get4f());
    }

    public final void visit() throws T {
        byte nodeType = this._ts.get1();
        char col = this._ts.get2();
        if (col == '\uffff') {
            this.leaf2(nodeType);
            return;
        }
        int equal = (nodeType & 0xC) >> 2;
        float fcmp = -1.0f;
        if (equal != 0 && equal != 1) {
            char off = equal == 3 ? this._ts.get2() : (char)'\u0000';
            int sz = equal == 3 ? (int)this._ts.get2() : 4;
            this._gcmp.fill(this._ct._bits, this._ts.position(), sz << 3, (int)off);
            throw H2O.unimpl();
        }
        fcmp = this._ts.get4f();
        int lmask = nodeType & 0x33;
        int rmask = (nodeType & 0xC0) >> 2;
        int skip = 0;
        switch (lmask) {
            case 0: {
                skip = this._ts.get1();
                break;
            }
            case 1: {
                skip = this._ts.get2();
                break;
            }
            case 2: {
                skip = this._ts.get3();
                break;
            }
            case 3: {
                skip = this._ts.get4();
                break;
            }
            case 16: {
                skip = this._ct._nclass < 256 ? 1 : 2;
                break;
            }
            case 48: {
                skip = 4;
                break;
            }
            default: {
                assert (false) : "illegal lmask value " + lmask;
                break;
            }
        }
        this.pre(col, fcmp, this._gcmp, equal);
        ++this._depth;
        if ((lmask & 0x10) == 16) {
            this.leaf2(lmask);
        } else {
            this.visit();
        }
        this.mid(col, fcmp, equal);
        if ((rmask & 0x10) == 16) {
            this.leaf2(rmask);
        } else {
            this.visit();
        }
        --this._depth;
        this.post(col, fcmp, equal);
        ++this._nodes;
    }
}

