/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.FrameTask;
import hex.Model;
import hex.SupervisedModel;
import hex.SupervisedModelBuilder;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.DeepLearningTask2;
import hex.schemas.DeepLearningV2;
import hex.schemas.ModelBuilderSchema;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import water.DKV;
import water.H2O;
import water.H2ONode;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.Scope;
import water.fvec.Frame;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.init.Linpack;
import water.init.NetworkTest;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MRUtils;
import water.util.PrettyPrint;

public class DeepLearning
extends SupervisedModelBuilder<DeepLearningModel, DeepLearningModel.DeepLearningParameters, DeepLearningModel.DeepLearningModelOutput> {
    public Model.ModelCategory[] can_build() {
        return new Model.ModelCategory[]{Model.ModelCategory.Regression, Model.ModelCategory.Binomial, Model.ModelCategory.Multinomial};
    }

    public DeepLearning(DeepLearningModel.DeepLearningParameters parms) {
        super("DeepLearning", (SupervisedModel.SupervisedParameters)parms);
        this.init(false);
    }

    public ModelBuilderSchema schema() {
        return new DeepLearningV2();
    }

    public Job<DeepLearningModel> trainModel() {
        return this.start(new DeepLearningDriver(), (long)(((DeepLearningModel.DeepLearningParameters)this._parms)._epochs * (double)this._train.numRows()));
    }

    public void init(boolean expensive) {
        super.init(expensive);
        ((DeepLearningModel.DeepLearningParameters)this._parms).validate(this, expensive);
    }

    public class DeepLearningDriver
    extends H2O.H2OCountedCompleter<DeepLearningDriver> {
        final transient String[] cp_modifiable = new String[]{"_expert_mode", "_seed", "_epochs", "_score_interval", "_train_samples_per_iteration", "_target_ratio_comm_to_comp", "_score_duty_cycle", "_classification_stop", "_regression_stop", "_quiet_mode", "_max_confusion_matrix_size", "_max_hit_ratio_k", "_diagnostics", "_variable_importances", "_force_load_balance", "_replicate_training_data", "_shuffle_training_data", "_single_node_mode", "_sparse", "_col_major", "_l1", "_l2", "_max_w2"};
        transient HashSet<Frame> _delete_me = new HashSet();

        protected void compute2() {
            try {
                Scope.enter();
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).read_lock_frames((Job)DeepLearning.this);
                DeepLearning.this.init(true);
                if (DeepLearning.this.error_count() > 0) {
                    throw new IllegalArgumentException("Found validation errors: " + DeepLearning.this.validationErrors());
                }
                this.buildModel();
            }
            catch (Throwable t) {
                t.printStackTrace();
                DeepLearning.this.cancel2(t);
                throw t;
            }
            finally {
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).read_unlock_frames((Job)DeepLearning.this);
                Scope.exit((Key[])new Key[0]);
                DeepLearning.this.done();
            }
            this.tryComplete();
        }

        Key self() {
            return DeepLearning.this._key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void buildModel() {
            Scope.enter();
            DeepLearningModel cp = null;
            if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._checkpoint == null) {
                cp = new DeepLearningModel(DeepLearning.this.dest(), (DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms, new DeepLearningModel.DeepLearningModelOutput(DeepLearning.this), DeepLearning.this._train, DeepLearning.this._valid);
                cp.model_info().initializeMembers();
            } else {
                DeepLearningModel previous = (DeepLearningModel)DKV.getGet((Key)((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._checkpoint);
                if (previous == null) {
                    throw new IllegalArgumentException("Checkpoint not found.");
                }
                Log.info((Object[])new Object[]{"Resuming from checkpoint."});
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._n_folds != 0) {
                    throw new UnsupportedOperationException("n_folds must be 0: Cross-validation is not supported during checkpoint restarts.");
                }
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder = previous.model_info().get_params()._autoencoder;
                if (!(((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder || ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._response_column != null && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._response_column.equals(previous.model_info().get_params()._response_column))) {
                    throw new IllegalArgumentException("response_vec must be the same as for the checkpointed model.");
                }
                if (ArrayUtils.difference((String[])((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._ignored_columns, (String[])previous.model_info().get_params()._ignored_columns).length != 0 || ArrayUtils.difference((String[])previous.model_info().get_params()._ignored_columns, (String[])((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._ignored_columns).length != 0) {
                    ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._ignored_columns = previous.model_info().get_params()._ignored_columns;
                    Log.warn((Object[])new Object[]{"Automatically re-using ignored_cols from the checkpointed model."});
                }
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid == null != (((DeepLearningModel.DeepLearningParameters)previous._parms)._valid == null) || ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid != null && !((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid.equals((Object)((DeepLearningModel.DeepLearningParameters)previous._parms)._valid)) {
                    throw new IllegalArgumentException("validation must be the same as for the checkpointed model.");
                }
                if (DeepLearning.this.isClassifier() != ((DeepLearningModel.DeepLearningModelOutput)previous._output).isClassifier()) {
                    Log.warn((Object[])new Object[]{"Automatically switching to " + (DeepLearning.this.isClassifier() ? "regression" : "classification") + " (same as the checkpointed model)."});
                }
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._epochs += previous.epoch_counter;
                Log.info((Object[])new Object[]{"Adding " + String.format("%.3f", previous.epoch_counter) + " epochs from the checkpointed model."});
                try {
                    FrameTask.DataInfo dinfo = new FrameTask.DataInfo(Key.make(), DeepLearning.this._train, DeepLearning.this._valid, ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder ? 0 : 1, ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder || ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._use_all_factor_levels, ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder ? FrameTask.DataInfo.TransformType.NORMALIZE : FrameTask.DataInfo.TransformType.STANDARDIZE, DeepLearning.this.isClassifier() ? FrameTask.DataInfo.TransformType.NONE : FrameTask.DataInfo.TransformType.STANDARDIZE);
                    DKV.put((Key)dinfo._key, (Iced)dinfo);
                    cp = new DeepLearningModel(DeepLearning.this.dest(), previous, false, dinfo);
                    cp.write_lock(this.self());
                    DeepLearningModel.DeepLearningParameters A = cp.model_info().get_params();
                    Model.Parameters B = DeepLearning.this._parms;
                    for (Field fA : ((Object)((Object)A)).getClass().getDeclaredFields()) {
                        if (!ArrayUtils.contains((String[])this.cp_modifiable, (String)fA.getName()) || !((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._expert_mode && ArrayUtils.contains((String[])cp.get_params().expert_options, (String)fA.getName())) continue;
                        for (Field fB : B.getClass().getDeclaredFields()) {
                            if (!fA.equals(fB)) continue;
                            try {
                                if (fB.get(B) != null && fA.get((Object)A) != null && fA.get((Object)A).toString().equals(fB.get(B).toString()) || fA.get((Object)A) == null && fB.get(B) == null) continue;
                                Log.info((Object[])new Object[]{"Applying user-requested modification of '" + fA.getName() + "': " + fA.get((Object)A) + " -> " + fB.get(B)});
                                fA.set((Object)A, fB.get(B));
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (A._n_folds != 0) {
                        Log.warn((Object[])new Object[]{"Disabling cross-validation: Not supported when resuming training from a checkpoint."});
                        A._n_folds = 0;
                    }
                    cp.update(this.self());
                }
                finally {
                    if (cp != null) {
                        cp.unlock(this.self());
                    }
                }
            }
            this.trainModel(cp);
            Key[] mms = ((DeepLearningModel.DeepLearningModelOutput)cp._output)._model_metrics;
            Scope.exit((Key[])new Key[]{DeepLearning.this.dest(), mms.length == 0 ? null : mms[mms.length - 1]});
        }

        public final DeepLearningModel trainModel(DeepLearningModel model) {
            Frame validScoreFrame = null;
            try {
                DeepLearningModel best_model;
                if (model == null) {
                    model = (DeepLearningModel)DKV.get((Key)DeepLearning.this.dest()).get();
                }
                model.write_lock(this.self());
                DeepLearningModel.DeepLearningParameters mp = (DeepLearningModel.DeepLearningParameters)model._parms;
                Frame tra_fr = new Frame(mp.train()._key, DeepLearning.this._train.names(), DeepLearning.this._train.vecs());
                Frame val_fr = DeepLearning.this._valid != null ? new Frame(mp.valid()._key, DeepLearning.this._valid.names(), DeepLearning.this._valid.vecs()) : null;
                long model_size = model.model_info().size();
                if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                    Log.info((Object[])new Object[]{"Number of model parameters (weights/biases): " + String.format("%,d", model_size)});
                }
                Frame train = tra_fr;
                if (mp._force_load_balance) {
                    train = this.reBalance(train, mp._replicate_training_data, mp._train.toString() + "." + model._key.toString() + ".train");
                }
                if (((DeepLearningModel.DeepLearningModelOutput)model._output).isClassifier() && mp._balance_classes) {
                    float[] trainSamplingFactors = new float[train.lastVec().domain().length];
                    if (mp._class_sampling_factors != null) {
                        if (mp._class_sampling_factors.length != train.lastVec().domain().length) {
                            throw new IllegalArgumentException("class_sampling_factors must have " + train.lastVec().domain().length + " elements");
                        }
                        trainSamplingFactors = (float[])mp._class_sampling_factors.clone();
                    }
                    train = MRUtils.sampleFrameStratified((Frame)train, (Vec)train.lastVec(), (float[])trainSamplingFactors, (long)((long)(mp._max_after_balance_size * (float)train.numRows())), (long)mp._seed, (boolean)true, (boolean)false);
                    ((DeepLearningModel.DeepLearningModelOutput)model._output)._modelClassDist = ((MRUtils.ClassDist)new MRUtils.ClassDist(train.lastVec()).doAll(new Vec[]{train.lastVec()})).rel_dist();
                }
                ((DeepLearningModel.DeepLearningModelOutput)model._output).autoencoder = ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder;
                model.training_rows = train.numRows();
                Frame trainScoreFrame = MRUtils.sampleFrame((Frame)train, (long)mp._score_training_samples, (long)mp._seed);
                if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                    Log.info((Object[])new Object[]{"Number of chunks of the training data: " + train.anyVec().nChunks()});
                }
                if (val_fr != null) {
                    model.validation_rows = val_fr.numRows();
                    validScoreFrame = ((DeepLearningModel.DeepLearningModelOutput)model._output).isClassifier() && mp._balance_classes && mp._score_validation_sampling == DeepLearningModel.DeepLearningParameters.ClassSamplingMethod.Stratified ? MRUtils.sampleFrameStratified((Frame)val_fr, (Vec)val_fr.lastVec(), null, (long)(mp._score_validation_samples > 0L ? mp._score_validation_samples : val_fr.numRows()), (long)(mp._seed + 1L), (boolean)false, (boolean)false) : MRUtils.sampleFrame((Frame)val_fr, (long)mp._score_validation_samples, (long)(mp._seed + 1L));
                    if (mp._force_load_balance) {
                        validScoreFrame = this.reBalance(validScoreFrame, false, mp._valid.toString() + "." + model._key.toString() + ".valid");
                    }
                    if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                        Log.info((Object[])new Object[]{"Number of chunks of the validation data: " + validScoreFrame.anyVec().nChunks()});
                    }
                }
                model.actual_train_samples_per_iteration = this.computeTrainSamplesPerIteration(mp, train.numRows(), model);
                if (mp._replicate_training_data && model.actual_train_samples_per_iteration == train.numRows() * (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) && !mp._shuffle_training_data && H2O.CLOUD.size() > 1 && !mp._reproducible) {
                    Log.warn((Object[])new Object[]{"Enabling training data shuffling, because all nodes train on the full dataset (replicated training data)."});
                    mp._shuffle_training_data = true;
                }
                model._timeLastScoreEnter = System.currentTimeMillis();
                if (!mp._quiet_mode) {
                    Log.info((Object[])new Object[]{"Initial model:\n" + (Object)((Object)model.model_info())});
                }
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder) {
                    model.doScoring(trainScoreFrame, validScoreFrame, this.self());
                }
                model.update(this.self());
                Log.info((Object[])new Object[]{"Starting to train the Deep Learning model."});
                do {
                    model.set_model_info(mp._epochs == 0.0 ? model.model_info() : (H2O.CLOUD.size() > 1 && mp._replicate_training_data ? (mp._single_node_mode ? ((DeepLearningTask2)new DeepLearningTask2(this.self(), train, model.model_info(), this.rowFraction(train, mp, model)).doAll(new Key[]{Key.make()})).model_info() : ((DeepLearningTask2)new DeepLearningTask2(this.self(), train, model.model_info(), this.rowFraction(train, mp, model)).doAllNodes()).model_info()) : ((DeepLearningTask)new DeepLearningTask(this.self(), model.model_info(), this.rowFraction(train, mp, model)).doAll(train)).model_info()));
                    DeepLearning.this.update(model.actual_train_samples_per_iteration);
                } while (model.doScoring(trainScoreFrame, validScoreFrame, this.self()));
                if (!DeepLearning.this.isCancelledOrCrashed() && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._override_with_best_model && model.actual_best_model_key != null && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._n_folds == 0 && (best_model = (DeepLearningModel)DKV.getGet((Key)model.actual_best_model_key)) != null && best_model.error() < model.error() && Arrays.equals(best_model.model_info().units, model.model_info().units)) {
                    Log.info((Object[])new Object[]{"Setting the model to be the best model so far (based on scoring history)."});
                    DeepLearningModel.DeepLearningModelInfo mi = best_model.model_info().deep_clone();
                    mi.set_processed_global(model.model_info().get_processed_global());
                    mi.set_processed_local(model.model_info().get_processed_local());
                    model.set_model_info(mi);
                    model.update(this.self());
                    model.doScoring(trainScoreFrame, validScoreFrame, this.self());
                    assert (best_model.error() == model.error());
                }
                Log.info((Object[])new Object[]{"=============================================================================================="});
                Log.info((Object[])new Object[]{"Finished training the Deep Learning model."});
                Log.info((Object[])new Object[]{model});
                Log.info((Object[])new Object[]{"=============================================================================================="});
            }
            catch (RuntimeException ex) {
                model = (DeepLearningModel)DKV.get((Key)DeepLearning.this.dest()).get();
                DeepLearning.this._state = Job.JobState.CANCELLED;
                Log.info((Object[])new Object[]{"Deep Learning model building was cancelled."});
                throw ex;
            }
            finally {
                if (model != null) {
                    model.unlock(this.self());
                }
                for (Frame f : this._delete_me) {
                    f.delete();
                }
            }
            return model;
        }

        private Frame reBalance(Frame fr, boolean local, String name) {
            int chunks = (int)Math.min((long)(4 * H2O.NUMCPUS * (local ? 1 : H2O.CLOUD.size())), fr.numRows());
            if (fr.anyVec().nChunks() > chunks && !((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._reproducible) {
                Log.info((Object[])new Object[]{"Dataset already contains " + fr.anyVec().nChunks() + " chunks. No need to rebalance."});
                return fr;
            }
            if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._reproducible) {
                Log.warn((Object[])new Object[]{"Reproducibility enforced - using only 1 thread - can be slow."});
                chunks = 1;
            }
            if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                Log.info((Object[])new Object[]{"ReBalancing dataset into (at least) " + chunks + " chunks."});
            }
            Key newKey = Key.make((String)(name + ".chunks" + chunks));
            RebalanceDataSet rb = new RebalanceDataSet(fr, newKey, chunks);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            Frame f = (Frame)DKV.get((Key)newKey).get();
            this._delete_me.add(f);
            return f;
        }

        private long computeTrainSamplesPerIteration(DeepLearningModel.DeepLearningParameters mp, long numRows, DeepLearningModel model) {
            long tspi = mp._train_samples_per_iteration;
            assert (tspi == 0L || tspi == -1L || tspi == -2L || tspi >= 1L);
            if (tspi == 0L || !mp._replicate_training_data && tspi == -1L) {
                tspi = numRows;
                if (!mp._quiet_mode) {
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to one epoch: #rows (" + tspi + ")."});
                }
            } else if (tspi == -1L) {
                tspi = (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) * numRows;
                if (!mp._quiet_mode) {
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to #nodes x #rows (" + tspi + ")."});
                }
            } else if (tspi == -2L) {
                double total_gflops = 0.0;
                for (H2ONode h2o : H2O.CLOUD._memary) {
                    HeartBeat hb = h2o._heartbeat;
                    total_gflops += hb._gflops;
                }
                if (mp._single_node_mode) {
                    total_gflops /= (double)H2O.CLOUD.size();
                }
                if (total_gflops == 0.0) {
                    total_gflops = Linpack.run((int)H2O.SELF._heartbeat._cpus_allowed) * (double)(mp._single_node_mode ? 1 : H2O.CLOUD.size());
                }
                long model_size = model.model_info().size();
                int[] msg_sizes = new int[]{(long)((int)(model_size * 4L)) == model_size * 4L ? (int)(model_size * 4L) : Integer.MAX_VALUE};
                double[] microseconds_collective = new double[msg_sizes.length];
                NetworkTest.NetworkTester nt = new NetworkTest.NetworkTester(msg_sizes, (double[][])null, microseconds_collective, (double)model_size > 1000000.0 ? 1 : 5, false, true);
                nt.compute2();
                int network_queue_length = mp._single_node_mode || H2O.CLOUD.size() == 1 ? 1 : 2 * (int)Math.floor(Math.log(H2O.CLOUD.size()) / Math.log(2.0));
                double flops_overhead_per_row = 30.0;
                if (mp._activation == DeepLearningModel.DeepLearningParameters.Activation.Maxout || mp._activation == DeepLearningModel.DeepLearningParameters.Activation.MaxoutWithDropout) {
                    flops_overhead_per_row *= 8.0;
                } else if (mp._activation == DeepLearningModel.DeepLearningParameters.Activation.Tanh || mp._activation == DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout) {
                    flops_overhead_per_row *= 5.0;
                }
                double fraction = mp._single_node_mode || H2O.CLOUD.size() == 1 ? 0.001 : 0.05;
                model.time_for_communication_us = (H2O.CLOUD.size() == 1 ? 10000.0 : 0.0) + (double)network_queue_length * microseconds_collective[0];
                double time_per_row_us = flops_overhead_per_row * (double)model_size / (total_gflops * 1.0E9) / (double)H2O.SELF._heartbeat._cpus_allowed * 1000000.0;
                tspi = (long)((model.time_for_communication_us / fraction - model.time_for_communication_us) / time_per_row_us);
                tspi = Math.min(tspi, (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) * numRows * 10L);
                if (tspi > numRows && (double)Math.abs(tspi % numRows) / (double)numRows < 0.2) {
                    tspi -= tspi % numRows;
                }
                tspi = Math.min(tspi, (long)(mp._epochs * (double)numRows / 10.0));
                tspi = Math.max(1L, tspi);
                if (!mp._quiet_mode) {
                    Log.info((Object[])new Object[]{"Auto-tuning parameter 'train_samples_per_iteration':"});
                    Log.info((Object[])new Object[]{"Estimated compute power : " + (int)total_gflops + " GFlops"});
                    Log.info((Object[])new Object[]{"Estimated time for comm : " + PrettyPrint.usecs((long)((long)model.time_for_communication_us))});
                    Log.info((Object[])new Object[]{"Estimated time per row  : " + ((long)time_per_row_us > 0L ? PrettyPrint.usecs((long)((long)time_per_row_us)) : time_per_row_us + " usecs")});
                    Log.info((Object[])new Object[]{"Estimated training speed: " + (int)(1000000.0 / time_per_row_us) + " rows/sec"});
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to auto-tuned value: " + tspi});
                }
            } else {
                tspi = Math.min(tspi, (long)(mp._epochs * (double)numRows));
            }
            assert (tspi != 0L && tspi != -1L && tspi != -2L && tspi >= 1L);
            return tspi;
        }

        private float computeRowUsageFraction(long numRows, long train_samples_per_iteration, boolean replicate_training_data) {
            float rowUsageFraction = (float)train_samples_per_iteration / (float)numRows;
            if (replicate_training_data) {
                rowUsageFraction /= (float)H2O.CLOUD.size();
            }
            assert (rowUsageFraction > 0.0f);
            return rowUsageFraction;
        }

        private float rowFraction(Frame train, DeepLearningModel.DeepLearningParameters p, DeepLearningModel m) {
            return this.computeRowUsageFraction(train.numRows(), m.actual_train_samples_per_iteration, p._replicate_training_data);
        }
    }
}

