/*
 * Decompiled with CFR 0.152.
 */
package hex.splitframe;

import hex.Model;
import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import hex.schemas.SplitFrameV2;
import hex.splitframe.SplitFrameModel;
import java.util.Arrays;
import jsr166y.CountedCompleter;
import water.ChunkSplitter;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.FrameUtils;

public class SplitFrame
extends ModelBuilder<SplitFrameModel, SplitFrameModel.SplitFrameParameters, SplitFrameModel.SplitFrameOutput> {
    public SplitFrame(SplitFrameModel.SplitFrameParameters parms) {
        super("SplitFrame", (Model.Parameters)parms);
        this.init(false);
    }

    public ModelBuilderSchema schema() {
        return new SplitFrameV2();
    }

    public SplitFrame trainModel() {
        return (SplitFrame)this.start(new SplitFrameDriver(), ((SplitFrameModel.SplitFrameParameters)this._parms).train().numCols() * ((SplitFrameModel.SplitFrameParameters)this._parms)._ratios.length);
    }

    public Model.ModelCategory[] can_build() {
        return new Model.ModelCategory[]{Model.ModelCategory.Unknown};
    }

    public void init(boolean expensive) {
        super.init(expensive);
        assert (((SplitFrameModel.SplitFrameParameters)this._parms)._ratios.length > 0) : "No ratio specified!";
        assert (((SplitFrameModel.SplitFrameParameters)this._parms)._ratios.length < 100) : "Too many frame splits demanded!";
        for (double p : ((SplitFrameModel.SplitFrameParameters)this._parms)._ratios) {
            if (!(p < 0.0) && !(p > 1.0)) continue;
            this.error("ratios", "Ratios must be between 0 and 1");
        }
    }

    private Vec[][] makeTemplates(Frame dataset, double[] ratios) {
        Vec anyVec = dataset.anyVec();
        long[][] espcPerSplit = SplitFrame.computeEspcPerSplit(anyVec._espc, anyVec.length(), ratios);
        int num = dataset.numCols();
        int nsplits = espcPerSplit.length;
        String[][] domains = dataset.domains();
        byte[] types = new byte[num];
        int j = 0;
        for (Vec v : dataset.vecs()) {
            types[j++] = v.get_type();
        }
        Vec[][] t = new Vec[nsplits][];
        for (int i = 0; i < nsplits; ++i) {
            t[i] = new Vec(Vec.newKey(), espcPerSplit[i]).makeCons(num, 0L, domains, types);
        }
        return t;
    }

    static long[][] computeEspcPerSplit(long[] espc, long len, double[] ratios) {
        assert (espc.length > 0 && espc[0] == 0L);
        assert (espc[espc.length - 1] == len);
        long[] partSizes = SplitFrame.partitione(len, ratios);
        int nparts = ratios.length + 1;
        long[][] r = new long[nparts][espc.length];
        long nrows = 0L;
        long start = 0L;
        int c = 0;
        for (int p = 0; p < nparts; ++p) {
            int nc = 0;
            while (c < espc.length - 1 && espc[c + 1] - start <= partSizes[p]) {
                r[p][++nc] = espc[c + 1] - start;
                ++c;
            }
            if (r[p][nc] < partSizes[p]) {
                r[p][++nc] = partSizes[p];
            }
            r[p] = Arrays.copyOf(r[p], nc + 1);
            nrows -= partSizes[p];
            start += partSizes[p];
        }
        return r;
    }

    static long[] partitione(long len, double[] ratio) {
        long[] r = new long[ratio.length + 1];
        long sum = 0L;
        int i = 0;
        float sr = 0.0f;
        for (i = 0; i < ratio.length; ++i) {
            r[i] = (int)(ratio[i] * (double)len);
            sum += r[i];
            sr = (float)((double)sr + ratio[i]);
        }
        if (sr < 1.0f) {
            r[i] = len - sum;
        } else {
            int n = i - 1;
            r[n] = r[n] + (len - sum);
        }
        return r;
    }

    private static class FrameSplitTask
    extends MRTask<FrameSplitTask> {
        final Vec[] _srcVecs;
        final double[] _ratios;
        final int _partIdx;
        transient int _pcidx;
        transient int _psrow;

        public FrameSplitTask(H2O.H2OCountedCompleter completer, Vec[] srcVecs, double[] ratios, int partIdx) {
            super(completer);
            this._srcVecs = srcVecs;
            this._ratios = ratios;
            this._partIdx = partIdx;
        }

        protected void setupLocal() {
            Vec anyInVec = this._srcVecs[0];
            long[] partSizes = SplitFrame.partitione(anyInVec.length(), this._ratios);
            long pnrows = 0L;
            for (int p = 0; p < this._partIdx; ++p) {
                pnrows += partSizes[p];
            }
            long[] espc = anyInVec._espc;
            while (this._pcidx < espc.length - 1 && (pnrows -= espc[this._pcidx + 1] - espc[this._pcidx]) > 0L) {
                ++this._pcidx;
            }
            assert (pnrows <= 0L);
            this._psrow = (int)(pnrows + espc[this._pcidx + 1] - espc[this._pcidx]);
        }

        public void map(Chunk[] cs) {
            int coutidx = cs[0].cidx();
            int cinidx = this._pcidx + coutidx;
            int startRow = coutidx > 0 ? 0 : this._psrow;
            int nrows = cs[0]._len;
            for (int i = 0; i < cs.length; ++i) {
                ChunkSplitter.extractChunkPart((Chunk)this._srcVecs[i].chunkForChunkIdx(cinidx), (Chunk)cs[i], (int)startRow, (int)nrows, (Futures)this._fs);
            }
        }
    }

    private class SplitFrameDriver
    extends H2O.H2OCountedCompleter<SplitFrameDriver> {
        private Throwable[] workersExceptions;

        private SplitFrameDriver() {
        }

        protected void compute2() {
            boolean exceptional;
            Frame dataset = ((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms).train();
            ((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms).read_lock_frames((Job)SplitFrame.this);
            SplitFrame.this.init(true);
            Key[] keyArray = ((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms)._destKeys = ((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms)._destKeys != null ? ((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms)._destKeys : FrameUtils.generateNumKeys((Key)dataset._key, (int)(((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms)._ratios.length + 1));
            assert (((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms)._destKeys.length == ((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms)._ratios.length + 1) : "Unexpected number of destination keys.";
            final SplitFrameModel model = new SplitFrameModel(SplitFrame.this.dest(), (SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms, new SplitFrameModel.SplitFrameOutput(SplitFrame.this));
            Vec[][] templates = SplitFrame.this.makeTemplates(dataset, ((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms)._ratios);
            final int nsplits = templates.length;
            assert (nsplits == ((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms)._ratios.length + 1) : "Unexpected number of split templates!";
            final Vec[] datasetVecs = dataset.vecs();
            ((SplitFrameModel.SplitFrameOutput)model._output)._splits = new Frame[nsplits];
            for (int s = 0; s < nsplits; ++s) {
                Frame split = new Frame(((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms)._destKeys[s], dataset.names(), templates[s]);
                split.delete_and_lock(SplitFrame.this._key);
                ((SplitFrameModel.SplitFrameOutput)model._output)._splits[s] = split;
            }
            model.delete_and_lock(SplitFrame.this._key);
            this.setPendingCount(1);
            H2O.submitTask((H2O.H2OCountedCompleter)new H2O.H2OCountedCompleter(this){

                public void compute2() {
                    this.setPendingCount(nsplits);
                    for (int s = 0; s < nsplits; ++s) {
                        new FrameSplitTask(new H2O.H2OCountedCompleter(this){

                            public void compute2() {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
                                SplitFrameDriver splitFrameDriver = SplitFrameDriver.this;
                                synchronized (splitFrameDriver) {
                                    SplitFrameDriver.access$202(SplitFrameDriver.this, SplitFrameDriver.this.workersExceptions != null ? Arrays.copyOf(SplitFrameDriver.this.workersExceptions, SplitFrameDriver.this.workersExceptions.length + 1) : new Throwable[1]);
                                    ((SplitFrameDriver)SplitFrameDriver.this).workersExceptions[((SplitFrameDriver)SplitFrameDriver.this).workersExceptions.length - 1] = ex;
                                }
                                this.tryComplete();
                                return false;
                            }
                        }, datasetVecs, ((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms)._ratios, s).asyncExec(((SplitFrameModel.SplitFrameOutput)model._output)._splits[s]);
                    }
                    this.tryComplete();
                }
            });
            this.tryComplete();
            model.unlock(SplitFrame.this._key);
            ((SplitFrameModel.SplitFrameParameters)SplitFrame.this._parms).read_unlock_frames((Job)SplitFrame.this);
            boolean bl = exceptional = this.workersExceptions != null;
            if (((SplitFrameModel.SplitFrameOutput)model._output)._splits != null) {
                for (Frame s : ((SplitFrameModel.SplitFrameOutput)model._output)._splits) {
                    if (s == null) continue;
                    if (!exceptional) {
                        s.update(SplitFrame.this._key);
                        s.unlock(SplitFrame.this._key);
                        continue;
                    }
                    s.unlock(SplitFrame.this._key);
                    s.delete(SplitFrame.this._key, new Futures()).blockForPending();
                }
            }
            SplitFrame.this.done();
        }

        static /* synthetic */ Throwable[] access$202(SplitFrameDriver x0, Throwable[] x1) {
            x0.workersExceptions = x1;
            return x1;
        }
    }
}

