/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelMetrics;
import hex.kmeans.KMeans;
import hex.kmeans.ModelMetricsKMeans;
import hex.schemas.KMeansModelV2;
import water.Key;
import water.api.ModelSchema;
import water.fvec.Frame;
import water.util.TwoDimTable;

public class KMeansModel
extends Model<KMeansModel, KMeansParameters, KMeansOutput> {
    public KMeansModel(Key selfKey, KMeansParameters parms, KMeansOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        assert (domain == null);
        return new ModelMetricsKMeans.MetricBuilderKMeans(((KMeansOutput)this._output).nfeatures());
    }

    public ModelSchema schema() {
        return new KMeansModelV2();
    }

    protected float[] score0(double[] data, float[] preds) {
        preds[0] = KMeans.closest(((KMeansOutput)this._output)._centers_raw, data, ((KMeansOutput)this._output)._categorical_column_count);
        return preds;
    }

    public static class KMeansOutput
    extends Model.Output {
        public int _categorical_column_count;
        public int _iterations;
        public TwoDimTable _centers;
        public double[][] _centers_raw;
        public long[] _size;
        public double[] _within_mse;
        public double _avg_within_ss;
        public double _avg_ss;
        public double _avg_between_ss;

        public KMeansOutput(KMeans b) {
            super((ModelBuilder)b);
        }

        public Model.ModelCategory getModelCategory() {
            return Model.ModelCategory.Clustering;
        }
    }

    public static class KMeansParameters
    extends Model.Parameters {
        public int _k = 1;
        public int _max_iterations = 1000;
        public boolean _standardize = true;
        public long _seed = System.nanoTime();
        public KMeans.Initialization _init = KMeans.Initialization.Furthest;
        Key<Frame> _user_points;
    }
}

