/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.Model;
import hex.ModelBuilder;
import hex.kmeans.KMeansModel;
import hex.schemas.KMeansV2;
import hex.schemas.ModelBuilderSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import water.H2O;
import water.Job;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public class KMeans
extends ModelBuilder<KMeansModel, KMeansModel.KMeansParameters, KMeansModel.KMeansOutput> {
    private int _ncats;
    private final double TOLERANCE = 1.0E-6;

    public Model.ModelCategory[] can_build() {
        return new Model.ModelCategory[]{Model.ModelCategory.Clustering};
    }

    public KMeans(KMeansModel.KMeansParameters parms) {
        super("K-means", (Model.Parameters)parms);
        this.init(false);
    }

    public ModelBuilderSchema schema() {
        return new KMeansV2();
    }

    public Job<KMeansModel> trainModel() {
        return this.start(new KMeansDriver(), ((KMeansModel.KMeansParameters)this._parms)._max_iterations);
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((KMeansModel.KMeansParameters)this._parms)._k < 1 || ((KMeansModel.KMeansParameters)this._parms)._k > 10000000) {
            this.error("_k", "k must be between 1 and 1e7");
        }
        if (((KMeansModel.KMeansParameters)this._parms)._max_iterations < 0 || ((KMeansModel.KMeansParameters)this._parms)._max_iterations > 1000000) {
            this.error("_max_iterations", " max_iterations must be between 0 and 1e6");
        }
        if (this._train == null) {
            return;
        }
        if (this._train.numRows() < (long)((KMeansModel.KMeansParameters)this._parms)._k) {
            this.error("_k", "Cannot make " + ((KMeansModel.KMeansParameters)this._parms)._k + " clusters out of " + this._train.numRows() + " rows");
        }
        if (null != ((KMeansModel.KMeansParameters)this._parms)._user_points && ((Frame)((KMeansModel.KMeansParameters)this._parms)._user_points.get()).numCols() != this._train.numCols()) {
            this.error("_user_points", "The user-specified points must have the same number of columns (" + this._train.numCols() + ") as the training observations");
        }
        for (Vec v : this._train.vecs()) {
            if (!v.isEnum()) continue;
            this.error("_train", "Columns cannot have categorical values");
        }
        Vec[] vecs = this._train.vecs();
        int ncats = 0;
        int nvecs = vecs.length;
        while (ncats != nvecs) {
            while (ncats < nvecs && vecs[ncats].isEnum()) {
                ++ncats;
            }
            while (nvecs > 0 && !vecs[nvecs - 1].isEnum()) {
                --nvecs;
            }
            if (ncats >= nvecs - 1) continue;
            this._train.swap(ncats, nvecs - 1);
        }
        this._ncats = ncats;
    }

    private static double minSqr(double[][] centers, double[] point, int ncats, ClusterDist cd) {
        return KMeans.closest((double[][])centers, (double[])point, (int)ncats, (ClusterDist)cd, (int)centers.length)._dist;
    }

    private static double minSqr(double[][] centers, double[] point, int ncats, ClusterDist cd, int count) {
        return KMeans.closest((double[][])centers, (double[])point, (int)ncats, (ClusterDist)cd, (int)count)._dist;
    }

    private static ClusterDist closest(double[][] centers, double[] point, int ncats, ClusterDist cd) {
        return KMeans.closest(centers, point, ncats, cd, centers.length);
    }

    private static double distance(double[] center, double[] point, int ncats) {
        double d;
        int column;
        double sqr = 0.0;
        int pts = point.length;
        for (column = 0; column < ncats; ++column) {
            d = point[column];
            if (Double.isNaN(d)) {
                --pts;
                continue;
            }
            if (d == center[column]) continue;
            sqr += 1.0;
        }
        for (column = ncats; column < center.length; ++column) {
            d = point[column];
            if (Double.isNaN(d)) {
                --pts;
                continue;
            }
            double delta = d - center[column];
            sqr += delta * delta;
        }
        if (0 < pts && pts < point.length) {
            sqr *= (double)(point.length / pts);
        }
        return sqr;
    }

    private static ClusterDist closest(double[][] centers, double[] point, int ncats, ClusterDist cd, int count) {
        int min = -1;
        double minSqr = Double.MAX_VALUE;
        for (int cluster = 0; cluster < count; ++cluster) {
            double sqr = KMeans.distance(centers[cluster], point, ncats);
            if (!(sqr < minSqr)) continue;
            min = cluster;
            minSqr = sqr;
        }
        cd._cluster = min;
        cd._dist = minSqr;
        return cd;
    }

    static int closest(double[][] centers, double[] point, int ncats) {
        int min = -1;
        double minSqr = Double.MAX_VALUE;
        for (int cluster = 0; cluster < centers.length; ++cluster) {
            double sqr = KMeans.distance(centers[cluster], point, ncats);
            if (!(sqr < minSqr)) continue;
            min = cluster;
            minSqr = sqr;
        }
        return min;
    }

    private double[][] recluster(double[][] points, Random rand) {
        double[][] res = new double[((KMeansModel.KMeansParameters)this._parms)._k][];
        res[0] = points[0];
        int count = 1;
        ClusterDist cd = new ClusterDist();
        switch (((KMeansModel.KMeansParameters)this._parms)._init) {
            case Random: {
                break;
            }
            case PlusPlus: {
                block5: while (count < res.length) {
                    double sum = 0.0;
                    for (double[] point1 : points) {
                        sum += KMeans.minSqr(res, point1, this._ncats, cd, count);
                    }
                    for (double[] point : points) {
                        if (!(KMeans.minSqr(res, point, this._ncats, cd, count) >= rand.nextDouble() * sum)) continue;
                        res[count++] = point;
                        continue block5;
                    }
                }
                break;
            }
            case Furthest: {
                while (count < res.length) {
                    double max = 0.0;
                    int index = 0;
                    for (int i = 0; i < points.length; ++i) {
                        double sqr = KMeans.minSqr(res, points[i], this._ncats, cd, count);
                        if (!(sqr > max)) continue;
                        max = sqr;
                        index = i;
                    }
                    res[count++] = points[index];
                }
                break;
            }
            default: {
                throw H2O.fail();
            }
        }
        return res;
    }

    private void randomRow(Vec[] vecs, Random rand, double[] center, double[] means, double[] mults) {
        long row = Math.max(0L, (long)(rand.nextDouble() * (double)vecs[0].length()) - 1L);
        KMeans.data(center, vecs, row, means, mults);
    }

    private static boolean standardize(double sigma) {
        return sigma > 1.0E-6;
    }

    private static double[][] max_cats(double[][] centers, long[][][] cats) {
        int K = cats.length;
        int ncats = cats[0].length;
        for (int clu = 0; clu < K; ++clu) {
            for (int col = 0; col < ncats; ++col) {
                centers[clu][col] = ArrayUtils.maxIndex((long[])cats[clu][col]);
            }
        }
        return centers;
    }

    private static double[][] destandardize(double[][] centers, int ncats, double[] means, double[] mults) {
        int K = centers.length;
        int N = centers[0].length;
        double[][] value = new double[K][N];
        for (int clu = 0; clu < K; ++clu) {
            System.arraycopy(centers[clu], 0, value[clu], 0, N);
            if (mults == null) continue;
            for (int col = ncats; col < N; ++col) {
                value[clu][col] = value[clu][col] / mults[col] + means[col];
            }
        }
        return value;
    }

    private static void data(double[] values, Vec[] vecs, long row, double[] means, double[] mults) {
        for (int i = 0; i < values.length; ++i) {
            double d = vecs[i].at(row);
            values[i] = KMeans.data(d, i, means, mults, vecs[i].cardinality());
        }
    }

    private static void data(double[] values, Chunk[] chks, int row, double[] means, double[] mults) {
        for (int i = 0; i < values.length; ++i) {
            double d = chks[i].atd(row);
            values[i] = KMeans.data(d, i, means, mults, chks[i].vec().cardinality());
        }
    }

    private static double data(double d, int i, double[] means, double[] mults, int cardinality) {
        if (cardinality == -1) {
            if (Double.isNaN(d)) {
                d = means[i];
            }
            if (mults != null) {
                d -= means[i];
                d *= mults[i];
            }
        } else if (Double.isNaN(d)) {
            d = Math.min(Math.round(means[i]), (long)(cardinality - 1));
        }
        return d;
    }

    private static final class ClusterDist {
        int _cluster;
        double _dist;

        private ClusterDist() {
        }
    }

    private static class Lloyds
    extends MRTask<Lloyds> {
        double[][] _centers;
        double[] _means;
        double[] _mults;
        final int _ncats;
        final int _k;
        double[][] _cMeans;
        long[][][] _cats;
        double[] _cSqr;
        long[] _size;
        long _worst_row;
        double _worst_err;

        Lloyds(double[][] centers, double[] means, double[] mults, int ncats, int k) {
            this._centers = centers;
            this._means = means;
            this._mults = mults;
            this._ncats = ncats;
            this._k = k;
        }

        public void map(Chunk[] cs) {
            int N = cs.length;
            assert (this._centers[0].length == N);
            this._cMeans = new double[this._k][N];
            this._cSqr = new double[this._k];
            this._size = new long[this._k];
            this._cats = new long[this._k][this._ncats][];
            for (int clu = 0; clu < this._k; ++clu) {
                for (int col = 0; col < this._ncats; ++col) {
                    this._cats[clu][col] = new long[cs[col].vec().cardinality()];
                }
            }
            this._worst_err = 0.0;
            double[] values = new double[N];
            ClusterDist cd = new ClusterDist();
            for (int row = 0; row < cs[0]._len; ++row) {
                int col;
                KMeans.data(values, cs, row, this._means, this._mults);
                KMeans.closest(this._centers, values, this._ncats, cd);
                int clu = cd._cluster;
                assert (clu != -1);
                int n = clu;
                this._cSqr[n] = this._cSqr[n] + cd._dist;
                for (col = 0; col < this._ncats; ++col) {
                    long[] lArray = this._cats[clu][col];
                    int n2 = (int)values[col];
                    lArray[n2] = lArray[n2] + 1L;
                }
                for (col = this._ncats; col < N; ++col) {
                    double[] dArray = this._cMeans[clu];
                    int n3 = col;
                    dArray[n3] = dArray[n3] + values[col];
                }
                int n4 = clu;
                this._size[n4] = this._size[n4] + 1L;
                if (!(cd._dist > this._worst_err)) continue;
                this._worst_err = cd._dist;
                this._worst_row = cs[0].start() + (long)row;
            }
            for (int clu = 0; clu < this._k; ++clu) {
                if (this._size[clu] == 0L) continue;
                ArrayUtils.div((double[])this._cMeans[clu], (double)this._size[clu]);
            }
            this._centers = null;
            this._mults = null;
            this._means = null;
        }

        public void reduce(Lloyds mr) {
            for (int clu = 0; clu < this._k; ++clu) {
                long ra = this._size[clu];
                long rb = mr._size[clu];
                double[] ma = this._cMeans[clu];
                double[] mb = mr._cMeans[clu];
                for (int c = 0; c < ma.length; ++c) {
                    if (ra + rb <= 0L) continue;
                    ma[c] = (ma[c] * (double)ra + mb[c] * (double)rb) / (double)(ra + rb);
                }
            }
            ArrayUtils.add((long[][][])this._cats, (long[][][])mr._cats);
            ArrayUtils.add((double[])this._cSqr, (double[])mr._cSqr);
            ArrayUtils.add((long[])this._size, (long[])mr._size);
            if (this._worst_err < mr._worst_err) {
                this._worst_err = mr._worst_err;
                this._worst_row = mr._worst_row;
            }
        }
    }

    private static class Sampler
    extends MRTask<Sampler> {
        double[][] _centers;
        double[] _means;
        double[] _mults;
        final int _ncats;
        final double _sqr;
        final double _probability;
        final long _seed;
        double[][] _sampled;

        Sampler(double[][] centers, double[] means, double[] mults, int ncats, double sqr, double prob, long seed) {
            this._centers = centers;
            this._means = means;
            this._mults = mults;
            this._ncats = ncats;
            this._sqr = sqr;
            this._probability = prob;
            this._seed = seed;
        }

        public void map(Chunk[] cs) {
            double[] values = new double[cs.length];
            ArrayList<Object> list = new ArrayList<Object>();
            Random rand = RandomUtils.getRNG((long[])new long[]{this._seed + cs[0].start()});
            ClusterDist cd = new ClusterDist();
            for (int row = 0; row < cs[0]._len; ++row) {
                KMeans.data(values, cs, row, this._means, this._mults);
                double sqr = KMeans.minSqr(this._centers, values, this._ncats, cd);
                if (!(this._probability * sqr > rand.nextDouble() * this._sqr)) continue;
                list.add(values.clone());
            }
            this._sampled = new double[list.size()][];
            list.toArray((T[])this._sampled);
            this._centers = null;
            this._mults = null;
            this._means = null;
        }

        public void reduce(Sampler other) {
            this._sampled = ArrayUtils.append((double[][])this._sampled, (double[][])other._sampled);
        }
    }

    private static class SumSqr
    extends MRTask<SumSqr> {
        double[][] _centers;
        double[] _means;
        double[] _mults;
        final int _ncats;
        double _sqr;

        SumSqr(double[][] centers, double[] means, double[] mults, int ncats) {
            this._centers = centers;
            this._means = means;
            this._mults = mults;
            this._ncats = ncats;
        }

        public void map(Chunk[] cs) {
            double[] values = new double[cs.length];
            ClusterDist cd = new ClusterDist();
            for (int row = 0; row < cs[0]._len; ++row) {
                KMeans.data(values, cs, row, this._means, this._mults);
                this._sqr += KMeans.minSqr(this._centers, values, this._ncats, cd);
            }
            this._mults = null;
            this._means = null;
            this._centers = null;
        }

        public void reduce(SumSqr other) {
            this._sqr += other._sqr;
        }
    }

    private static class TotSS
    extends MRTask<TotSS> {
        double[] _means;
        double[] _mults;
        double _tss;

        TotSS(double[] means, double[] mults) {
            this._means = means;
            this._mults = mults;
            this._tss = 0.0;
        }

        public void map(Chunk[] cs) {
            for (int row = 0; row < cs[0]._len; ++row) {
                for (int i = 0; i < cs.length; ++i) {
                    double d = cs[i].atd(row);
                    if (Double.isNaN(d)) continue;
                    d = (d - this._means[i]) * (this._mults == null ? 1.0 : this._mults[i]);
                    this._tss += d * d;
                }
            }
            this._means = null;
        }

        public void reduce(TotSS other) {
            this._tss += other._tss;
        }
    }

    private class KMeansDriver
    extends H2O.H2OCountedCompleter<KMeansDriver> {
        private transient int _reinit_attempts;

        private KMeansDriver() {
        }

        double[] prepMeans(Vec[] vecs) {
            double[] means = new double[vecs.length];
            for (int i = 0; i < vecs.length; ++i) {
                means[i] = vecs[i].mean();
            }
            return means;
        }

        double[] prepMults(Vec[] vecs) {
            if (!((KMeansModel.KMeansParameters)KMeans.this._parms)._standardize) {
                return null;
            }
            double[] mults = new double[vecs.length];
            for (int i = 0; i < vecs.length; ++i) {
                double sigma = vecs[i].sigma();
                mults[i] = KMeans.standardize(sigma) ? 1.0 / sigma : 1.0;
            }
            return mults;
        }

        double[][] initial_centers(KMeansModel model, Vec[] vecs, double[] means, double[] mults) {
            double[][] centers;
            Random rand = RandomUtils.getRNG((long[])new long[]{((KMeansModel.KMeansParameters)KMeans.this._parms)._seed - 1L});
            if (null != ((KMeansModel.KMeansParameters)KMeans.this._parms)._user_points) {
                int numCenters = ((KMeansModel.KMeansParameters)KMeans.this._parms)._k;
                int numCols = ((Frame)((KMeansModel.KMeansParameters)KMeans.this._parms)._user_points.get()).numCols();
                centers = new double[numCenters][numCols];
                Vec[] centersVecs = ((Frame)((KMeansModel.KMeansParameters)KMeans.this._parms)._user_points.get()).vecs();
                for (int r = 0; r < numCenters; ++r) {
                    for (int c = 0; c < numCols; ++c) {
                        centers[r][c] = centersVecs[c].at((long)r);
                        centers[r][c] = KMeans.data(centers[r][c], c, means, mults, vecs[c].cardinality());
                    }
                }
            } else if (((KMeansModel.KMeansParameters)KMeans.this._parms)._init == Initialization.Random) {
                for (double[] center : centers = new double[((KMeansModel.KMeansParameters)KMeans.this._parms)._k][KMeans.this._train.numCols()]) {
                    KMeans.this.randomRow(vecs, rand, center, means, mults);
                }
            } else {
                centers = new double[1][vecs.length];
                KMeans.this.randomRow(vecs, rand, centers[0], means, mults);
                while (((KMeansModel.KMeansOutput)model._output)._iterations < 5) {
                    SumSqr sqr = (SumSqr)new SumSqr(centers, means, mults, KMeans.this._ncats).doAll(vecs);
                    Sampler sampler = (Sampler)new Sampler(centers, means, mults, KMeans.this._ncats, sqr._sqr, ((KMeansModel.KMeansParameters)KMeans.this._parms)._k * 3, ((KMeansModel.KMeansParameters)KMeans.this._parms)._seed).doAll(vecs);
                    centers = ArrayUtils.append((double[][])centers, (double[][])sampler._sampled);
                    if (!KMeans.this.isRunning()) {
                        return null;
                    }
                    ((KMeansModel.KMeansOutput)model._output)._centers_raw = KMeans.destandardize(centers, KMeans.this._ncats, means, mults);
                    ((KMeansModel.KMeansOutput)model._output)._avg_within_ss = sqr._sqr / (double)KMeans.this._train.numRows();
                    ++((KMeansModel.KMeansOutput)model._output)._iterations;
                    model.update(KMeans.this._key);
                }
                centers = KMeans.this.recluster(centers, rand);
                ((KMeansModel.KMeansOutput)model._output)._iterations = -1;
            }
            return centers;
        }

        boolean cleanupBadClusters(Lloyds task, Vec[] vecs, double[][] centers, double[] means, double[] mults) {
            int clu;
            for (clu = 0; clu < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k && task._size[clu] != 0L; ++clu) {
            }
            if (clu == ((KMeansModel.KMeansParameters)KMeans.this._parms)._k) {
                return false;
            }
            long row = task._worst_row;
            Log.warn((Object[])new Object[]{"KMeans: Re-initializing cluster " + clu + " to row " + row});
            centers[clu] = task._cMeans[clu];
            KMeans.data(centers[clu], vecs, row, means, mults);
            task._size[clu] = 1L;
            for (clu = 0; clu < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k && task._size[clu] != 0L; ++clu) {
            }
            if (clu == ((KMeansModel.KMeansParameters)KMeans.this._parms)._k) {
                return false;
            }
            Log.warn((Object[])new Object[]{"KMeans: Re-running Lloyds to re-init another cluster"});
            if (this._reinit_attempts++ < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k) {
                return true;
            }
            this._reinit_attempts = 0;
            return false;
        }

        double[][] computeStatsFillModel(Lloyds task, KMeansModel model, Vec[] vecs, double[][] centers, double[] means, double[] mults) {
            ((KMeansModel.KMeansOutput)model._output)._centers_raw = KMeans.destandardize(centers, KMeans.this._ncats, means, mults);
            String[] rowHeaders = new String[((KMeansModel.KMeansParameters)KMeans.this._parms)._k];
            for (int i = 0; i < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k; ++i) {
                rowHeaders[i] = String.valueOf(i + 1);
            }
            Object[] colTypes = new String[KMeans.this._train.numCols()];
            Arrays.fill(colTypes, "double");
            ((KMeansModel.KMeansOutput)model._output)._centers = new TwoDimTable("Cluster means", rowHeaders, KMeans.this._train.names(), (String[])colTypes, null, (String[][])new String[((KMeansModel.KMeansParameters)KMeans.this._parms)._k][], ((KMeansModel.KMeansOutput)model._output)._centers_raw);
            ((KMeansModel.KMeansOutput)model._output)._size = task._size;
            ((KMeansModel.KMeansOutput)model._output)._within_mse = task._cSqr;
            double ssq = 0.0;
            for (int i = 0; i < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k; ++i) {
                ssq += ((KMeansModel.KMeansOutput)model._output)._within_mse[i];
                int n = i;
                ((KMeansModel.KMeansOutput)model._output)._within_mse[n] = ((KMeansModel.KMeansOutput)model._output)._within_mse[n] / (double)task._size[i];
            }
            ((KMeansModel.KMeansOutput)model._output)._avg_within_ss = ssq / (double)KMeans.this._train.numRows();
            if (((KMeansModel.KMeansParameters)KMeans.this._parms)._k == 1) {
                ((KMeansModel.KMeansOutput)model._output)._avg_ss = ((KMeansModel.KMeansOutput)model._output)._avg_within_ss;
            } else {
                TotSS totss = (TotSS)new TotSS(means, mults).doAll(vecs);
                ((KMeansModel.KMeansOutput)model._output)._avg_ss = totss._tss / (double)KMeans.this._train.numRows();
            }
            ((KMeansModel.KMeansOutput)model._output)._avg_between_ss = ((KMeansModel.KMeansOutput)model._output)._avg_ss - ((KMeansModel.KMeansOutput)model._output)._avg_within_ss;
            return task._cMeans;
        }

        boolean isDone(KMeansModel model, double[][] newCenters, double[][] oldCenters) {
            if (!KMeans.this.isRunning()) {
                return true;
            }
            if (((KMeansModel.KMeansOutput)model._output)._iterations > ((KMeansModel.KMeansParameters)KMeans.this._parms)._max_iterations) {
                return true;
            }
            if (oldCenters == null) {
                return false;
            }
            double average_change = 0.0;
            for (int clu = 0; clu < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k; ++clu) {
                average_change += KMeans.distance(oldCenters[clu], newCenters[clu], KMeans.this._ncats);
            }
            return (average_change /= (double)((KMeansModel.KMeansParameters)KMeans.this._parms)._k) < 1.0E-6;
        }

        protected void compute2() {
            KMeansModel model = null;
            try {
                ((KMeansModel.KMeansParameters)KMeans.this._parms).read_lock_frames((Job)KMeans.this);
                KMeans.this.init(true);
                if (KMeans.this.error_count() > 0) {
                    throw new IllegalArgumentException("Found validation errors: " + KMeans.this.validationErrors());
                }
                model = new KMeansModel(KMeans.this.dest(), (KMeansModel.KMeansParameters)KMeans.this._parms, new KMeansModel.KMeansOutput(KMeans.this));
                model.delete_and_lock(KMeans.this._key);
                ((KMeansModel.KMeansOutput)model._output)._categorical_column_count = KMeans.this._ncats;
                Vec[] vecs = KMeans.this._train.vecs();
                double[] means = this.prepMeans(vecs);
                double[] mults = this.prepMults(vecs);
                double[][] centers = this.initial_centers(model, vecs, means, mults);
                if (centers == null) {
                    return;
                }
                double[][] oldCenters = null;
                while (!this.isDone(model, centers, oldCenters)) {
                    Lloyds task = (Lloyds)new Lloyds(centers, means, mults, KMeans.this._ncats, ((KMeansModel.KMeansParameters)KMeans.this._parms)._k).doAll(vecs);
                    KMeans.max_cats(task._cMeans, task._cats);
                    if (this.cleanupBadClusters(task, vecs, centers, means, mults)) continue;
                    oldCenters = centers;
                    centers = this.computeStatsFillModel(task, model, vecs, centers, means, mults);
                    ++((KMeansModel.KMeansOutput)model._output)._iterations;
                    model.update(KMeans.this._key);
                    KMeans.this.update(1L);
                }
                KMeans.this.done();
            }
            catch (Throwable t) {
                t.printStackTrace();
                KMeans.this.failed(t);
                throw t;
            }
            finally {
                if (model != null) {
                    model.unlock(KMeans.this._key);
                }
                ((KMeansModel.KMeansParameters)KMeans.this._parms).read_unlock_frames((Job)KMeans.this);
            }
            this.tryComplete();
        }
    }

    public static enum Initialization {
        Random,
        PlusPlus,
        Furthest,
        User;

    }
}

