/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import hex.tree.SharedTree;
import hex.tree.SharedTreeModel;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.ModelUtils;

public class Score
extends MRTask<Score> {
    final SharedTree _bldr;
    final boolean _oob;
    final Model.ModelCategory _mcat;
    ModelMetrics.MetricBuilder _mb;

    public Score(SharedTree bldr, boolean oob, Model.ModelCategory mcat) {
        this._bldr = bldr;
        this._oob = oob;
        this._mcat = mcat;
    }

    public void map(Chunk[] chks) {
        Chunk ys = this._bldr.chk_resp(chks);
        int nclass = this._bldr._nclass;
        String[] domain = this._bldr.vresponse().domain();
        int oobColIdx = this._bldr.idx_oobt();
        this._mb = ((SharedTreeModel)((Object)this._bldr._model)).makeMetricBuilder(domain);
        float[] cdists = this._mb._work;
        double[] tmp = this._bldr._parms._valid != null ? new double[this._bldr._ncols] : null;
        float[] val = new float[1];
        for (int row = 0; row < ys._len; ++row) {
            if (ys.isNA(row) || this._oob && chks[oobColIdx].at8(row) != 0L) continue;
            if (this._bldr._parms._valid != null) {
                this._bldr._model.score0(chks, row, tmp, cdists);
            } else {
                this._bldr.score2(chks, cdists, row);
            }
            if (nclass > 1) {
                cdists[0] = ModelUtils.getPrediction((float[])cdists, (int)row);
            }
            val[0] = (float)ys.atd(row);
            this._mb.perRow(cdists, val, this._bldr._model);
        }
    }

    public void reduce(Score t) {
        this._mb.reduce(t._mb);
    }

    ModelMetricsSupervised makeModelMetrics(SharedTreeModel model, Frame fr, String resp) {
        return (ModelMetricsSupervised)this._mb.makeModelMetrics((Model)model, fr, fr.vec(resp).sigma());
    }
}

