/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.FrameTask;
import hex.Model;
import hex.SupervisedModel;
import hex.SupervisedModelBuilder;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import hex.glm.GLMValidation;
import hex.glm.LSMSolver;
import hex.optimization.L_BFGS;
import hex.schemas.GLMV2;
import hex.schemas.ModelBuilderSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import jsr166y.CountedCompleter;
import water.DKV;
import water.DTask;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MRUtils;
import water.util.MathUtils;
import water.util.ModelUtils;

public class GLM
extends SupervisedModelBuilder<GLMModel, GLMModel.GLMParameters, GLMModel.GLMOutput> {
    private static final int WORK_TOTAL = 100000000;
    private boolean _clean_enums;
    private static double GLM_GRAD_EPS = 1.0E-4;
    private static final int MAX_ITERATIONS_PER_LAMBDA = 10;
    private static final int MAX_ITER = 50;
    private static final int sparseCoefThreshold = 750;
    private static final double beta_epsilon = 1.0E-4;

    public Model.ModelCategory[] can_build() {
        return new Model.ModelCategory[]{Model.ModelCategory.Regression};
    }

    public GLM(Key dest, String desc, GLMModel.GLMParameters parms) {
        super(dest, desc, (SupervisedModel.SupervisedParameters)parms);
        this.init(false);
    }

    public GLM(GLMModel.GLMParameters parms) {
        super("GLM", (SupervisedModel.SupervisedParameters)parms);
        this.init(false);
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (expensive && ((GLMModel.GLMParameters)this._parms)._link == GLMModel.GLMParameters.Link.family_default) {
            ((GLMModel.GLMParameters)this._parms)._link = ((GLMModel.GLMParameters)this._parms)._family.defaultLink;
        }
        ((GLMModel.GLMParameters)this._parms).validate(this);
    }

    public ModelBuilderSchema schema() {
        return new GLMV2();
    }

    public Job<GLMModel> trainModel() {
        this._clean_enums = ((GLMModel.GLMParameters)this._parms)._convert_to_enum && !this._response.isEnum();
        ((GLMModel.GLMParameters)this._parms).read_lock_frames((Job)this);
        this.init(true);
        FrameTask.DataInfo dinfo = new FrameTask.DataInfo(Key.make(), this._train, this._valid, 1, ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels || ((GLMModel.GLMParameters)this._parms)._lambda_search, ((GLMModel.GLMParameters)this._parms)._standardize ? FrameTask.DataInfo.TransformType.STANDARDIZE : FrameTask.DataInfo.TransformType.NONE, FrameTask.DataInfo.TransformType.NONE);
        DKV.put((Key)dinfo._key, (Iced)dinfo);
        H2O.H2OCountedCompleter cmp = new H2O.H2OCountedCompleter(){
            AtomicBoolean _gotException = new AtomicBoolean(false);

            public void compute2() {
            }

            public void onCompletion(CountedCompleter cc) {
                GLM.this.done();
                ((GLMModel.GLMParameters)GLM.this._parms).read_unlock_frames((Job)GLM.this);
                if (GLM.this._clean_enums) {
                    GLM.this.train().lastVec().remove();
                    if (GLM.this.valid() != null) {
                        GLM.this.valid().lastVec().remove();
                    }
                }
            }

            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter cc) {
                if (!this._gotException.getAndSet(true)) {
                    Job thisJob = (Job)DKV.getGet((Key)GLM.this._key);
                    if (thisJob._state == Job.JobState.CANCELLED) {
                        GLM.this.failed(ex);
                    }
                    ((GLMModel.GLMParameters)GLM.this._parms).read_unlock_frames((Job)GLM.this);
                    if (GLM.this._clean_enums) {
                        GLM.this.train().lastVec().remove();
                        if (GLM.this.valid() != null) {
                            GLM.this.valid().lastVec().remove();
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        this.start(cmp, 100000000L);
        H2O.submitTask((H2O.H2OCountedCompleter)new GLMDriver(cmp, dinfo));
        return this;
    }

    private static final double beta_diff(double[] b1, double[] b2) {
        if (b1 == null) {
            return Double.MAX_VALUE;
        }
        double res = b1[0] >= b2[0] ? b1[0] - b2[0] : b2[0] - b1[0];
        for (int i = 1; i < b1.length; ++i) {
            double diff = b1[i] - b2[i];
            if (diff > res) {
                res = diff;
                continue;
            }
            if (!(-diff > res)) continue;
            res = -diff;
        }
        return res;
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN) {
        assert (beta != null);
        if (activeCols == null) {
            return beta;
        }
        double[] res = MemoryManager.malloc8d((int)fullN);
        int i = 0;
        for (int c : activeCols) {
            res[c] = beta[i++];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static final double[] contractVec(double[] beta, int[] activeCols) {
        if (beta == null) {
            return null;
        }
        if (activeCols == null) {
            return (double[])beta.clone();
        }
        double[] res = MemoryManager.malloc8d((int)(activeCols.length + 1));
        int i = 0;
        for (int c : activeCols) {
            res[i++] = beta[c];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static final double[] resizeVec(double[] beta, int[] activeCols, int[] oldActiveCols, int fullN) {
        if (beta == null || Arrays.equals(activeCols, oldActiveCols)) {
            return beta;
        }
        double[] full = GLM.expandVec(beta, oldActiveCols, fullN);
        if (activeCols == null) {
            return full;
        }
        return GLM.contractVec(full, activeCols);
    }

    protected static double l1norm(double[] beta) {
        if (beta == null) {
            return 0.0;
        }
        double l1 = 0.0;
        for (int i = 0; i < beta.length - 1; ++i) {
            l1 += beta[i] < 0.0 ? -beta[i] : beta[i];
        }
        return l1;
    }

    private static double penalty(double[] beta, double alpha, double lambda) {
        return lambda * (alpha * GLM.l1norm(beta) + 0.5 * (1.0 - alpha) * ArrayUtils.l2norm((double[])beta, (boolean)true));
    }

    private static double objval(GLMTask.GLMIterationTask glmt, double alpha, double lambda) {
        return glmt._val.residual_deviance / (double)glmt._nobs + GLM.penalty(glmt._beta, alpha, lambda);
    }

    public static final class GLMGradientSolver
    extends L_BFGS.GradientSolver {
        final Key _jobKey = null;
        final GLMModel.GLMParameters _glmp;
        final FrameTask.DataInfo _dinfo;
        final double _ymu;
        final double _lambda;
        final long _nobs;

        public GLMGradientSolver(GLMModel.GLMParameters glmp, FrameTask.DataInfo dinfo, double lambda, double ymu, long nobs) {
            this._glmp = glmp;
            this._dinfo = dinfo;
            this._ymu = ymu;
            this._nobs = nobs;
            this._lambda = lambda;
        }

        @Override
        public L_BFGS.GradientInfo[] getGradient(double[][] betas) {
            double reg = 1.0 / (double)this._nobs;
            GLMTask.GLMIterationTask[] glmts = ((GLMTask.GLMLineSearchTask)new GLMTask.GLMLineSearchTask((Key)this._jobKey, (FrameTask.DataInfo)this._dinfo, (GLMModel.GLMParameters)this._glmp, (double[][])betas, (double)this._ymu, (long)this._nobs, null).doAll((Frame)this._dinfo._adaptedFrame))._glmts;
            L_BFGS.GradientInfo[] ginfos = new L_BFGS.GradientInfo[glmts.length];
            for (int i = 0; i < ginfos.length; ++i) {
                ginfos[i] = new GLMGradientInfo(glmts[i], this._lambda);
            }
            return ginfos;
        }
    }

    public static final class GLMGradientInfo
    extends L_BFGS.GradientInfo {
        public final GLMValidation _val;

        public GLMGradientInfo(GLMTask.GLMIterationTask t, double lambda) {
            super(t._val.residualDeviance() / (double)t._nobs + 0.5 * lambda * ArrayUtils.l2norm2((double[])t._beta, (boolean)true), t.gradient(0.0, lambda));
            this._val = t._val;
        }
    }

    public static final class GLMColBasedGradientSolver
    extends L_BFGS.GradientSolver {
        final Key _jobKey = null;
        final GLMModel.GLMParameters _glmp;
        final FrameTask.DataInfo _dinfo;
        final double _ymu;
        final double _lambda;
        final long _nobs;

        public GLMColBasedGradientSolver(GLMModel.GLMParameters glmp, FrameTask.DataInfo dinfo, double lambda, double ymu, long nobs) {
            this._glmp = glmp;
            this._dinfo = dinfo;
            this._ymu = ymu;
            this._nobs = nobs;
            this._lambda = lambda;
        }

        @Override
        public L_BFGS.GradientInfo[] getGradient(double[][] betas) {
            GLMTask.ColGradientTask gt = (GLMTask.ColGradientTask)new GLMTask.ColGradientTask(this._dinfo, this._glmp, betas, 1.0 / (double)this._nobs).doAll(this._dinfo._adaptedFrame);
            L_BFGS.GradientInfo[] ginfos = new L_BFGS.GradientInfo[betas.length];
            for (int i = 0; i < ginfos.length; ++i) {
                for (int j = 0; j < betas[i].length - 1; ++j) {
                    double[] dArray = gt._gradient[i];
                    int n = j;
                    dArray[n] = dArray[n] + this._lambda * betas[i][j];
                }
                ginfos[i] = new L_BFGS.GradientInfo(gt._objVals[i] + 0.5 * this._lambda * ArrayUtils.l2norm2((double[])betas[i], (boolean)true), gt._gradient[i]);
            }
            return ginfos;
        }
    }

    public final class GLMDriver
    extends DTask<GLMDriver> {
        final FrameTask.DataInfo _dinfo;
        transient ArrayList<FrameTask.DataInfo> _foldInfos;
        double[] lambdas;
        final GLMTaskInfo[] _state;
        int _lambdaId;
        int _maxLambda;
        transient AtomicBoolean _gotException;

        public GLMDriver(H2O.H2OCountedCompleter cmp, FrameTask.DataInfo dinfo) {
            super(cmp);
            this._foldInfos = new ArrayList();
            this._gotException = new AtomicBoolean();
            this._dinfo = dinfo;
            this._state = ((GLMModel.GLMParameters)GLM.this._parms)._n_folds > 1 ? new GLMTaskInfo[((GLMModel.GLMParameters)GLM.this._parms)._n_folds + 1] : new GLMTaskInfo[1];
        }

        private double[] nullBeta(FrameTask.DataInfo dinfo, GLMModel.GLMParameters params, double ymu) {
            double[] beta = MemoryManager.malloc8d((int)(dinfo.fullN() + 1));
            beta[beta.length - 1] = params.linkInv(ymu);
            return beta;
        }

        private void doCleanup() {
            DKV.remove((Key)this._dinfo._key);
            for (FrameTask.DataInfo dinfo : this._foldInfos) {
                DKV.remove((Key)dinfo._key);
            }
        }

        public boolean onExceptionalCompletion(Throwable ex, CountedCompleter cc) {
            this.doCleanup();
            if (!this._gotException.getAndSet(true)) {
                if (ex instanceof TooManyPredictorsException) {
                    this._maxLambda = this._lambdaId;
                    this.tryComplete();
                    return false;
                }
                new DTask.RemoveCall(null, GLM.this._dest).invokeTask();
                return true;
            }
            return false;
        }

        public void onCompletion(CountedCompleter cc) {
            this.doCleanup();
            H2O.H2OCountedCompleter cmp = (H2O.H2OCountedCompleter)this.getCompleter();
            cmp.addToPendingCount(1);
            new GLMModel.FinalizeAndUnlockTsk(cmp, GLM.this._dest, GLM.this._key).fork();
        }

        protected void compute2() {
            if (((GLMModel.GLMParameters)GLM.this._parms)._alpha.length > 1) {
                return;
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._nlambdas == -1) {
                ((GLMModel.GLMParameters)GLM.this._parms)._nlambdas = 100;
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._nlambdas <= 1) {
                throw new IllegalArgumentException("GLM2(" + GLM.this._dest + ") nlambdas must be > 1 when running with lambda search.");
            }
            Futures fs = new Futures();
            new GLMTask.YMUTask(GLM.this._key, this._dinfo._key, ((GLMModel.GLMParameters)GLM.this._parms)._n_folds, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.YMUTask>((H2O.H2OCountedCompleter)this){

                public String toString() {
                    return "YMUTask callback. completer = " + this.getCompleter() != null ? "null" : this.getCompleter().toString();
                }

                public void callback(final GLMTask.YMUTask ymut) {
                    long nobs;
                    double gYmu;
                    if (ymut._ymin == ymut._ymax) {
                        throw new IllegalArgumentException("GLM2(" + GLM.this._dest + "): attempted to run with constant response. Response == " + ymut._ymin + " for all rows in the training set.");
                    }
                    boolean skipNAs = true;
                    if ((double)ymut.nobs() / (double)GLMDriver.this._dinfo._adaptedFrame.numRows() < 0.75) {
                        skipNAs = false;
                        gYmu = GLMDriver.this._dinfo._adaptedFrame.lastVec().mean();
                        nobs = GLMDriver.this._dinfo._adaptedFrame.numRows();
                    } else {
                        gYmu = ymut.ymu();
                        nobs = ymut.nobs();
                    }
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.binomial && ((GLMModel.GLMParameters)GLM.this._parms)._prior != -1.0 && ((GLMModel.GLMParameters)GLM.this._parms)._prior != gYmu && !Double.isNaN(((GLMModel.GLMParameters)GLM.this._parms)._prior)) {
                        double ratio = ((GLMModel.GLMParameters)GLM.this._parms)._prior / gYmu;
                        double pi0 = 1.0;
                        double pi1 = 1.0;
                        if (ratio > 1.0) {
                            pi1 = 1.0 / ratio;
                        } else if (ratio < 1.0) {
                            pi0 = ratio;
                        }
                        double iceptAdjust = Math.log(pi0 / pi1);
                    } else {
                        ((GLMModel.GLMParameters)GLM.this._parms)._prior = gYmu;
                        double iceptAdjust = 0.0;
                    }
                    H2O.H2OCountedCompleter cmp = (H2O.H2OCountedCompleter)this.getCompleter();
                    cmp.addToPendingCount(1);
                    new GLMTask.LMAXTask(GLM.this._key, GLMDriver.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, gYmu, nobs, ModelUtils.DEFAULT_THRESHOLDS, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.LMAXTask>(cmp){

                        public String toString() {
                            return "LMAXTask callback. completer = " + (this.getCompleter() != null ? "NULL" : this.getCompleter().toString());
                        }

                        public void callback(final GLMTask.LMAXTask gLmax) {
                            GLMModel.GLMOutput glmOutput = new GLMModel.GLMOutput(GLM.this, GLMDriver.this._dinfo, ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.binomial);
                            String warning = null;
                            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                                assert (!Double.isNaN(gLmax.lmax())) : "running lambda_value search, but don't know what is the lambda_value max!";
                                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_min_ratio == -1.0) {
                                    ((GLMModel.GLMParameters)GLM.this._parms)._lambda_min_ratio = nobs > (long)(25 * GLMDriver.this._dinfo.fullN()) ? 1.0E-4 : 0.01;
                                }
                                double d = Math.pow(((GLMModel.GLMParameters)GLM.this._parms)._lambda_min_ratio, 1.0 / (double)(((GLMModel.GLMParameters)GLM.this._parms)._nlambdas - 1));
                                GLMDriver.this.lambdas = new double[((GLMModel.GLMParameters)GLM.this._parms)._nlambdas];
                                GLMDriver.this.lambdas[0] = gLmax.lmax();
                                if (((GLMModel.GLMParameters)GLM.this._parms)._nlambdas == 1) {
                                    throw new IllegalArgumentException("Number of lambdas must be > 1 when running with lambda_search!");
                                }
                                for (int i = 1; i < GLMDriver.this.lambdas.length; ++i) {
                                    GLMDriver.this.lambdas[i] = GLMDriver.this.lambdas[i - 1] * d;
                                }
                            } else {
                                int i;
                                GLMDriver.this.lambdas = ((GLMModel.GLMParameters)GLM.this._parms)._lambda == null || ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length == 0 ? new double[]{0.01 * gLmax.lmax()} : ((GLMModel.GLMParameters)GLM.this._parms)._lambda;
                                for (i = 0; i < GLMDriver.this.lambdas.length && GLMDriver.this.lambdas[i] >= gLmax.lmax(); ++i) {
                                }
                                if (i == GLMDriver.this.lambdas.length) {
                                    throw new IllegalArgumentException("Given lambda(s) are all > lambda_max = " + gLmax.lmax() + ", have nothing to run with. lambda = " + Arrays.toString(GLMDriver.this.lambdas));
                                }
                                if (i > 0) {
                                    warning = "Removed " + i + " lambdas greater than lambda_max.";
                                }
                                GLMDriver.this.lambdas = ArrayUtils.append((double[])new double[]{gLmax.lmax()}, (double[])Arrays.copyOfRange(GLMDriver.this.lambdas, i, GLMDriver.this.lambdas.length));
                            }
                            double nextLambda = GLMDriver.this.lambdas[1];
                            if (GLMDriver.this.lambdas.length > 1) {
                                glmOutput.addNullSubmodel(gLmax.lmax(), ((GLMModel.GLMParameters)GLM.this._parms).link(gYmu), gLmax._val);
                            }
                            GLMDriver.this._maxLambda = GLMDriver.this.lambdas.length;
                            GLMModel model = new GLMModel(GLM.this._dest, (GLMModel.GLMParameters)GLM.this._parms, glmOutput, GLMDriver.this._dinfo, gYmu, gLmax.lmax(), nobs);
                            if (warning != null) {
                                model.addWarning(warning);
                            }
                            model.delete_and_lock(GLM.this._key);
                            double lmax = gLmax.lmax();
                            GLMDriver.this._state[0] = new GLMTaskInfo(GLM.this._dest, GLMDriver.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, gLmax._nobs, gLmax._ymu, lmax, lmax, null, gLmax.gradient(((GLMModel.GLMParameters)GLM.this._parms)._alpha[0], lmax), GLM.objval(gLmax, ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0], gLmax.lmax()));
                            this.getCompleter().addToPendingCount(1);
                            if (((GLMModel.GLMParameters)GLM.this._parms)._n_folds > 1) {
                                H2O.H2OCallback cmp = new H2O.H2OCallback((H2O.H2OCountedCompleter)this.getCompleter()){

                                    public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                                        DTask[] tasks = new GLMLambdaTask[GLMDriver.this._state.length];
                                        for (int i = 0; i < tasks.length; ++i) {
                                            tasks[i] = new GLMLambdaTask(null, GLM.this._key, GLM.this._progressKey, GLMDriver.this._state[i], GLMDriver.this.lambdas[GLMDriver.this._lambdaId], ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS);
                                        }
                                        this.getCompleter().addToPendingCount(1);
                                        new MRUtils.ParallelTasks((H2O.H2OCountedCompleter)new LambdaSearchIteration((H2O.H2OCountedCompleter)this.getCompleter(), ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS), tasks).fork();
                                    }
                                };
                                cmp.addToPendingCount(GLMDriver.this._state.length - 2);
                                for (int i = 1; i < GLMDriver.this._state.length; ++i) {
                                    final int fi = i;
                                    final GLMModel.GLMParameters params = (GLMModel.GLMParameters)((GLMModel.GLMParameters)GLM.this._parms).clone();
                                    params._n_folds = 0;
                                    final FrameTask.DataInfo dinfo = GLMDriver.this._dinfo.getFold(i - 1, ((GLMModel.GLMParameters)GLM.this._parms)._n_folds);
                                    GLMDriver.this._foldInfos.add(dinfo);
                                    DKV.put((Key)dinfo._key, (Iced)dinfo);
                                    Log.info((Object[])new Object[]{"inserted dinfo for fold " + i + " under key " + dinfo._key});
                                    if (i == 0) continue;
                                    new GLMTask.LMAXTask(GLM.this._key, dinfo, params, ymut.ymu(fi - 1), ymut.nobs(fi - 1), ModelUtils.DEFAULT_THRESHOLDS, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.LMAXTask>((H2O.H2OCountedCompleter)cmp){

                                        public String toString() {
                                            return "Xval LMAXTask callback., completer = " + this.getCompleter() == null ? "null" : this.getCompleter().toString();
                                        }

                                        public void callback(GLMTask.LMAXTask lLmax) {
                                            double lmax = lLmax.lmax();
                                            Key dstKey = Key.make((String)(GLM.this._dest.toString() + "_xval_" + fi), (byte)1, (byte)31, (boolean)true, (H2ONode[])new H2ONode[]{H2O.SELF});
                                            GLMDriver.this._state[fi] = new GLMTaskInfo(dstKey, dinfo, params, lLmax._nobs, lLmax._ymu, lLmax.lmax(), gLmax.lmax(), GLMDriver.this.nullBeta(dinfo, params, lLmax._ymu), lLmax.gradient(((GLMModel.GLMParameters)GLM.this._parms)._alpha[0], lmax), GLM.objval(lLmax, ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0], lLmax.lmax()));
                                            assert (DKV.get((Key)dinfo._key) != null);
                                            new GLMModel(dstKey, params, new GLMModel.GLMOutput(GLM.this, dinfo, ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.binomial), dinfo, lLmax._ymu, lmax, nobs).delete_and_lock(GLM.this._key);
                                            if (lLmax.lmax() > gLmax.lmax()) {
                                                this.getCompleter().addToPendingCount(1);
                                                new GLMLambdaTask((H2O.H2OCountedCompleter)this.getCompleter(), GLM.this._key, GLM.this._progressKey, GLMDriver.this._state[fi], gLmax.lmax(), ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS).fork();
                                            }
                                        }
                                    }).asyncExec(dinfo._adaptedFrame);
                                }
                            } else {
                                new GLMLambdaTask((H2O.H2OCountedCompleter)new LambdaSearchIteration((H2O.H2OCountedCompleter)this.getCompleter(), ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS), GLM.this._key, GLM.this._progressKey, GLMDriver.this._state[0], GLMDriver.this.lambdas[++GLMDriver.this._lambdaId], ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS).fork();
                            }
                        }
                    }).asyncExec(GLMDriver.this._dinfo._adaptedFrame);
                }
            }).asyncExec(this._dinfo._adaptedFrame);
        }

        private class LambdaSearchIteration
        extends H2O.H2OCallback {
            final boolean _forceLBFGS;

            public LambdaSearchIteration(H2O.H2OCountedCompleter cmp, boolean forceLBFGS) {
                super(cmp);
                this._forceLBFGS = forceLBFGS;
            }

            public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                double currentLambda = GLMDriver.this.lambdas[GLMDriver.this._lambdaId];
                if (((GLMModel.GLMParameters)GLM.this._parms)._n_folds > 1) {
                    MRUtils.ParallelTasks t = (MRUtils.ParallelTasks)h2OCountedCompleter;
                    for (int i = 0; i < ((GLMLambdaTask[])t._tasks).length; ++i) {
                        GLMDriver.this._state[i] = ((GLMLambdaTask[])t._tasks)[i]._taskInfo;
                    }
                }
                if (++GLMDriver.this._lambdaId < GLMDriver.this._maxLambda) {
                    this.getCompleter().addToPendingCount(1);
                    double nextLambda = GLMDriver.this.lambdas[GLMDriver.this._lambdaId];
                    if (((GLMModel.GLMParameters)GLM.this._parms)._n_folds > 1) {
                        DTask[] tasks = new GLMLambdaTask[GLMDriver.this._state.length];
                        LambdaSearchIteration cmp = new LambdaSearchIteration((H2O.H2OCountedCompleter)this.getCompleter(), this._forceLBFGS);
                        cmp.addToPendingCount(tasks.length - 1);
                        for (int i = 0; i < tasks.length; ++i) {
                            GLMDriver.this._state[i]._lastLambda = currentLambda;
                            tasks[i] = new GLMLambdaTask((H2O.H2OCountedCompleter)cmp, GLM.this._key, GLM.this._progressKey, GLMDriver.this._state[i], nextLambda, false);
                        }
                        new MRUtils.ParallelTasks((H2O.H2OCountedCompleter)new LambdaSearchIteration((H2O.H2OCountedCompleter)this.getCompleter(), this._forceLBFGS), tasks).fork();
                    } else {
                        GLMDriver.this._state[0]._lastLambda = currentLambda;
                        new GLMLambdaTask((H2O.H2OCountedCompleter)new LambdaSearchIteration((H2O.H2OCountedCompleter)this.getCompleter(), this._forceLBFGS), GLM.this._key, GLM.this._progressKey, GLMDriver.this._state[0], nextLambda, this._forceLBFGS).fork();
                    }
                }
            }
        }
    }

    public static final class GLMLambdaTask
    extends DTask<GLMLambdaTask> {
        FrameTask.DataInfo _activeData;
        GLMTaskInfo _taskInfo;
        final double _currentLambda;
        int _iter;
        final Key _jobKey;
        Key _progressKey;
        long _start_time;
        double _addedL2;
        final boolean _forceLBFGS;
        int[] _activeCols;
        private transient IterationInfo _lastResult;

        public GLMLambdaTask(H2O.H2OCountedCompleter cmp, Key jobKey, Key progressKey, GLMTaskInfo state, double lambda, boolean forceLBFGS) {
            super(cmp);
            this._taskInfo = state;
            assert (DKV.get((Key)this._taskInfo._dinfo._key) != null);
            this._currentLambda = lambda;
            this._jobKey = jobKey;
            this._progressKey = progressKey;
            this._forceLBFGS = forceLBFGS;
        }

        private String LogInfo(String msg) {
            msg = "GLM2[dest=" + this._taskInfo._dstKey + ", iteration=" + this._iter + ", lambda = " + this._currentLambda + "]: " + msg;
            Log.info((Object[])new Object[]{msg});
            return msg;
        }

        private int[] activeCols(double l1, double l2, double[] grad) {
            int selected = 0;
            int[] cols = null;
            if (this._taskInfo._params._alpha[0] > 0.0) {
                double rhs = this._taskInfo._params._alpha[0] * (2.0 * l1 - l2);
                cols = MemoryManager.malloc4((int)this._taskInfo._dinfo.fullN());
                int j = 0;
                if (this._activeCols == null) {
                    this._activeCols = new int[]{-1};
                }
                for (int i = 0; i < this._taskInfo._dinfo.fullN(); ++i) {
                    if (!(j < this._activeCols.length && i == this._activeCols[j] || grad[i] > rhs) && !(grad[i] < -rhs)) continue;
                    cols[selected++] = i;
                    if (j >= this._activeCols.length || i != this._activeCols[j]) continue;
                    ++j;
                }
            }
            if (this._taskInfo._params._alpha[0] == 0.0 || selected == this._taskInfo._dinfo.fullN()) {
                this._activeCols = null;
                this._activeData = this._taskInfo._dinfo;
                selected = this._taskInfo._dinfo.fullN();
            } else {
                this._activeCols = Arrays.copyOf(cols, selected);
                this._activeData = this._taskInfo._dinfo.filterExpandedColumns(this._activeCols);
                assert (DKV.get((Key)this._activeData._key) != null);
            }
            this.LogInfo("strong rule at lambda_value=" + l1 + ", got " + selected + " active cols out of " + this._taskInfo._dinfo.fullN() + " total.");
            assert (this._activeCols == null || this._activeData.fullN() == this._activeCols.length) : this.LogInfo("mismatched number of cols, got " + this._activeCols.length + " active cols, but data info claims " + this._activeData.fullN());
            return this._activeCols;
        }

        private double[] setSubmodel(double[] newBeta, GLMValidation val, H2O.H2OCountedCompleter cmp) {
            double[] newBetaDeNorm;
            double[] fullBeta;
            double[] dArray = fullBeta = this._activeCols == null || newBeta == null ? newBeta : GLM.expandVec(newBeta, this._activeCols, this._taskInfo._dinfo.fullN() + 1);
            if (fullBeta == null) {
                fullBeta = MemoryManager.malloc8d((int)(this._taskInfo._dinfo.fullN() + 1));
                fullBeta[fullBeta.length - 1] = this._taskInfo._params.linkInv(this._taskInfo._ymu);
            }
            if (this._taskInfo._dinfo._predictor_transform == FrameTask.DataInfo.TransformType.STANDARDIZE) {
                int numoff;
                newBetaDeNorm = (double[])fullBeta.clone();
                double norm = 0.0;
                for (int i = numoff = this._taskInfo._dinfo.numStart(); i < fullBeta.length - 1; ++i) {
                    double b = newBetaDeNorm[i] * this._taskInfo._dinfo._normMul[i - numoff];
                    norm += b * this._taskInfo._dinfo._normSub[i - numoff];
                    newBetaDeNorm[i] = b;
                }
                int n = newBetaDeNorm.length - 1;
                newBetaDeNorm[n] = newBetaDeNorm[n] - norm;
            } else {
                newBetaDeNorm = null;
            }
            GLMModel.setSubmodel(cmp, this._taskInfo._dstKey, this._currentLambda, newBetaDeNorm == null ? fullBeta : newBetaDeNorm, newBetaDeNorm == null ? null : fullBeta, this._iter + 1, System.currentTimeMillis() - this._start_time, this._taskInfo._dinfo.fullN() >= 750, val);
            return fullBeta;
        }

        protected void checkKKTAndComplete(final double[] newBeta, final boolean failedLineSearch) {
            double[] fullBeta;
            H2O.H2OCountedCompleter cmp = (H2O.H2OCountedCompleter)this.getCompleter();
            cmp.addToPendingCount(1);
            if (newBeta == null) {
                fullBeta = MemoryManager.malloc8d((int)(this._taskInfo._dinfo.fullN() + 1));
                fullBeta[fullBeta.length - 1] = this._taskInfo._params.linkInv(this._taskInfo._ymu);
            } else {
                fullBeta = GLM.expandVec(newBeta, this._activeCols, this._taskInfo._dinfo.fullN() + 1);
            }
            new GLMTask.GLMIterationTask(this._jobKey, this._taskInfo._dinfo, this._taskInfo._params, false, true, true, fullBeta, this._taskInfo._ymu, 1.0 / (double)this._taskInfo._nobs, this._taskInfo._thresholds, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.GLMIterationTask>(cmp){

                public String toString() {
                    return "checkKKTAndComplete.Callback, completer = " + this.getCompleter() == null ? "null" : this.getCompleter().toString();
                }

                public void callback(GLMTask.GLMIterationTask glmt2) {
                    double[] grad = glmt2.gradient(GLMLambdaTask.this._taskInfo._params._alpha[0], GLMLambdaTask.this._currentLambda);
                    if (ArrayUtils.hasNaNsOrInfs((double[])grad)) {
                        if (!failedLineSearch) {
                            GLMLambdaTask.this.LogInfo("Check KKT got NaNs. Invoking line search");
                            GLMLambdaTask.this._taskInfo._params._higher_accuracy = true;
                            this.getCompleter().addToPendingCount(1);
                            new GLMTask.GLMLineSearchTask(GLMLambdaTask.this._jobKey, GLMLambdaTask.this._activeData, GLMLambdaTask.this._taskInfo._params, ((GLMLambdaTask)GLMLambdaTask.this)._lastResult._beta, GLM.contractVec(fullBeta, GLMLambdaTask.this._activeCols), 1.0E-4, GLMLambdaTask.this._taskInfo._ymu, GLMLambdaTask.this._taskInfo._nobs, (H2O.H2OCountedCompleter)new LineSearchIteration(this.getCompleter())).asyncExec(GLMLambdaTask.this._activeData._adaptedFrame);
                            return;
                        }
                        GLMLambdaTask.this.LogInfo("got NaNs/Infs in gradient at lambda " + GLMLambdaTask.this._currentLambda);
                    }
                    double[] subgrad = (double[])grad.clone();
                    LSMSolver.ADMMSolver.subgrad(GLMLambdaTask.this._taskInfo._params._alpha[0], GLMLambdaTask.this._currentLambda, fullBeta, subgrad);
                    double err = GLM_GRAD_EPS;
                    if (!failedLineSearch && GLMLambdaTask.this._activeCols != null) {
                        for (int c : GLMLambdaTask.this._activeCols) {
                            if (subgrad[c] > err) {
                                err = subgrad[c];
                                continue;
                            }
                            if (!(subgrad[c] < -err)) continue;
                            err = -subgrad[c];
                        }
                        int[] failedCols = new int[64];
                        int fcnt = 0;
                        for (int i = 0; i < grad.length - 1; ++i) {
                            if (Arrays.binarySearch(GLMLambdaTask.this._activeCols, i) >= 0 || !(subgrad[i] > err) && !(-subgrad[i] > err)) continue;
                            if (fcnt == failedCols.length) {
                                failedCols = Arrays.copyOf(failedCols, failedCols.length << 1);
                            }
                            failedCols[fcnt++] = i;
                        }
                        if (fcnt > 0) {
                            int n = GLMLambdaTask.this._activeCols.length;
                            int[] oldCols = GLMLambdaTask.this._activeCols;
                            GLMLambdaTask.this._activeCols = Arrays.copyOf(GLMLambdaTask.this._activeCols, GLMLambdaTask.this._activeCols.length + fcnt);
                            for (int i = 0; i < fcnt; ++i) {
                                GLMLambdaTask.this._activeCols[n + i] = failedCols[i];
                            }
                            if (GLMLambdaTask.this._lastResult != null) {
                                GLMLambdaTask.this._lastResult = new IterationInfo(((GLMLambdaTask)GLMLambdaTask.this)._lastResult._iter, GLM.resizeVec(((GLMLambdaTask)GLMLambdaTask.this)._lastResult._beta, GLMLambdaTask.this._activeCols, oldCols, GLMLambdaTask.this._taskInfo._dinfo.fullN() + 1), GLM.resizeVec(((GLMLambdaTask)GLMLambdaTask.this)._lastResult._grad, GLMLambdaTask.this._activeCols, oldCols, GLMLambdaTask.this._taskInfo._dinfo.fullN() + 1), ((GLMLambdaTask)GLMLambdaTask.this)._lastResult._objval);
                            }
                            Arrays.sort(GLMLambdaTask.this._activeCols);
                            GLMLambdaTask.this.LogInfo(fcnt + " variables failed KKT conditions check! Adding them to the model and continuing computation.(grad_eps = " + err + ", activeCols = " + (GLMLambdaTask.this._activeCols.length > 100 ? "lost" : Arrays.toString(GLMLambdaTask.this._activeCols)));
                            GLMLambdaTask.this._activeData = GLMLambdaTask.this._taskInfo._dinfo.filterExpandedColumns(GLMLambdaTask.this._activeCols);
                            this.getCompleter().addToPendingCount(1);
                            new GLMTask.GLMIterationTask(GLMLambdaTask.this._jobKey, GLMLambdaTask.this._activeData, GLMLambdaTask.this._taskInfo._params, true, true, true, GLM.contractVec(glmt2._beta, GLMLambdaTask.this._activeCols), GLMLambdaTask.this._taskInfo._ymu, 1.0 / (double)GLMLambdaTask.this._taskInfo._nobs, GLMLambdaTask.this._taskInfo._thresholds, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter())).asyncExec(GLMLambdaTask.this._activeData._adaptedFrame);
                            return;
                        }
                    }
                    GLMLambdaTask.this._taskInfo._beta = glmt2._beta;
                    GLMLambdaTask.this._taskInfo._gradient = glmt2.gradient(GLMLambdaTask.this._taskInfo._params._alpha[0], GLMLambdaTask.this._taskInfo._lastLambda);
                    GLMLambdaTask.this._taskInfo._iter = GLMLambdaTask.this._iter;
                    int diff = 10 - GLMLambdaTask.this._iter + GLMLambdaTask.this._taskInfo._iter;
                    if (diff > 0) {
                        new Job.ProgressUpdate((long)diff).fork(GLMLambdaTask.this._progressKey);
                    }
                    GLMLambdaTask.this.setSubmodel(newBeta, glmt2._val, (H2O.H2OCountedCompleter)this.getCompleter().getCompleter());
                }
            }).asyncExec(this._taskInfo._dinfo._adaptedFrame);
        }

        protected boolean needLineSearch(GLMTask.GLMIterationTask glmt) {
            return this.needLineSearch(glmt, 1.0);
        }

        protected boolean needLineSearch(GLMTask.GLMIterationTask glmt, double step) {
            if (this._taskInfo._params._family == GLMModel.GLMParameters.Family.gaussian) {
                return false;
            }
            if (glmt._beta == null) {
                return false;
            }
            if (ArrayUtils.hasNaNsOrInfs((double[])glmt._xy) || glmt._grad != null && ArrayUtils.hasNaNsOrInfs((double[])glmt._grad) || glmt._gram != null && glmt._gram.hasNaNsOrInfs()) {
                return true;
            }
            if (glmt._val != null && glmt._val.residual_deviance > glmt._val.null_deviance) {
                return true;
            }
            if (glmt._val == null) {
                return false;
            }
            return this.needLineSearch(glmt._beta, GLM.objval(glmt, this._taskInfo._params._alpha[0], this._currentLambda), step);
        }

        protected boolean needLineSearch(double[] beta, double objval, double step) {
            double[] oldBeta;
            assert (beta != null);
            if (Double.isNaN(objval)) {
                return true;
            }
            double[] grad = this._lastResult._grad;
            double f_hat = 0.0;
            double[] dArray = oldBeta = this._lastResult == null ? GLM.contractVec(this._taskInfo._beta, this._activeCols) : this._lastResult._beta;
            if (oldBeta == null) {
                for (int i = 0; i < beta.length; ++i) {
                    f_hat += step * grad[i] * beta[i] + 0.5 * beta[i] * beta[i];
                }
            } else {
                for (int i = 0; i < beta.length; ++i) {
                    double diff = beta[i] - oldBeta[i];
                    f_hat += step * grad[i] * diff + 0.5 * diff * diff;
                }
            }
            return objval > (f_hat = 1.0E-4 * f_hat + this._lastResult._objval);
        }

        private static final boolean isSparse(Frame f) {
            int scount = 0;
            for (Vec v : f.vecs()) {
                if (v.nzCnt() << 3 <= v.length()) continue;
                ++scount;
            }
            return f.numCols() >> 1 < scount;
        }

        private L_BFGS.GradientInfo adjustL2(L_BFGS.GradientInfo ginfo, double[] coefs, double lambdaDiff) {
            for (int i = 0; i < coefs.length - 1; ++i) {
                int n = i;
                ginfo._gradient[n] = ginfo._gradient[n] + lambdaDiff * coefs[i];
            }
            return ginfo;
        }

        private MRTask makeGLMTask(Key jobKey, FrameTask.DataInfo dinfo, GLMModel.GLMParameters params, boolean computeGram, boolean validate, boolean computeGradient, double[] beta) {
            return null;
        }

        protected void compute2() {
            int n;
            this._start_time = System.currentTimeMillis();
            if (this._currentLambda > this._taskInfo._lambdaMax) {
                this.tryComplete();
                return;
            }
            this._iter = this._taskInfo._iter;
            this.LogInfo("starting computation of lambda = " + this._currentLambda + ", previous lambda = " + this._taskInfo._lastLambda);
            int[] activeCols = this.activeCols(this._currentLambda, this._taskInfo._lastLambda, this._taskInfo._gradient);
            int n2 = n = activeCols == null ? this._taskInfo._dinfo.fullN() : activeCols.length;
            if (n > this._taskInfo._params._max_active_predictors) {
                throw new TooManyPredictorsException();
            }
            double[] beta = GLM.contractVec(this._taskInfo._beta, this._activeCols);
            this._lastResult = new IterationInfo(this._taskInfo._iter, beta, GLM.contractVec(this._taskInfo._gradient, this._activeCols), this._taskInfo._objval);
            boolean LBFGS = this._forceLBFGS;
            if (LBFGS) {
                L_BFGS.GradientSolver solver;
                if (this._taskInfo._params._alpha[0] > 0.0 || this._activeCols != null) {
                    throw H2O.unimpl();
                }
                Log.info((Object[])new Object[]{"current lambda = " + this._currentLambda});
                L_BFGS.GradientSolver gradientSolver = solver = this._activeData._adaptedFrame.numCols() >= 100 || GLMLambdaTask.isSparse(this._activeData._adaptedFrame) ? new GLMColBasedGradientSolver(this._taskInfo._params, this._activeData, this._currentLambda, this._taskInfo._ymu, this._taskInfo._nobs) : new GLMGradientSolver(this._taskInfo._params, this._activeData, this._currentLambda, this._taskInfo._ymu, this._taskInfo._nobs);
                if (beta == null) {
                    beta = MemoryManager.malloc8d((int)(this._activeData.fullN() + 1));
                    beta[beta.length - 1] = this._taskInfo._params.link(this._taskInfo._ymu);
                }
                long t1 = System.currentTimeMillis();
                if (this._taskInfo._lbfgs == null) {
                    this._taskInfo._lbfgs = new L_BFGS();
                }
                L_BFGS.GradientInfo gOld = this._taskInfo._gOld == null ? solver.getGradient(beta) : this.adjustL2(this._taskInfo._gOld, beta, this._currentLambda - this._taskInfo._lastLambda);
                final int workInc = 100000000 / this._taskInfo._params._lambda.length / this._taskInfo._lbfgs.maxIter();
                L_BFGS.Result r = this._taskInfo._lbfgs.solve(solver, beta, gOld, new L_BFGS.ProgressMonitor(){

                    @Override
                    public boolean progress(L_BFGS.GradientInfo ginfo) {
                        Job.update((long)workInc, (Key)GLMLambdaTask.this._jobKey);
                        return Job.isRunning((Key)GLMLambdaTask.this._jobKey);
                    }
                });
                long t2 = System.currentTimeMillis();
                Log.info((Object[])new Object[]{"L_BFGS (k = " + this._taskInfo._lbfgs.k() + ") done after " + r.iter + " iterations and " + (t2 - t1) / 1000L + " seconds, objval = " + r.ginfo._objVal + ", penalty = " + this._currentLambda * 0.5 * ArrayUtils.l2norm2((double[])beta, (boolean)true) + ",  gradient norm2 = " + MathUtils.l2norm2((double[])r.ginfo._gradient)});
                this._taskInfo._gOld = r.ginfo;
                double[] newBeta = r.coefs;
                this._taskInfo._beta = newBeta;
                this._taskInfo._iter = this._iter += r.iter;
                this.setSubmodel(newBeta, null, (H2O.H2OCountedCompleter)this);
                this.tryComplete();
            } else {
                new GLMTask.GLMIterationTask(this._jobKey, this._activeData, this._taskInfo._params, true, false, false, beta, this._taskInfo._ymu, 1.0 / (double)this._taskInfo._nobs, this._taskInfo._thresholds, (H2O.H2OCountedCompleter)new Iteration((CountedCompleter)this)).asyncExec(this._activeData._adaptedFrame);
            }
        }

        private class LineSearchIteration
        extends H2O.H2OCallback<GLMTask.GLMLineSearchTask> {
            LineSearchIteration(CountedCompleter cmp) {
                super((H2O.H2OCountedCompleter)cmp);
            }

            public void callback(GLMTask.GLMLineSearchTask glmt) {
                assert (this.getCompleter().getPendingCount() <= 1) : "unexpected pending count, expected 1, got " + this.getCompleter().getPendingCount();
                double step = 0.5;
                for (int i = 0; i < glmt._glmts.length; ++i) {
                    if (!GLMLambdaTask.this.needLineSearch(glmt._glmts[i], step)) {
                        GLMLambdaTask.this.LogInfo("line search: found admissible step = " + step + ",  objval = " + GLM.objval(glmt._glmts[i], GLMLambdaTask.this._taskInfo._params._alpha[0], GLMLambdaTask.this._currentLambda));
                        GLMLambdaTask.this._taskInfo._params._higher_accuracy = true;
                        this.getCompleter().addToPendingCount(1);
                        new GLMTask.GLMIterationTask(GLMLambdaTask.this._jobKey, GLMLambdaTask.this._activeData, GLMLambdaTask.this._taskInfo._params, true, true, true, glmt._glmts[i]._beta, GLMLambdaTask.this._taskInfo._ymu, 1.0 / (double)GLMLambdaTask.this._taskInfo._nobs, GLMLambdaTask.this._taskInfo._thresholds, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter(), false, step)).asyncExec(GLMLambdaTask.this._activeData._adaptedFrame);
                        return;
                    }
                    step *= 0.5;
                }
                if (!GLMLambdaTask.this._taskInfo._params._higher_accuracy) {
                    GLMLambdaTask.this._taskInfo._params._higher_accuracy = true;
                    int add2iter = GLMLambdaTask.this._iter - GLMLambdaTask.this._taskInfo._iter;
                    GLMLambdaTask.this.LogInfo("Line search failed to progress, rerunning current lambda from scratch with high accuracy on, adding " + add2iter + " to max iterations");
                    GLMLambdaTask.this._taskInfo._max_iter += add2iter;
                    this.getCompleter().addToPendingCount(1);
                    new GLMTask.GLMIterationTask(GLMLambdaTask.this._jobKey, GLMLambdaTask.this._activeData, GLMLambdaTask.this._taskInfo._params, true, true, true, GLM.contractVec(GLMLambdaTask.this._taskInfo._beta, GLMLambdaTask.this._activeCols), GLMLambdaTask.this._taskInfo._ymu, 1.0 / (double)GLMLambdaTask.this._taskInfo._nobs, GLMLambdaTask.this._taskInfo._thresholds, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter(), false, 1.0)).asyncExec(GLMLambdaTask.this._activeData._adaptedFrame);
                    return;
                }
                GLMLambdaTask.this.LogInfo("Line search did not find feasible step, converged.");
                GLMLambdaTask.this.checkKKTAndComplete(((GLMLambdaTask)GLMLambdaTask.this)._lastResult._beta, true);
            }
        }

        private class Iteration
        extends H2O.H2OCallback<GLMTask.GLMIterationTask> {
            public final long _iterationStartTime;
            final boolean _countIteration;
            final double _lineSearchStep;

            public Iteration(CountedCompleter cmp) {
                this(cmp, true, 1.0);
            }

            public Iteration(CountedCompleter cmp, boolean countIteration, double lineSearchStep) {
                super((H2O.H2OCountedCompleter)cmp);
                this._lineSearchStep = lineSearchStep;
                this._countIteration = countIteration;
                this._iterationStartTime = System.currentTimeMillis();
            }

            public void callback(GLMTask.GLMIterationTask glmt) {
                if (GLMLambdaTask.this._jobKey != null && !Job.isRunning((Key)GLMLambdaTask.this._jobKey)) {
                    throw new Job.JobCancelledException();
                }
                assert (GLMLambdaTask.this._activeCols == null || glmt._beta == null || glmt._beta.length == GLMLambdaTask.this._activeCols.length + 1) : GLMLambdaTask.access$200(GLMLambdaTask.this, "betalen = " + glmt._beta.length + ", activecols = " + GLMLambdaTask.this._activeCols.length);
                assert (GLMLambdaTask.this._activeCols == null || GLMLambdaTask.this._activeCols.length == GLMLambdaTask.this._activeData.fullN());
                assert (this.getCompleter().getPendingCount() <= 1) : GLMLambdaTask.access$200(GLMLambdaTask.this, "unexpected pending count, expected <=  1, got " + this.getCompleter().getPendingCount());
                if (this._countIteration) {
                    ++GLMLambdaTask.this._iter;
                }
                long callbackStart = System.currentTimeMillis();
                if (GLMLambdaTask.this.needLineSearch(glmt, this._lineSearchStep)) {
                    this.getCompleter().addToPendingCount(1);
                    GLMLambdaTask.this.LogInfo("invoking line search");
                    double[] oldBeta = ((GLMLambdaTask)GLMLambdaTask.this)._lastResult._beta;
                    if (oldBeta == null) {
                        oldBeta = MemoryManager.malloc8d((int)(GLMLambdaTask.this._taskInfo._dinfo.fullN() + 1));
                        oldBeta[oldBeta.length - 1] = GLMLambdaTask.this._taskInfo._params.link(GLMLambdaTask.this._taskInfo._ymu);
                    }
                    new GLMTask.GLMLineSearchTask(GLMLambdaTask.this._jobKey, GLMLambdaTask.this._activeData, GLMLambdaTask.this._taskInfo._params, oldBeta, glmt._beta, 1.0E-4, GLMLambdaTask.this._taskInfo._ymu, GLMLambdaTask.this._taskInfo._nobs, (H2O.H2OCountedCompleter)new LineSearchIteration(this.getCompleter())).asyncExec(GLMLambdaTask.this._activeData._adaptedFrame);
                    return;
                }
                if (glmt._newThresholds != null) {
                    GLMLambdaTask.this._taskInfo._thresholds = ArrayUtils.join((float[])glmt._newThresholds[0], (float[])glmt._newThresholds[1]);
                    Arrays.sort(GLMLambdaTask.this._taskInfo._thresholds);
                }
                double gerr = Double.NaN;
                if (glmt._val != null && glmt._computeGradient) {
                    GLMLambdaTask.this._lastResult = new IterationInfo(GLMLambdaTask.this._iter, glmt._beta, glmt.gradient(GLMLambdaTask.this._taskInfo._params._alpha[0], GLMLambdaTask.this._currentLambda), GLM.objval(glmt, GLMLambdaTask.this._taskInfo._params._alpha[0], GLMLambdaTask.this._currentLambda));
                    double[] grad = (double[])((GLMLambdaTask)GLMLambdaTask.this)._lastResult._grad.clone();
                    LSMSolver.ADMMSolver.subgrad(GLMLambdaTask.this._taskInfo._params._alpha[0], GLMLambdaTask.this._currentLambda, glmt._beta, grad);
                    gerr = 0.0;
                    for (double d : grad) {
                        if (d > gerr) {
                            gerr = d;
                            continue;
                        }
                        if (!(d < -gerr)) continue;
                        gerr = -d;
                    }
                    if (gerr <= GLM_GRAD_EPS) {
                        GLMLambdaTask.this.LogInfo("converged by reaching small enough gradient, with max |subgradient| = " + gerr);
                        GLMLambdaTask.this.checkKKTAndComplete(glmt._beta, false);
                        return;
                    }
                }
                double[] newBeta = MemoryManager.malloc8d((int)glmt._xy.length);
                long t1 = System.currentTimeMillis();
                LSMSolver.ADMMSolver slvr = new LSMSolver.ADMMSolver(GLMLambdaTask.this._currentLambda, GLMLambdaTask.this._taskInfo._params._alpha[0], GLM_GRAD_EPS, GLMLambdaTask.this._addedL2);
                slvr.solve(glmt._gram, glmt._xy, glmt._yy, newBeta, GLMLambdaTask.this._currentLambda * GLMLambdaTask.this._taskInfo._params._alpha[0]);
                if (this._lineSearchStep < 1.0) {
                    if (glmt._beta != null) {
                        for (int i = 0; i < newBeta.length; ++i) {
                            newBeta[i] = glmt._beta[i] * (1.0 - this._lineSearchStep) + this._lineSearchStep * newBeta[i];
                        }
                    } else {
                        int i = 0;
                        while (i < newBeta.length) {
                            int n = i++;
                            newBeta[n] = newBeta[n] * this._lineSearchStep;
                        }
                    }
                }
                GLMLambdaTask.this.LogInfo("Gram computed in " + (callbackStart - this._iterationStartTime) + "ms, " + (Double.isNaN(gerr) ? "" : "gradient = " + gerr + ",") + ", step = " + this._lineSearchStep + ", ADMM: " + slvr.iterations + " iterations, " + (System.currentTimeMillis() - t1) + "ms (" + slvr.decompTime + "), subgrad_err=" + slvr.gerr);
                if (slvr._addedL2 > GLMLambdaTask.this._addedL2) {
                    GLMLambdaTask.this.LogInfo("added " + (slvr._addedL2 - GLMLambdaTask.this._addedL2) + "L2 penalty");
                }
                new Job.ProgressUpdate(1L).fork(GLMLambdaTask.this._progressKey);
                GLMLambdaTask.this._addedL2 = slvr._addedL2;
                if (ArrayUtils.hasNaNsOrInfs((double[])newBeta)) {
                    throw new RuntimeException(GLMLambdaTask.this.LogInfo("got NaNs and/or Infs in beta"));
                }
                double bdiff = GLM.beta_diff(glmt._beta, newBeta);
                if (GLMLambdaTask.this._taskInfo._params._family == GLMModel.GLMParameters.Family.gaussian || bdiff < 1.0E-4 || GLMLambdaTask.this._iter >= GLMLambdaTask.this._taskInfo._max_iter) {
                    int diff = (int)Math.log10(bdiff);
                    int nzs = 0;
                    for (int i = 0; i < newBeta.length; ++i) {
                        if (newBeta[i] == 0.0) continue;
                        ++nzs;
                    }
                    GLMLambdaTask.this.LogInfo("converged (reached a fixed point with ~ 1e" + diff + " precision), got " + nzs + " nzs");
                    GLMLambdaTask.this.checkKKTAndComplete(newBeta, false);
                    return;
                }
                if (glmt._beta != null) {
                    GLMLambdaTask.this.setSubmodel(glmt._beta, glmt._val, (H2O.H2OCountedCompleter)this.getCompleter().getCompleter());
                }
                boolean validate = GLMLambdaTask.this._taskInfo._params._higher_accuracy || GLMLambdaTask.this._iter % 5 == 0;
                this.getCompleter().addToPendingCount(1);
                new GLMTask.GLMIterationTask(GLMLambdaTask.this._jobKey, GLMLambdaTask.this._activeData, glmt._glm, true, validate, validate, newBeta, GLMLambdaTask.this._taskInfo._ymu, 1.0 / (double)GLMLambdaTask.this._taskInfo._nobs, GLMLambdaTask.this._taskInfo._thresholds, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter(), true, Math.min(1.0, 2.0 * this._lineSearchStep))).asyncExec(GLMLambdaTask.this._activeData._adaptedFrame);
            }
        }

        private static final class IterationInfo {
            final double[] _beta;
            final double[] _grad;
            final double _objval;
            final int _iter;

            public IterationInfo(int iter, double[] beta, double[] grad, double objval) {
                this._iter = iter;
                this._beta = beta;
                this._grad = grad;
                this._objval = objval;
            }
        }
    }

    public static final class GLMTaskInfo
    extends Iced {
        final long _nobs;
        final double _ymu;
        final double _lambdaMax;
        double[] _beta;
        double[] _gradient;
        int _iter;
        int _max_iter;
        double _lastLambda;
        float[] _thresholds;
        double _objval;
        final Key _dstKey;
        final FrameTask.DataInfo _dinfo;
        final GLMModel.GLMParameters _params;
        L_BFGS _lbfgs;
        L_BFGS.GradientInfo _gOld;

        public GLMTaskInfo(Key dstKey, FrameTask.DataInfo dinfo, GLMModel.GLMParameters params, long nobs, double ymu, double lmax, double lambda, double[] beta, double[] gradient, double objval) {
            this._dstKey = dstKey;
            this._dinfo = dinfo;
            this._params = params;
            this._nobs = nobs;
            this._ymu = ymu;
            this._lambdaMax = lmax;
            this._lastLambda = lambda;
            this._beta = beta;
            this._gradient = gradient;
            this._max_iter = this._params._lambda_search ? 10 : 50;
            this._objval = objval;
            if (this._params._family == GLMModel.GLMParameters.Family.binomial) {
                this._thresholds = ModelUtils.DEFAULT_THRESHOLDS;
            }
        }
    }

    private static class TooManyPredictorsException
    extends RuntimeException {
        private TooManyPredictorsException() {
        }
    }
}

