/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.FrameTask;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsRegression;
import hex.SupervisedModel;
import hex.SupervisedModelBuilder;
import hex.glm.GLM;
import hex.glm.GLMValidation;
import hex.schemas.GLMModelV2;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import water.DTask;
import water.H2O;
import water.Iced;
import water.Key;
import water.MemoryManager;
import water.TAtomic;
import water.api.ModelSchema;
import water.fvec.Chunk;
import water.util.ModelUtils;
import water.util.TwoDimTable;

public class GLMModel
extends SupervisedModel<GLMModel, GLMParameters, GLMOutput> {
    final FrameTask.DataInfo _dinfo;
    final double _lambda_max;
    final double _ymu;
    final long _nobs;
    long _run_time;

    public GLMModel(Key selfKey, GLMParameters parms, GLMOutput output, FrameTask.DataInfo dinfo, double ymu, double lambda_max, long nobs) {
        super(selfKey, (SupervisedModel.SupervisedParameters)parms, (SupervisedModel.SupervisedOutput)output);
        this._ymu = ymu;
        this._lambda_max = lambda_max;
        this._nobs = nobs;
        this._dinfo = dinfo;
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        switch (((GLMOutput)this._output).getModelCategory()) {
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain, ModelUtils.DEFAULT_THRESHOLDS);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
        }
        throw H2O.unimpl();
    }

    public ModelSchema schema() {
        return new GLMModelV2();
    }

    public double[] beta() {
        return ((GLMOutput)this._output)._global_beta;
    }

    public GLMValidation validation() {
        return ((GLMOutput)this._output)._submodels[((GLMOutput)this._output)._best_lambda_idx].validation;
    }

    public float[] score0(Chunk[] chks, int row_in_chunk, double[] tmp, float[] preds) {
        int i;
        double eta = 0.0;
        double[] b = this.beta();
        if (!((GLMParameters)this._parms)._use_all_factor_levels) {
            for (i = 0; i < this._dinfo._catOffsets.length - 1; ++i) {
                if (chks[i].atd(row_in_chunk) == 0.0) continue;
                eta += b[this._dinfo._catOffsets[i] + (int)(chks[i].atd(row_in_chunk) - 1.0)];
            }
        } else {
            for (i = 0; i < this._dinfo._catOffsets.length - 1; ++i) {
                eta += b[this._dinfo._catOffsets[i] + (int)chks[i].atd(row_in_chunk)];
            }
        }
        int noff = this._dinfo.numStart() - this._dinfo._cats;
        for (int i2 = this._dinfo._cats; i2 < b.length - 1 - noff; ++i2) {
            eta += b[noff + i2] * chks[i2].atd(row_in_chunk);
        }
        double mu = ((GLMParameters)this._parms).linkInv(eta += b[b.length - 1]);
        preds[0] = (float)mu;
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
            if (Double.isNaN(mu)) {
                preds[0] = Float.NaN;
                preds[1] = Float.NaN;
                preds[2] = Float.NaN;
            } else {
                preds[0] = mu >= (double)((GLMOutput)this._output)._threshold ? 1 : 0;
                preds[1] = 1.0f - (float)mu;
                preds[2] = (float)mu;
            }
        }
        return preds;
    }

    protected float[] score0(double[] data, float[] preds) {
        int i;
        double eta = 0.0;
        double[] b = this.beta();
        if (!((GLMParameters)this._parms)._use_all_factor_levels) {
            for (i = 0; i < this._dinfo._catOffsets.length - 1; ++i) {
                if (data[i] == 0.0) continue;
                eta += b[this._dinfo._catOffsets[i] + (int)(data[i] - 1.0)];
            }
        } else {
            for (i = 0; i < this._dinfo._catOffsets.length - 1; ++i) {
                eta += b[this._dinfo._catOffsets[i] + (int)data[i]];
            }
        }
        int noff = this._dinfo.numStart() - this._dinfo._cats;
        for (int i2 = this._dinfo._cats; i2 < data.length; ++i2) {
            eta += b[noff + i2] * data[i2];
        }
        double mu = ((GLMParameters)this._parms).linkInv(eta += b[b.length - 1]);
        preds[0] = (float)mu;
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
            if (Double.isNaN(mu)) {
                preds[0] = Float.NaN;
                preds[1] = Float.NaN;
                preds[2] = Float.NaN;
            } else {
                preds[0] = mu >= (double)((GLMOutput)this._output)._threshold ? 1 : 0;
                preds[1] = 1.0f - (float)mu;
                preds[2] = (float)mu;
            }
        }
        return preds;
    }

    public static void setSubmodel(H2O.H2OCountedCompleter cmp, Key modelKey, final double lambda, double[] beta, double[] norm_beta, int iteration, long runtime, boolean sparseCoef, GLMValidation val) {
        final Submodel sm = new Submodel(lambda, beta, norm_beta, runtime, iteration, sparseCoef);
        sm.validation = val;
        cmp.addToPendingCount(1);
        new TAtomic<GLMModel>(cmp){

            public GLMModel atomic(GLMModel old) {
                if (old == null) {
                    return old;
                }
                if (((GLMOutput)old._output)._submodels == null) {
                    ((GLMOutput)old._output)._submodels = new Submodel[]{sm};
                } else {
                    int id = ((GLMOutput)old._output).submodelIdForLambda(lambda);
                    if (id < 0) {
                        id = -id - 1;
                        ((GLMOutput)old._output)._submodels = Arrays.copyOf(((GLMOutput)old._output)._submodels, ((GLMOutput)old._output)._submodels.length + 1);
                        for (int i = ((GLMOutput)old._output)._submodels.length - 1; i > id; --i) {
                            ((GLMOutput)old._output)._submodels[i] = ((GLMOutput)old._output)._submodels[i - 1];
                        }
                    } else {
                        if (((GLMOutput)old._output)._submodels[id].iteration > sm.iteration) {
                            return old;
                        }
                        ((GLMOutput)old._output)._submodels = (Submodel[])((GLMOutput)old._output)._submodels.clone();
                    }
                    ((GLMOutput)old._output)._submodels[id] = sm;
                    old._run_time = Math.max(old._run_time, sm.run_time);
                }
                ((GLMOutput)old._output).pickBestModel(false);
                return old;
            }
        }.fork(modelKey);
    }

    public int rank(double lambda) {
        return -1;
    }

    public static void setXvalidation(H2O.H2OCountedCompleter cmp, Key modelKey, final double lambda, final GLMValidation val) {
        new TAtomic<GLMModel>(cmp){

            public GLMModel atomic(GLMModel old) {
                if (old == null) {
                    return old;
                }
                ((GLMOutput)old._output)._submodels = (Submodel[])((GLMOutput)old._output)._submodels.clone();
                int id = ((GLMOutput)old._output).submodelIdForLambda(lambda);
                ((GLMOutput)old._output)._submodels[id] = (Submodel)((GLMOutput)old._output)._submodels[id].clone();
                ((GLMOutput)old._output)._submodels[id].xvalidation = val;
                ((GLMOutput)old._output).pickBestModel(false);
                return old;
            }
        }.fork(modelKey);
    }

    public HashMap<String, Double> coefficients() {
        HashMap<String, Double> res = new HashMap<String, Double>();
        double[] b = this.beta();
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                res.put(((GLMOutput)this._output)._coefficients_table.getColHeaders()[i], b[i]);
            }
        }
        return res;
    }

    static class FinalizeAndUnlockTsk
    extends DTask.DKeyTask<FinalizeAndUnlockTsk, GLMModel> {
        final Key _jobKey;

        public FinalizeAndUnlockTsk(H2O.H2OCountedCompleter cmp, Key modelKey, Key jobKey) {
            super(cmp, modelKey);
            this._jobKey = jobKey;
        }

        protected void map(GLMModel glmModel) {
            ((GLMOutput)glmModel._output).pickBestModel(false);
            glmModel.update(this._jobKey);
            glmModel.unlock(this._jobKey);
        }
    }

    public static class GLMOutput
    extends SupervisedModel.SupervisedOutput {
        Submodel[] _submodels;
        int _best_lambda_idx;
        float _threshold;
        double[] _global_beta;
        TwoDimTable _coefficients_table;
        double _residual_deviance;
        double _null_deviance;
        double _residual_degrees_of_freedom;
        double _null_degrees_of_freedom;
        double _aic;
        double _auc;
        TwoDimTable _variable_importance;
        boolean _binomial;
        private static String[] binomialClassNames = new String[]{"0", "1"};

        public int rank() {
            return this.rank(this._submodels[this._best_lambda_idx].lambda_value);
        }

        public GLMOutput() {
        }

        public GLMOutput(SupervisedModelBuilder b, FrameTask.DataInfo dinfo, boolean binomial) {
            super(b);
            String[] cnames = dinfo.coefNames();
            String[] pnames = dinfo._adaptedFrame.names();
            Object[] colTypes = new String[cnames.length + 1];
            Object[] colFormat = new String[cnames.length + 1];
            Arrays.fill(colTypes, "double");
            Arrays.fill(colFormat, "%5f");
            String[] coefficient_names = Arrays.copyOf(cnames, cnames.length + 1);
            coefficient_names[cnames.length] = "Intercept";
            this._coefficients_table = new TwoDimTable("Best Lambda", new String[]{"Coefficients", "Norm Coefficients"}, coefficient_names, (String[])colTypes, (String[])colFormat);
            this._binomial = binomial;
        }

        public int nclasses() {
            return this._binomial ? 2 : 1;
        }

        public String[] classNames() {
            return this._binomial ? binomialClassNames : null;
        }

        void addNullSubmodel(double lmax, double icept, GLMValidation val) {
            assert (this._submodels == null);
            double[] beta = MemoryManager.malloc8d((int)this._coefficients_table.getColDim());
            beta[beta.length - 1] = icept;
            this._submodels = new Submodel[]{new Submodel(lmax, beta, beta, 0L, 0, this._coefficients_table.getColDim() > 750)};
            this._submodels[0].validation = val;
        }

        public int submodelIdForLambda(double lambda) {
            if (lambda >= this._submodels[0].lambda_value) {
                return 0;
            }
            for (int i = this._submodels.length - 1; i >= 0; --i) {
                if (lambda == this._submodels[i].lambda_value || Math.abs(this._submodels[i].lambda_value - lambda) / lambda < 1.0E-5) {
                    return i;
                }
                if (!(this._submodels[i].lambda_value > lambda)) continue;
                return -i - 2;
            }
            return -1;
        }

        public Submodel submodelForLambda(double lambda) {
            return this._submodels[this.submodelIdForLambda(lambda)];
        }

        public int rank(double lambda) {
            Submodel sm = this.submodelForLambda(lambda);
            if (sm == null) {
                return 0;
            }
            return this.submodelForLambda((double)lambda).rank;
        }

        public void pickBestModel(boolean useAuc) {
            int bestId = this._submodels.length - 1;
            if (this._submodels.length > 2) {
                boolean xval = false;
                GLMValidation bestVal = null;
                for (Submodel sm : this._submodels) {
                    if (sm.xvalidation == null) continue;
                    xval = true;
                    bestVal = sm.xvalidation;
                }
                if (!xval) {
                    bestVal = this._submodels[0].validation;
                }
                for (int i = 1; i < this._submodels.length; ++i) {
                    GLMValidation val;
                    GLMValidation gLMValidation = val = xval ? this._submodels[i].xvalidation : this._submodels[i].validation;
                    if (val == null || val == bestVal || !(useAuc && val.auc > bestVal.auc) && !(val.residual_deviance < bestVal.residual_deviance)) continue;
                    bestVal = val;
                    bestId = i;
                }
            }
            this._best_lambda_idx = bestId;
            this.setSubmodelIdx(this._best_lambda_idx);
        }

        public void setSubmodelIdx(int l) {
            this._best_lambda_idx = l;
            if (this._submodels[l].validation == null) {
                this._threshold = 0.5f;
                this._residual_deviance = Double.NaN;
                this._null_deviance = Double.NaN;
                this._residual_degrees_of_freedom = Double.NaN;
                this._null_degrees_of_freedom = Double.NaN;
                this._aic = Double.NaN;
                this._auc = Double.NaN;
            } else {
                this._threshold = this._submodels[l].validation.best_threshold;
                this._residual_deviance = this._submodels[l].validation.residualDeviance();
                this._null_deviance = this._submodels[l].validation.nullDeviance();
                this._residual_degrees_of_freedom = this._submodels[l].validation.resDOF();
                this._null_degrees_of_freedom = this._submodels[l].validation.nullDOF();
                this._aic = this._submodels[l].validation.aic();
                this._auc = this._submodels[l].validation.auc();
            }
            if (this._global_beta == null) {
                this._global_beta = MemoryManager.malloc8d((int)this._coefficients_table.getColDim());
            } else {
                Arrays.fill(this._global_beta, 0.0);
            }
            int j = 0;
            for (int i : this._submodels[l].idxs) {
                this._global_beta[i] = this._submodels[l].beta[j];
                this._coefficients_table.set(0, i, this._submodels[l].beta[j]);
                if (this._submodels[l].norm_beta != null) {
                    this._coefficients_table.set(1, i, this._submodels[l].norm_beta[j++]);
                    continue;
                }
                ++j;
            }
            if (this._submodels[l].norm_beta == null) {
                this._variable_importance = null;
            } else {
                j = 0;
                String[] coef_names = new String[this._coefficients_table.getColDim() - 1];
                double[] rel_imp = new double[this._coefficients_table.getColDim() - 1];
                for (int i = 0; i < this._submodels[l].idxs.length - 1; ++i) {
                    coef_names[j] = this._coefficients_table.getColHeaders()[j];
                    rel_imp[this._submodels[l].idxs[i]] = Math.abs(this._submodels[l].norm_beta[j++]);
                }
                this._variable_importance = this.calcVarImp(rel_imp, coef_names);
            }
        }

        public TwoDimTable calcVarImp(final double[] rel_imp, String[] coef_names) {
            int i;
            int i$;
            if (rel_imp == null) {
                return null;
            }
            if (coef_names == null) {
                coef_names = new String[rel_imp.length];
                for (int i2 = 0; i2 < coef_names.length; ++i2) {
                    coef_names[i2] = "C" + String.valueOf(i2 + 1);
                }
            }
            assert (rel_imp.length == coef_names.length);
            Integer[] sorted_idx = new Integer[rel_imp.length];
            for (int i3 = 0; i3 < sorted_idx.length; ++i3) {
                sorted_idx[i3] = i3;
            }
            Arrays.sort(sorted_idx, new Comparator<Integer>(){

                @Override
                public int compare(Integer idx1, Integer idx2) {
                    return Double.compare(-rel_imp[idx1], -rel_imp[idx2]);
                }
            });
            double total = 0.0;
            double max = rel_imp[sorted_idx[0]];
            String[] sorted_names = new String[coef_names.length];
            double[][] sorted_imp = new double[3][rel_imp.length];
            int j = 0;
            Integer[] arr$ = sorted_idx;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                i = arr$[i$];
                total += rel_imp[i];
                sorted_names[j] = coef_names[i];
                sorted_imp[0][j] = rel_imp[i];
                sorted_imp[1][j++] = rel_imp[i] / max;
            }
            j = 0;
            arr$ = sorted_idx;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                i = arr$[i$];
                sorted_imp[2][j++] = rel_imp[i] / total;
            }
            Object[] col_types = new String[rel_imp.length];
            Object[] col_formats = new String[rel_imp.length];
            Arrays.fill(col_types, "double");
            Arrays.fill(col_formats, "%5f");
            return new TwoDimTable("Variable Importance", new String[]{"Relative Importance", "Scaled Importance", "Percentage"}, sorted_names, (String[])col_types, (String[])col_formats, (String[][])new String[3][], sorted_imp);
        }
    }

    public static class Submodel
    extends Iced {
        final double lambda_value;
        final int iteration;
        final long run_time;
        GLMValidation validation;
        GLMValidation xvalidation;
        final int rank;
        final int[] idxs;
        final boolean sparseCoef;
        double[] beta;
        double[] norm_beta;

        public Submodel(double lambda, double[] beta, double[] norm_beta, long run_time, int iteration, boolean sparseCoef) {
            this.lambda_value = lambda;
            this.run_time = run_time;
            this.iteration = iteration;
            int r = 0;
            if (beta != null) {
                double[] b = norm_beta != null ? norm_beta : beta;
                for (double d : beta) {
                    if (d == 0.0) continue;
                    ++r;
                }
                this.idxs = MemoryManager.malloc4((int)(sparseCoef ? r : beta.length));
                int j = 0;
                for (int i = 0; i < beta.length; ++i) {
                    if (sparseCoef && beta[i] == 0.0) continue;
                    this.idxs[j++] = i;
                }
                j = 0;
                this.beta = MemoryManager.malloc8d((int)this.idxs.length);
                for (int i : this.idxs) {
                    this.beta[j++] = beta[i];
                }
                if (norm_beta != null) {
                    j = 0;
                    this.norm_beta = MemoryManager.malloc8d((int)this.idxs.length);
                    for (int i : this.idxs) {
                        this.norm_beta[j++] = norm_beta[i];
                    }
                }
            } else {
                this.idxs = null;
            }
            this.rank = r;
            this.sparseCoef = sparseCoef;
        }
    }

    public static class GLM_LBFGS_Parameters
    extends GLMParameters {
    }

    public static class GLMParameters
    extends SupervisedModel.SupervisedParameters {
        public boolean _standardize = true;
        public final Family _family;
        public Link _link;
        public Solver _solver = Solver.ADMM;
        public final double _tweedie_variance_power;
        public final double _tweedie_link_power;
        public double[] _alpha;
        public double[] _lambda;
        public double _prior = -1.0;
        public boolean _lambda_search = false;
        public int _nlambdas = -1;
        public double _lambda_min_ratio = -1.0;
        public boolean _higher_accuracy = false;
        public boolean _use_all_factor_levels = false;
        public int _n_folds;
        public int _max_active_predictors = 10000;

        public void validate(GLM glm) {
            if (this._solver == Solver.L_BFGS) {
                glm.hide("_alpha", "L1 penalty is currently only available for ADMM solver.");
                glm.hide("_higher_accuracy", "only available for ADMM");
                this._alpha = new double[]{0.0};
            }
            if (!this._lambda_search) {
                glm.hide("_lambda_min_ratio", "only applies if lambda search is on.");
                glm.hide("_nlambdas", "only applies if lambda search is on.");
            }
        }

        public GLMParameters() {
            this(Family.gaussian, Link.family_default);
            assert (this._link == Link.family_default);
        }

        public GLMParameters(Family f) {
            this(f, f.defaultLink);
        }

        public GLMParameters(Family f, Link l) {
            this(f, l, new double[]{1.0E-5}, new double[]{0.5});
        }

        public GLMParameters(Family f, Link l, double[] lambda, double[] alpha) {
            this._family = f;
            this._lambda = lambda;
            this._alpha = alpha;
            this._tweedie_link_power = Double.NaN;
            this._tweedie_variance_power = Double.NaN;
            if (f == Family.binomial) {
                this._convert_to_enum = true;
            }
            this._link = l;
            if (this._link != Link.family_default) {
                this._link = l;
                switch (this._family) {
                    case gaussian: {
                        if (this._link == Link.identity || this._link == Link.log || this._link == Link.inverse) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only identity, log and inverse links are allowed for family=gaussian.");
                    }
                    case binomial: {
                        if (this._link == Link.logit || this._link == Link.log) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only logit and log links are allowed for family=binomial.");
                    }
                    case poisson: {
                        if (this._link == Link.log || this._link == Link.identity) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only log and identity links are allowed for family=poisson.");
                    }
                    case gamma: {
                        if (this._link == Link.inverse || this._link == Link.log || this._link == Link.identity) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only inverse, log and identity links are allowed for family=gamma.");
                    }
                    case tweedie: {
                        if (this._link == Link.tweedie) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only tweedie link allowed for family=tweedie.");
                    }
                    default: {
                        H2O.fail();
                    }
                }
            }
        }

        public GLMParameters(Family f, double[] lambda, double[] alpha, double twVar, double twLnk) {
            this._lambda = lambda;
            this._alpha = alpha;
            this._tweedie_variance_power = twVar;
            this._tweedie_link_power = twLnk;
            this._family = f;
            this._link = f.defaultLink;
        }

        public final double variance(double mu) {
            switch (this._family) {
                case gaussian: {
                    return 1.0;
                }
                case binomial: {
                    return mu * (1.0 - mu);
                }
                case poisson: {
                    return mu;
                }
                case gamma: {
                    return mu * mu;
                }
                case tweedie: {
                    return Math.pow(mu, this._tweedie_variance_power);
                }
            }
            throw new RuntimeException("unknown family Id " + (Object)((Object)this));
        }

        public double[] nullModelBeta(FrameTask.DataInfo dinfo, double ymu) {
            double[] res = MemoryManager.malloc8d((int)(dinfo.fullN() + 1));
            res[res.length - 1] = this.link(ymu);
            return res;
        }

        public final boolean canonical() {
            switch (this._family) {
                case gaussian: {
                    return this._link == Link.identity;
                }
                case binomial: {
                    return this._link == Link.logit;
                }
                case poisson: {
                    return this._link == Link.log;
                }
                case gamma: {
                    return false;
                }
                case tweedie: {
                    return false;
                }
            }
            throw H2O.unimpl();
        }

        public final double mustart(double y, double ymu) {
            switch (this._family) {
                case gaussian: 
                case binomial: 
                case poisson: {
                    return ymu;
                }
                case gamma: {
                    return y;
                }
                case tweedie: {
                    return y + (y == 0.0 ? 0.1 : 0.0);
                }
            }
            throw new RuntimeException("unimplemented");
        }

        public final double deviance(double yr, double ym) {
            switch (this._family) {
                case gaussian: {
                    return (yr - ym) * (yr - ym);
                }
                case binomial: {
                    return 2.0 * (GLMParameters.y_log_y(yr, ym) + GLMParameters.y_log_y(1.0 - yr, 1.0 - ym));
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
                case tweedie: {
                    double one_minus_p = 1.0 - this._tweedie_variance_power;
                    double two_minus_p = 2.0 - this._tweedie_variance_power;
                    return Math.pow(yr, two_minus_p) / (one_minus_p * two_minus_p) - yr * Math.pow(ym, one_minus_p) / one_minus_p + Math.pow(ym, two_minus_p) / two_minus_p;
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public final double link(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case logit: {
                    assert (0.0 <= x && x <= 1.0) : "x out of bounds, expected <0,1> range, got " + x;
                    return Math.log(x / (1.0 - x));
                }
                case log: {
                    return Math.log(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return Math.pow(x, this._tweedie_link_power);
                }
            }
            throw new RuntimeException("unknown link function " + (Object)((Object)this));
        }

        public final double linkDeriv(double x) {
            switch (this._link) {
                case logit: {
                    return 1.0 / (x * (1.0 - x));
                }
                case identity: {
                    return 1.0;
                }
                case log: {
                    return 1.0 / x;
                }
                case inverse: {
                    return -1.0 / (x * x);
                }
                case tweedie: {
                    return this._tweedie_link_power * Math.pow(x, this._tweedie_link_power - 1.0);
                }
            }
            throw H2O.unimpl();
        }

        public final double linkInv(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case logit: {
                    return 1.0 / (Math.exp(-x) + 1.0);
                }
                case log: {
                    return Math.exp(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return Math.pow(x, 1.0 / this._tweedie_link_power);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        public final double linkInvDeriv(double x) {
            switch (this._link) {
                case identity: {
                    return 1.0;
                }
                case logit: {
                    double g = Math.exp(-x);
                    double gg = (g + 1.0) * (g + 1.0);
                    return g / gg;
                }
                case log: {
                    return Math.max(Math.exp(x), Double.MIN_NORMAL);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return -1.0 / (xx * xx);
                }
                case tweedie: {
                    double vp = (1.0 - this._tweedie_link_power) / this._tweedie_link_power;
                    return 1.0 / this._tweedie_link_power * Math.pow(x, vp);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        static final double y_log_y(double y, double mu) {
            if (y == 0.0) {
                return 0.0;
            }
            if (mu < Double.MIN_NORMAL) {
                mu = Double.MIN_NORMAL;
            }
            return y * Math.log(y / mu);
        }

        public static enum Solver {
            ADMM,
            L_BFGS;

        }

        public static enum Link {
            family_default,
            identity,
            logit,
            log,
            inverse,
            tweedie;

        }

        public static enum Family {
            gaussian(Link.identity),
            binomial(Link.logit),
            poisson(Link.log),
            gamma(Link.inverse),
            tweedie(Link.tweedie);

            public final Link defaultLink;

            private Family(Link link) {
                this.defaultLink = link;
            }
        }
    }

    public static class GetScoringModelTask
    extends DTask.DKeyTask<GetScoringModelTask, GLMModel> {
        final double _lambda;
        public GLMModel _res;

        public GetScoringModelTask(H2O.H2OCountedCompleter cmp, Key modelKey, double lambda) {
            super(cmp, modelKey);
            this._lambda = lambda;
        }

        public void map(GLMModel m) {
            Submodel sm;
            this._res = (GLMModel)m.clone();
            this._res._output = (GLMOutput)((GLMOutput)this._res._output).clone();
            Submodel submodel = sm = Double.isNaN(this._lambda) ? ((GLMOutput)this._res._output)._submodels[((GLMOutput)this._res._output)._best_lambda_idx] : ((GLMOutput)this._res._output).submodelForLambda(this._lambda);
            assert (sm != null) : "GLM[" + m._key + "]: missing submodel for lambda " + this._lambda;
            sm = (Submodel)sm.clone();
            ((GLMOutput)this._res._output)._submodels = new Submodel[]{sm};
            ((GLMOutput)this._res._output).setSubmodelIdx(0);
        }
    }
}

