/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.FrameTask;
import hex.glm.GLMModel;
import hex.glm.GLMValidation;
import hex.gram.Gram;
import java.util.ArrayList;
import java.util.Arrays;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.util.ArrayUtils;

public abstract class GLMTask<T extends GLMTask<T>>
extends FrameTask<T> {
    protected final GLMModel.GLMParameters _glm;

    public GLMTask(Key jobKey, FrameTask.DataInfo dinfo, GLMModel.GLMParameters glm) {
        this(jobKey, dinfo, glm, null);
    }

    public GLMTask(Key jobKey, FrameTask.DataInfo dinfo, GLMModel.GLMParameters glm, H2O.H2OCountedCompleter cmp) {
        super(jobKey, dinfo == null ? null : dinfo._key, dinfo == null ? null : dinfo._activeCols, cmp);
        this._glm = glm;
    }

    protected final double computeEta(int ncats, int[] cats, double[] nums, double[] beta) {
        double res = 0.0;
        for (int i = 0; i < ncats; ++i) {
            res += beta[cats[i]];
        }
        int numStart = this._dinfo.numStart();
        for (int i = 0; i < nums.length; ++i) {
            res += nums[i] * beta[numStart + i];
        }
        return res += beta[beta.length - 1];
    }

    public static class GLMXValidationTask
    extends GLMValidationTask<GLMXValidationTask> {
        protected final GLMModel[] _xmodels;
        protected GLMValidation[] _xvals;
        long _nobs;
        final float[] _thresholds;

        public static Key makeKey() {
            return Key.make((String)("__GLMValidation_" + Key.make().toString()));
        }

        public GLMXValidationTask(GLMModel mainModel, double lambda, GLMModel[] xmodels, float[] thresholds) {
            this(mainModel, lambda, xmodels, thresholds, null);
        }

        public GLMXValidationTask(GLMModel mainModel, double lambda, GLMModel[] xmodels, float[] thresholds, H2O.H2OCountedCompleter completer) {
            super(mainModel, lambda, completer);
            this._xmodels = xmodels;
            this._thresholds = thresholds;
        }

        @Override
        public void map(Chunk[] chunks) {
            long gid = chunks[0].start();
            this._xvals = new GLMValidation[this._xmodels.length];
            for (int i = 0; i < this._xmodels.length; ++i) {
                this._xvals[i] = new GLMValidation(null, this._xmodels[i]._ymu, (GLMModel.GLMParameters)this._xmodels[i]._parms, ((GLMModel.GLMOutput)this._xmodels[i]._output).rank(), this._thresholds);
            }
            int nrows = chunks[0]._len;
            double[] row = MemoryManager.malloc8d((int)((GLMModel.GLMOutput)this._xmodels[0]._output)._names.length);
            float[] preds = MemoryManager.malloc4f((int)(((GLMModel.GLMParameters)this._xmodels[0]._parms)._family == GLMModel.GLMParameters.Family.binomial ? 3 : 1));
            block1: for (int i = 0; i < nrows; ++i) {
                if (chunks[chunks.length - 1].isNA(i)) continue;
                for (int j = 0; j < chunks.length - 1; ++j) {
                    if (chunks[j].isNA(i)) continue block1;
                    row[j] = chunks[j].atd(i);
                }
                ++this._nobs;
                int mid = (int)(((long)i + gid) % (long)this._xmodels.length);
                GLMModel model = this._xmodels[mid];
                GLMValidation val = this._xvals[mid];
                model.score0(row, preds);
                double response = chunks[chunks.length - 1].at8(i);
                val.add(response, ((GLMModel.GLMParameters)model._parms)._family == GLMModel.GLMParameters.Family.binomial ? (double)preds[2] : (double)preds[0]);
            }
        }

        public void reduce(GLMXValidationTask gval) {
            this._nobs += gval._nobs;
            for (int i = 0; i < this._xvals.length; ++i) {
                this._xvals[i].add(gval._xvals[i]);
            }
        }

        @Override
        public void postGlobal() {
            H2O.H2OCountedCompleter cmp = (H2O.H2OCountedCompleter)this.getCompleter();
            if (cmp != null) {
                cmp.addToPendingCount(this._xvals.length + 1);
            }
            for (int i = 0; i < this._xvals.length; ++i) {
                this._xvals[i].computeAIC();
                this._xvals[i].computeAUC();
                this._xvals[i].nobs = this._nobs - this._xvals[i].nobs;
                GLMModel.setXvalidation(cmp, this._xmodels[i]._key, this._lambda, this._xvals[i]);
            }
            GLMModel.setXvalidation(cmp, this._model._key, this._lambda, new GLMValidation.GLMXValidation(this._model, this._xmodels, this._xvals, this._lambda, this._nobs, this._thresholds));
        }
    }

    public static class GLMValidationTask<T extends GLMValidationTask<T>>
    extends MRTask<T> {
        protected final GLMModel _model;
        protected GLMValidation _res;
        public final double _lambda;
        public boolean _improved;
        Key _jobKey;

        public static Key makeKey() {
            return Key.make((String)("__GLMValidation_" + Key.make().toString()));
        }

        public GLMValidationTask(GLMModel model, double lambda) {
            this(model, lambda, null);
        }

        public GLMValidationTask(GLMModel model, double lambda, H2O.H2OCountedCompleter completer) {
            super(completer);
            this._lambda = lambda;
            this._model = model;
        }

        public void map(Chunk[] chunks) {
            this._res = new GLMValidation(null, this._model._ymu, (GLMModel.GLMParameters)this._model._parms, this._model.rank(this._lambda));
            int nrows = chunks[0]._len;
            double[] row = MemoryManager.malloc8d((int)((GLMModel.GLMOutput)this._model._output)._names.length);
            float[] preds = MemoryManager.malloc4f((int)(((GLMModel.GLMParameters)this._model._parms)._family == GLMModel.GLMParameters.Family.binomial ? 3 : 1));
            block0: for (int i = 0; i < nrows; ++i) {
                if (chunks[chunks.length - 1].isNA(i)) continue;
                for (int j = 0; j < chunks.length - 1; ++j) {
                    if (chunks[j].isNA(i)) continue block0;
                    row[j] = chunks[j].atd(i);
                }
                this._model.score0(row, preds);
                double response = chunks[chunks.length - 1].atd(i);
                this._res.add(response, ((GLMModel.GLMParameters)this._model._parms)._family == GLMModel.GLMParameters.Family.binomial ? (double)preds[2] : (double)preds[0]);
            }
        }

        public void reduce(GLMValidationTask gval) {
            this._res.add(gval._res);
        }

        public void postGlobal() {
            this._res.computeAIC();
            this._res.computeAUC();
        }
    }

    public static class GLMIterationTask
    extends GLMTask<GLMIterationTask> {
        final double[] _beta;
        protected Gram _gram;
        double[] _xy;
        protected double[] _grad;
        double _yy;
        GLMValidation _val;
        final double _ymu;
        protected final double _reg;
        long _nobs;
        final boolean _validate;
        final float[] _thresholds;
        float[][] _newThresholds;
        int[] _ti;
        final boolean _computeGradient;
        final boolean _computeGram;
        public static final int N_THRESHOLDS = 50;

        public GLMIterationTask(Key jobKey, FrameTask.DataInfo dinfo, GLMModel.GLMParameters glm, boolean computeGram, boolean validate, boolean computeGradient, double[] beta, double ymu, double reg, float[] thresholds, H2O.H2OCountedCompleter cmp) {
            super(jobKey, dinfo, glm, cmp);
            this._beta = beta;
            this._ymu = ymu;
            this._reg = reg;
            this._computeGram = computeGram;
            this._validate = validate;
            assert (glm._family != GLMModel.GLMParameters.Family.binomial || thresholds != null);
            this._thresholds = (float[])(this._validate ? thresholds : null);
            this._computeGradient = computeGradient;
            assert (!this._computeGradient || validate);
        }

        private void sampleThresholds(int yi) {
            this._ti[yi] = this._newThresholds[yi].length >> 2;
            try {
                Arrays.sort(this._newThresholds[yi]);
            }
            catch (Throwable t) {
                System.out.println("got AIOOB during sort?! ary = " + Arrays.toString(this._newThresholds[yi]));
                return;
            }
            for (int i = 0; i < this._newThresholds.length; i += 4) {
                this._newThresholds[yi][i >> 2] = this._newThresholds[yi][i];
            }
        }

        @Override
        public void processRow(long gid, double[] nums, int ncats, int[] cats, double[] responses) {
            double var;
            double mu;
            double z;
            double w;
            ++this._nobs;
            double y = responses[0];
            assert (this._glm._family != GLMModel.GLMParameters.Family.gamma || y > 0.0) : "illegal response column, y must be > 0  for family=Gamma.";
            assert (this._glm._family != GLMModel.GLMParameters.Family.binomial || 0.0 <= y && y <= 1.0) : "illegal response column, y must be <0,1>  for family=Binomial. got " + y;
            int numStart = this._dinfo.numStart();
            double d = 1.0;
            if (this._glm._family == GLMModel.GLMParameters.Family.gaussian) {
                w = 1.0;
                z = y;
                mu = this._validate || this._computeGradient ? this.computeEta(ncats, cats, nums, this._beta) : 0.0;
                var = 1.0;
            } else {
                double eta;
                if (this._beta == null) {
                    mu = this._glm.mustart(y, this._ymu);
                    eta = this._glm.link(mu);
                } else {
                    eta = this.computeEta(ncats, cats, nums, this._beta);
                    mu = this._glm.linkInv(eta);
                }
                var = Math.max(1.0E-6, this._glm.variance(mu));
                d = this._glm.linkDeriv(mu);
                z = eta + (y - mu) * d;
                w = 1.0 / (var * d * d);
            }
            if (this._validate) {
                this._val.add(y, mu);
                if (this._glm._family == GLMModel.GLMParameters.Family.binomial) {
                    int yi = (int)y;
                    if (this._ti[yi] == this._newThresholds[yi].length) {
                        this.sampleThresholds(yi);
                    }
                    int n = yi;
                    int n2 = this._ti[n];
                    this._ti[n] = n2 + 1;
                    this._newThresholds[yi][n2] = (float)mu;
                }
            }
            assert (w >= 0.0 || Double.isNaN(w)) : "invalid weight " + w;
            double wz = w * z;
            this._yy += wz * z;
            if (this._computeGradient || this._computeGram) {
                int i;
                double grad = this._computeGradient ? (mu - y) / (var * d) : 0.0;
                for (i = 0; i < ncats; ++i) {
                    int ii = cats[i];
                    if (this._computeGradient) {
                        int n = ii;
                        this._grad[n] = this._grad[n] + grad;
                    }
                    int n = ii;
                    this._xy[n] = this._xy[n] + wz;
                }
                for (i = 0; i < nums.length; ++i) {
                    int n = numStart + i;
                    this._xy[n] = this._xy[n] + wz * nums[i];
                    if (!this._computeGradient) continue;
                    int n3 = numStart + i;
                    this._grad[n3] = this._grad[n3] + grad * nums[i];
                }
                if (this._computeGradient) {
                    int n = numStart + this._dinfo._nums;
                    this._grad[n] = this._grad[n] + grad;
                }
                int n = numStart + this._dinfo._nums;
                this._xy[n] = this._xy[n] + wz;
                if (this._computeGram) {
                    this._gram.addRow(nums, ncats, cats, w);
                }
            }
        }

        @Override
        protected void chunkInit() {
            if (this._computeGram) {
                this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo._nums, this._dinfo._cats, true);
            }
            this._xy = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
            int rank = 0;
            if (this._beta != null) {
                for (double d : this._beta) {
                    if (d == 0.0) continue;
                    ++rank;
                }
            }
            if (this._validate) {
                this._val = new GLMValidation(null, this._ymu, this._glm, rank, this._thresholds);
                if (this._glm._family == GLMModel.GLMParameters.Family.binomial) {
                    this._ti = new int[2];
                    this._newThresholds = new float[2][200];
                }
            }
            if (this._computeGradient) {
                this._grad = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
            }
            if (this._glm._family == GLMModel.GLMParameters.Family.binomial && this._validate) {
                this._ti = new int[2];
                this._newThresholds = new float[2][200];
            }
        }

        @Override
        protected void chunkDone(long n) {
            if (this._computeGram) {
                this._gram.mul(this._reg);
            }
            int i = 0;
            while (i < this._xy.length) {
                int n2 = i++;
                this._xy[n2] = this._xy[n2] * this._reg;
            }
            if (this._grad != null) {
                i = 0;
                while (i < this._grad.length) {
                    int n3 = i++;
                    this._grad[n3] = this._grad[n3] * this._reg;
                }
            }
            this._yy *= this._reg;
            if (this._validate && this._glm._family == GLMModel.GLMParameters.Family.binomial) {
                assert (this._val != null);
                this._newThresholds[0] = Arrays.copyOf(this._newThresholds[0], this._ti[0]);
                this._newThresholds[1] = Arrays.copyOf(this._newThresholds[1], this._ti[1]);
                Arrays.sort(this._newThresholds[0]);
                Arrays.sort(this._newThresholds[1]);
            }
        }

        public void reduce(GLMIterationTask git) {
            if (this._jobKey == null || Job.isRunning((Key)this._jobKey)) {
                ArrayUtils.add((double[])this._xy, (double[])git._xy);
                if (this._computeGram) {
                    this._gram.add(git._gram);
                }
                this._yy += git._yy;
                this._nobs += git._nobs;
                if (this._validate) {
                    this._val.add(git._val);
                }
                if (this._computeGradient) {
                    ArrayUtils.add((double[])this._grad, (double[])git._grad);
                }
                if (this._validate && this._glm._family == GLMModel.GLMParameters.Family.binomial) {
                    int i;
                    this._newThresholds[0] = ArrayUtils.join((float[])this._newThresholds[0], (float[])git._newThresholds[0]);
                    this._newThresholds[1] = ArrayUtils.join((float[])this._newThresholds[1], (float[])git._newThresholds[1]);
                    if (this._newThresholds[0].length >= 100) {
                        for (i = 0; i < 100; i += 2) {
                            this._newThresholds[0][i >> 1] = this._newThresholds[0][i];
                        }
                    }
                    if (this._newThresholds[0].length > 50) {
                        this._newThresholds[0] = Arrays.copyOf(this._newThresholds[0], 50);
                    }
                    if (this._newThresholds[1].length >= 100) {
                        for (i = 0; i < 100; i += 2) {
                            this._newThresholds[1][i >> 1] = this._newThresholds[1][i];
                        }
                    }
                    if (this._newThresholds[1].length > 50) {
                        this._newThresholds[1] = Arrays.copyOf(this._newThresholds[1], 50);
                    }
                }
                super.reduce((MRTask)git);
            }
        }

        protected void postGlobal() {
            if (this._val != null) {
                this._val.computeAIC();
                this._val.computeAUC();
            }
        }

        public double[] gradient(double alpha, double lambda) {
            double[] res = (double[])this._grad.clone();
            if (this._beta != null) {
                for (int i = 0; i < res.length - 1; ++i) {
                    int n = i;
                    res[n] = res[n] + (1.0 - alpha) * lambda * this._beta[i];
                }
            }
            return res;
        }
    }

    public static class ColGradientTask
    extends MRTask<ColGradientTask> {
        final GLMModel.GLMParameters _params;
        final double[][] _beta;
        final FrameTask.DataInfo _dinfo;
        final double _reg;
        double[][] _gradient;
        double[] _objVals;

        public ColGradientTask(FrameTask.DataInfo dinfo, GLMModel.GLMParameters params, double[][] beta, double reg) {
            this._dinfo = dinfo;
            this._params = params;
            this._beta = beta;
            this._reg = reg;
        }

        public void map(Chunk[] chks) {
            int i;
            int j;
            int j2;
            int i2;
            double[][] eta = new double[this._beta.length][];
            double[] obj = MemoryManager.malloc8d((int)this._beta.length);
            boolean[] skp = MemoryManager.mallocZ((int)chks[0]._len);
            for (i2 = 0; i2 < eta.length; ++i2) {
                eta[i2] = MemoryManager.malloc8d((int)chks[0]._len);
            }
            this._gradient = new double[this._beta.length][];
            for (i2 = 0; i2 < this._gradient.length; ++i2) {
                this._gradient[i2] = MemoryManager.malloc8d((int)this._beta[i2].length);
            }
            int nxs = chks.length - 1;
            Chunk responseChunk = chks[nxs];
            Chunk offsetChunk = null;
            if (this._dinfo._offset) {
                offsetChunk = chks[--nxs];
            }
            for (int i3 = 0; i3 < this._dinfo._cats; ++i3) {
                Chunk c = chks[i3];
                for (int r = 0; r < c._len; ++r) {
                    if (skp[r] || c.isNA(r)) {
                        skp[r] = true;
                        continue;
                    }
                    int off = (int)c.at8(r) + this._dinfo._catOffsets[i3];
                    if (!this._dinfo._useAllFactorLevels) {
                        if (off == this._dinfo._catOffsets[i3]) continue;
                        --off;
                    }
                    for (int j3 = 0; j3 < eta.length; ++j3) {
                        double[] dArray = eta[j3];
                        int n = r;
                        dArray[n] = dArray[n] + this._beta[j3][off];
                    }
                }
            }
            int numStart = this._dinfo.numStart();
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                for (int j4 = 0; j4 < eta.length; ++j4) {
                    double off = 0.0;
                    for (int i4 = 0; i4 < this._dinfo._nums; ++i4) {
                        off -= this._beta[j4][numStart + i4] * this._dinfo._normSub[i4] * this._dinfo._normMul[i4];
                    }
                    int r = 0;
                    while (r < chks[0]._len) {
                        double[] dArray = eta[j4];
                        int n = r++;
                        dArray[n] = dArray[n] + off;
                    }
                }
            }
            for (int i5 = 0; i5 < this._dinfo._nums; ++i5) {
                Chunk c = chks[i5 + this._dinfo._cats];
                int r = c.nextNZ(-1);
                while (r < c._len) {
                    if (skp[r] || c.isNA(r)) {
                        skp[r] = true;
                    } else {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i5];
                        }
                        for (j2 = 0; j2 < eta.length; ++j2) {
                            double[] dArray = eta[j2];
                            int n = r;
                            dArray[n] = dArray[n] + this._beta[j2][numStart + i5] * d;
                        }
                    }
                    r = c.nextNZ(r);
                }
            }
            double[] eta_sums = MemoryManager.malloc8d((int)eta.length);
            for (int r = 0; r < chks[0]._len; ++r) {
                if (skp[r] || responseChunk.isNA(r)) continue;
                double off = this._dinfo._offset ? offsetChunk.atd(r) : 0.0;
                double y = responseChunk.atd(r);
                for (j = 0; j < eta.length; ++j) {
                    double offset = off + (this._dinfo._intercept ? this._beta[j][this._beta[j].length - 1] : 0.0);
                    double mu = this._params.linkInv(eta[j][r] + offset);
                    int n = j;
                    obj[n] = obj[n] + this._params.deviance(y, mu);
                    double var = this._params.variance(mu);
                    if (var < 1.0E-6) {
                        var = 1.0E-6;
                    }
                    eta[j][r] = (mu - y) / (var * this._params.linkDeriv(mu));
                    int n2 = j;
                    eta_sums[n2] = eta_sums[n2] + eta[j][r];
                }
            }
            for (int j5 = 0; j5 < this._gradient.length; ++j5) {
                if (this._dinfo._intercept) {
                    this._gradient[j5][this._gradient[j5].length - 1] = eta_sums[j5];
                }
                if (this._dinfo._normMul == null || this._dinfo._normSub == null) continue;
                for (int i6 = 0; i6 < this._dinfo._nums; ++i6) {
                    this._gradient[j5][numStart + i6] = -this._dinfo._normSub[i6] * this._dinfo._normMul[i6] * eta_sums[j5];
                }
            }
            for (i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (int r = 0; r < c._len; ++r) {
                    if (skp[r]) continue;
                    int off = (int)c.at8(r) + this._dinfo._catOffsets[i];
                    if (!this._dinfo._useAllFactorLevels) {
                        if (off == this._dinfo._catOffsets[i]) continue;
                        --off;
                    }
                    for (j2 = 0; j2 < eta.length; ++j2) {
                        double[] dArray = this._gradient[j2];
                        int n = off;
                        dArray[n] = dArray[n] + eta[j2][r];
                    }
                }
            }
            for (i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                int r = c.nextNZ(-1);
                while (r < c._len) {
                    if (!skp[r] && !c.isNA(r)) {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        for (j = 0; j < eta.length; ++j) {
                            double[] dArray = this._gradient[j];
                            int n = numStart + i;
                            dArray[n] = dArray[n] + eta[j][r] * d;
                        }
                    }
                    r = c.nextNZ(r);
                }
            }
            for (i = 0; i < this._beta.length; ++i) {
                int n = i;
                obj[n] = obj[n] * this._reg;
                int j6 = 0;
                while (j6 < this._beta[i].length) {
                    double[] dArray = this._gradient[i];
                    int n3 = j6++;
                    dArray[n3] = dArray[n3] * this._reg;
                }
            }
            this._objVals = obj;
        }

        public void reduce(ColGradientTask grt) {
            ArrayUtils.add((double[])this._objVals, (double[])grt._objVals);
            for (int i = 0; i < this._beta.length; ++i) {
                ArrayUtils.add((double[])this._gradient[i], (double[])grt._gradient[i]);
            }
        }
    }

    public static class GLMLineSearchTask
    extends GLMTask<GLMLineSearchTask> {
        GLMIterationTask[] _glmts;

        public GLMLineSearchTask(Key jobKey, FrameTask.DataInfo dinfo, GLMModel.GLMParameters glm, double[] oldBeta, double[] newBeta, double betaEps, double ymu, long nobs, H2O.H2OCountedCompleter cmp) {
            super(jobKey, dinfo, glm, cmp);
            int i;
            ArrayList<Object> betas = new ArrayList<Object>();
            double diff = 1.0;
            while (diff > betaEps && betas.size() < 100) {
                diff = 0.0;
                for (i = 0; i < newBeta.length; ++i) {
                    newBeta[i] = 0.5 * (oldBeta == null ? newBeta[i] : oldBeta[i] + newBeta[i]);
                    double d = newBeta[i] - (oldBeta == null ? 0.0 : oldBeta[i]);
                    if (d > diff) {
                        diff = d;
                        continue;
                    }
                    if (!(d < -diff)) continue;
                    diff = -d;
                }
                betas.add(newBeta.clone());
            }
            this._glmts = new GLMIterationTask[betas.size()];
            for (i = 0; i < this._glmts.length; ++i) {
                this._glmts[i] = new GLMIterationTask(jobKey, null, glm, false, true, true, (double[])betas.get(i), ymu, 1.0 / (double)nobs, new float[]{0.0f}, null);
            }
        }

        public GLMLineSearchTask(Key jobKey, FrameTask.DataInfo dinfo, GLMModel.GLMParameters glm, double[][] betas, double ymu, long nobs, H2O.H2OCountedCompleter cmp) {
            super(jobKey, dinfo, glm, cmp);
            this._glmts = new GLMIterationTask[betas.length];
            for (int i = 0; i < this._glmts.length; ++i) {
                this._glmts[i] = new GLMIterationTask(jobKey, null, glm, false, true, true, betas[i], ymu, 1.0 / (double)nobs, new float[]{0.0f}, null);
            }
        }

        @Override
        public void setupLocal() {
            super.setupLocal();
            for (GLMIterationTask glmt : this._glmts) {
                ((GLMTask)glmt)._dinfo = this._dinfo;
            }
        }

        @Override
        public void closeLocal() {
            super.closeLocal();
            for (GLMIterationTask glmt : this._glmts) {
                ((GLMTask)glmt)._dinfo = null;
            }
        }

        @Override
        public void chunkInit() {
            this._glmts = (GLMIterationTask[])this._glmts.clone();
            for (int i = 0; i < this._glmts.length; ++i) {
                this._glmts[i] = (GLMIterationTask)this._glmts[i].clone();
                this._glmts[i].chunkInit();
            }
        }

        @Override
        public void chunkDone(long n) {
            for (int i = 0; i < this._glmts.length; ++i) {
                this._glmts[i].chunkDone(n);
            }
        }

        public void postGlobal() {
            for (int i = 0; i < this._glmts.length; ++i) {
                this._glmts[i].postGlobal();
            }
        }

        @Override
        public final void processRow(long gid, double[] nums, int ncats, int[] cats, double[] responses) {
            for (int i = 0; i < this._glmts.length; ++i) {
                this._glmts[i].processRow(gid, nums, ncats, cats, responses);
            }
        }

        public void reduce(GLMLineSearchTask git) {
            for (int i = 0; i < this._glmts.length; ++i) {
                this._glmts[i].reduce(git._glmts[i]);
            }
        }
    }

    static class LMAXTask
    extends GLMIterationTask {
        private double[] _z;
        private final double _gPrimeMu;
        private double _lmax;
        private final double _alpha;

        public LMAXTask(Key jobKey, FrameTask.DataInfo dinfo, GLMModel.GLMParameters params, double ymu, long nobs, float[] thresholds, H2O.H2OCountedCompleter cmp) {
            super(jobKey, dinfo, params, false, true, true, params.nullModelBeta(dinfo, ymu), ymu, 1.0 / (double)nobs, thresholds, cmp);
            this._gPrimeMu = params.linkDeriv(ymu);
            this._alpha = params._alpha[0];
        }

        @Override
        public void chunkInit() {
            super.chunkInit();
            this._z = MemoryManager.malloc8d((int)this._grad.length);
        }

        @Override
        public void processRow(long gid, double[] nums, int ncats, int[] cats, double[] responses) {
            double w = (responses[0] - this._ymu) * this._gPrimeMu;
            for (int i = 0; i < ncats; ++i) {
                int n = cats[i];
                this._z[n] = this._z[n] + w;
            }
            int numStart = this._dinfo.numStart();
            for (int i = 0; i < nums.length; ++i) {
                int n = i + numStart;
                this._z[n] = this._z[n] + w * nums[i];
            }
            super.processRow(gid, nums, ncats, cats, responses);
        }

        @Override
        public void reduce(GLMIterationTask git) {
            ArrayUtils.add((double[])this._z, (double[])((LMAXTask)git)._z);
            super.reduce(git);
        }

        @Override
        protected void postGlobal() {
            super.postGlobal();
            double res = Math.abs(this._z[0]);
            for (int i = 1; i < this._z.length; ++i) {
                if (res < this._z[i]) {
                    res = this._z[i];
                    continue;
                }
                if (!(res < -this._z[i])) continue;
                res = -this._z[i];
            }
            this._lmax = this._glm.variance(this._ymu) * res / ((double)this._nobs * Math.max(this._alpha, 0.001));
        }

        public double lmax() {
            return this._lmax;
        }
    }

    static class YMUTask
    extends FrameTask<YMUTask> {
        private long[] _nobs;
        protected double[] _ymu;
        public double[] _ymin;
        public double[] _ymax;
        final int _nfolds;

        public YMUTask(Key jobKey, Key dataInfoKey, int nfolds) {
            this(jobKey, dataInfoKey, nfolds, null);
        }

        public YMUTask(Key jobKey, Key dataInfoKey, int nfolds, H2O.H2OCountedCompleter cmp) {
            super(jobKey, dataInfoKey, null, cmp);
            this._nfolds = nfolds;
        }

        @Override
        public void chunkInit() {
            super.chunkInit();
            this._ymu = new double[this._nfolds + 1];
            this._nobs = new long[this._nfolds + 1];
            this._ymax = new double[this._nfolds + 1];
            this._ymin = new double[this._nfolds + 1];
            Arrays.fill(this._ymax, Double.NEGATIVE_INFINITY);
            Arrays.fill(this._ymin, Double.POSITIVE_INFINITY);
        }

        @Override
        protected void processRow(long gid, double[] nums, int ncats, int[] cats, double[] responses) {
            double response = responses[0];
            this._ymu[0] = this._ymu[0] + response;
            this._nobs[0] = this._nobs[0] + 1L;
            if (response < this._ymin[0]) {
                this._ymin[0] = response;
            }
            if (response > this._ymax[0]) {
                this._ymax[0] = response;
            }
            for (int i = 1; i < this._nfolds + 1; ++i) {
                if (gid % (long)this._nfolds == (long)(i - 1)) continue;
                int n = i;
                this._ymu[n] = this._ymu[n] + response;
                int n2 = i;
                this._nobs[n2] = this._nobs[n2] + 1L;
                if (response < this._ymin[0]) {
                    this._ymin[i] = response;
                }
                if (!(response > this._ymax[i])) continue;
                this._ymax[i] = response;
            }
        }

        public void reduce(YMUTask t) {
            if (t._nobs[0] != 0L) {
                if (this._nobs[0] == 0L) {
                    this._ymu = t._ymu;
                    this._nobs = t._nobs;
                    this._ymin = t._ymin;
                    this._ymax = t._ymax;
                } else {
                    for (int i = 0; i < this._nfolds + 1; ++i) {
                        if (this._nobs[i] + t._nobs[i] == 0L) continue;
                        this._ymu[i] = this._ymu[i] * ((double)this._nobs[i] / (double)(this._nobs[i] + t._nobs[i])) + t._ymu[i] * (double)t._nobs[i] / (double)(this._nobs[i] + t._nobs[i]);
                        int n = i;
                        this._nobs[n] = this._nobs[n] + t._nobs[i];
                        if (t._ymax[i] > this._ymax[i]) {
                            this._ymax[i] = t._ymax[i];
                        }
                        if (!(t._ymin[i] < this._ymin[i])) continue;
                        this._ymin[i] = t._ymin[i];
                    }
                }
            }
        }

        @Override
        protected void chunkDone(long n) {
            for (int i = 0; i < this._ymu.length; ++i) {
                if (this._nobs[i] == 0L) continue;
                int n2 = i;
                this._ymu[n2] = this._ymu[n2] / (double)this._nobs[i];
            }
        }

        public double ymu() {
            return this.ymu(-1);
        }

        public long nobs() {
            return this.nobs(-1);
        }

        public double ymu(int foldId) {
            return this._ymu[foldId + 1];
        }

        public long nobs(int foldId) {
            return this._nobs[foldId + 1];
        }
    }
}

