/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import hex.FrameTask;
import hex.Model;
import hex.ModelBuilder;
import hex.gram.Gram;
import hex.pca.PCAModel;
import hex.schemas.ModelBuilderSchema;
import hex.schemas.PCAV2;
import java.util.ArrayList;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.MemoryManager;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;

public class PCA
extends ModelBuilder<PCAModel, PCAModel.PCAParameters, PCAModel.PCAOutput> {
    static final int MAX_COL = 5000;

    public Model.ModelCategory[] can_build() {
        return new Model.ModelCategory[]{Model.ModelCategory.Clustering};
    }

    public PCA(PCAModel.PCAParameters parms) {
        super("PCA", (Model.Parameters)parms);
        this.init(false);
    }

    public ModelBuilderSchema schema() {
        return new PCAV2();
    }

    public Job<PCAModel> trainModel() {
        return this.start(new PCADriver(), 0L);
    }

    public void init(boolean expensive) {
        super.init(expensive);
    }

    private class PCADriver
    extends H2O.H2OCountedCompleter<PCADriver> {
        private PCADriver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute2() {
            block14: {
                PCAModel model = null;
                FrameTask.DataInfo dinfo = null;
                try {
                    ((PCAModel.PCAParameters)PCA.this._parms).read_lock_frames((Job)PCA.this);
                    PCA.this.init(true);
                    model = new PCAModel(PCA.this.dest(), (PCAModel.PCAParameters)PCA.this._parms, new PCAModel.PCAOutput(PCA.this));
                    model.delete_and_lock(PCA.this._key);
                    Frame fr = PCA.this._train;
                    Vec[] vecs = fr.vecs();
                    ArrayList<Integer> removeCols = new ArrayList<Integer>();
                    for (int i = 0; i < vecs.length; ++i) {
                        if (vecs[i].min() != vecs[i].max() && !((double)vecs[i].naCnt() > (double)vecs[i].length() * 0.2)) continue;
                        removeCols.add(i);
                    }
                    if (!removeCols.isEmpty()) {
                        int[] cols = new int[removeCols.size()];
                        for (int i = 0; i < cols.length; ++i) {
                            cols[i] = (Integer)removeCols.get(i);
                        }
                        fr.remove(cols);
                    }
                    if (fr.numCols() < 2) {
                        throw new IllegalArgumentException("Need more than one column to run PCA");
                    }
                    dinfo = new FrameTask.DataInfo(Key.make(), fr, null, 0, false, ((PCAModel.PCAParameters)PCA.this._parms)._standardized ? FrameTask.DataInfo.TransformType.STANDARDIZE : FrameTask.DataInfo.TransformType.NONE);
                    DKV.put((Key)dinfo._key, (Iced)dinfo);
                    ((PCAModel.PCAOutput)model._output)._catOffsets = dinfo._catOffsets;
                    ((PCAModel.PCAOutput)model._output)._normSub = dinfo._normSub;
                    ((PCAModel.PCAOutput)model._output)._normMul = dinfo._normMul;
                    Gram.GramTask tsk = (Gram.GramTask)new Gram.GramTask(PCA.this._key, dinfo, false, false).doAll(dinfo._adaptedFrame);
                    Matrix myGram = new Matrix(tsk._gram.getXX());
                    SingularValueDecomposition mySVD = myGram.svd();
                    double[] Sval = mySVD.getSingularValues();
                    ((PCAModel.PCAOutput)model._output)._eigVec = mySVD.getV().getArray();
                    assert (Sval.length == ((PCAModel.PCAOutput)model._output)._eigVec.length);
                    ((PCAModel.PCAOutput)model._output)._rank = mySVD.rank();
                    double[] sdev = new double[Sval.length];
                    double totVar = 0.0;
                    double dfcorr = (double)dinfo._adaptedFrame.numRows() / ((double)dinfo._adaptedFrame.numRows() - 1.0);
                    for (int i = 0; i < Sval.length; ++i) {
                        Sval[i] = dfcorr * Sval[i];
                        sdev[i] = Math.sqrt(Sval[i]);
                        totVar += Sval[i];
                    }
                    ((PCAModel.PCAOutput)model._output)._sdev = sdev;
                    ((PCAModel.PCAOutput)model._output)._namesExp = this.namesExp(sdev.length);
                    ((PCAModel.PCAOutput)model._output)._numPC = Math.min(this.getNumPC(sdev, ((PCAModel.PCAParameters)PCA.this._parms)._tolerance), ((PCAModel.PCAParameters)PCA.this._parms)._max_pc);
                    double[] propVar = new double[Sval.length];
                    double[] cumVar = new double[Sval.length];
                    for (int i = 0; i < Sval.length; ++i) {
                        propVar[i] = Sval[i] / totVar;
                        cumVar[i] = i == 0 ? propVar[0] : cumVar[i - 1] + propVar[i];
                    }
                    ((PCAModel.PCAOutput)model._output)._propVar = propVar;
                    ((PCAModel.PCAOutput)model._output)._cumVar = cumVar;
                    PCA.this.done();
                }
                catch (Throwable t) {
                    Job thisJob = (Job)DKV.getGet((Key)PCA.this._key);
                    if (thisJob._state == Job.JobState.CANCELLED) {
                        Log.info((Object[])new Object[]{"Job cancelled by user."});
                        break block14;
                    }
                    t.printStackTrace();
                    PCA.this.failed(t);
                    throw t;
                }
                finally {
                    if (model != null) {
                        model.unlock(PCA.this._key);
                    }
                    DKV.remove((Key)dinfo._key);
                    ((PCAModel.PCAParameters)PCA.this._parms).read_unlock_frames((Job)PCA.this);
                }
            }
            this.tryComplete();
        }

        public String[] namesExp(int sdevLen) {
            int i;
            int i2;
            int n = ((PCA)PCA.this)._train._names.length;
            String[][] domains = PCA.this._train.domains();
            int[] nums = MemoryManager.malloc4((int)n);
            int[] cats = MemoryManager.malloc4((int)n);
            int nnums = 0;
            int ncats = 0;
            for (i2 = 0; i2 < n; ++i2) {
                if (domains[i2] != null) {
                    cats[ncats++] = i2;
                    continue;
                }
                nums[nnums++] = i2;
            }
            for (i2 = 0; i2 < ncats; ++i2) {
                for (int j = i2 + 1; j < ncats; ++j) {
                    if (domains[cats[i2]].length >= domains[cats[j]].length) continue;
                    int x = cats[i2];
                    cats[i2] = cats[j];
                    cats[j] = x;
                }
            }
            int k = 0;
            String[] names = new String[sdevLen];
            for (i = 0; i < ncats; ++i) {
                for (int j = 1; j < domains[cats[i]].length; ++j) {
                    names[k++] = ((PCA)PCA.this)._train._names[cats[i]] + "." + domains[cats[i]][j];
                }
            }
            for (i = 0; i < nnums; ++i) {
                names[k++] = ((PCA)PCA.this)._train._names[nums[i]];
            }
            return names;
        }

        public int getNumPC(double[] sdev, double tol) {
            if (sdev == null) {
                return 0;
            }
            double cutoff = tol * sdev[0];
            for (int i = 0; i < sdev.length; ++i) {
                if (!(sdev[i] < cutoff)) continue;
                return i;
            }
            return sdev.length;
        }
    }
}

