/*
 * Decompiled with CFR 0.152.
 */
package hex.quantile;

import hex.Model;
import hex.ModelBuilder;
import hex.quantile.QuantileModel;
import hex.schemas.ModelBuilderSchema;
import hex.schemas.QuantileV2;
import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;

public class Quantile
extends ModelBuilder<QuantileModel, QuantileModel.QuantileParameters, QuantileModel.QuantileOutput> {
    public Quantile(QuantileModel.QuantileParameters parms) {
        super("Quantile", (Model.Parameters)parms);
        this.init(false);
    }

    public ModelBuilderSchema schema() {
        return new QuantileV2();
    }

    public Quantile trainModel() {
        return (Quantile)this.start(new QuantileDriver(), this.train().numCols() * ((QuantileModel.QuantileParameters)this._parms)._probs.length);
    }

    public Model.ModelCategory[] can_build() {
        return new Model.ModelCategory[]{Model.ModelCategory.Unknown};
    }

    public void init(boolean expensive) {
        super.init(expensive);
        for (double p : ((QuantileModel.QuantileParameters)this._parms)._probs) {
            if (!(p < 0.0) && !(p > 1.0)) continue;
            this.error("_probs", "Probabilities must be between 0 and 1");
        }
    }

    static double computeQuantile(double lo, double hi, long row, long nrows, double prob) {
        if (lo == hi) {
            return lo;
        }
        double plo = (double)(row + 0L) / (double)(nrows - 1L);
        double phi = (double)(row + 1L) / (double)(nrows - 1L);
        assert (plo <= prob && prob < phi);
        return lo + (hi - lo) * (prob - plo) / (phi - plo);
    }

    private static class Histo
    extends MRTask<Histo> {
        private static final int NBINS = 1024;
        private final int _nbins;
        private final double _lb;
        private final double _step;
        private final long _start_row;
        private final long _nrows;
        private final boolean _isInt;
        long[] _bins;
        double[] _elems;

        private Histo(double lb, double ub, long start_row, long nrows, boolean isInt) {
            this._nbins = 1024;
            this._lb = lb;
            this._step = (ub - lb) / (double)this._nbins;
            this._start_row = start_row;
            this._nrows = nrows;
            this._isInt = isInt;
        }

        public void map(Chunk chk) {
            this._bins = new long[this._nbins];
            long[] bins = this._bins;
            this._elems = new double[this._nbins];
            double[] elems = this._elems;
            for (int row = 0; row < chk._len; ++row) {
                double d = chk.atd(row);
                double idx = (d - this._lb) / this._step;
                if (!(0.0 <= idx) || !(idx < (double)bins.length)) continue;
                int i = (int)idx;
                if (bins[i] == 0L) {
                    elems[i] = d;
                } else if (!Double.isNaN(elems[i]) && elems[i] != d) {
                    elems[i] = Double.NaN;
                }
                int n = i;
                bins[n] = bins[n] + 1L;
            }
        }

        public void reduce(Histo h) {
            for (int i = 0; i < this._nbins; ++i) {
                if (this._bins[i] == 0L) {
                    this._elems[i] = h._elems[i];
                    continue;
                }
                if (h._bins[i] <= 0L || this._elems[i] == h._elems[i]) continue;
                this._elems[i] = Double.NaN;
            }
            ArrayUtils.add((long[])this._bins, (long[])h._bins);
        }

        double findQuantile(double prob) {
            double hi;
            double lo;
            double p2 = prob * (double)(this._nrows - 1L);
            long r2 = (long)p2;
            int loidx = this.findBin(r2);
            double d = lo = loidx == this._nbins ? this.binEdge(this._nbins) : this._elems[loidx];
            if (Double.isNaN(lo)) {
                return Double.NaN;
            }
            if ((double)r2 == p2) {
                return lo;
            }
            long r3 = r2 + 1L;
            int hiidx = this.findBin(r3);
            double d2 = hi = hiidx == this._nbins ? this.binEdge(this._nbins) : this._elems[hiidx];
            if (Double.isNaN(hi)) {
                return Double.NaN;
            }
            return Quantile.computeQuantile(lo, hi, r2, this._nrows, prob);
        }

        private double binEdge(int idx) {
            return this._lb + this._step * (double)idx;
        }

        private int findBin(long row) {
            long sum = this._start_row;
            for (int i = 0; i < this._nbins; ++i) {
                if (row >= (sum += this._bins[i])) continue;
                return i;
            }
            return this._nbins;
        }

        Histo refinePass(double prob) {
            double prow = prob * (double)(this._nrows - 1L);
            long lorow = (long)prow;
            int loidx = this.findBin(lorow);
            assert (loidx < this._nbins);
            double lo = this.binEdge(loidx);
            long hirow = (double)lorow == prow ? lorow : lorow + 1L;
            int hiidx = this.findBin(hirow);
            double hi = hiidx == this._nbins ? this.binEdge(this._nbins) : this.binEdge(hiidx + 1);
            long sum = this._start_row;
            for (int i = 0; i < loidx; ++i) {
                sum += this._bins[i];
            }
            return new Histo(lo, hi, sum, this._nrows, this._isInt);
        }
    }

    private class QuantileDriver
    extends H2O.H2OCountedCompleter<QuantileDriver> {
        private QuantileDriver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void compute2() {
            model = null;
            try {
                Scope.enter();
                ((QuantileModel.QuantileParameters)Quantile.this._parms).read_lock_frames((Job)Quantile.this);
                Quantile.this.init(true);
                model = new QuantileModel(Quantile.this.dest(), (QuantileModel.QuantileParameters)Quantile.this._parms, new QuantileModel.QuantileOutput(Quantile.this));
                ((QuantileModel.QuantileOutput)model._output)._quantiles = new double[Quantile.this.train().numCols()][((QuantileModel.QuantileParameters)Quantile.this._parms)._probs.length];
                model.delete_and_lock(Quantile.this._key);
                vecs = Quantile.this.train().vecs();
                n = 0;
lbl12:
                // 2 sources

                while (n < vecs.length) {
                    if (Quantile.this.isRunning()) ** GOTO lbl-1000
                    if (model == null) ** GOTO lbl36
                    ** GOTO lbl35
                }
                ** GOTO lbl58
            }
            catch (Throwable t) {
                block11: {
                    block12: {
                        try {
                            thisJob = (Job)DKV.getGet((Key)Quantile.this._key);
                            if (thisJob._state != Job.JobState.CANCELLED) {
                                t.printStackTrace();
                                Quantile.this.failed(t);
                                throw t;
                            }
                            Log.info((Object[])new Object[]{"Job cancelled by user."});
                            if (model != null) {
                            }
                            break block11;
                        }
                        catch (Throwable var10_12) {
                            if (model != null) {
                                model.unlock(Quantile.this._key);
                            }
                            ((QuantileModel.QuantileParameters)Quantile.this._parms).read_unlock_frames((Job)Quantile.this);
                            Scope.exit((Key[])new Key[]{model == null ? null : model._key});
                            throw var10_12;
                        }
lbl35:
                        // 1 sources

                        model.unlock(Quantile.this._key);
lbl36:
                        // 2 sources

                        ((QuantileModel.QuantileParameters)Quantile.this._parms).read_unlock_frames((Job)Quantile.this);
                        Scope.exit((Key[])new Key[]{model == null ? null : model._key});
                        return;
lbl-1000:
                        // 1 sources

                        {
                            vec = vecs[n];
                            h1 = (Histo)new Histo(vec.min(), vec.max(), 0L, vec.length(), vec.isInt()).doAll(new Vec[]{vec});
                            for (p = 0; p < ((QuantileModel.QuantileParameters)Quantile.this._parms)._probs.length; ++((QuantileModel.QuantileOutput)model._output)._iterations, ++p) {
                                prob = ((QuantileModel.QuantileParameters)Quantile.this._parms)._probs[p];
                                h = h1;
                                while (Double.isNaN(((QuantileModel.QuantileOutput)model._output)._quantiles[n][p] = h.findQuantile(prob))) {
                                    h = (Histo)h.refinePass(prob).doAll(new Vec[]{vec});
                                }
                                model.update(Quantile.this._key);
                                Quantile.this.update(1L);
                            }
                            sb = new StringBuilder();
                            sb.append("Quantile: iter: ").append(((QuantileModel.QuantileOutput)model._output)._iterations).append(" Qs=").append(Arrays.toString(((QuantileModel.QuantileOutput)model._output)._quantiles[n]));
                            Log.info((Object[])new Object[]{sb});
                            ++n;
                            ** GOTO lbl12
lbl58:
                            // 1 sources

                            Quantile.this.done();
                            if (model == null) break block12;
                        }
                        model.unlock(Quantile.this._key);
                    }
                    ((QuantileModel.QuantileParameters)Quantile.this._parms).read_unlock_frames((Job)Quantile.this);
                    Scope.exit((Key[])new Key[]{model == null ? null : model._key});
                    model.unlock(Quantile.this._key);
                }
                ((QuantileModel.QuantileParameters)Quantile.this._parms).read_unlock_frames((Job)Quantile.this);
                Scope.exit((Key[])new Key[]{model == null ? null : model._key});
            }
            this.tryComplete();
        }
    }
}

