/*
 * Decompiled with CFR 0.152.
 */
package hex.splitframe;

import java.util.Random;
import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.MathUtils;

public class ShuffleSplitFrame {
    public static Frame[] shuffleSplitFrame(Frame fr, Key[] keys, final double[] ratios, final long seed) {
        assert (keys.length == ratios.length);
        double sum = ratios[0];
        for (int i = 1; i < ratios.length; ++i) {
            ratios[i] = sum += ratios[i];
        }
        assert (MathUtils.equalsWithinOneSmallUlp((double)sum, (double)1.0));
        final int ncols = fr.numCols();
        MRTask mr = new MRTask(){

            public void map(Chunk[] cs, NewChunk[] ncs) {
                Random rng = new Random(seed * (long)cs[0].cidx());
                int nrows = cs[0]._len;
                for (int i = 0; i < nrows; ++i) {
                    int x;
                    double r = rng.nextDouble();
                    for (x = 0; x < ratios.length - 1 && !(r < ratios[x]); ++x) {
                    }
                    x *= ncols;
                    for (int j = 0; j < ncols; ++j) {
                        ncs[x + j].addNum(cs[j].atd(i));
                    }
                }
            }
        }.doAll(ncols * ratios.length, fr);
        Frame[] frames = new Frame[ratios.length];
        Vec[] vecs = fr.vecs();
        String[] names = fr.names();
        Futures fs = new Futures();
        for (int i = 0; i < ratios.length; ++i) {
            Vec[] nvecs = new Vec[ncols];
            for (int c = 0; c < ncols; ++c) {
                mr.appendables()[i * ncols + c].setDomain(vecs[c].domain());
                nvecs[c] = mr.appendables()[i * ncols + c].close(fs);
            }
            frames[i] = new Frame(keys[i], fr.names(), nvecs);
            DKV.put((Keyed)frames[i], (Futures)fs);
        }
        fs.blockForPending();
        return frames;
    }
}

