/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import water.AutoBuffer;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.RandomUtils;

public abstract class FrameTask<T extends FrameTask<T>>
extends MRTask<T> {
    protected transient DataInfo _dinfo;
    final Key _dinfoKey;
    final int[] _activeCols;
    protected final Key _jobKey;
    protected float _useFraction = 1.0f;
    protected boolean _shuffle = false;
    protected boolean _skipMissing = true;

    protected boolean skipMissing() {
        return this._skipMissing;
    }

    public FrameTask(Key jobKey, DataInfo dinfo) {
        this(jobKey, dinfo._key, dinfo._activeCols, null);
    }

    public FrameTask(Key jobKey, DataInfo dinfo, H2O.H2OCountedCompleter cmp) {
        this(jobKey, dinfo._key, dinfo._activeCols, cmp);
    }

    public FrameTask(Key jobKey, Key dinfoKey, int[] activeCols) {
        this(jobKey, dinfoKey, activeCols, null);
    }

    public FrameTask(Key jobKey, Key dinfoKey, int[] activeCols, H2O.H2OCountedCompleter cmp) {
        super(cmp);
        assert (dinfoKey == null || DKV.get((Key)dinfoKey) != null);
        this._jobKey = jobKey;
        this._dinfoKey = dinfoKey;
        this._activeCols = activeCols;
    }

    protected FrameTask(FrameTask ft) {
        this._dinfo = ft._dinfo;
        this._jobKey = ft._jobKey;
        this._useFraction = ft._useFraction;
        this._shuffle = ft._shuffle;
        this._activeCols = ft._activeCols;
        this._dinfoKey = ft._dinfoKey;
        assert (DKV.get((Key)this._dinfoKey) != null);
    }

    protected void setupLocal() {
        DataInfo dinfo = (DataInfo)DKV.get((Key)this._dinfoKey).get();
        this._dinfo = this._activeCols == null ? dinfo : dinfo.filterExpandedColumns(this._activeCols);
    }

    protected void closeLocal() {
        this._dinfo = null;
    }

    public final double[] normMul() {
        return this._dinfo._normMul;
    }

    public final double[] normSub() {
        return this._dinfo._normSub;
    }

    public final double[] normRespMul() {
        return this._dinfo._normMul;
    }

    public final double[] normRespSub() {
        return this._dinfo._normSub;
    }

    protected void processRow(long gid, double[] nums, int ncats, int[] cats, double[] response) {
        throw new RuntimeException("should've been overriden!");
    }

    protected void processRow(long gid, double[] nums, int ncats, int[] cats, double[] response, NewChunk[] outputs) {
        throw new RuntimeException("should've been overriden!");
    }

    public T dfork(Frame fr) {
        assert (fr == this._dinfo._adaptedFrame);
        return (T)((Object)((FrameTask)super.dfork(fr)));
    }

    protected void chunkInit() {
    }

    protected void chunkDone(long n) {
    }

    public final void map(Chunk[] chunks, NewChunk[] outputs) {
        if (this._jobKey != null && !Job.isRunning((Key)this._jobKey)) {
            throw new Job.JobCancelledException();
        }
        int nrows = chunks[0]._len;
        long offset = chunks[0].start();
        this.chunkInit();
        double[] nums = MemoryManager.malloc8d((int)this._dinfo._nums);
        int[] cats = MemoryManager.malloc4((int)this._dinfo._cats);
        double[] response = this._dinfo._responses == 0 ? null : MemoryManager.malloc8d((int)this._dinfo._responses);
        int start = 0;
        int end = nrows;
        Random skip_rng = null;
        int repeats = (int)Math.ceil(this._useFraction);
        float fraction = this._useFraction / (float)repeats;
        if ((double)fraction < 1.0) {
            skip_rng = RandomUtils.getDeterRNG((long)new Random().nextLong());
        }
        long[] shuf_map = null;
        if (this._shuffle) {
            shuf_map = new long[end - start];
            for (int i = 0; i < shuf_map.length; ++i) {
                shuf_map[i] = start + i;
            }
            ArrayUtils.shuffleArray((long[])shuf_map, (long)new Random().nextLong());
        }
        long num_processed_rows = 0L;
        for (int rrr = 0; rrr < repeats; ++rrr) {
            block2: for (int rr = start; rr < end; ++rr) {
                int i;
                int r = shuf_map != null ? (int)shuf_map[rr - start] : rr;
                long lr = (long)r + chunks[0].start();
                if (this._dinfo._nfolds > 0 && lr % (long)this._dinfo._nfolds == (long)this._dinfo._foldId || skip_rng != null && skip_rng.nextFloat() > fraction) continue;
                ++num_processed_rows;
                for (Chunk c : chunks) {
                    if (this.skipMissing() && c.isNA0(r)) continue block2;
                }
                int ncats = 0;
                for (i = 0; i < this._dinfo._cats; ++i) {
                    if (chunks[i].isNA0(r)) {
                        cats[ncats++] = this._dinfo._catOffsets[i + 1] - 1;
                        continue;
                    }
                    int c = (int)chunks[i].at80(r);
                    if (this._dinfo._catLvls != null) {
                        if ((c = Arrays.binarySearch(this._dinfo._catLvls[i], c)) < 0) continue;
                        cats[ncats++] = c + this._dinfo._catOffsets[i];
                        continue;
                    }
                    if (this._dinfo._useAllFactorLevels) {
                        cats[ncats++] = c + this._dinfo._catOffsets[i];
                        continue;
                    }
                    if (c == 0) continue;
                    cats[ncats++] = c + this._dinfo._catOffsets[i] - 1;
                }
                int n = chunks.length - this._dinfo._responses;
                while (i < n) {
                    double d = chunks[i].at0(r);
                    if (this._dinfo._normMul != null) {
                        d = (d - this._dinfo._normSub[i - this._dinfo._cats]) * this._dinfo._normMul[i - this._dinfo._cats];
                    }
                    nums[i - this._dinfo._cats] = d;
                    ++i;
                }
                for (i = 0; i < this._dinfo._responses; ++i) {
                    response[i] = chunks[chunks.length - this._dinfo._responses + i].at0(r);
                    if (this._dinfo._normRespMul != null) {
                        response[i] = (response[i] - this._dinfo._normRespSub[i]) * this._dinfo._normRespMul[i];
                    }
                    if (Double.isNaN(response[i])) continue block2;
                }
                long seed = offset + (long)(rrr * (end - start)) + (long)r;
                if (outputs != null && outputs.length > 0) {
                    this.processRow(seed, nums, ncats, cats, response, outputs);
                    continue;
                }
                this.processRow(seed, nums, ncats, cats, response);
            }
        }
        this.chunkDone(num_processed_rows);
    }

    public static class DataInfo
    extends Keyed {
        public int[] _activeCols;
        public Frame _adaptedFrame;
        public int _responses;
        public TransformType _predictor_transform;
        public TransformType _response_transform;
        public boolean _useAllFactorLevels;
        public int _nums;
        public int _cats;
        public int[] _catOffsets;
        public int[] _catMissing;
        public double[] _normMul;
        public double[] _normSub;
        public double[] _normRespMul;
        public double[] _normRespSub;
        public int _foldId;
        public int _nfolds;
        public Key _frameKey;
        final int[][] _catLvls;

        public long checksum() {
            throw H2O.unimpl();
        }

        public DataInfo deep_clone() {
            AutoBuffer ab = new AutoBuffer();
            this.write(ab);
            ab.flipForReading();
            return (DataInfo)new DataInfo().read(ab);
        }

        private DataInfo() {
            super(null);
            this._catLvls = null;
        }

        private DataInfo(Key selfKey, DataInfo dinfo, int foldId, int nfolds) {
            super(selfKey);
            assert (dinfo._catLvls == null) : "Should not be called with filtered levels (assuming the selected levels may change with fold id) ";
            this._predictor_transform = dinfo._predictor_transform;
            this._response_transform = dinfo._response_transform;
            this._responses = dinfo._responses;
            this._nums = dinfo._nums;
            this._cats = dinfo._cats;
            this._adaptedFrame = dinfo._adaptedFrame;
            this._catOffsets = dinfo._catOffsets;
            this._catMissing = dinfo._catMissing;
            this._normMul = dinfo._normMul;
            this._normSub = dinfo._normSub;
            this._normRespMul = dinfo._normRespMul;
            this._normRespSub = dinfo._normRespSub;
            this._foldId = foldId;
            this._nfolds = nfolds;
            this._useAllFactorLevels = dinfo._useAllFactorLevels;
            this._catLvls = null;
        }

        public DataInfo(Key selfKey, Frame fr, int hasResponses, boolean useAllFactorLvls, double[] normSub, double[] normMul, TransformType predictor_transform, double[] normRespSub, double[] normRespMul) {
            this(selfKey, fr, hasResponses, useAllFactorLvls, normMul != null && normSub != null ? predictor_transform : TransformType.NONE, normRespMul != null && normRespSub != null ? TransformType.STANDARDIZE : TransformType.NONE);
            assert (normSub == null == (normMul == null));
            assert (normRespSub == null == (normRespMul == null));
            if (normSub != null) {
                System.arraycopy(normSub, 0, this._normSub, 0, normSub.length);
                System.arraycopy(normMul, 0, this._normMul, 0, normMul.length);
            }
            if (normRespSub != null) {
                System.arraycopy(normRespSub, 0, this._normRespSub, 0, normRespSub.length);
                System.arraycopy(normRespMul, 0, this._normRespMul, 0, normRespMul.length);
            }
        }

        public static Frame prepareFrame(Frame source, Vec response, int[] ignored_cols, boolean toEnum, boolean dropConstantCols, boolean dropNACols) {
            int i;
            Frame fr = new Frame(null, (String[])source._names.clone(), (Vec[])source.vecs().clone());
            if (ignored_cols != null) {
                fr.remove(ignored_cols);
            }
            Vec[] vecs = fr.vecs();
            if (response != null) {
                for (int i2 = 0; i2 < vecs.length - 1; ++i2) {
                    if (vecs[i2] != response) continue;
                    String n = fr._names[i2];
                    if (toEnum && !vecs[i2].isEnum()) {
                        fr.add(n, fr.remove(i2).toEnum());
                        break;
                    }
                    fr.add(n, fr.remove(i2));
                    break;
                }
                if (toEnum && !response.isEnum() && vecs[vecs.length - 1] == response) {
                    String n = fr._names[vecs.length - 1];
                    fr.add(n, fr.remove(vecs.length - 1).toEnum());
                }
            }
            ArrayList constantOrNAs = new ArrayList();
            ArrayList<Integer> constantCols = new ArrayList<Integer>();
            ArrayList<Integer> NACols = new ArrayList<Integer>();
            for (int i3 = 0; i3 < vecs.length - 1; ++i3) {
                boolean droptoomanyNAs;
                boolean dropconstant = dropConstantCols && vecs[i3].min() == vecs[i3].max();
                boolean bl = droptoomanyNAs = dropNACols && vecs[i3].naCnt() > vecs[i3].length() * 1L;
                if (dropconstant) {
                    constantCols.add(i3);
                    continue;
                }
                if (!droptoomanyNAs) continue;
                NACols.add(i3);
            }
            constantOrNAs.addAll(constantCols);
            constantOrNAs.addAll(NACols);
            String msg = "";
            if (constantCols.size() > 0) {
                msg = msg + "Dropping constant column(s): ";
            }
            Iterator i$ = constantCols.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                msg = msg + fr._names[i] + " ";
            }
            if (NACols.size() > 0) {
                msg = msg + "Dropping column(s) with too many missing values: ";
            }
            i$ = NACols.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                msg = msg + fr._names[i] + " (" + String.format("%.2f", (double)vecs[i].naCnt() * 100.0 / (double)vecs[i].length()) + "%) ";
            }
            for (String s : msg.split("\n")) {
                Log.info((Object[])new Object[]{s});
            }
            if (!constantOrNAs.isEmpty()) {
                int[] cols = new int[constantOrNAs.size()];
                for (int i4 = 0; i4 < cols.length; ++i4) {
                    cols[i4] = (Integer)constantOrNAs.get(i4);
                }
                fr.remove(cols);
            }
            return fr;
        }

        public static Frame prepareFrame(Frame source, int[] ignored_cols, boolean dropConstantCols, boolean dropNACols) {
            int i;
            Frame fr = new Frame(null, (String[])source._names.clone(), (Vec[])source.vecs().clone());
            if (ignored_cols != null) {
                fr.remove(ignored_cols);
            }
            Vec[] vecs = fr.vecs();
            ArrayList constantOrNAs = new ArrayList();
            ArrayList<Integer> constantCols = new ArrayList<Integer>();
            ArrayList<Integer> NACols = new ArrayList<Integer>();
            for (int i2 = 0; i2 < vecs.length; ++i2) {
                boolean droptoomanyNAs;
                boolean dropconstant = dropConstantCols && vecs[i2].min() == vecs[i2].max();
                boolean bl = droptoomanyNAs = dropNACols && (double)vecs[i2].naCnt() > (double)vecs[i2].length() * 0.2;
                if (dropconstant) {
                    constantCols.add(i2);
                    continue;
                }
                if (!droptoomanyNAs) continue;
                NACols.add(i2);
            }
            constantOrNAs.addAll(constantCols);
            constantOrNAs.addAll(NACols);
            String msg = "";
            if (constantCols.size() > 0) {
                msg = msg + "Dropping constant column(s): ";
            }
            Iterator i$ = constantCols.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                msg = msg + fr._names[i] + " ";
            }
            if (NACols.size() > 0) {
                msg = msg + "Dropping column(s) with too many missing values: ";
            }
            i$ = NACols.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                msg = msg + fr._names[i] + " (" + String.format("%.2f", (double)vecs[i].naCnt() * 100.0 / (double)vecs[i].length()) + "%) ";
            }
            for (String s : msg.split("\n")) {
                Log.info((Object[])new Object[]{s});
            }
            if (!constantOrNAs.isEmpty()) {
                int[] cols = new int[constantOrNAs.size()];
                for (int i3 = 0; i3 < cols.length; ++i3) {
                    cols[i3] = (Integer)constantOrNAs.get(i3);
                }
                fr.remove(cols);
            }
            return fr;
        }

        public static Frame prepareFrame(Frame source, Vec response, int[] ignored_cols, boolean toEnum, boolean dropConstantCols) {
            return DataInfo.prepareFrame(source, response, ignored_cols, toEnum, dropConstantCols, false);
        }

        public DataInfo(Key selfKey, Frame fr, int nResponses, boolean useAllFactors, TransformType predictor_transform) {
            this(selfKey, fr, nResponses, useAllFactors, predictor_transform, TransformType.NONE);
        }

        public DataInfo(Key selfKey, Frame fr, int[][] catLevels, int responses, TransformType predictor_transform, TransformType response_transform, int foldId, int nfolds) {
            super(selfKey);
            Vec v;
            int i;
            this._adaptedFrame = fr;
            this._catOffsets = MemoryManager.malloc4((int)(catLevels.length + 1));
            this._catMissing = new int[catLevels.length];
            int s = 0;
            for (i = 0; i < catLevels.length; ++i) {
                this._catOffsets[i] = s;
                s += catLevels[i].length;
            }
            this._catLvls = catLevels;
            this._catOffsets[this._catOffsets.length - 1] = s;
            this._responses = responses;
            this._cats = catLevels.length;
            this._nums = fr.numCols() - this._cats - responses;
            this._predictor_transform = predictor_transform;
            if (this._predictor_transform == TransformType.STANDARDIZE && this._nums > 0) {
                this._normMul = MemoryManager.malloc8d((int)this._nums);
                this._normSub = MemoryManager.malloc8d((int)this._nums);
                for (i = 0; i < this._nums; ++i) {
                    v = fr.vec(catLevels.length + i);
                    this._normMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    this._normSub[i] = v.mean();
                }
            } else {
                this._predictor_transform = predictor_transform;
                if (this._predictor_transform == TransformType.NORMALIZE && this._nums > 0) {
                    this._normMul = MemoryManager.malloc8d((int)this._nums);
                    this._normSub = MemoryManager.malloc8d((int)this._nums);
                    for (i = 0; i < this._nums; ++i) {
                        v = fr.vec(catLevels.length + i);
                        this._normMul[i] = v.max() - v.min() > 0.0 ? 1.0 / (v.max() - v.min()) : 1.0;
                        this._normSub[i] = v.mean();
                    }
                } else {
                    this._normMul = null;
                    this._normSub = null;
                }
            }
            if ((this._response_transform = response_transform) == TransformType.STANDARDIZE && responses > 0) {
                this._normRespMul = MemoryManager.malloc8d((int)responses);
                this._normRespSub = MemoryManager.malloc8d((int)responses);
                for (i = 0; i < responses; ++i) {
                    v = fr.vec(fr.numCols() - responses + i);
                    this._normRespSub[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    this._normRespSub[i] = v.mean();
                }
            } else {
                this._response_transform = response_transform;
                if (this._response_transform == TransformType.NORMALIZE && responses > 0) {
                    this._normRespMul = MemoryManager.malloc8d((int)responses);
                    this._normRespSub = MemoryManager.malloc8d((int)responses);
                    for (i = 0; i < responses; ++i) {
                        v = fr.vec(fr.numCols() - responses + i);
                        this._normRespSub[i] = v.max() - v.min() > 0.0 ? 1.0 / (v.max() - v.min()) : 1.0;
                        this._normRespSub[i] = v.mean();
                    }
                } else {
                    this._normRespMul = null;
                    this._normRespSub = null;
                }
            }
            this._useAllFactorLevels = false;
            this._adaptedFrame.reloadVecs();
            this._nfolds = nfolds;
            this._foldId = foldId;
        }

        public DataInfo(Key selfKey, Frame fr, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform) {
            super(selfKey);
            Vec v;
            int i;
            int i2;
            this._foldId = 0;
            this._nfolds = 0;
            this._predictor_transform = predictor_transform;
            this._response_transform = response_transform;
            this._responses = nResponses;
            this._useAllFactorLevels = useAllFactorLevels;
            this._catLvls = null;
            Vec[] vecs = fr.vecs();
            int n = vecs.length - this._responses;
            if (n < 1) {
                throw new IllegalArgumentException("Training data must have at least one column.");
            }
            int[] nums = MemoryManager.malloc4((int)n);
            int[] cats = MemoryManager.malloc4((int)n);
            int nnums = 0;
            int ncats = 0;
            for (i2 = 0; i2 < n; ++i2) {
                if (vecs[i2].isEnum()) {
                    cats[ncats++] = i2;
                    continue;
                }
                nums[nnums++] = i2;
            }
            this._nums = nnums;
            this._cats = ncats;
            for (i2 = 0; i2 < ncats; ++i2) {
                for (int j = i2 + 1; j < ncats; ++j) {
                    if (vecs[cats[i2]].domain().length >= vecs[cats[j]].domain().length) continue;
                    int x = cats[i2];
                    cats[i2] = cats[j];
                    cats[j] = x;
                }
            }
            Vec[] vecs2 = (Vec[])vecs.clone();
            String[] names = (String[])fr._names.clone();
            this._catOffsets = MemoryManager.malloc4((int)(ncats + 1));
            this._catMissing = new int[ncats];
            this._catOffsets[0] = 0;
            int len = 0;
            for (i = 0; i < ncats; ++i) {
                v = vecs2[i] = vecs[cats[i]];
                names[i] = fr._names[cats[i]];
                this._catMissing[i] = v.naCnt() > 0L ? 1 : 0;
                this._catOffsets[i + 1] = len += v.domain().length - (useAllFactorLevels ? 0 : 1) + (v.naCnt() > 0L ? 1 : 0);
            }
            if (predictor_transform != TransformType.NONE) {
                this._normSub = MemoryManager.malloc8d((int)nnums);
                this._normMul = MemoryManager.malloc8d((int)nnums);
                Arrays.fill(this._normMul, 1.0);
            } else {
                this._normMul = null;
                this._normSub = null;
            }
            for (i = 0; i < nnums; ++i) {
                Vec vec = vecs[nums[i]];
                vecs2[i + ncats] = vec;
                v = vec;
                names[i + ncats] = fr._names[nums[i]];
                if (predictor_transform == TransformType.STANDARDIZE) {
                    this._normSub[i] = v.mean();
                    this._normMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    continue;
                }
                if (predictor_transform != TransformType.NORMALIZE) continue;
                this._normSub[i] = v.mean();
                this._normMul[i] = v.max() - v.min() > 0.0 ? 1.0 / (v.max() - v.min()) : 1.0;
            }
            if (response_transform != TransformType.NONE && this._responses > 0) {
                this._normRespSub = MemoryManager.malloc8d((int)this._responses);
                this._normRespMul = MemoryManager.malloc8d((int)this._responses);
                Arrays.fill(this._normRespMul, 1.0);
            } else {
                this._normRespMul = null;
                this._normRespSub = null;
            }
            for (i = 0; i < this._responses; ++i) {
                Vec vec = vecs[nnums + ncats + i];
                vecs2[nnums + ncats + i] = vec;
                v = vec;
                if (response_transform == TransformType.STANDARDIZE) {
                    this._normRespSub[i] = v.mean();
                    this._normRespMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    continue;
                }
                if (response_transform != TransformType.NORMALIZE) continue;
                this._normRespSub[i] = v.mean();
                this._normRespMul[i] = v.max() - v.min() > 0.0 ? 1.0 / (v.max() - v.min()) : 1.0;
            }
            this._adaptedFrame = new Frame(names, vecs2);
            this._adaptedFrame.reloadVecs();
        }

        public DataInfo filterExpandedColumns(int[] cols) {
            int k;
            if (cols == null) {
                return this;
            }
            int i = 0;
            int j = 0;
            int ignoredCnt = 0;
            int[][] catLvls = new int[this._cats][];
            int[] ignoredCols = MemoryManager.malloc4((int)(this._nums + this._cats));
            if (this._catOffsets != null) {
                while (i < cols.length && cols[i] < this._catOffsets[this._catOffsets.length - 1]) {
                    int[] levels = MemoryManager.malloc4((int)(this._catOffsets[j + 1] - this._catOffsets[j]));
                    k = 0;
                    while (i < cols.length && cols[i] < this._catOffsets[j + 1]) {
                        levels[k++] = cols[i++] - this._catOffsets[j];
                    }
                    if (k > 0) {
                        catLvls[j] = Arrays.copyOf(levels, k);
                    }
                    ++j;
                }
            }
            for (int k2 = 0; k2 < catLvls.length; ++k2) {
                if (catLvls[k2] != null) continue;
                ignoredCols[ignoredCnt++] = k2;
            }
            if (ignoredCnt > 0) {
                int[][] c = new int[this._cats - ignoredCnt][];
                int y = 0;
                for (int[] catLvl : catLvls) {
                    if (catLvl == null) continue;
                    c[y++] = catLvl;
                }
                assert (y == c.length);
                catLvls = c;
            }
            j = 0;
            int prev = 0;
            while (i < cols.length) {
                for (k = prev; k < cols[i] - this.numStart(); ++k) {
                    ignoredCols[ignoredCnt++] = k + this._cats;
                    ++j;
                }
                prev = ++j;
                ++i;
            }
            for (k = prev; k < this._nums; ++k) {
                ignoredCols[ignoredCnt++] = k + this._cats;
            }
            Frame f = new Frame((String[])this._adaptedFrame.names().clone(), (Vec[])this._adaptedFrame.vecs().clone());
            if (ignoredCnt > 0) {
                f.remove(Arrays.copyOf(ignoredCols, ignoredCnt));
            }
            assert (catLvls.length < f.numCols()) : "cats = " + catLvls.length + " numcols = " + f.numCols();
            DataInfo dinfo = new DataInfo(this._key, f, catLvls, this._responses, this._predictor_transform, this._response_transform, this._foldId, this._nfolds);
            dinfo._activeCols = cols;
            return dinfo;
        }

        public String toString() {
            return "";
        }

        public DataInfo getFold(int foldId, int nfolds) {
            return new DataInfo(Key.make(), this, foldId, nfolds);
        }

        public final int fullN() {
            return this._nums + this._catOffsets[this._cats];
        }

        public final int largestCat() {
            return this._cats > 0 ? this._catOffsets[1] : 0;
        }

        public final int numStart() {
            return this._catOffsets[this._cats];
        }

        public final String[] coefNames() {
            int k = 0;
            int n = this.fullN();
            String[] res = new String[n];
            Vec[] vecs = this._adaptedFrame.vecs();
            for (int i = 0; i < this._cats; ++i) {
                int j;
                int n2 = j = this._useAllFactorLevels ? 0 : 1;
                while (j < vecs[i].domain().length) {
                    res[k++] = this._adaptedFrame._names[i] + "." + vecs[i].domain()[j];
                    ++j;
                }
                if (vecs[i].naCnt() <= 0L) continue;
                res[k++] = this._adaptedFrame._names[i] + ".missing(NA)";
            }
            int nums = n - k;
            System.arraycopy(this._adaptedFrame._names, this._cats, res, k, nums);
            return res;
        }

        public final void softMaxCategoricals(float[] in, float[] out) {
            if (this._cats == 0) {
                return;
            }
            if (!this._useAllFactorLevels) {
                throw new UnsupportedOperationException("All factor levels must be present for re-scaling with SoftMax.");
            }
            assert (in.length == out.length);
            assert (in.length == this.fullN());
            Vec[] vecs = this._adaptedFrame.vecs();
            int k = 0;
            for (int i = 0; i < this._cats; ++i) {
                int j;
                int factors = vecs[i].domain().length;
                float max = ArrayUtils.maxValue((float[])in, (int)k, (int)(k + factors));
                float scale = 0.0f;
                for (j = 0; j < factors; ++j) {
                    out[k + j] = (float)Math.exp(in[k + j] - max);
                    scale += out[k + j];
                }
                for (j = 0; j < factors; ++j) {
                    int n = k + j;
                    out[n] = out[n] / scale;
                }
                k += factors;
            }
            assert (k == this.numStart());
        }

        public final void unScaleNumericals(float[] in, float[] out) {
            if (this._nums == 0) {
                return;
            }
            assert (in.length == out.length);
            assert (in.length == this.fullN());
            for (int k = this.numStart(); k < this.fullN(); ++k) {
                out[k] = in[k] / (float)this._normMul[k - this.numStart()] + (float)this._normSub[k - this.numStart()];
            }
        }

        public static enum TransformType {
            NONE,
            STANDARDIZE,
            NORMALIZE;

        }
    }
}

