/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.FrameTask;
import hex.Model;
import hex.ModelBuilder;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.DeepLearningTask2;
import hex.schemas.DeepLearningV2;
import hex.schemas.ModelBuilderSchema;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import water.DKV;
import water.H2O;
import water.H2ONode;
import water.HeartBeat;
import water.Job;
import water.Key;
import water.Scope;
import water.api.ValidationAdapter;
import water.fvec.Frame;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.init.Linpack;
import water.init.NetworkTest;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MRUtils;
import water.util.PrettyPrint;

public class DeepLearning
extends ModelBuilder<DeepLearningModel, DeepLearningModel.DeepLearningParameters, DeepLearningModel.DeepLearningOutput> {
    public DeepLearning(DeepLearningModel.DeepLearningParameters parms) {
        super("DeepLearning", (Model.Parameters)parms);
    }

    public ModelBuilderSchema schema() {
        return new DeepLearningV2();
    }

    public Job<DeepLearningModel> train() {
        return this.start(new DeepLearningDriver(), (long)(((DeepLearningModel.DeepLearningParameters)this._parms).epochs * (double)((DeepLearningModel.DeepLearningParameters)this._parms).train().numRows()));
    }

    public class DeepLearningDriver
    extends H2O.H2OCountedCompleter<DeepLearningDriver> {
        final transient String[] expert_options = new String[]{"use_all_factor_levels", "loss", "max_w2", "score_training_samples", "score_validation_samples", "initial_weight_distribution", "initial_weight_scale", "diagnostics", "rate_decay", "score_duty_cycle", "variable_importances", "fast_mode", "score_validation_sampling", "ignore_const_cols", "force_load_balance", "replicate_training_data", "shuffle_training_data", "nesterov_accelerated_gradient", "classification_stop", "regression_stop", "quiet_mode", "max_confusion_matrix_size", "max_hit_ratio_k", "hidden_dropout_ratios", "single_node_mode", "sparse", "col_major", "autoencoder", "average_activation", "sparsity_beta", "max_categorical_features"};
        final transient String[] cp_modifiable = new String[]{"expert_mode", "seed", "epochs", "score_interval", "train_samples_per_iteration", "target_ratio_comm_to_comp", "score_duty_cycle", "classification_stop", "regression_stop", "quiet_mode", "max_confusion_matrix_size", "max_hit_ratio_k", "diagnostics", "variable_importances", "force_load_balance", "replicate_training_data", "shuffle_training_data", "single_node_mode", "sparse", "col_major", "l1", "l2", "max_w2"};
        transient HashSet<Frame> _delete_me = new HashSet();

        protected void compute2() {
            try {
                this.buildModel();
            }
            catch (Throwable t) {
                t.printStackTrace();
                DeepLearning.this.cancel2(t);
                throw t;
            }
            finally {
                DeepLearning.this.done();
            }
            this.tryComplete();
        }

        Key self() {
            return DeepLearning.this._key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void buildModel() {
            int i;
            Scope.enter();
            DeepLearningModel cp = null;
            Frame tra_fr = ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).train();
            if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).checkpoint == null) {
                cp = this.initModel();
            } else {
                DeepLearningModel previous = (DeepLearningModel)DKV.get((Key)((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).checkpoint).get();
                if (previous == null) {
                    throw new IllegalArgumentException("Checkpoint not found.");
                }
                Log.info((Object[])new Object[]{"Resuming from checkpoint."});
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).n_folds != 0) {
                    throw new UnsupportedOperationException("n_folds must be 0: Cross-validation is not supported during checkpoint restarts.");
                }
                assert (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._train != null);
                if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._train.equals((Object)previous.model_info().get_params()._train)) {
                    throw new IllegalArgumentException("source must be the same as for the checkpointed model.");
                }
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).autoencoder = previous.model_info().get_params().autoencoder;
                if (!(((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).autoencoder || ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._response_column != null && tra_fr.vec((String)((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._response_column)._key.equals((Object)tra_fr.vec((String)previous.model_info().get_params()._response_column)._key))) {
                    throw new IllegalArgumentException("response_vec must be the same as for the checkpointed model.");
                }
                if (ArrayUtils.difference((String[])((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._ignored_columns, (String[])previous.model_info().get_params()._ignored_columns).length != 0 || ArrayUtils.difference((String[])previous.model_info().get_params()._ignored_columns, (String[])((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._ignored_columns).length != 0) {
                    ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._ignored_columns = previous.model_info().get_params()._ignored_columns;
                    Log.warn((Object[])new Object[]{"Automatically re-using ignored_cols from the checkpointed model."});
                }
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid == null == (((DeepLearningModel.DeepLearningParameters)previous._parms)._valid != null) || ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid != null && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid != null && ((DeepLearningModel.DeepLearningParameters)previous._parms)._valid != null && !((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid.equals((Object)((DeepLearningModel.DeepLearningParameters)previous._parms)._valid)) {
                    throw new IllegalArgumentException("validation must be the same as for the checkpointed model.");
                }
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._classification != previous.model_info().get_params()._classification) {
                    Object[] objectArray = new Object[1];
                    ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._classification = !((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._classification;
                    objectArray[0] = "Automatically switching to " + (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._classification ? "classification" : "regression") + " (same as the checkpointed model).";
                    Log.warn((Object[])objectArray);
                }
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).epochs += previous.epoch_counter;
                Log.info((Object[])new Object[]{"Adding " + String.format("%.3f", previous.epoch_counter) + " epochs from the checkpointed model."});
                try {
                    FrameTask.DataInfo dataInfo = DeepLearningModel.prepareDataInfo((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms);
                    cp = new DeepLearningModel(previous, DeepLearning.this.dest(), this.self(), dataInfo);
                    cp.write_lock(this.self());
                    DeepLearningModel.DeepLearningParameters A = cp.model_info().get_params();
                    Model.Parameters B = DeepLearning.this._parms;
                    for (Field fA : ((Object)((Object)A)).getClass().getDeclaredFields()) {
                        if (!ArrayUtils.contains((String[])this.cp_modifiable, (String)fA.getName()) || !((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).expert_mode && ArrayUtils.contains((String[])this.expert_options, (String)fA.getName())) continue;
                        for (Field fB : B.getClass().getDeclaredFields()) {
                            if (!fA.equals(fB)) continue;
                            try {
                                if (fB.get(B) != null && fA.get((Object)A) != null && fA.get((Object)A).toString().equals(fB.get(B).toString()) || fA.get((Object)A) == null && fB.get(B) == null) continue;
                                Log.info((Object[])new Object[]{"Applying user-requested modification of '" + fA.getName() + "': " + fA.get((Object)A) + " -> " + fB.get(B)});
                                fA.set((Object)A, fB.get(B));
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (A.n_folds != 0) {
                        Log.warn((Object[])new Object[]{"Disabling cross-validation: Not supported when resuming training from a checkpoint."});
                        A.n_folds = 0;
                    }
                    cp.update(this.self());
                }
                finally {
                    if (cp != null) {
                        cp.unlock(this.self());
                    }
                }
            }
            this.trainModel(cp);
            Frame val_fr = ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid == null ? null : ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).valid();
            int validlen = val_fr != null ? val_fr.vecs().length : 0;
            Key[] keep = new Key[tra_fr.vecs().length + validlen + 6];
            for (i = 0; i < tra_fr.vecs().length; ++i) {
                keep[i] = tra_fr.vecs()[i]._key;
            }
            keep[tra_fr.vecs().length] = ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._train;
            for (i = 0; i < validlen; ++i) {
                keep[i] = val_fr.vecs()[i]._key;
            }
            if (val_fr != null) {
                keep[tra_fr.vecs().length + 1] = ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid;
            }
            keep[tra_fr.vecs().length + 2] = DeepLearning.this._dest;
            keep[tra_fr.vecs().length + 3] = cp.actual_best_model_key;
            keep[tra_fr.vecs().length + 4] = this.self();
            keep[tra_fr.vecs().length + 5] = DeepLearning.this._progressKey;
            Scope.exit((Key[])keep);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DeepLearningModel initModel() {
            try {
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).lock_frames((Job)DeepLearning.this);
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).sanityCheckParameters() > 0) {
                    throw new IllegalArgumentException("Error(s) in model parameters: " + ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).validationErrors());
                }
                FrameTask.DataInfo dinfo = DeepLearningModel.prepareDataInfo((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms);
                Vec resp = dinfo._adaptedFrame.lastVec();
                float[] priorDist = ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._classification ? ((MRUtils.ClassDist)new MRUtils.ClassDist(resp).doAll(new Vec[]{resp})).rel_dist() : null;
                DeepLearningModel model = new DeepLearningModel(DeepLearning.this.dest(), this.self(), ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._train, dinfo, (DeepLearningModel.DeepLearningParameters)((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).clone(), priorDist);
                model.model_info().initializeMembers();
                DeepLearningModel deepLearningModel = model;
                return deepLearningModel;
            }
            finally {
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).unlock_frames((Job)DeepLearning.this);
            }
        }

        public final DeepLearningModel trainModel(DeepLearningModel model) {
            Frame validScoreFrame = null;
            try {
                DeepLearningModel best_model;
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).lock_frames((Job)DeepLearning.this);
                if (model == null) {
                    model = (DeepLearningModel)DKV.get((Key)DeepLearning.this.dest()).get();
                }
                model.write_lock(this.self());
                DeepLearningModel.DeepLearningParameters mp = (DeepLearningModel.DeepLearningParameters)model._parms;
                Frame tra_fr = ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).train();
                Frame val_fr = ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid == null ? null : ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).valid();
                ValidationAdapter validAdapter = new ValidationAdapter(val_fr, ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._classification);
                validAdapter.prepareValidationWithModel((Model)model);
                long model_size = model.model_info().size();
                if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).quiet_mode) {
                    Log.info((Object[])new Object[]{"Number of model parameters (weights/biases): " + String.format("%,d", model_size)});
                }
                Frame train = model.model_info().data_info()._adaptedFrame;
                if (mp.force_load_balance) {
                    train = this.reBalance(train, mp.replicate_training_data);
                }
                if (mp._classification && mp.balance_classes) {
                    float[] trainSamplingFactors = new float[train.lastVec().domain().length];
                    if (mp.class_sampling_factors != null) {
                        if (mp.class_sampling_factors.length != train.lastVec().domain().length) {
                            throw new IllegalArgumentException("class_sampling_factors must have " + train.lastVec().domain().length + " elements");
                        }
                        trainSamplingFactors = (float[])mp.class_sampling_factors.clone();
                    }
                    train = MRUtils.sampleFrameStratified((Frame)train, (Vec)train.lastVec(), (float[])trainSamplingFactors, (long)((long)(mp.max_after_balance_size * (float)train.numRows())), (long)mp.seed, (boolean)true, (boolean)false);
                    model.setModelClassDistribution(((MRUtils.ClassDist)new MRUtils.ClassDist(train.lastVec()).doAll(new Vec[]{train.lastVec()})).rel_dist());
                }
                model.training_rows = train.numRows();
                Frame trainScoreFrame = MRUtils.sampleFrame((Frame)train, (long)mp.score_training_samples, (long)mp.seed);
                if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).quiet_mode) {
                    Log.info((Object[])new Object[]{"Number of chunks of the training data: " + train.anyVec().nChunks()});
                }
                if (val_fr != null) {
                    model.validation_rows = val_fr.numRows();
                    Frame adaptedValid = validAdapter.getValidation();
                    if (validAdapter.getValidAdaptor().needsAdaptation2CM()) {
                        int rIndex = 0;
                        for (int i = 0; i < tra_fr.names().length; ++i) {
                            if (tra_fr._names[i] != ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._response_column) continue;
                            rIndex = i;
                        }
                        String responseName = tra_fr._names != null && rIndex >= 0 ? tra_fr._names[rIndex] : "response_vec";
                        adaptedValid.add(validAdapter.getValidAdaptor().adaptedValidationResponse(responseName), validAdapter.getValidAdaptor().getAdaptedValidationResponse2CM());
                    }
                    validScoreFrame = mp._classification && mp.balance_classes && mp.score_validation_sampling == DeepLearningModel.DeepLearningParameters.ClassSamplingMethod.Stratified ? MRUtils.sampleFrameStratified((Frame)adaptedValid, (Vec)adaptedValid.lastVec(), null, (long)(mp.score_validation_samples > 0L ? mp.score_validation_samples : adaptedValid.numRows()), (long)(mp.seed + 1L), (boolean)false, (boolean)false) : MRUtils.sampleFrame((Frame)adaptedValid, (long)mp.score_validation_samples, (long)(mp.seed + 1L));
                    if (mp.force_load_balance) {
                        validScoreFrame = this.reBalance(validScoreFrame, false);
                    }
                    if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).quiet_mode) {
                        Log.info((Object[])new Object[]{"Number of chunks of the validation data: " + validScoreFrame.anyVec().nChunks()});
                    }
                }
                model.actual_train_samples_per_iteration = this.computeTrainSamplesPerIteration(mp, train.numRows(), model);
                if (mp.replicate_training_data && model.actual_train_samples_per_iteration == train.numRows() * (long)(mp.single_node_mode ? 1 : H2O.CLOUD.size()) && !mp.shuffle_training_data && H2O.CLOUD.size() > 1 && !mp.reproducible) {
                    Log.warn((Object[])new Object[]{"Enabling training data shuffling, because all nodes train on the full dataset (replicated training data)."});
                    mp.shuffle_training_data = true;
                }
                model._timeLastScoreEnter = System.currentTimeMillis();
                if (!mp.quiet_mode) {
                    Log.info((Object[])new Object[]{"Initial model:\n" + (Object)((Object)model.model_info())});
                }
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).autoencoder) {
                    model.doScoring(train, trainScoreFrame, validScoreFrame, this.self(), validAdapter.getValidAdaptor());
                }
                model.update(this.self());
                Log.info((Object[])new Object[]{"Starting to train the Deep Learning model."});
                do {
                    model.set_model_info(mp.epochs == 0.0 ? model.model_info() : (H2O.CLOUD.size() > 1 && mp.replicate_training_data ? (mp.single_node_mode ? ((DeepLearningTask2)new DeepLearningTask2(this.self(), train, model.model_info(), this.rowFraction(train, mp, model)).doAll(new Key[]{Key.make()})).model_info() : ((DeepLearningTask2)new DeepLearningTask2(this.self(), train, model.model_info(), this.rowFraction(train, mp, model)).doAllNodes()).model_info()) : ((DeepLearningTask)new DeepLearningTask(this.self(), model.model_info(), this.rowFraction(train, mp, model)).doAll(train)).model_info()));
                    DeepLearning.this.update(model.actual_train_samples_per_iteration);
                    if (mp.quiet_mode) continue;
                    Log.info((Object[])new Object[]{"Progress: " + PrettyPrint.formatPct((double)DeepLearning.this.progress())});
                } while (model.doScoring(train, trainScoreFrame, validScoreFrame, this.self(), validAdapter.getValidAdaptor()));
                if (!DeepLearning.this.isCancelledOrCrashed() && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).override_with_best_model && model.actual_best_model_key != null && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).n_folds == 0 && (best_model = (DeepLearningModel)DKV.get((Key)model.actual_best_model_key).get()) != null && best_model.error() < model.error() && Arrays.equals(best_model.model_info().units, model.model_info().units)) {
                    Log.info((Object[])new Object[]{"Setting the model to be the best model so far (based on scoring history)."});
                    DeepLearningModel.DeepLearningModelInfo mi = best_model.model_info().deep_clone();
                    mi.set_processed_global(model.model_info().get_processed_global());
                    mi.set_processed_local(model.model_info().get_processed_local());
                    model.set_model_info(mi);
                    model.update(this.self());
                    model.doScoring(train, trainScoreFrame, validScoreFrame, this.self(), validAdapter.getValidAdaptor());
                    assert (best_model.error() == model.error());
                }
                Log.info((Object[])new Object[]{model});
                Log.info((Object[])new Object[]{"Finished training the Deep Learning model."});
            }
            catch (RuntimeException ex) {
                model = (DeepLearningModel)DKV.get((Key)DeepLearning.this.dest()).get();
                DeepLearning.this._state = Job.JobState.CANCELLED;
                Log.info((Object[])new Object[]{"Deep Learning model building was cancelled."});
                throw ex;
            }
            finally {
                if (model != null) {
                    model.unlock(this.self());
                }
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).unlock_frames((Job)DeepLearning.this);
                for (Frame f : this._delete_me) {
                    f.delete();
                }
            }
            return model;
        }

        private Frame reBalance(Frame fr, boolean local) {
            int chunks = (int)Math.min((long)(4 * H2O.NUMCPUS * (local ? 1 : H2O.CLOUD.size())), fr.numRows());
            if (fr.anyVec().nChunks() > chunks && !((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).reproducible) {
                Log.info((Object[])new Object[]{"Dataset already contains " + fr.anyVec().nChunks() + " chunks. No need to rebalance."});
                return fr;
            }
            if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).reproducible) {
                Log.warn((Object[])new Object[]{"Reproducibility enforced - using only 1 thread - can be slow."});
                chunks = 1;
            }
            if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).quiet_mode) {
                Log.info((Object[])new Object[]{"ReBalancing dataset into (at least) " + chunks + " chunks."});
            }
            Key newKey = fr._key != null ? Key.make((String)(fr._key.toString() + ".balanced")) : Key.make();
            newKey = Key.makeUserHidden((Key)newKey);
            RebalanceDataSet rb = new RebalanceDataSet(fr, newKey, chunks);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            Frame f = (Frame)DKV.get((Key)newKey).get();
            this._delete_me.add(f);
            return f;
        }

        private long computeTrainSamplesPerIteration(DeepLearningModel.DeepLearningParameters mp, long numRows, DeepLearningModel model) {
            long tspi = mp.train_samples_per_iteration;
            assert (tspi == 0L || tspi == -1L || tspi == -2L || tspi >= 1L);
            if (tspi == 0L || !mp.replicate_training_data && tspi == -1L) {
                tspi = numRows;
                if (!mp.quiet_mode) {
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp.train_samples_per_iteration + ") to one epoch: #rows (" + tspi + ")."});
                }
            } else if (tspi == -1L) {
                tspi = (long)(mp.single_node_mode ? 1 : H2O.CLOUD.size()) * numRows;
                if (!mp.quiet_mode) {
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp.train_samples_per_iteration + ") to #nodes x #rows (" + tspi + ")."});
                }
            } else if (tspi == -2L) {
                double total_gflops = 0.0;
                for (H2ONode h2o : H2O.CLOUD._memary) {
                    HeartBeat hb = h2o._heartbeat;
                    total_gflops += hb._gflops;
                }
                if (mp.single_node_mode) {
                    total_gflops /= (double)H2O.CLOUD.size();
                }
                if (total_gflops == 0.0) {
                    total_gflops = Linpack.run((int)H2O.SELF._heartbeat._cpus_allowed) * (double)(mp.single_node_mode ? 1 : H2O.CLOUD.size());
                }
                long model_size = model.model_info().size();
                int[] msg_sizes = new int[]{(long)((int)(model_size * 4L)) == model_size * 4L ? (int)(model_size * 4L) : Integer.MAX_VALUE};
                double[] microseconds_collective = new double[msg_sizes.length];
                NetworkTest.NetworkTester nt = new NetworkTest.NetworkTester(msg_sizes, (double[][])null, microseconds_collective, (double)model_size > 1000000.0 ? 1 : 5, false, true);
                nt.compute2();
                int network_queue_length = mp.single_node_mode || H2O.CLOUD.size() == 1 ? 1 : 2 * (int)Math.floor(Math.log(H2O.CLOUD.size()) / Math.log(2.0));
                double flops_overhead_per_row = 30.0;
                if (mp.activation == DeepLearningModel.DeepLearningParameters.Activation.Maxout || mp.activation == DeepLearningModel.DeepLearningParameters.Activation.MaxoutWithDropout) {
                    flops_overhead_per_row *= 8.0;
                } else if (mp.activation == DeepLearningModel.DeepLearningParameters.Activation.Tanh || mp.activation == DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout) {
                    flops_overhead_per_row *= 5.0;
                }
                double fraction = mp.single_node_mode || H2O.CLOUD.size() == 1 ? 0.001 : 0.05;
                model.time_for_communication_us = (H2O.CLOUD.size() == 1 ? 10000.0 : 0.0) + (double)network_queue_length * microseconds_collective[0];
                double time_per_row_us = flops_overhead_per_row * (double)model_size / (total_gflops * 1.0E9) / (double)H2O.SELF._heartbeat._cpus_allowed * 1000000.0;
                tspi = (long)((model.time_for_communication_us / fraction - model.time_for_communication_us) / time_per_row_us);
                tspi = Math.min(tspi, (long)(mp.single_node_mode ? 1 : H2O.CLOUD.size()) * numRows * 10L);
                if (tspi > numRows && (double)Math.abs(tspi % numRows) / (double)numRows < 0.2) {
                    tspi -= tspi % numRows;
                }
                tspi = Math.min(tspi, (long)(mp.epochs * (double)numRows / 10.0));
                tspi = Math.max(1L, tspi);
                if (!mp.quiet_mode) {
                    Log.info((Object[])new Object[]{"Auto-tuning parameter 'train_samples_per_iteration':"});
                    Log.info((Object[])new Object[]{"Estimated compute power : " + (int)total_gflops + " GFlops"});
                    Log.info((Object[])new Object[]{"Estimated time for comm : " + PrettyPrint.usecs((long)((long)model.time_for_communication_us))});
                    Log.info((Object[])new Object[]{"Estimated time per row  : " + ((long)time_per_row_us > 0L ? PrettyPrint.usecs((long)((long)time_per_row_us)) : time_per_row_us + " usecs")});
                    Log.info((Object[])new Object[]{"Estimated training speed: " + (int)(1000000.0 / time_per_row_us) + " rows/sec"});
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp.train_samples_per_iteration + ") to auto-tuned value: " + tspi});
                }
            } else {
                tspi = Math.min(tspi, (long)(mp.epochs * (double)numRows));
            }
            assert (tspi != 0L && tspi != -1L && tspi != -2L && tspi >= 1L);
            return tspi;
        }

        private float computeRowUsageFraction(long numRows, long train_samples_per_iteration, boolean replicate_training_data) {
            float rowUsageFraction = (float)train_samples_per_iteration / (float)numRows;
            if (replicate_training_data) {
                rowUsageFraction /= (float)H2O.CLOUD.size();
            }
            assert (rowUsageFraction > 0.0f);
            return rowUsageFraction;
        }

        private float rowFraction(Frame train, DeepLearningModel.DeepLearningParameters p, DeepLearningModel m) {
            return this.computeRowUsageFraction(train.numRows(), m.actual_train_samples_per_iteration, p.replicate_training_data);
        }
    }
}

