/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.FrameTask;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.Neurons;
import java.util.Arrays;
import java.util.Random;
import water.H2O;
import water.Key;
import water.util.Log;

public class DeepLearningTask
extends FrameTask<DeepLearningTask> {
    private final boolean _training;
    private DeepLearningModel.DeepLearningModelInfo _input;
    DeepLearningModel.DeepLearningModelInfo _output;
    transient Neurons[] _neurons;
    int _chunk_node_count = 1;
    static long _lastWarn;
    static long _warnCount;

    public final DeepLearningModel.DeepLearningModelInfo model_info() {
        return this._output;
    }

    public DeepLearningTask(Key jobKey, DeepLearningModel.DeepLearningModelInfo input, float fraction) {
        this(jobKey, input, fraction, null);
    }

    private DeepLearningTask(Key jobKey, DeepLearningModel.DeepLearningModelInfo input, float fraction, H2O.H2OCountedCompleter cmp) {
        super(jobKey, input.data_info(), cmp);
        this._training = true;
        this._input = input;
        this._useFraction = fraction;
        this._shuffle = this._input.get_params().shuffle_training_data;
        assert (this._output == null);
    }

    @Override
    protected void setupLocal() {
        super.setupLocal();
        this._output = this._input;
        this._input = null;
        this._output.set_processed_local(0L);
    }

    @Override
    protected void chunkInit() {
        this._neurons = DeepLearningTask.makeNeuronsForTraining(this._output);
    }

    @Override
    public final void processRow(long seed, double[] nums, int numcats, int[] cats, double[] responses) {
        seed = this.model_info().get_params().reproducible ? (seed += this.model_info().get_processed_global()) : new Random().nextLong();
        ((Neurons.Input)this._neurons[0]).setInput(seed, nums, numcats, cats);
        DeepLearningTask.step(seed, this._neurons, this._output, this._training, responses);
    }

    @Override
    protected void chunkDone(long n) {
        if (this._training) {
            this._output.add_processed_local(n);
        }
    }

    public void reduce(DeepLearningTask other) {
        if (other._output.get_processed_local() > 0L && other._output != this._output) {
            if (this._output.get_processed_local() == 0L) {
                this._output = other._output;
                this._chunk_node_count = other._chunk_node_count;
            } else {
                this._output.add(other._output);
                this._chunk_node_count += other._chunk_node_count;
            }
        }
        if (other._output.unstable()) {
            this._output.set_unstable();
        }
    }

    protected void postGlobal() {
        if (H2O.CLOUD.size() > 1 && !this._output.get_params().replicate_training_data) {
            long now = System.currentTimeMillis();
            if (this._chunk_node_count < H2O.CLOUD.size() && now - _lastWarn > 5000L && _warnCount < 3L) {
                Log.warn((Object[])new Object[]{H2O.CLOUD.size() - this._chunk_node_count + " node(s) (out of " + H2O.CLOUD.size() + ") are not contributing to model updates. Consider setting replicate_training_data to true or using a larger training dataset (or fewer H2O nodes)."});
                _lastWarn = now;
                ++_warnCount;
            }
        }
        if (!this._output.get_params().replicate_training_data || H2O.CLOUD.size() == 1) {
            this._output.div(this._chunk_node_count);
            this._output.add_processed_global(this._output.get_processed_local());
            this._output.set_processed_local(0L);
        }
        assert (this._input == null);
    }

    public static Neurons[] makeNeuronsForTraining(DeepLearningModel.DeepLearningModelInfo minfo) {
        return DeepLearningTask.makeNeurons(minfo, true);
    }

    public static Neurons[] makeNeuronsForTesting(DeepLearningModel.DeepLearningModelInfo minfo) {
        return DeepLearningTask.makeNeurons(minfo, false);
    }

    private static Neurons[] makeNeurons(DeepLearningModel.DeepLearningModelInfo minfo, boolean training) {
        int i;
        FrameTask.DataInfo dinfo = minfo.data_info();
        DeepLearningModel.DeepLearningParameters params = minfo.get_params();
        int[] h = params.hidden;
        Neurons[] neurons = new Neurons[h.length + 2];
        neurons[0] = new Neurons.Input(dinfo.fullN(), dinfo);
        block8: for (i = 0; i < h.length; ++i) {
            switch (params.activation) {
                case Tanh: {
                    neurons[i + 1] = new Neurons.Tanh(h[i]);
                    continue block8;
                }
                case TanhWithDropout: {
                    neurons[i + 1] = new Neurons.TanhDropout(h[i]);
                    continue block8;
                }
                case Rectifier: {
                    neurons[i + 1] = new Neurons.Rectifier(h[i]);
                    continue block8;
                }
                case RectifierWithDropout: {
                    neurons[i + 1] = new Neurons.RectifierDropout(h[i]);
                    continue block8;
                }
                case Maxout: {
                    neurons[i + 1] = new Neurons.Maxout(h[i]);
                    continue block8;
                }
                case MaxoutWithDropout: {
                    neurons[i + 1] = new Neurons.MaxoutDropout(h[i]);
                }
            }
        }
        neurons[neurons.length - 1] = params._classification ? new Neurons.Softmax(minfo.units[minfo.units.length - 1]) : new Neurons.Linear(1);
        for (i = 0; i < neurons.length; ++i) {
            neurons[i].init(neurons, i, params, minfo, training);
        }
        return neurons;
    }

    public static void step(long seed, Neurons[] neurons, DeepLearningModel.DeepLearningModelInfo minfo, boolean training, double[] responses) {
        try {
            int i;
            for (i = 1; i < neurons.length - 1; ++i) {
                neurons[i].fprop(seed, training);
            }
            if (minfo.get_params()._classification) {
                ((Neurons.Softmax)neurons[neurons.length - 1]).fprop();
                if (training) {
                    for (i = 1; i < neurons.length - 1; ++i) {
                        Arrays.fill(neurons[i]._e.raw(), 0.0f);
                    }
                    assert ((double)((int)responses[0]) == responses[0]);
                    int target_label = (int)responses[0];
                    ((Neurons.Softmax)neurons[neurons.length - 1]).bprop(target_label);
                }
            } else {
                ((Neurons.Linear)neurons[neurons.length - 1]).fprop();
                if (training) {
                    for (i = 1; i < neurons.length - 1; ++i) {
                        Arrays.fill(neurons[i]._e.raw(), 0.0f);
                    }
                    float target_value = (float)responses[0];
                    ((Neurons.Linear)neurons[neurons.length - 1]).bprop(target_value);
                }
            }
            if (training) {
                for (int i2 = neurons.length - 2; i2 > 0; --i2) {
                    neurons[i2].bprop();
                }
            }
        }
        catch (RuntimeException ex) {
            Log.warn((Object[])new Object[]{ex.getMessage()});
            minfo.set_unstable();
            throw new RuntimeException("Canceling job due to numerical instability.");
        }
    }
}

