/*
 * Decompiled with CFR 0.152.
 */
package hex.example;

import hex.Model;
import hex.ModelBuilder;
import hex.example.ExampleModel;
import hex.schemas.ExampleV2;
import hex.schemas.ModelBuilderSchema;
import java.util.Arrays;
import water.H2O;
import water.Job;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.Log;

public class Example
extends ModelBuilder<ExampleModel, ExampleModel.ExampleParameters, ExampleModel.ExampleOutput> {
    public Example(ExampleModel.ExampleParameters parms) {
        super("Example", (Model.Parameters)parms);
        this._parms = parms;
    }

    public ModelBuilderSchema schema() {
        return new ExampleV2();
    }

    public Example train() {
        return (Example)this.start(new ExampleDriver(), ((ExampleModel.ExampleParameters)this._parms)._max_iters);
    }

    private static class Max
    extends MRTask<Max> {
        double[] _maxs;

        private Max() {
        }

        public void map(Chunk[] cs) {
            this._maxs = new double[cs.length];
            Arrays.fill(this._maxs, -1.7976931348623157E308);
            for (int col = 0; col < cs.length; ++col) {
                for (int row = 0; row < cs[col]._len; ++row) {
                    this._maxs[col] = Math.max(this._maxs[col], cs[col].at0(row));
                }
            }
        }

        public void reduce(Max that) {
            for (int col = 0; col < this._maxs.length; ++col) {
                this._maxs[col] = Math.max(this._maxs[col], that._maxs[col]);
            }
        }
    }

    private class ExampleDriver
    extends H2O.H2OCountedCompleter<ExampleDriver> {
        private ExampleDriver() {
        }

        protected void compute2() {
            ExampleModel model = null;
            try {
                ((ExampleModel.ExampleParameters)Example.this._parms).lock_frames((Job)Example.this);
                Frame fr = ((ExampleModel.ExampleParameters)Example.this._parms).train();
                model = new ExampleModel(Example.this.dest(), fr, (ExampleModel.ExampleParameters)Example.this._parms, new ExampleModel.ExampleOutput());
                model.delete_and_lock(Example.this._key);
                while (((ExampleModel.ExampleOutput)model._output)._iters < ((ExampleModel.ExampleParameters)Example.this._parms)._max_iters) {
                    if (!Example.this.isRunning()) {
                        return;
                    }
                    double[] maxs = ((Max)new Max().doAll((Frame)fr))._maxs;
                    ((ExampleModel.ExampleOutput)model._output)._maxs = maxs;
                    model.update(Example.this._key);
                    Example.this.update(1L);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Example: iter: ").append(((ExampleModel.ExampleOutput)model._output)._iters);
                    Log.info((Object[])new Object[]{sb});
                    ++((ExampleModel.ExampleOutput)model._output)._iters;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Example.this.cancel2(t);
                throw t;
            }
            finally {
                if (model != null) {
                    model.unlock(Example.this._key);
                }
                ((ExampleModel.ExampleParameters)Example.this._parms).unlock_frames((Job)Example.this);
                Example.this.done();
            }
            this.tryComplete();
        }
    }
}

