/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.AUC;
import hex.ConfusionMatrix2;
import hex.glm.GLMModel;
import water.Iced;
import water.Key;
import water.util.ModelUtils;

public class GLMValidation
extends Iced {
    final double _ymu;
    double residual_deviance;
    double null_deviance;
    long nobs;
    float best_threshold;
    double auc = Double.NaN;
    Key[] xval_models;
    double aic;
    private double _aic2;
    final Key dataKey;
    public final float[] thresholds;
    ConfusionMatrix2[] _cms;
    final GLMModel.GLMParameters _glm;
    private final int _rank;
    double[] tprs;
    double[] fprs;

    public GLMValidation(Key dataKey, double ymu, GLMModel.GLMParameters glm, int rank) {
        this(dataKey, ymu, glm, rank, (float[])(glm.family == GLMModel.GLMParameters.Family.binomial ? ModelUtils.DEFAULT_THRESHOLDS : null));
    }

    public GLMValidation(Key dataKey, double ymu, GLMModel.GLMParameters glm, int rank, float[] thresholds) {
        this._rank = rank;
        this._ymu = ymu;
        this._glm = glm;
        if (this._glm.family == GLMModel.GLMParameters.Family.binomial) {
            this._cms = new ConfusionMatrix2[thresholds.length];
            for (int i = 0; i < this._cms.length; ++i) {
                this._cms[i] = new ConfusionMatrix2(2);
            }
        }
        this.dataKey = dataKey;
        this.thresholds = thresholds;
    }

    public static Key makeKey() {
        return Key.make((String)("__GLMValidation_" + Key.make()));
    }

    public void add(double yreal, double ymodel) {
        this.null_deviance += this._glm.deviance(yreal, this._ymu);
        if (this._glm.family == GLMModel.GLMParameters.Family.binomial) {
            for (int i = 0; i < this.thresholds.length; ++i) {
                this._cms[i].add((int)yreal, ymodel >= (double)this.thresholds[i] ? 1 : 0);
            }
        }
        this.residual_deviance += this._glm.deviance(yreal, ymodel);
        ++this.nobs;
        if (this._glm.family == GLMModel.GLMParameters.Family.poisson) {
            long y = Math.round(yreal);
            double logfactorial = 0.0;
            for (long i = 2L; i <= y; ++i) {
                logfactorial += Math.log(i);
            }
            this._aic2 += yreal * Math.log(ymodel) - logfactorial - ymodel;
        }
    }

    public void add(GLMValidation v) {
        this.residual_deviance += v.residual_deviance;
        this.null_deviance += v.null_deviance;
        this.nobs += v.nobs;
        this._aic2 += v._aic2;
        if (this._cms == null) {
            this._cms = v._cms;
        } else {
            for (int i = 0; i < this._cms.length; ++i) {
                this._cms[i].add(v._cms[i]);
            }
        }
    }

    public final double nullDeviance() {
        return this.null_deviance;
    }

    public final double residualDeviance() {
        return this.residual_deviance;
    }

    public final long nullDOF() {
        return this.nobs - 1L;
    }

    public final long resDOF() {
        return this.nobs - (long)this._rank - 1L;
    }

    public double auc() {
        return this.auc;
    }

    public double aic() {
        return this.aic;
    }

    protected void computeAIC() {
        this.aic = 0.0;
        switch (this._glm.family) {
            case gaussian: {
                this.aic = (double)this.nobs * (Math.log(this.residual_deviance / (double)this.nobs * 2.0 * Math.PI) + 1.0) + 2.0;
                break;
            }
            case binomial: {
                this.aic = this.residual_deviance;
                break;
            }
            case poisson: {
                this.aic = -2.0 * this._aic2;
                break;
            }
            case gamma: 
            case tweedie: {
                this.aic = Double.NaN;
                break;
            }
            default: {
                assert (false) : "missing implementation for family " + (Object)((Object)this._glm.family);
                break;
            }
        }
        this.aic += (double)(2 * this._rank);
    }

    protected void computeAUC() {
        if (this._glm.family == GLMModel.GLMParameters.Family.binomial) {
            for (ConfusionMatrix2 cm : this._cms) {
                cm.reComputeErrors();
            }
            AUC auc = new AUC(this._cms, this.thresholds, null);
            this.auc = auc.data().AUC();
            this.best_threshold = auc.data().threshold();
        }
    }

    public String toString() {
        return "null_dev = " + this.null_deviance + ", res_dev = " + this.residual_deviance + ", auc = " + this.auc();
    }

    private double trapeziod_area(double x1, double x2, double y1, double y2) {
        double base = Math.abs(x1 - x2);
        double havg = 0.5 * (y1 + y2);
        return base * havg;
    }

    public static class GLMXValidation
    extends GLMValidation {
        public GLMXValidation(GLMModel mainModel, GLMModel[] xvalModels, GLMValidation[] xvals, double lambda, long nobs, float[] thresholds) {
            super(mainModel._key, mainModel._ymu, (GLMModel.GLMParameters)mainModel._parms, mainModel.rank(lambda), thresholds);
            this.xval_models = new Key[xvalModels.length];
            for (int i = 0; i < this.xval_models.length; ++i) {
                this.xval_models[i] = xvalModels[i]._key;
            }
            double t = 0.0;
            for (int i = 0; i < xvalModels.length; ++i) {
                this.add(xvals[i]);
                t += (double)xvals[i].best_threshold;
            }
            this.computeAUC();
            this.computeAIC();
            this.best_threshold = (float)(t / (double)xvalModels.length);
            this.nobs = nobs;
        }
    }
}

