/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.Model;
import hex.kmeans.KMeans;
import hex.schemas.KMeansModelV2;
import water.Key;
import water.api.ModelSchema;
import water.fvec.Chunk;
import water.fvec.Frame;

public class KMeansModel
extends Model<KMeansModel, KMeansParameters, KMeansOutput> {
    public KMeansModel(Key selfKey, Frame fr, KMeansParameters parms, KMeansOutput output, int ncats) {
        super(selfKey, fr, (Model.Parameters)parms, (Model.Output)output);
        ((KMeansOutput)this._output)._ncats = ncats;
    }

    public boolean isSupervised() {
        return false;
    }

    public ModelSchema schema() {
        return new KMeansModelV2();
    }

    protected float[] score0(Chunk[] chks, int row_in_chunk, double[] tmp, float[] preds) {
        assert (chks.length >= ((KMeansOutput)this._output)._names.length);
        for (int i = 0; i < ((KMeansOutput)this._output)._names.length; ++i) {
            tmp[i] = chks[i].at0(row_in_chunk);
        }
        return this.score0(tmp, preds);
    }

    protected float[] score0(double[] data, float[] preds) {
        preds[0] = KMeans.closest(((KMeansOutput)this._output)._clusters, data, ((KMeansOutput)this._output)._ncats);
        return preds;
    }

    public static class KMeansOutput
    extends Model.Output {
        public int _ncats;
        public int _iters;
        public double[][] _clusters;
        public long[] _rows;
        public double[] _mses;
        public double _mse;

        public int nfeatures() {
            return this._names.length;
        }

        public Model.ModelCategory getModelCategory() {
            return Model.ModelCategory.Clustering;
        }
    }

    public static class KMeansParameters
    extends Model.Parameters {
        public int _K;
        public int _max_iters = 100;
        public boolean _normalize = false;
        public long _seed;
        public KMeans.Initialization _init = KMeans.Initialization.Furthest;

        public int sanityCheckParameters() {
            if (this._K < 2) {
                this.validation_error("K", "K must be >= 2");
            }
            if (this._max_iters < 1) {
                this.validation_error("max_iters", "max_iters must be > 1");
            }
            if (this.train().numRows() < (long)this._K) {
                throw new IllegalArgumentException("Cannot make " + this._K + " clusters out of " + this.train().numRows() + " rows.");
            }
            return this._validation_error_count;
        }
    }
}

