/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.example.Example;
import hex.example.ExampleModel;
import hex.schemas.ModelBuilderSchema;
import water.api.API;
import water.api.ModelParametersSchema;
import water.fvec.Frame;
import water.util.PojoUtils;

public class ExampleV2
extends ModelBuilderSchema<Example, ExampleV2, ExampleParametersV2> {
    public ExampleParametersV2 createParametersSchema() {
        return new ExampleParametersV2();
    }

    public Example createImpl() {
        if (((ExampleParametersV2)this.parameters).max_iters < 0 || ((ExampleParametersV2)this.parameters).max_iters > 9999999) {
            throw new IllegalArgumentException("1<= max_iters && max_iters < 10000000");
        }
        if (((ExampleParametersV2)this.parameters).max_iters == 0) {
            ((ExampleParametersV2)this.parameters).max_iters = 1000;
        }
        return new Example(((ExampleParametersV2)this.parameters).createImpl());
    }

    protected String acceptsFrame(Frame fr) {
        return "/v2/Example?training_frame=" + fr._key;
    }

    public static final class ExampleParametersV2
    extends ModelParametersSchema<ExampleModel.ExampleParameters, ExampleParametersV2> {
        @API(help="Maximum training iterations.")
        public int max_iters;

        public String[] fields() {
            return new String[]{"max_iters"};
        }

        public ExampleModel.ExampleParameters createImpl() {
            ExampleModel.ExampleParameters impl = new ExampleModel.ExampleParameters();
            PojoUtils.copyProperties((Object)((Object)impl), (Object)((Object)this), (PojoUtils.FieldNaming)PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES);
            return impl;
        }
    }
}

