/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.gbm.GBM;
import hex.gbm.GBMModel;
import hex.schemas.ModelBuilderSchema;
import water.api.API;
import water.api.ModelParametersSchema;
import water.fvec.Frame;
import water.util.PojoUtils;

public class GBMV2
extends ModelBuilderSchema<GBM, GBMV2, GBMParametersV2> {
    public GBMParametersV2 createParametersSchema() {
        return new GBMParametersV2();
    }

    public GBM createImpl() {
        if (((GBMParametersV2)this.parameters).ntrees == 0) {
            ((GBMParametersV2)this.parameters).ntrees = 50;
        }
        if (((GBMParametersV2)this.parameters).ntrees < 0 || ((GBMParametersV2)this.parameters).ntrees > 100000) {
            throw new IllegalArgumentException("ntrees must be between 1 and 100000");
        }
        if (((GBMParametersV2)this.parameters).learn_rate == 0.0f) {
            ((GBMParametersV2)this.parameters).learn_rate = 0.1f;
        }
        if (((GBMParametersV2)this.parameters).learn_rate < 0.0f || ((GBMParametersV2)this.parameters).learn_rate > 100000.0f) {
            throw new IllegalArgumentException("learn_rate must be between 0.0 and 1.0");
        }
        if (((GBMParametersV2)this.parameters).loss == null) {
            ((GBMParametersV2)this.parameters).loss = GBMModel.GBMParameters.Family.AUTO;
        }
        if (((GBMParametersV2)this.parameters).seed == 0L) {
            ((GBMParametersV2)this.parameters).seed = System.nanoTime();
        }
        GBMModel.GBMParameters parms = ((GBMParametersV2)this.parameters).createImpl();
        return new GBM(parms);
    }

    protected String acceptsFrame(Frame fr) {
        return "/v2/GBM?training_frame=" + fr._key;
    }

    public static final class GBMParametersV2
    extends ModelParametersSchema<GBMModel.GBMParameters, GBMParametersV2> {
        @API(help="Number of trees. Grid Search, comma sep values:50,100,150,200")
        public int ntrees;
        @API(help="Learning rate from 0.0 to 1.0")
        public float learn_rate;
        @API(help="Loss function", values={"AUTO", "Bernoulli"})
        public GBMModel.GBMParameters.Family loss;
        @API(help="RNG Seed for balancing classes", level=API.Level.expert)
        public long seed;

        public String[] fields() {
            return new String[]{"destination_key", "train", "response_column", "ntrees", "learn_rate", "loss", "importance", "seed"};
        }

        public GBMParametersV2 fillFromImpl(GBMModel.GBMParameters parms) {
            super.fillFromImpl((Model.Parameters)parms);
            this.loss = GBMModel.GBMParameters.Family.AUTO;
            return this;
        }

        public GBMModel.GBMParameters createImpl() {
            GBMModel.GBMParameters impl = new GBMModel.GBMParameters();
            PojoUtils.copyProperties((Object)((Object)impl), (Object)((Object)this), (PojoUtils.FieldNaming)PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES);
            return impl;
        }
    }
}

