/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.schemas.ModelBuilderSchema;
import water.api.ModelParametersSchema;
import water.fvec.Frame;
import water.util.PojoUtils;

public class GLMV2
extends ModelBuilderSchema<GLM, GLMV2, GLMParametersV2> {
    public GLMParametersV2 createParametersSchema() {
        return new GLMParametersV2();
    }

    public GLM createImpl() {
        if (((GLMParametersV2)this.parameters).K < 2 || ((GLMParametersV2)this.parameters).K > 9999999) {
            throw new IllegalArgumentException("2<= K && K < 10000000");
        }
        if (((GLMParametersV2)this.parameters).max_iters < 0 || ((GLMParametersV2)this.parameters).max_iters > 9999999) {
            throw new IllegalArgumentException("1<= max_iters && max_iters < 10000000");
        }
        if (((GLMParametersV2)this.parameters).max_iters == 0) {
            ((GLMParametersV2)this.parameters).max_iters = 1000;
        }
        if (((GLMParametersV2)this.parameters).seed == 0L) {
            ((GLMParametersV2)this.parameters).seed = System.nanoTime();
        }
        GLMModel.GLMParameters parms = ((GLMParametersV2)this.parameters).createImpl();
        return new GLM(parms);
    }

    protected String acceptsFrame(Frame fr) {
        return "/v2/GLM?training_frame=" + fr._key;
    }

    public static final class GLMParametersV2
    extends ModelParametersSchema<GLMModel.GLMParameters, GLMParametersV2> {
        public int K;
        public int max_iters;
        public boolean normalize = true;
        public long seed;

        public String[] fields() {
            return new String[]{"destination_key", "K", "max_iters", "normalize", "seed"};
        }

        public GLMParametersV2 fillFromImpl(GLMModel.GLMParameters parms) {
            super.fillFromImpl((Model.Parameters)parms);
            return this;
        }

        public GLMModel.GLMParameters createImpl() {
            GLMModel.GLMParameters impl = new GLMModel.GLMParameters();
            PojoUtils.copyProperties((Object)((Object)impl), (Object)((Object)this), (PojoUtils.FieldNaming)PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES);
            return impl;
        }
    }
}

